/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.font;

import com.android.resources.ResourceFolderType;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.model.StudioAndroidModuleInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.xml.XmlFile;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.dom.SingleRootResourceDomFileDescription;
import org.jetbrains.android.dom.font.FontFamily;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class FontFamilyDomFileDescription
extends SingleRootResourceDomFileDescription<FontFamily> {
    public static final String TAG_NAME = "font-family";

    public FontFamilyDomFileDescription() {
        super(FontFamily.class, TAG_NAME, ResourceFolderType.FONT);
    }

    public static boolean isFontFamilyFile(@NotNull XmlFile file2) {
        return FontFamilyDomFileDescription.isFileInResourceFolderType(file2, ResourceFolderType.FONT);
    }

    @NotNull
    public static List<String> getPossibleRoots(@NotNull AndroidFacet facet2, @NotNull ResourceFolderType folderType) {
        AndroidVersion sdkVersion = StudioAndroidModuleInfo.getInstance(facet2).getBuildSdkVersion();
        if (sdkVersion == null || sdkVersion.getFeatureLevel() >= 26 || ApplicationManager.getApplication().isUnitTestMode()) {
            return Collections.singletonList(TAG_NAME);
        }
        return Collections.emptyList();
    }
}

