/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkVersionInfo;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.google.common.base.Strings;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Range;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiElement;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TargetApiConverter
extends ResolvingConverter<Integer> {
    private final Set<Integer> myAllVariants;

    public TargetApiConverter() {
        Range range = Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(33));
        this.myAllVariants = ContiguousSet.create((Range)range, (DiscreteDomain)DiscreteDomain.integers());
    }

    @Nullable
    public LookupElement createLookupElement(Integer api) {
        String codeName;
        if (api == null) {
            return null;
        }
        String lookupString = SdkVersionInfo.getBuildCode((int)api);
        if (lookupString == null) {
            return null;
        }
        StringBuilder typeText = new StringBuilder();
        if (lookupString.length() == 1 && (codeName = SdkVersionInfo.getCodeName((int)api)) != null) {
            typeText.append(codeName).append(", ");
        }
        typeText.append(api);
        return PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)lookupString).withTypeText(typeText.toString(), true).withCaseSensitivity(false), (double)api.intValue());
    }

    @Nullable
    public PsiElement resolve(Integer o, ConvertContext context2) {
        return super.resolve((Object)o, context2);
    }

    public String getErrorMessage(@Nullable String s, ConvertContext context2) {
        block4: {
            if (Strings.isNullOrEmpty((String)s)) {
                return "Value shouldn't be empty";
            }
            try {
                int api = Integer.parseInt(s);
                if (!TargetApiConverter.isLegalApi(api, context2)) {
                    return String.format(Locale.US, "%d is not a valid API level", api);
                }
            }
            catch (NumberFormatException e) {
                int buildCode = SdkVersionInfo.getApiByBuildCode((String)s, (boolean)false);
                if (buildCode != -1) break block4;
                return "Value is neither valid build code nor an integer";
            }
        }
        return null;
    }

    @Nullable
    public Integer fromString(@Nullable @NonNls String s, ConvertContext context2) {
        if (s == null) {
            return null;
        }
        try {
            int api = Integer.parseInt(s);
            return TargetApiConverter.isLegalApi(api, context2) ? Integer.valueOf(api) : null;
        }
        catch (NumberFormatException e) {
            int buildCode = SdkVersionInfo.getApiByBuildCode((String)s, (boolean)false);
            return buildCode == -1 ? null : Integer.valueOf(buildCode);
        }
    }

    private static boolean isLegalApi(int api, @NotNull ConvertContext context2) {
        return api >= 1 && api <= TargetApiConverter.getHighestKnownApi(context2);
    }

    private static int getHighestKnownApi(@NotNull ConvertContext context2) {
        Module module2 = context2.getModule();
        if (module2 == null) {
            return 33;
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
        if (facet2 == null) {
            return 33;
        }
        IAndroidTarget apiTarget = ConfigurationManager.getOrCreateInstance(module2).getHighestApiTarget();
        if (apiTarget == null) {
            return 33;
        }
        return Math.max(apiTarget.getVersion().getApiLevel(), 33);
    }

    @Nullable
    public String toString(@Nullable Integer s, ConvertContext context2) {
        if (s == null) {
            return null;
        }
        return SdkVersionInfo.getBuildCode((int)s);
    }

    @NotNull
    public Collection<Integer> getVariants(ConvertContext context2) {
        return this.myAllVariants;
    }
}

