/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.StudioResourceRepositoryManager;
import com.android.tools.res.ResourceNamespacing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.impl.source.xml.SchemaPrefix;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.text.StringKt;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.xml.XmlExtension;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.android.dom.converters.ResourceNamespaceFakePsiElement;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0019\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0014J\u0013\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a2\u0006\u0002\u0010\rJ\n\u0010\u000e\u001a\u0004\u0018\u00010\fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/android/dom/converters/ResourceNamespaceReference;", "Lcom/intellij/psi/PsiReferenceBase;", "Lcom/intellij/psi/xml/XmlElement;", "domValue", "Lcom/intellij/util/xml/GenericDomValue;", "resourceValue", "Lorg/jetbrains/android/dom/resources/ResourceValue;", "(Lcom/intellij/util/xml/GenericDomValue;Lorg/jetbrains/android/dom/resources/ResourceValue;)V", "calculateDefaultRangeInElement", "Lcom/intellij/openapi/util/TextRange;", "getVariants", "", "Lcom/intellij/psi/PsiElement;", "()[Lcom/intellij/psi/PsiElement;", "resolve", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nResourceNamespaceReference.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceNamespaceReference.kt\norg/jetbrains/android/dom/converters/ResourceNamespaceReference\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,111:1\n57#2,2:112\n*S KotlinDebug\n*F\n+ 1 ResourceNamespaceReference.kt\norg/jetbrains/android/dom/converters/ResourceNamespaceReference\n*L\n54#1:112,2\n*E\n"})
public final class ResourceNamespaceReference
extends PsiReferenceBase<XmlElement> {
    @NotNull
    private final ResourceValue resourceValue;

    public ResourceNamespaceReference(@NotNull GenericDomValue<?> domValue, @NotNull ResourceValue resourceValue) {
        Intrinsics.checkNotNullParameter(domValue, (String)"domValue");
        Intrinsics.checkNotNullParameter((Object)resourceValue, (String)"resourceValue");
        XmlElement xmlElement = DomUtil.getValueElement(domValue);
        Intrinsics.checkNotNull((Object)xmlElement);
        super((PsiElement)xmlElement, null, true);
        this.resourceValue = resourceValue;
    }

    @NotNull
    public PsiElement[] getVariants() {
        Intrinsics.checkNotNullExpressionValue((Object)PsiElement.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
        return PsiElement.EMPTY_ARRAY;
    }

    @Nullable
    public PsiElement resolve() {
        PsiElement psiElement;
        SchemaPrefix schemaPrefix;
        String string = StringKt.nullize((String)this.getRangeInElement().substring(((XmlElement)this.getElement()).getText()), (boolean)true);
        if (string == null) {
            return null;
        }
        String prefix = string;
        XmlExtension xmlExtension = XmlExtension.getExtensionByElement((PsiElement)this.getElement());
        if (xmlExtension != null) {
            PsiElement psiElement2 = this.getElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"element");
            PsiElement $this$parentOfType_u24default$iv = psiElement2;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            schemaPrefix = xmlExtension.getPrefixDeclaration((XmlTag)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, XmlTag.class, (boolean)true), prefix);
        } else {
            schemaPrefix = null;
        }
        SchemaPrefix prefixDeclaration = schemaPrefix;
        StudioResourceRepositoryManager studioResourceRepositoryManager = StudioResourceRepositoryManager.getInstance(this.getElement());
        if (studioResourceRepositoryManager == null) {
            return null;
        }
        StudioResourceRepositoryManager repositoryManager = studioResourceRepositoryManager;
        if (prefixDeclaration != null && repositoryManager.getNamespacing() != ResourceNamespacing.DISABLED) {
            return (PsiElement)prefixDeclaration;
        }
        PsiElement psiElement3 = this.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"element");
        ResourceNamespace resourceNamespace = IdeResourcesUtil.resolveResourceNamespace((XmlElement)psiElement3, prefix);
        if (resourceNamespace == null) {
            return null;
        }
        ResourceNamespace resourceNamespace2 = resourceNamespace;
        PsiElement psiElement4 = this.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement4, (String)"element");
        ResourceNamespace resourceNamespace3 = IdeResourcesUtil.resolveResourceNamespace((XmlElement)psiElement4, prefix);
        if (Intrinsics.areEqual((Object)resourceNamespace3, (Object)ResourceNamespace.ANDROID)) {
            PsiElement psiElement5 = this.getElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement5, (String)"element");
            psiElement = (PsiElement)new ResourceNamespaceFakePsiElement(resourceNamespace2, (XmlElement)psiElement5);
        } else if (repositoryManager.getAppResources().getNamespaces().contains(resourceNamespace3)) {
            PsiElement psiElement6 = this.getElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement6, (String)"element");
            psiElement = (PsiElement)new ResourceNamespaceFakePsiElement(resourceNamespace2, (XmlElement)psiElement6);
        } else {
            psiElement = null;
        }
        return psiElement;
    }

    @NotNull
    protected TextRange calculateDefaultRangeInElement() {
        TextRange wholeReferenceRange = super.calculateDefaultRangeInElement();
        int startOffset = wholeReferenceRange.getStartOffset() + (this.resourceValue.getPrefix() == '\u0000' ? 0 : 1);
        String string = this.resourceValue.getPackage();
        Intrinsics.checkNotNull((Object)string);
        return new TextRange(startOffset, startOffset + string.length());
    }
}

