/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.android.resources.ResourceType;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import org.jetbrains.android.dom.converters.ResourceReferenceConverter;
import org.jetbrains.android.dom.resources.ResourceNameConverter;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParentStyleConverter
extends ResourceReferenceConverter {
    public ParentStyleConverter() {
        super(ResourceType.STYLE, false, false);
        this.setAllowAttributeReferences(false);
    }

    @Override
    @NotNull
    public PsiReference[] createReferences(GenericDomValue<ResourceValue> value2, PsiElement element2, ConvertContext context2) {
        Object[] refs;
        XmlAttributeValue attributeValue;
        if (element2 instanceof XmlAttributeValue && (attributeValue = (XmlAttributeValue)element2).isValid() && attributeValue.getValue().isEmpty()) {
            return PsiReference.EMPTY_ARRAY;
        }
        Object[] refsFromSuper = super.createReferences(value2, element2, context2);
        ResourceValue resValue = (ResourceValue)value2.getValue();
        if (resValue == null || resValue.getPackage() != null) {
            return refsFromSuper;
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((ConvertContext)context2);
        if (facet2 != null && (refs = ParentStyleConverter.getReferencesInStyleName(value2, facet2)).length > 0) {
            return (PsiReference[])ArrayUtil.mergeArrays((Object[])refsFromSuper, (Object[])refs);
        }
        return refsFromSuper;
    }

    @NotNull
    private static PsiReference[] getReferencesInStyleName(@NotNull GenericDomValue<?> value2, @NotNull AndroidFacet facet2) {
        String[] ids;
        String s = value2.getStringValue();
        if (s == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        int start2 = 0;
        int idx = s.indexOf(47);
        if (idx >= 0) {
            start2 = idx + 1;
            s = s.substring(start2);
        }
        if ((ids = s.split("\\.")).length < 2) {
            return PsiReference.EMPTY_ARRAY;
        }
        ArrayList<ResourceNameConverter.MyParentStyleReference> result2 = new ArrayList<ResourceNameConverter.MyParentStyleReference>(ids.length - 1);
        int offset = s.length();
        for (int i = ids.length - 1; i >= 0; --i) {
            String styleName = s.substring(0, offset);
            if (i < ids.length - 1) {
                ResourceValue val = ResourceValue.referenceTo('\u0000', null, ResourceType.STYLE.getName(), styleName);
                result2.add(new ResourceNameConverter.MyParentStyleReference((GenericDomValue)value2, new TextRange(1 + start2, 1 + start2 + offset), val, facet2));
            }
            if (ResourceNameConverter.hasExplicitParent(facet2, styleName)) break;
            offset = offset - ids[i].length() - 1;
        }
        return result2.toArray(PsiReference.EMPTY_ARRAY);
    }

    @Override
    public String toString(@Nullable ResourceValue element2, ConvertContext context2) {
        if (element2 != null && element2.getPrefix() == '@') {
            return element2.toString();
        }
        return super.toString(element2, context2);
    }
}

