/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.android.tools.idea.model.ManifestPlaceholderResolver;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManifestPlaceholderConverter
extends ResolvingConverter
implements CustomReferenceConverter<Object> {
    private static Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\$\\{(\\w+)\\}?");
    private Converter myConverterDelegate;

    public ManifestPlaceholderConverter(@NotNull Converter converter) {
        this.myConverterDelegate = converter;
    }

    @NotNull
    public Collection<?> getVariants(ConvertContext context2) {
        if (this.myConverterDelegate instanceof ResolvingConverter) {
            return ((ResolvingConverter)this.myConverterDelegate).getVariants(context2);
        }
        return Collections.emptyList();
    }

    public String getErrorMessage(@Nullable String s, ConvertContext context2) {
        if (context2.getModule() != null && s != null && s.contains("${")) {
            ManifestPlaceholderResolver resolver = new ManifestPlaceholderResolver(context2.getModule());
            s = resolver.resolve(s);
        }
        return this.myConverterDelegate.getErrorMessage(s, context2);
    }

    @Nullable
    public Object fromString(@Nullable @NonNls String s, ConvertContext context2) {
        if (s != null && s.contains("${")) {
            return new PlaceholderValue(s);
        }
        return this.myConverterDelegate.fromString(s, context2);
    }

    @Nullable
    public String toString(@Nullable Object o, ConvertContext context2) {
        if (o instanceof PlaceholderValue) {
            return ((PlaceholderValue)o).myValueWithPlaceholders;
        }
        return this.myConverterDelegate != null ? this.myConverterDelegate.toString(o, context2) : null;
    }

    @NotNull
    public PsiReference[] createReferences(GenericDomValue<Object> value2, PsiElement element2, ConvertContext context2) {
        if (context2.getModule() == null || !(value2.getValue() instanceof PlaceholderValue) && this.myConverterDelegate instanceof CustomReferenceConverter) {
            return ((CustomReferenceConverter)this.myConverterDelegate).createReferences(value2, element2, context2);
        }
        String stringValue = element2.getText();
        if (stringValue == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        ManifestPlaceholderResolver resolver = new ManifestPlaceholderResolver(context2.getModule());
        ImmutableSet placeholders = resolver.getPlaceholders().keySet();
        String[] placeholdersArray = ArrayUtil.toStringArray((Collection)placeholders);
        ArrayList<PlaceholderReference> result2 = new ArrayList<PlaceholderReference>();
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(stringValue);
        while (matcher.find()) {
            TextRange range = new TextRange(matcher.start(1), matcher.end(1));
            result2.add(new PlaceholderReference(element2, range, placeholdersArray));
        }
        return result2.toArray(PsiReference.EMPTY_ARRAY);
    }

    static class PlaceholderValue {
        String myValueWithPlaceholders;

        PlaceholderValue(String valueWithPlaceholders) {
            this.myValueWithPlaceholders = valueWithPlaceholders;
        }
    }

    private static class PlaceholderReference
    extends PsiReferenceBase<PsiElement> {
        private static final String GRADLE_APPLICATION_ID = "applicationId";
        private final PsiElement myDummyElement = new FakePsiElement(){

            public PsiElement getParent() {
                return this.getElement();
            }
        };
        private final String[] myValues;
        private final String myName;

        public PlaceholderReference(@NotNull PsiElement element2, TextRange range, String[] manifestPlaceholderElements) {
            super(element2, range, true);
            this.myName = range.substring(element2.getText());
            this.myValues = (String[])ArrayUtil.append((Object[])manifestPlaceholderElements, (Object)GRADLE_APPLICATION_ID);
        }

        @Nullable
        public PsiElement resolve() {
            return ArrayUtil.contains((String)this.myName, (String[])this.myValues) ? this.myDummyElement : null;
        }

        @NotNull
        public String[] getVariants() {
            return this.myValues;
        }
    }
}

