/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.android.tools.idea.res.IdeResourcesUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntegerConverter
extends ResolvingConverter<String> {
    public static final IntegerConverter INSTANCE = new IntegerConverter();

    @NotNull
    public Collection<String> getVariants(ConvertContext context2) {
        return Collections.emptyList();
    }

    public String fromString(@Nullable @NonNls String s, ConvertContext context2) {
        if (s == null || IdeResourcesUtil.isIdDeclaration(s) || IdeResourcesUtil.isIdReference(s)) {
            return s;
        }
        try {
            Long l = Long.decode(s);
            if (l >= 0x100000000L || l <= -4294967295L) {
                return null;
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
        return s;
    }

    public String toString(@Nullable String s, ConvertContext context2) {
        return s;
    }
}

