/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.android.tools.sdk.AndroidPlatform;
import com.android.tools.sdk.AndroidTargetData;
import com.google.common.collect.Lists;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.android.dom.LookupClass;
import org.jetbrains.android.dom.LookupPrefix;
import org.jetbrains.android.dom.manifest.Action;
import org.jetbrains.android.dom.manifest.Activity;
import org.jetbrains.android.dom.manifest.Category;
import org.jetbrains.android.dom.manifest.IntentFilter;
import org.jetbrains.android.dom.manifest.Receiver;
import org.jetbrains.android.dom.manifest.Service;
import org.jetbrains.android.sdk.AndroidPlatforms;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConstantFieldConverter
extends Converter<String>
implements CustomReferenceConverter<String> {
    public String fromString(@Nullable @NonNls String s, ConvertContext context2) {
        return s;
    }

    public String toString(@Nullable String value2, ConvertContext context2) {
        return value2;
    }

    @NotNull
    public PsiReference[] createReferences(GenericDomValue<String> value2, PsiElement element2, ConvertContext context2) {
        DomElement domElement = context2.getInvocationElement();
        LookupClass lookupClass = (LookupClass)domElement.getAnnotation(LookupClass.class);
        LookupPrefix lookupPrefix = (LookupPrefix)domElement.getAnnotation(LookupPrefix.class);
        if (lookupClass == null || lookupPrefix == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        Module module2 = context2.getModule();
        GlobalSearchScope scope2 = module2 != null ? GlobalSearchScope.allScope((Project)module2.getProject()) : domElement.getResolveScope();
        JavaPsiFacade javaFacade = JavaPsiFacade.getInstance((Project)context2.getPsiManager().getProject());
        String[] classNames = lookupClass.value();
        ArrayList result2 = Lists.newArrayListWithCapacity((int)classNames.length);
        Set<String> filteringSet = ConstantFieldConverter.getFilteringSet(context2);
        for (String className : classNames) {
            PsiClass psiClass = javaFacade.findClass(className, scope2);
            if (psiClass == null) continue;
            result2.add(new MyReference(element2, psiClass, lookupPrefix.value(), filteringSet));
        }
        return result2.toArray(PsiReference.EMPTY_ARRAY);
    }

    @Nullable
    private static Set<String> getFilteringSet(@NotNull ConvertContext context2) {
        Module module2 = context2.getModule();
        if (module2 == null) {
            return null;
        }
        AndroidPlatform platform = AndroidPlatforms.getInstance(module2);
        if (platform == null) {
            return null;
        }
        AndroidTargetData targetData = AndroidTargetData.get(platform.getSdkData(), platform.getTarget());
        DomElement element2 = context2.getInvocationElement().getParent();
        if (element2 instanceof Category) {
            return targetData.getStaticConstantsData().getCategories();
        }
        if (element2 instanceof Action && (element2 = element2.getParent()) instanceof IntentFilter) {
            if ((element2 = element2.getParent()) instanceof Activity) {
                return targetData.getStaticConstantsData().getActivityActions();
            }
            if (element2 instanceof Service) {
                return targetData.getStaticConstantsData().getServiceActions();
            }
            if (element2 instanceof Receiver) {
                return targetData.getStaticConstantsData().getReceiverActions();
            }
        }
        return null;
    }

    private static class MyReference
    extends PsiReferenceBase<PsiElement> {
        private final PsiClass myClass;
        private final String myLookupPrefix;
        private final Set<String> myFilteringSet;

        public MyReference(@NotNull PsiElement element2, @NotNull PsiClass aClass, @NotNull String lookupPrefix, @Nullable Set<String> filteringSet) {
            super(element2, true);
            this.myClass = aClass;
            this.myLookupPrefix = lookupPrefix;
            this.myFilteringSet = filteringSet;
        }

        @Nullable
        public PsiElement resolve() {
            return (PsiElement)ResolveCache.getInstance((Project)this.myElement.getProject()).resolveWithCaching((PsiReference)this, (ResolveCache.AbstractResolver)new ResolveCache.Resolver(){

                @Nullable
                public PsiElement resolve(@NotNull PsiReference reference, boolean incompleteCode) {
                    return this.resolveInner();
                }
            }, false, false);
        }

        @Nullable
        private PsiElement resolveInner() {
            final String value2 = this.getValue();
            if (value2.isEmpty()) {
                return null;
            }
            final Ref ref = Ref.create();
            this.processFields(new Processor<Pair<PsiField, String>>(){

                public boolean process(Pair<PsiField, String> pair) {
                    if (value2.equals(pair.getSecond())) {
                        ref.set((Object)((PsiElement)pair.getFirst()));
                        return false;
                    }
                    return true;
                }
            });
            return (PsiElement)ref.get();
        }

        @NotNull
        public Object[] getVariants() {
            final ArrayList result2 = new ArrayList();
            final HashSet added = new HashSet();
            this.processFields(new Processor<Pair<PsiField, String>>(){

                public boolean process(Pair<PsiField, String> pair) {
                    String s = (String)pair.getSecond();
                    if (myFilteringSet != null && !myFilteringSet.contains(s)) {
                        return true;
                    }
                    if (added.add(s)) {
                        LookupElementBuilder builder2 = LookupElementBuilder.create((Object)pair.getFirst(), (String)s).withCaseSensitivity(true);
                        String unqualifiedName = AndroidUtils.getUnqualifiedName(s);
                        if (unqualifiedName != null) {
                            builder2 = builder2.withLookupString(unqualifiedName);
                        }
                        result2.add(builder2);
                    }
                    return true;
                }
            });
            return ArrayUtil.toObjectArray(result2);
        }

        private void processFields(@NotNull Processor<Pair<PsiField, String>> processor) {
            PsiField[] psiFields;
            for (PsiField field2 : psiFields = this.myClass.getFields()) {
                PsiLiteralExpression literalExpression;
                Object o;
                PsiExpression initializer2;
                if (!field2.hasModifierProperty("static") || !field2.hasModifierProperty("public") || !((initializer2 = field2.getInitializer()) instanceof PsiLiteralExpression) || !((o = (literalExpression = (PsiLiteralExpression)initializer2).getValue()) instanceof String) || !o.toString().startsWith(this.myLookupPrefix) || processor.process((Object)Pair.create((Object)field2, (Object)o.toString()))) continue;
                return;
            }
        }
    }
}

