/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ResolvingConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.jcip.annotations.NotThreadSafe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeConverter
extends ResolvingConverter<String> {
    private final List<ResolvingConverter<String>> myConverters;

    CompositeConverter(List<ResolvingConverter<String>> converters) {
        this.myConverters = converters;
    }

    @NotNull
    public Collection<String> getVariants(ConvertContext context2) {
        ArrayList<String> variants = new ArrayList<String>();
        for (ResolvingConverter<String> converter : this.myConverters) {
            variants.addAll(converter.getVariants(context2));
        }
        return variants;
    }

    public String fromString(@Nullable String s, ConvertContext context2) {
        for (ResolvingConverter<String> converter : this.myConverters) {
            String result2 = (String)converter.fromString(s, context2);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    public String toString(@Nullable String s, ConvertContext context2) {
        return s;
    }

    @NotThreadSafe
    public static class Builder {
        private final List<ResolvingConverter<String>> myConverters = new ArrayList<ResolvingConverter<String>>();
        private boolean myIsBuilt = false;

        private void assertNotBuilt() {
            if (this.myIsBuilt) {
                throw new IllegalStateException("CompositeConverterBuilder shouldn't be used after .build() is called");
            }
        }

        public void addConverter(@NotNull ResolvingConverter<String> converter) {
            this.assertNotBuilt();
            this.myConverters.add(converter);
        }

        @Nullable
        public ResolvingConverter<String> build() {
            this.assertNotBuilt();
            this.myIsBuilt = true;
            switch (this.myConverters.size()) {
                case 0: {
                    return null;
                }
                case 1: {
                    return this.myConverters.get(0);
                }
            }
            return new CompositeConverter(this.myConverters);
        }
    }
}

