/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.android.tools.idea.res.psi.AndroidResourceToPsiResolver;
import com.android.tools.idea.res.psi.ResourceReferencePsiElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.android.dom.wrappers.ResourceElementWrapper;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidResourceReferenceBase
extends PsiReferenceBase.Poly<XmlElement> {
    protected final AndroidFacet myFacet;
    protected final ResourceValue myResourceValue;

    public AndroidResourceReferenceBase(@NotNull GenericDomValue<?> value2, @Nullable TextRange range, @NotNull ResourceValue resourceValue, @NotNull AndroidFacet facet2) {
        super((PsiElement)DomUtil.getValueElement(value2), range, true);
        this.myResourceValue = resourceValue;
        this.myFacet = facet2;
    }

    public boolean includeDynamicFeatures() {
        return false;
    }

    @Nullable
    public PsiElement bindToElement(@NotNull PsiElement element2) throws IncorrectOperationException {
        return null;
    }

    @NotNull
    public ResourceValue getResourceValue() {
        return this.myResourceValue;
    }

    public PsiElement[] computeTargetElements() {
        ResolveResult[] resolveResults = this.multiResolve(false);
        ArrayList<PsiElement> results2 = new ArrayList<PsiElement>();
        for (ResolveResult result2 : resolveResults) {
            PsiElement element2 = result2.getElement();
            if (element2 instanceof ResourceElementWrapper) {
                results2.add(((ResourceElementWrapper)element2).getWrappedElement());
                continue;
            }
            if (element2 instanceof ResourceReferencePsiElement) {
                PsiElement[] targets = AndroidResourceToPsiResolver.getInstance().getGotoDeclarationTargets(((ResourceReferencePsiElement)element2).getResourceReference(), this.myElement);
                results2.addAll(Arrays.asList(targets));
                continue;
            }
            results2.add(element2);
        }
        return results2.toArray(PsiElement.EMPTY_ARRAY);
    }

    public ResolveResult[] multiResolve(boolean incompleteCode) {
        return ResolveCache.getInstance((Project)((XmlElement)this.myElement).getProject()).resolveWithCaching((PsiPolyVariantReference)this, (reference, incompleteCode1) -> this.resolveInner(), false, incompleteCode);
    }

    private ResolveResult[] resolveInner() {
        if (this.includeDynamicFeatures()) {
            return AndroidResourceToPsiResolver.getInstance().resolveReferenceWithDynamicFeatureModules(this.myResourceValue, (XmlElement)this.myElement, this.myFacet);
        }
        return AndroidResourceToPsiResolver.getInstance().resolveReference(this.myResourceValue, (XmlElement)this.myElement, this.myFacet);
    }

    public boolean isReferenceTo(@NotNull PsiElement element2) {
        ResolveResult[] results2;
        for (ResolveResult result2 : results2 = this.multiResolve(false)) {
            PsiElement target2 = result2.getElement();
            if (!element2.getManager().areElementsEquivalent(target2, element2)) continue;
            return true;
        }
        return false;
    }
}

