/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.android.tools.idea.model.AndroidModel;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PackageReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiPackageReference;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import org.jetbrains.android.AndroidApplicationPackageRenameProcessor;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidPackageConverter
extends Converter<String>
implements CustomReferenceConverter<String> {
    public String fromString(@Nullable @NonNls String s, ConvertContext context2) {
        return s;
    }

    public String toString(@Nullable String s, ConvertContext context2) {
        return s;
    }

    @NotNull
    public PsiReference[] createReferences(GenericDomValue<String> value2, PsiElement element2, ConvertContext context2) {
        String s = value2.getStringValue();
        return s != null ? new MyPackageReferenceSet(s, element2).getPsiReferences() : PsiReference.EMPTY_ARRAY;
    }

    private static class MyPackageReferenceSet
    extends PackageReferenceSet {
        final int myStartInElement;

        public MyPackageReferenceSet(String s, PsiElement element2) {
            this(s, element2, ElementManipulators.getOffsetInElement((PsiElement)element2));
        }

        public MyPackageReferenceSet(String str, PsiElement element2, int startInElement) {
            super(str, element2, startInElement);
            this.myStartInElement = startInElement;
        }

        @NotNull
        protected PsiPackageReference createReference(TextRange range, int index2) {
            AndroidModel androidModel;
            AndroidFacet facet2 = AndroidFacet.getInstance((PsiElement)this.getElement());
            if (facet2 != null && ((androidModel = AndroidModel.get(facet2)) != null && androidModel.overridesManifestPackage() || ((AndroidFacetConfiguration)facet2.getConfiguration()).isLibraryProject())) {
                return new PsiPackageReference((PackageReferenceSet)this, range, index2);
            }
            return new MyPsiPackageReference(this, range, index2);
        }
    }

    private static class MyPsiPackageReference
    extends PsiPackageReference {
        private final MyPackageReferenceSet myReferenceSet;
        private final TextRange myTextRange;

        public MyPsiPackageReference(MyPackageReferenceSet referenceSet, TextRange textRange, int index2) {
            super((PackageReferenceSet)referenceSet, textRange, index2);
            this.myReferenceSet = referenceSet;
            this.myTextRange = textRange;
        }

        @NotNull
        public ResolveResult[] multiResolve(boolean incompleteCode) {
            return PsiElementResolveResult.createResults((PsiElement[])new PsiElement[]{this.myElement});
        }

        public boolean isReferenceTo(@NotNull PsiElement element2) {
            ResolveResult[] results2;
            for (ResolveResult result2 : results2 = this.doMultiResolve()) {
                if (!this.getElement().getManager().areElementsEquivalent(result2.getElement(), element2)) continue;
                return true;
            }
            return false;
        }

        public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
            return this.myElement;
        }

        public PsiElement bindToElement(@NotNull PsiElement element2) throws IncorrectOperationException {
            if (!(element2 instanceof PsiPackage) || !(this.myElement instanceof XmlAttributeValue)) {
                throw new IncorrectOperationException("Cannot bind to " + element2);
            }
            String newPackageName = ((PsiPackage)element2).getQualifiedName();
            String basePackage = ((XmlAttributeValue)this.myElement).getValue();
            String oldPackageName = this.myElement.getText().substring(this.myReferenceSet.myStartInElement, this.myTextRange.getEndOffset());
            PsiFile file2 = this.myElement.getContainingFile();
            if (!basePackage.isEmpty() && file2 instanceof XmlFile) {
                AndroidApplicationPackageRenameProcessor.processAllAttributesToUpdate((XmlFile)file2, basePackage, oldPackageName, newPackageName, new Processor<Pair<GenericAttributeValue, String>>(){

                    public boolean process(Pair<GenericAttributeValue, String> pair) {
                        ((GenericAttributeValue)pair.getFirst()).setStringValue((String)pair.getSecond());
                        return true;
                    }
                });
            }
            return this.myElement;
        }
    }
}

