/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom;

import com.android.resources.ResourceFolderType;
import com.intellij.openapi.module.Module;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import java.util.EnumSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.dom.AndroidResourceDomFileDescription;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B%\b\u0016\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB)\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u000b\u001a\u00020\u0007\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/android/dom/SingleRootResourceDomFileDescription;", "T", "Lcom/intellij/util/xml/DomElement;", "Lorg/jetbrains/android/dom/AndroidResourceDomFileDescription;", "rootElementClass", "Ljava/lang/Class;", "rootTagName", "", "resourceFolderType", "Lcom/android/resources/ResourceFolderType;", "(Ljava/lang/Class;Ljava/lang/String;Lcom/android/resources/ResourceFolderType;)V", "tagName", "resourceFolderTypes", "Ljava/util/EnumSet;", "(Ljava/lang/Class;Ljava/lang/String;Ljava/util/EnumSet;)V", "acceptsOtherRootTagNames", "", "isMyFile", "file", "Lcom/intellij/psi/xml/XmlFile;", "module", "Lcom/intellij/openapi/module/Module;", "intellij.android.core"})
public abstract class SingleRootResourceDomFileDescription<T extends DomElement>
extends AndroidResourceDomFileDescription<T> {
    public SingleRootResourceDomFileDescription(@NotNull Class<T> rootElementClass, @NotNull String tagName, @NotNull EnumSet<ResourceFolderType> resourceFolderTypes) {
        Intrinsics.checkNotNullParameter(rootElementClass, (String)"rootElementClass");
        Intrinsics.checkNotNullParameter((Object)tagName, (String)"tagName");
        Intrinsics.checkNotNullParameter(resourceFolderTypes, (String)"resourceFolderTypes");
        super(rootElementClass, tagName, resourceFolderTypes, null);
    }

    public SingleRootResourceDomFileDescription(@NotNull Class<T> rootElementClass, @NotNull String rootTagName, @NotNull ResourceFolderType resourceFolderType) {
        Intrinsics.checkNotNullParameter(rootElementClass, (String)"rootElementClass");
        Intrinsics.checkNotNullParameter((Object)rootTagName, (String)"rootTagName");
        Intrinsics.checkNotNullParameter((Object)resourceFolderType, (String)"resourceFolderType");
        EnumSet<Enum> enumSet = EnumSet.of((Enum)resourceFolderType);
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"of<ResourceFolderType>(resourceFolderType)");
        this(rootElementClass, rootTagName, enumSet);
    }

    public final boolean acceptsOtherRootTagNames() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final boolean isMyFile(@NotNull XmlFile file2, @Nullable Module module2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (!super.isMyFile(file2, module2)) return false;
        XmlTag xmlTag = file2.getRootTag();
        if (!Intrinsics.areEqual((Object)this.myRootTagName, (Object)(xmlTag != null ? xmlTag.getName() : null))) return false;
        return true;
    }
}

