/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom;

import com.android.AndroidXConstants;
import com.android.ide.common.rendering.api.AttributeFormat;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.resources.ResourceType;
import com.android.tools.dom.attrs.AttributeDefinition;
import com.android.tools.dom.attrs.AttributeDefinitions;
import com.android.tools.dom.attrs.StyleableDefinition;
import com.android.tools.idea.AndroidTextUtils;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.projectsystem.GoogleMavenArtifactId;
import com.android.tools.idea.psi.TagToClassMapper;
import com.android.tools.idea.res.StudioResourceRepositoryManager;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.google.common.collect.ImmutableSet;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.reflect.DomExtension;
import com.intellij.xml.XmlElementDescriptor;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.dom.AndroidDomElement;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.dom.RequiredImpl;
import org.jetbrains.android.dom.Styleable;
import org.jetbrains.android.dom.animation.InterpolatorElement;
import org.jetbrains.android.dom.animation.fileDescriptions.InterpolatorDomFileDescription;
import org.jetbrains.android.dom.attrs.ToolsAttributeUtil;
import org.jetbrains.android.dom.converters.CompositeConverter;
import org.jetbrains.android.dom.converters.ManifestPlaceholderConverter;
import org.jetbrains.android.dom.converters.ResourceReferenceConverter;
import org.jetbrains.android.dom.layout.Data;
import org.jetbrains.android.dom.layout.DataBindingElement;
import org.jetbrains.android.dom.layout.Fragment;
import org.jetbrains.android.dom.layout.LayoutElement;
import org.jetbrains.android.dom.layout.LayoutViewElement;
import org.jetbrains.android.dom.layout.LayoutViewElementDescriptor;
import org.jetbrains.android.dom.layout.Tag;
import org.jetbrains.android.dom.manifest.AndroidManifestUtils;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.dom.manifest.ManifestElement;
import org.jetbrains.android.dom.manifest.UsesSdk;
import org.jetbrains.android.dom.menu.MenuItem;
import org.jetbrains.android.dom.navigation.NavDestinationElement;
import org.jetbrains.android.dom.navigation.NavigationSchema;
import org.jetbrains.android.dom.raw.XmlRawResourceElement;
import org.jetbrains.android.dom.xml.AndroidXmlResourcesUtil;
import org.jetbrains.android.dom.xml.Intent;
import org.jetbrains.android.dom.xml.XmlResourceElement;
import org.jetbrains.android.facet.AndroidClassesForXmlUtilKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.TagFromClassDescriptor;
import org.jetbrains.android.resourceManagers.FrameworkResourceManager;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AttributeProcessingUtil {
    private static final String PREFERENCE_TAG_NAME = "Preference";
    private static final ImmutableSet<String> SIZE_NOT_REQUIRED_TAG_NAMES = ImmutableSet.of((Object)"merge", (Object)"TableRow", (Object)"include", (Object)"requestFocus", (Object)"layout", (Object)"data", (Object[])new String[]{"import", "tag"});
    private static final ImmutableSet<String> SIZE_NOT_REQUIRED_PARENT_TAG_NAMES = ImmutableSet.of((Object)"TableRow", (Object)"TableLayout", (Object)"merge", (Object)"GridLayout", (Object)AndroidXConstants.FQCN_GRID_LAYOUT_V7.oldName(), (Object)AndroidXConstants.FQCN_GRID_LAYOUT_V7.newName(), (Object[])new String[]{"android.support.percent.PercentRelativeLayout", "android.support.percent.PercentFrameLayout"});

    private AttributeProcessingUtil() {
    }

    private static Logger getLog() {
        return Logger.getInstance(AttributeProcessingUtil.class);
    }

    public static boolean isLayoutAttributeRequired(@NotNull XmlName attributeName, @NotNull DomElement element2) {
        String localName = attributeName.getLocalName();
        if (!"layout_width".equals(localName) && !"layout_height".equals(localName)) {
            return false;
        }
        if ((element2 instanceof LayoutViewElement || element2 instanceof Fragment) && "http://schemas.android.com/apk/res/android".equals(attributeName.getNamespaceKey())) {
            String tagName;
            XmlElement xmlElement = element2.getXmlElement();
            XmlTag tag = xmlElement instanceof XmlTag ? (XmlTag)xmlElement : null;
            String string = tagName = tag != null ? tag.getName() : null;
            if (!(SIZE_NOT_REQUIRED_TAG_NAMES.contains((Object)tagName) || tag != null && tag.getAttribute("style") != null)) {
                String parentTagName;
                XmlTag parentTag = tag != null ? tag.getParentTag() : null;
                String string2 = parentTagName = parentTag != null ? parentTag.getName() : null;
                if (!SIZE_NOT_REQUIRED_PARENT_TAG_NAMES.contains((Object)parentTagName)) {
                    return true;
                }
            }
        }
        return false;
    }

    @Nullable
    private static String getNamespaceUriByResourcePackage(@NotNull AndroidFacet facet2, @Nullable String resPackage) {
        if (resPackage == null) {
            String aPackage;
            if (!((AndroidFacetConfiguration)facet2.getConfiguration()).isAppProject() || AndroidModel.isRequired(facet2)) {
                return "http://schemas.android.com/apk/res-auto";
            }
            Manifest manifest = Manifest.getMainManifest(facet2);
            if (manifest != null && (aPackage = (String)manifest.getPackage().getValue()) != null && !aPackage.isEmpty()) {
                return "http://schemas.android.com/apk/res/" + aPackage;
            }
        } else if (resPackage.equals("android")) {
            return "http://schemas.android.com/apk/res/android";
        }
        return null;
    }

    private static void registerStyleableAttributes(@NotNull DomElement element2, @NotNull StyleableDefinition styleable, @Nullable String namespaceUri, @NotNull AttributeProcessor callback2, @NotNull Set<XmlName> skippedAttributes) {
        for (AttributeDefinition attrDef : styleable.getAttributes()) {
            XmlName xmlName = AttributeProcessingUtil.getXmlName(attrDef, namespaceUri);
            if (!skippedAttributes.add(xmlName)) continue;
            AttributeProcessingUtil.registerAttribute(attrDef, xmlName, styleable.getName(), element2, callback2);
        }
    }

    private static boolean mustBeSoft(@NotNull Converter converter, @NotNull Collection<AttributeFormat> formats) {
        if (converter instanceof CompositeConverter || converter instanceof ResourceReferenceConverter) {
            return false;
        }
        return formats.size() > 1;
    }

    private static void registerAttribute(@NotNull AttributeDefinition attrDef, @NotNull XmlName xmlName, @Nullable String parentStyleableName, @NotNull DomElement element2, @NotNull AttributeProcessor callback2) {
        DomExtension extension = callback2.processAttribute(xmlName, attrDef, parentStyleableName);
        if (extension == null) {
            return;
        }
        Object converter = AndroidDomUtil.getSpecificConverter(xmlName, element2);
        if (converter == null) {
            if ("http://schemas.android.com/tools".equals(xmlName.getNamespaceKey())) {
                converter = ToolsAttributeUtil.getConverter(attrDef);
            } else {
                converter = AndroidDomUtil.getConverter(attrDef);
                if (converter != null && element2.getParentOfType(Manifest.class, true) != null) {
                    converter = new ManifestPlaceholderConverter((Converter)converter);
                }
            }
        }
        if (converter != null) {
            extension.setConverter(converter, AttributeProcessingUtil.mustBeSoft(converter, attrDef.getFormats()));
        }
        if (element2 instanceof LayoutElement && AttributeProcessingUtil.isLayoutAttributeRequired(xmlName, element2) || element2 instanceof ManifestElement && AndroidManifestUtils.isRequiredAttribute(xmlName, element2)) {
            extension.addCustomAnnotation((Annotation)((Object)new RequiredImpl()));
        }
    }

    private static void registerAttributes(@NotNull AndroidFacet facet2, @NotNull DomElement element2, @NotNull String styleableName, @Nullable String resPackage, @NotNull AttributeProcessor callback2, @NotNull Set<XmlName> skipNames) {
        ResourceManager manager = ModuleResourceManagers.getInstance(facet2).getResourceManager(resPackage);
        if (manager == null) {
            return;
        }
        AttributeDefinitions attrDefs = manager.getAttributeDefinitions();
        if (attrDefs == null) {
            return;
        }
        String namespace = AttributeProcessingUtil.getNamespaceUriByResourcePackage(facet2, resPackage);
        StyleableDefinition styleable = attrDefs.getStyleableByName(styleableName);
        if (styleable != null) {
            AttributeProcessingUtil.registerStyleableAttributes(element2, styleable, namespace, callback2, skipNames);
        }
    }

    private static void registerAttributesForClassAndSuperclasses(@NotNull AndroidFacet facet2, @NotNull DomElement element2, @Nullable PsiClass c, @NotNull AttributeProcessor callback2, @NotNull Set<XmlName> skipNames) {
        while (c != null) {
            String additionalStyleableName;
            PsiClass additional;
            String styleableName = c.getName();
            if (styleableName != null) {
                AttributeProcessingUtil.registerAttributes(facet2, element2, styleableName, AttributeProcessingUtil.getResourcePackage(c), callback2, skipNames);
            }
            if ((additional = AttributeProcessingUtil.getAdditionalAttributesClass(facet2, c)) != null && (additionalStyleableName = additional.getName()) != null) {
                AttributeProcessingUtil.registerAttributes(facet2, element2, additionalStyleableName, AttributeProcessingUtil.getResourcePackage(additional), callback2, skipNames);
            }
            c = AttributeProcessingUtil.getSuperclass(c);
        }
    }

    @Nullable
    private static PsiClass getAdditionalAttributesClass(@NotNull AndroidFacet facet2, @NotNull PsiClass c) {
        if (AndroidXConstants.CLASS_NESTED_SCROLL_VIEW.isEquals(StringUtil.notNullize((String)c.getQualifiedName()))) {
            return AndroidClassesForXmlUtilKt.findViewValidInXMLByName(facet2, "ScrollView");
        }
        return null;
    }

    @Nullable
    private static String getResourcePackage(@NotNull PsiClass psiClass) {
        String qualifiedName = psiClass.getQualifiedName();
        return qualifiedName != null && qualifiedName.startsWith("android.") && !qualifiedName.startsWith("android.support.") && !qualifiedName.startsWith("androidx.") && !qualifiedName.startsWith("android.arch.") ? "android" : null;
    }

    @Nullable
    private static PsiClass getSuperclass(@NotNull PsiClass c) {
        return (PsiClass)ApplicationManager.getApplication().runReadAction(() -> c.isValid() ? c.getSuperClass() : null);
    }

    public static void processXmlAttributes(@NotNull AndroidFacet facet2, @NotNull XmlTag tag, @NotNull XmlResourceElement element2, @NotNull Set<XmlName> skipAttrNames, @NotNull AttributeProcessor callback2) {
        PsiClass widgetClass;
        String widgetClassName;
        String tagName = tag.getName();
        String styleableName = (String)AndroidXmlResourcesUtil.SPECIAL_STYLEABLE_NAMES.get((Object)tagName);
        if (styleableName != null) {
            HashSet<XmlName> newSkipAttrNames = new HashSet<XmlName>();
            if (element2 instanceof Intent) {
                newSkipAttrNames.add(new XmlName("action", "http://schemas.android.com/apk/res/android"));
            }
            AttributeProcessingUtil.registerAttributes(facet2, element2, styleableName, "android", callback2, newSkipAttrNames);
        }
        AndroidXmlResourcesUtil.PreferenceSource preferenceSource = AndroidXmlResourcesUtil.PreferenceSource.getPreferencesSource(tag, facet2);
        Map<String, PsiClass> prefClassMap = TagToClassMapper.getInstance(facet2.getModule()).getClassMap(preferenceSource.getQualifiedBaseClass());
        PsiClass psiClass = prefClassMap.get(tagName);
        if (psiClass == null) {
            return;
        }
        AttributeProcessingUtil.registerAttributesForClassAndSuperclasses(facet2, element2, psiClass, callback2, skipAttrNames);
        if (StringUtil.notNullize((String)psiClass.getQualifiedName()).startsWith("android.preference.") && (widgetClassName = AndroidTextUtils.trimEndOrNullize((String)tagName, (String)PREFERENCE_TAG_NAME)) != null && (widgetClass = AndroidClassesForXmlUtilKt.findViewValidInXMLByName(facet2, widgetClassName)) != null) {
            AttributeProcessingUtil.registerAttributesForClassAndSuperclasses(facet2, element2, widgetClass, callback2, skipAttrNames);
        }
    }

    @Nullable
    public static String getLayoutStyleablePrimary(@NotNull PsiClass psiLayoutClass) {
        String viewName = psiLayoutClass.getName();
        if (viewName == null) {
            return null;
        }
        switch (viewName) {
            case "ViewGroup": {
                return "ViewGroup_MarginLayout";
            }
            case "TableRow": {
                return "TableRow_Cell";
            }
        }
        return viewName + "_Layout";
    }

    @Nullable
    public static String getLayoutStyleableSecondary(@NotNull PsiClass psiLayoutClass) {
        String viewName = psiLayoutClass.getName();
        if (viewName == null) {
            return null;
        }
        return viewName + "_LayoutParams";
    }

    private static void registerAttributesFromSuffixedStyleables(@NotNull AndroidFacet facet2, @NotNull DomElement element2, @NotNull PsiClass psiClass, @NotNull AttributeProcessor callback2, @NotNull Set<XmlName> skipAttrNames) {
        String secondary;
        String primary = AttributeProcessingUtil.getLayoutStyleablePrimary(psiClass);
        if (primary != null) {
            AttributeProcessingUtil.registerAttributes(facet2, element2, primary, AttributeProcessingUtil.getResourcePackage(psiClass), callback2, skipAttrNames);
        }
        if ((secondary = AttributeProcessingUtil.getLayoutStyleableSecondary(psiClass)) != null) {
            AttributeProcessingUtil.registerAttributes(facet2, element2, secondary, null, callback2, skipAttrNames);
        }
    }

    private static void registerAttributesFromSuffixedStyleables(@NotNull AndroidFacet facet2, @NotNull DomElement element2, @NotNull AttributeProcessor callback2, @NotNull Set<XmlName> skipAttrNames) {
        AttributeProcessingUtil.registerAttributesFromSuffixedStyleablesForNamespace(facet2, element2, callback2, skipAttrNames, ResourceNamespace.ANDROID);
        AttributeProcessingUtil.registerAttributesFromSuffixedStyleablesForNamespace(facet2, element2, callback2, skipAttrNames, ResourceNamespace.RES_AUTO);
    }

    private static void registerAttributesFromSuffixedStyleablesForNamespace(@NotNull AndroidFacet facet2, @NotNull DomElement element2, @NotNull AttributeProcessor callback2, @NotNull Set<XmlName> skipAttrNames, @NotNull ResourceNamespace resourceNamespace) {
        ResourceRepository repo = StudioResourceRepositoryManager.getInstance(facet2).getResourcesForNamespace(resourceNamespace);
        if (repo == null) {
            return;
        }
        List layoutStyleablesPrimary = repo.getResources(resourceNamespace, ResourceType.STYLEABLE, item2 -> {
            String name2 = item2.getName();
            return name2.endsWith("_Layout") || name2.endsWith("_LayoutParams") || name2.equals("ViewGroup_MarginLayout") || name2.equals("TableRow_Cell");
        });
        for (ResourceItem item3 : layoutStyleablesPrimary) {
            int indexOfLastUnderscore;
            String name2 = item3.getName();
            String viewName = name2.substring(0, indexOfLastUnderscore = name2.lastIndexOf(95));
            PsiClass psiClass = AndroidClassesForXmlUtilKt.findViewClassByName(facet2, viewName);
            if (psiClass == null) continue;
            AttributeProcessingUtil.registerAttributes(facet2, element2, name2, AttributeProcessingUtil.getResourcePackage(psiClass), callback2, skipAttrNames);
        }
    }

    public static void processNavAttributes(@NotNull AndroidFacet facet2, @NotNull XmlTag tag, @NotNull NavDestinationElement element2, @NotNull Set<XmlName> skipAttrNames, @NotNull AttributeProcessor callback2) {
        try {
            NavigationSchema.createIfNecessary(facet2.getModule());
        }
        catch (ClassNotFoundException e) {
            return;
        }
        NavigationSchema schema = NavigationSchema.get(facet2.getModule());
        for (PsiClass psiClass : schema.getStyleablesForTag(tag.getName())) {
            AttributeProcessingUtil.registerAttributesForClassAndSuperclasses(facet2, element2, psiClass, callback2, skipAttrNames);
        }
    }

    public static void processLayoutAttributes(@NotNull AndroidFacet facet2, @NotNull XmlTag tag, @NotNull LayoutElement element2, @NotNull Set<XmlName> skipAttrNames, @NotNull AttributeProcessor callback2) {
        String tagName;
        if (!(element2 instanceof DataBindingElement)) {
            XmlElementDescriptor descriptor2;
            AttributeProcessingUtil.registerToolsAttribute("targetApi", callback2);
            AttributeProcessingUtil.registerToolsAttribute("ignore", callback2);
            if (tag.getParentTag() == null) {
                AttributeProcessingUtil.registerToolsAttribute("context", callback2);
                AttributeProcessingUtil.registerToolsAttribute("menu", callback2);
                AttributeProcessingUtil.registerToolsAttribute("actionBarNavMode", callback2);
                AttributeProcessingUtil.registerToolsAttribute("showIn", callback2);
                AttributeProcessingUtil.registerToolsAttribute("viewBindingIgnore", callback2);
            }
            if ((descriptor2 = tag.getDescriptor()) instanceof LayoutViewElementDescriptor && ((LayoutViewElementDescriptor)descriptor2).getClazz() != null) {
                String viewClass = ((LayoutViewElementDescriptor)descriptor2).getClazz();
                AttributeProcessingUtil.registerToolsAttribute("viewBindingType", callback2);
                if (InheritanceUtil.isInheritor((PsiClass)viewClass, (String)"android.widget.AdapterView")) {
                    AttributeProcessingUtil.registerToolsAttribute("listitem", callback2);
                    AttributeProcessingUtil.registerToolsAttribute("listheader", callback2);
                    AttributeProcessingUtil.registerToolsAttribute("listfooter", callback2);
                }
                if (InheritanceUtil.isInheritor((PsiClass)viewClass, (String)AndroidXConstants.CLASS_DRAWER_LAYOUT.newName()) || InheritanceUtil.isInheritor((PsiClass)viewClass, (String)AndroidXConstants.CLASS_DRAWER_LAYOUT.oldName())) {
                    AttributeProcessingUtil.registerToolsAttribute("openDrawer", callback2);
                }
                if (InheritanceUtil.isInheritor((PsiClass)viewClass, (String)AndroidXConstants.RECYCLER_VIEW.newName()) || InheritanceUtil.isInheritor((PsiClass)viewClass, (String)AndroidXConstants.RECYCLER_VIEW.oldName())) {
                    AttributeProcessingUtil.registerToolsAttribute("itemCount", callback2);
                    AttributeProcessingUtil.registerToolsAttribute("listitem", callback2);
                }
            }
        }
        if (element2 instanceof Tag || element2 instanceof Data) {
            return;
        }
        switch (tagName = tag.getName()) {
            case "androidx.compose.ui.platform.ComposeView": {
                AttributeProcessingUtil.registerToolsAttribute("composableName", callback2);
                break;
            }
            case "fragment": {
                AttributeProcessingUtil.registerToolsAttribute("layout", callback2);
                break;
            }
            case "view": {
                PsiClass aClass;
                String name2 = tag.getAttributeValue("class");
                if (name2 == null || (aClass = AndroidClassesForXmlUtilKt.findViewValidInXMLByName(facet2, name2)) == null) break;
                AttributeProcessingUtil.registerAttributesForClassAndSuperclasses(facet2, element2, aClass, callback2, skipAttrNames);
                break;
            }
            case "merge": {
                if (tag.getParentTag() == null) {
                    AttributeProcessingUtil.registerToolsAttribute("parentTag", callback2);
                }
                AttributeProcessingUtil.registerAttributesForClassAndSuperclasses(facet2, element2, AndroidClassesForXmlUtilKt.findViewValidInXMLByName(facet2, "merge"), callback2, skipAttrNames);
                String parentTagName = tag.getAttributeValue("parentTag", "http://schemas.android.com/tools");
                if (parentTagName == null) break;
                AttributeProcessingUtil.registerAttributesForClassAndSuperclasses(facet2, element2, AndroidClassesForXmlUtilKt.findViewValidInXMLByName(facet2, parentTagName), callback2, skipAttrNames);
                break;
            }
            default: {
                PsiClass c = AndroidClassesForXmlUtilKt.findViewValidInXMLByName(facet2, tagName);
                AttributeProcessingUtil.registerAttributesForClassAndSuperclasses(facet2, element2, c, callback2, skipAttrNames);
            }
        }
        if (tagName.equals("merge")) {
            return;
        }
        XmlTag parentTag = tag.getParentTag();
        PsiClass parentViewClass = null;
        if (parentTag != null) {
            String parentTagName = parentTag.getName();
            if ("merge".equals(parentTagName)) {
                parentTagName = parentTag.getAttributeValue("parentTag", "http://schemas.android.com/tools");
            }
            if ("layout".equals(parentTagName)) {
                parentViewClass = AndroidClassesForXmlUtilKt.findViewClassByName(facet2, "android.view.ViewGroup");
            } else if (parentTagName != null) {
                parentViewClass = AndroidClassesForXmlUtilKt.findViewValidInXMLByName(facet2, parentTagName);
            }
            if (parentTagName != null) {
                while (parentViewClass != null) {
                    AttributeProcessingUtil.registerAttributesFromSuffixedStyleables(facet2, element2, parentViewClass, callback2, skipAttrNames);
                    parentViewClass = AttributeProcessingUtil.getSuperclass(parentViewClass);
                }
                return;
            }
        }
        AttributeProcessingUtil.registerAttributesFromSuffixedStyleables(facet2, element2, callback2, skipAttrNames);
    }

    public static void processAttributes(@NotNull AndroidDomElement element2, @NotNull AndroidFacet facet2, boolean processAllExistingAttrsFirst, @NotNull AttributeProcessor callback2) {
        String styleableName;
        AttributeDefinitions definitions;
        if (DumbService.getInstance((Project)facet2.getModule().getProject()).isDumb()) {
            return;
        }
        XmlTag tag = element2.getXmlTag();
        assert (tag != null);
        HashSet<XmlName> skippedAttributes = processAllExistingAttrsFirst ? AttributeProcessingUtil.registerExistingAttributes(facet2, tag, element2, callback2) : new HashSet<XmlName>();
        XmlElementDescriptor descriptor2 = tag.getDescriptor();
        if (descriptor2 instanceof TagFromClassDescriptor && ((TagFromClassDescriptor)descriptor2).getClazz() == null) {
            return;
        }
        if (element2 instanceof ManifestElement) {
            AttributeProcessingUtil.processManifestAttributes(tag, element2, callback2);
        } else if (element2 instanceof LayoutElement) {
            AttributeProcessingUtil.processLayoutAttributes(facet2, tag, (LayoutElement)element2, skippedAttributes, callback2);
        } else if (element2 instanceof XmlResourceElement) {
            AttributeProcessingUtil.processXmlAttributes(facet2, tag, (XmlResourceElement)element2, skippedAttributes, callback2);
        } else if (element2 instanceof XmlRawResourceElement) {
            AttributeProcessingUtil.processRawAttributes(tag, callback2);
        } else if (element2 instanceof NavDestinationElement) {
            AttributeProcessingUtil.processNavAttributes(facet2, tag, (NavDestinationElement)element2, skippedAttributes, callback2);
        }
        Styleable styleableAnnotation = (Styleable)element2.getAnnotation(Styleable.class);
        if (styleableAnnotation == null) {
            return;
        }
        boolean isSystem = styleableAnnotation.packageName().equals("android");
        if (isSystem) {
            String[] manager = ModuleResourceManagers.getInstance(facet2).getFrameworkResourceManager();
            if (manager == null) {
                return;
            }
            definitions = manager.getAttributeDefinitions();
            if (definitions == null) {
                return;
            }
        } else {
            definitions = ModuleResourceManagers.getInstance(facet2).getLocalResourceManager().getAttributeDefinitions();
        }
        if (element2 instanceof MenuItem) {
            AttributeProcessingUtil.processMenuItemAttributes(facet2, element2, skippedAttributes, callback2);
            return;
        }
        for (String styleableName2 : styleableAnnotation.value()) {
            StyleableDefinition styleable = definitions.getStyleableByName(styleableName2);
            if (styleable != null) {
                AttributeProcessingUtil.registerStyleableAttributes(element2, styleable, isSystem ? "http://schemas.android.com/apk/res/android" : "http://schemas.android.com/apk/res-auto", callback2, skippedAttributes);
                continue;
            }
            if (!isSystem) continue;
            AttributeProcessingUtil.getLog().warn(String.format("@Styleable(%s) annotation doesn't point to existing styleable", styleableName2));
        }
        if (element2 instanceof InterpolatorElement && (styleableName = InterpolatorDomFileDescription.getInterpolatorStyleableByTagName(tag.getName())) != null) {
            StyleableDefinition styleable = definitions.getStyleableByName(styleableName);
            if (styleable == null) {
                AttributeProcessingUtil.getLog().warn(String.format("%s doesn't point to existing styleable for interpolator", styleableName));
            } else {
                AttributeProcessingUtil.registerStyleableAttributes(element2, styleable, "http://schemas.android.com/apk/res/android", callback2, skippedAttributes);
            }
        }
    }

    public static void processRawAttributes(@NotNull XmlTag tag, @NotNull AttributeProcessor callback2) {
        if ("resources".equals(tag.getName())) {
            AttributeProcessingUtil.registerToolsAttribute("shrinkMode", callback2);
            AttributeProcessingUtil.registerToolsAttribute("keep", callback2);
            AttributeProcessingUtil.registerToolsAttribute("discard", callback2);
        }
    }

    public static void processManifestAttributes(@NotNull XmlTag tag, @NotNull AndroidDomElement element2, @NotNull AttributeProcessor callback2) {
        if (tag.getParentTag() != null) {
            AttributeProcessingUtil.registerToolsAttribute("node", callback2);
            AttributeProcessingUtil.registerToolsAttribute("strict", callback2);
            AttributeProcessingUtil.registerToolsAttribute("remove", callback2);
            AttributeProcessingUtil.registerToolsAttribute("replace", callback2);
        }
        if (element2 instanceof UsesSdk) {
            AttributeProcessingUtil.registerToolsAttribute("overrideLibrary", callback2);
        }
    }

    private static void processMenuItemAttributes(@NotNull AndroidFacet facet2, @NotNull DomElement element2, @NotNull Collection<XmlName> skippedAttributes, @NotNull AttributeProcessor callback2) {
        FrameworkResourceManager manager = ModuleResourceManagers.getInstance(facet2).getFrameworkResourceManager();
        if (manager == null) {
            return;
        }
        AttributeDefinitions styleables = ((ResourceManager)manager).getAttributeDefinitions();
        if (styleables == null) {
            return;
        }
        StyleableDefinition styleable = styleables.getStyleableByName("MenuItem");
        if (styleable == null) {
            AttributeProcessingUtil.getLog().warn("No StyleableDefinition for MenuItem");
            return;
        }
        for (AttributeDefinition attribute2 : styleable.getAttributes()) {
            XmlName xmlName;
            String name2 = attribute2.getName();
            if (name2.equals("showAsAction")) {
                boolean hasAppCompat;
                boolean bl = hasAppCompat = DependencyManagementUtil.dependsOn(facet2.getModule(), GoogleMavenArtifactId.APP_COMPAT_V7) || DependencyManagementUtil.dependsOn(facet2.getModule(), GoogleMavenArtifactId.ANDROIDX_APP_COMPAT_V7);
                if (hasAppCompat) {
                    XmlName xmlName2 = new XmlName(name2, "http://schemas.android.com/apk/res-auto");
                    if (!skippedAttributes.add(xmlName2)) continue;
                    AttributeProcessingUtil.registerAttribute(attribute2, xmlName2, "MenuItem", element2, callback2);
                    continue;
                }
            }
            if (!skippedAttributes.add(xmlName = new XmlName(name2, "http://schemas.android.com/apk/res/android"))) continue;
            AttributeProcessingUtil.registerAttribute(attribute2, xmlName, "MenuItem", element2, callback2);
        }
    }

    private static void registerToolsAttribute(@NotNull String attributeName, @NotNull AttributeProcessor callback2) {
        AttributeDefinition definition = ToolsAttributeUtil.getAttrDefByName(attributeName);
        if (definition != null) {
            XmlName name2 = new XmlName(attributeName, "http://schemas.android.com/tools");
            DomExtension domExtension = callback2.processAttribute(name2, definition, null);
            Converter converter = ToolsAttributeUtil.getConverter(definition);
            if (domExtension != null && converter != null) {
                domExtension.setConverter(converter);
            }
        } else {
            AttributeProcessingUtil.getLog().warn("No attribute definition for tools attribute " + attributeName);
        }
    }

    @NotNull
    private static Set<XmlName> registerExistingAttributes(@NotNull AndroidFacet facet2, @NotNull XmlTag tag, @NotNull AndroidDomElement element2, @NotNull AttributeProcessor callback2) {
        XmlAttribute[] attrs;
        HashSet<XmlName> result2 = new HashSet<XmlName>();
        for (XmlAttribute attr : attrs = tag.getAttributes()) {
            AttributeDefinition attrDef;
            String localName = attr.getLocalName();
            if (localName.endsWith(CompletionUtil.DUMMY_IDENTIFIER_TRIMMED) || "xmlns".equals(attr.getNamespacePrefix()) || (attrDef = AndroidDomUtil.getAttributeDefinition(facet2, attr)) == null) continue;
            XmlName xmlName = AttributeProcessingUtil.getXmlName(attrDef, attr.getNamespace());
            result2.add(xmlName);
            String namespaceUri = attr.getNamespace();
            AttributeProcessingUtil.registerAttribute(attrDef, xmlName, null, element2, callback2);
        }
        return result2;
    }

    private static XmlName getXmlName(@NotNull AttributeDefinition attrDef, @Nullable String namespaceUri) {
        ResourceReference attrReference = attrDef.getResourceReference();
        String attrNamespaceUri = attrReference.getNamespace().getXmlNamespaceUri();
        return new XmlName(attrReference.getName(), "http://schemas.android.com/tools".equals(namespaceUri) ? "http://schemas.android.com/tools" : attrNamespaceUri);
    }

    public static interface AttributeProcessor {
        @Nullable
        public DomExtension processAttribute(@NotNull XmlName var1, @NotNull AttributeDefinition var2, @Nullable String var3);
    }
}

