/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom;

import com.android.tools.idea.model.AndroidManifestIndexQueryUtils;
import com.android.tools.idea.model.StudioAndroidModuleInfo;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.ScopeType;
import com.android.tools.idea.psi.TagToClassMapper;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.util.ModuleExtensionsKt;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiQualifiedNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.migration.MigrationClassImpl;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ProcessingContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.xml.XmlElementDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.android.dom.AndroidXmlReferenceProvider;
import org.jetbrains.android.dom.AndroidXmlReferenceProviderKt;
import org.jetbrains.android.dom.drawable.CustomDrawableDomElement;
import org.jetbrains.android.dom.layout.LayoutViewElement;
import org.jetbrains.android.dom.layout.View;
import org.jetbrains.android.dom.xml.AndroidXmlResourcesUtil;
import org.jetbrains.android.dom.xml.PreferenceElement;
import org.jetbrains.android.facet.AndroidClassesForXmlUtilKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.TagFromClassDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00132\u00020\u0001:\u0002\u0013\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J#\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/android/dom/AndroidXmlReferenceProvider;", "Lcom/intellij/psi/PsiReferenceProvider;", "()V", "getClassFilter", "Lkotlin/Function2;", "", "Lcom/intellij/psi/PsiClass;", "", "baseClassQName", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "getReferencesByElement", "", "Lcom/intellij/psi/PsiReference;", "element", "Lcom/intellij/psi/PsiElement;", "context", "Lcom/intellij/util/ProcessingContext;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/util/ProcessingContext;)[Lcom/intellij/psi/PsiReference;", "Companion", "MyClassOrPackageReference", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nAndroidXmlReferenceProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidXmlReferenceProvider.kt\norg/jetbrains/android/dom/AndroidXmlReferenceProvider\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,217:1\n26#2:218\n26#2:219\n26#2:220\n37#3,2:221\n*S KotlinDebug\n*F\n+ 1 AndroidXmlReferenceProvider.kt\norg/jetbrains/android/dom/AndroidXmlReferenceProvider\n*L\n46#1:218\n48#1:219\n50#1:220\n62#1:221,2\n*E\n"})
public final class AndroidXmlReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element2, @NotNull ProcessingContext context2) {
        ASTNode closingTagName;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!(element2 instanceof XmlTag)) {
            boolean $i$f$emptyArray = false;
            return new PsiReference[0];
        }
        AndroidFacet androidFacet = ModuleExtensionsKt.getAndroidFacet((PsiElement)element2);
        if (androidFacet == null) {
            boolean $i$f$emptyArray = false;
            return new PsiReference[0];
        }
        AndroidFacet facet2 = androidFacet;
        String string = AndroidXmlReferenceProvider.Companion.computeBaseClass((XmlTag)element2);
        if (string == null) {
            boolean $i$f$emptyArray = false;
            return new PsiReference[0];
        }
        String baseClassQName = string;
        Function2 function2 = this.getClassFilter(baseClassQName, facet2);
        if (function2 == null) {
            function2 = getReferencesByElement.classFilter.1.INSTANCE;
        }
        Function2 classFilter2 = function2;
        List result2 = new ArrayList();
        ASTNode startTagName = XmlChildRole.START_TAG_NAME_FINDER.findChild(element2.getNode());
        if (startTagName != null) {
            AndroidXmlReferenceProvider.Companion.addReferences((XmlTag)element2, startTagName, result2, facet2, baseClassQName, (Function2<? super String, ? super PsiClass, Boolean>)classFilter2, true);
        }
        if ((closingTagName = XmlChildRole.CLOSING_TAG_NAME_FINDER.findChild(element2.getNode())) != null) {
            AndroidXmlReferenceProvider.Companion.addReferences((XmlTag)element2, closingTagName, result2, facet2, baseClassQName, (Function2<? super String, ? super PsiClass, Boolean>)classFilter2, false);
        }
        Collection $this$toTypedArray$iv = result2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new PsiReference[0]);
    }

    private final Function2<String, PsiClass, Boolean> getClassFilter(String baseClassQName, AndroidFacet facet2) {
        if (Intrinsics.areEqual((Object)baseClassQName, (Object)"android.graphics.drawable.Drawable")) {
            String string = AndroidManifestIndexQueryUtils.queryPackageNameFromManifestIndex(facet2);
            if (string == null) {
                return getClassFilter.packageName.1.INSTANCE;
            }
            String packageName2 = string;
            return (Function2)new Function2<String, PsiClass, Boolean>(packageName2){
                final /* synthetic */ String $packageName;
                {
                    this.$packageName = $packageName;
                    super(2);
                }

                @NotNull
                public final Boolean invoke(@NotNull String string, @NotNull PsiClass psiClass) {
                    Intrinsics.checkNotNullParameter((Object)string, (String)"<anonymous parameter 0>");
                    Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
                    String string2 = psiClass.getQualifiedName();
                    return string2 != null ? StringsKt.startsWith$default((String)string2, (String)this.$packageName, (boolean)false, (int)2, null) : false;
                }
            };
        }
        return null;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JX\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0018\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00112\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/android/dom/AndroidXmlReferenceProvider$Companion;", "", "()V", "addReferences", "", "tag", "Lcom/intellij/psi/xml/XmlTag;", "nameElement", "Lcom/intellij/lang/ASTNode;", "result", "", "Lcom/intellij/psi/PsiReference;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "baseClassQName", "", "classFilter", "Lkotlin/Function2;", "Lcom/intellij/psi/PsiClass;", "", "startTag", "computeBaseClass", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        private final void addReferences(XmlTag tag, ASTNode nameElement, List<PsiReference> result2, AndroidFacet facet2, String baseClassQName, Function2<? super String, ? super PsiClass, Boolean> classFilter2, boolean startTag) {
            String string = nameElement.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nameElement.text");
            String text2 = string;
            String[] stringArray = new String[]{"."};
            List nameParts = StringsKt.split$default((CharSequence)text2, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            int offset = 0;
            for (String name2 : nameParts) {
                if (((CharSequence)name2).length() > 0) {
                    TextRange range = new TextRange((offset += name2.length()) - name2.length(), offset);
                    result2.add((PsiReference)new MyClassOrPackageReference(tag, nameElement, range, facet2, baseClassQName, classFilter2, startTag));
                }
                ++offset;
            }
        }

        private final String computeBaseClass(XmlTag tag) {
            String string;
            DomElement domElement = DomManager.getDomManager((Project)tag.getProject()).getDomElement(tag);
            if (domElement instanceof LayoutViewElement && !(domElement instanceof View)) {
                string = "android.view.View";
            } else if (domElement instanceof PreferenceElement) {
                AndroidFacet androidFacet = ModuleExtensionsKt.getAndroidFacet((PsiElement)((PsiElement)tag));
                if (androidFacet == null) {
                    return null;
                }
                AndroidFacet facet2 = androidFacet;
                string = AndroidXmlResourcesUtil.PreferenceSource.getPreferencesSource(tag, facet2).getQualifiedBaseClass();
            } else {
                string = domElement instanceof CustomDrawableDomElement ? "android.graphics.drawable.Drawable" : null;
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001BO\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u0002H\u0016J\b\u0010\u001d\u001a\u00020\bH\u0016J\u0013\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0016\u00a2\u0006\u0002\u0010!J\u0012\u0010\"\u001a\u0004\u0018\u00010\u00022\u0006\u0010#\u001a\u00020\fH\u0016J\n\u0010$\u001a\u0004\u0018\u00010\u0002H\u0016J\n\u0010%\u001a\u0004\u0018\u00010\u0002H\u0002R \u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0013\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0018\u001a\u00070\u0019\u00a2\u0006\u0002\b\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/android/dom/AndroidXmlReferenceProvider$MyClassOrPackageReference;", "Lcom/intellij/psi/PsiReferenceBase;", "Lcom/intellij/psi/PsiElement;", "tag", "Lcom/intellij/psi/xml/XmlTag;", "myNameElement", "Lcom/intellij/lang/ASTNode;", "myRangeInNameElement", "Lcom/intellij/openapi/util/TextRange;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "myBaseClassQName", "", "classFilter", "Lkotlin/Function2;", "Lcom/intellij/psi/PsiClass;", "", "myStartTag", "(Lcom/intellij/psi/xml/XmlTag;Lcom/intellij/lang/ASTNode;Lcom/intellij/openapi/util/TextRange;Lorg/jetbrains/android/facet/AndroidFacet;Ljava/lang/String;Lkotlin/jvm/functions/Function2;Z)V", "isParentContainer", "()Z", "isParentContainer$delegate", "Lkotlin/Lazy;", "packagePrefix", "project", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/annotations/NotNull;", "bindToElement", "element", "getRangeInElement", "getVariants", "", "", "()[Ljava/lang/Object;", "handleElementRename", "newElementName", "resolve", "resolveInner", "intellij.android.core"})
    @SourceDebugExtension(value={"SMAP\nAndroidXmlReferenceProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidXmlReferenceProvider.kt\norg/jetbrains/android/dom/AndroidXmlReferenceProvider$MyClassOrPackageReference\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,217:1\n1#2:218\n26#3:219\n26#3:220\n513#4:221\n498#4,6:222\n513#4:228\n498#4,6:229\n125#5:235\n152#5,3:236\n37#6,2:239\n*S KotlinDebug\n*F\n+ 1 AndroidXmlReferenceProvider.kt\norg/jetbrains/android/dom/AndroidXmlReferenceProvider$MyClassOrPackageReference\n*L\n103#1:219\n109#1:220\n115#1:221\n115#1:222,6\n124#1:228\n124#1:229,6\n125#1:235\n125#1:236,3\n125#1:239,2\n*E\n"})
    private static final class MyClassOrPackageReference
    extends PsiReferenceBase<PsiElement> {
        @NotNull
        private final ASTNode myNameElement;
        @NotNull
        private final TextRange myRangeInNameElement;
        @NotNull
        private final AndroidFacet facet;
        @NotNull
        private final String myBaseClassQName;
        @NotNull
        private final Function2<String, PsiClass, Boolean> classFilter;
        private final boolean myStartTag;
        @NotNull
        private final Project project;
        @NotNull
        private final String packagePrefix;
        @NotNull
        private final Lazy isParentContainer$delegate;

        public MyClassOrPackageReference(@NotNull XmlTag tag, @NotNull ASTNode myNameElement, @NotNull TextRange myRangeInNameElement, @NotNull AndroidFacet facet2, @NotNull String myBaseClassQName, @NotNull Function2<? super String, ? super PsiClass, Boolean> classFilter2, boolean myStartTag) {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Intrinsics.checkNotNullParameter((Object)myNameElement, (String)"myNameElement");
            Intrinsics.checkNotNullParameter((Object)myRangeInNameElement, (String)"myRangeInNameElement");
            Intrinsics.checkNotNullParameter((Object)facet2, (String)"facet");
            Intrinsics.checkNotNullParameter((Object)myBaseClassQName, (String)"myBaseClassQName");
            Intrinsics.checkNotNullParameter(classFilter2, (String)"classFilter");
            super((PsiElement)tag, true);
            this.myNameElement = myNameElement;
            this.myRangeInNameElement = myRangeInNameElement;
            this.facet = facet2;
            this.myBaseClassQName = myBaseClassQName;
            this.classFilter = classFilter2;
            this.myStartTag = myStartTag;
            Project project = tag.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"tag.project");
            this.project = project;
            String string = this.myNameElement.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"myNameElement.text");
            String string2 = string;
            int n = 0;
            int n2 = this.myRangeInNameElement.getStartOffset();
            String string3 = string2.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            this.packagePrefix = string3;
            this.isParentContainer$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(tag){
                final /* synthetic */ XmlTag $tag;
                {
                    this.$tag = $tag;
                    super(0);
                }

                @NotNull
                public final Boolean invoke() {
                    PsiElement psiElement = this.$tag.getParent();
                    XmlTag xmlTag = psiElement instanceof XmlTag ? (XmlTag)psiElement : null;
                    XmlElementDescriptor xmlElementDescriptor = xmlTag != null ? xmlTag.getDescriptor() : null;
                    TagFromClassDescriptor tagFromClassDescriptor = xmlElementDescriptor instanceof TagFromClassDescriptor ? (TagFromClassDescriptor)xmlElementDescriptor : null;
                    if (tagFromClassDescriptor == null) {
                        return true;
                    }
                    TagFromClassDescriptor parentTagFromClassDescriptor = tagFromClassDescriptor;
                    return parentTagFromClassDescriptor.isContainer();
                }
            }));
        }

        private final boolean isParentContainer() {
            Lazy lazy = this.isParentContainer$delegate;
            return (Boolean)lazy.getValue();
        }

        @Nullable
        public PsiElement resolve() {
            return (PsiElement)ResolveCache.getInstance((Project)this.project).resolveWithCaching((PsiReference)this, new ResolveCache.AbstractResolver(this){
                final /* synthetic */ MyClassOrPackageReference this$0;
                {
                    this.this$0 = $receiver;
                }

                @Nullable
                public final PsiElement resolve(@NotNull MyClassOrPackageReference myClassOrPackageReference, boolean bl) {
                    Intrinsics.checkNotNullParameter((Object)((Object)myClassOrPackageReference), (String)"<anonymous parameter 0>");
                    return MyClassOrPackageReference.access$resolveInner(this.this$0);
                }
            }, false, false);
        }

        private final PsiElement resolveInner() {
            PsiPackage psiPackage;
            int end = this.myRangeInNameElement.getEndOffset();
            String string = this.myNameElement.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"myNameElement.text");
            String string2 = string;
            int n = 0;
            String string3 = string2.substring(n, end);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String value2 = string3;
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.project);
            PsiClass psiClass = AndroidClassesForXmlUtilKt.findClassValidInXMLByName(this.facet, value2, this.myBaseClassQName);
            PsiElement psiElement = psiClass instanceof PsiElement ? (PsiElement)psiClass : null;
            if (psiElement == null && (psiElement = (psiPackage = facade.findPackage(value2)) instanceof PsiElement ? (PsiElement)psiPackage : null) == null) {
                Module module2 = this.facet.getModule();
                Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"facet.module");
                PsiPackage it = psiPackage = facade.findClass(value2, ProjectSystemUtil.getModuleSystem(module2).getResolveScope(ScopeType.MAIN));
                boolean bl = false;
                psiElement = (PsiElement)(it instanceof MigrationClassImpl ? psiPackage : null);
            }
            return psiElement;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public Object[] getVariants() {
            void $this$mapTo$iv$iv;
            PsiClass psiClass;
            String name2;
            Map.Entry entry;
            Map.Entry element$iv$iv;
            Map $this$filterTo$iv$iv;
            if (!this.isParentContainer()) {
                boolean $i$f$emptyArray = false;
                return new Object[0];
            }
            if (!this.myStartTag) {
                boolean $i$f$emptyArray = false;
                return new Object[0];
            }
            int apiLevel = StudioAndroidModuleInfo.getInstance(this.facet).getModuleMinApi();
            Map map2 = TagToClassMapper.getInstance(this.facet.getModule()).getClassMap(this.myBaseClassQName);
            Intrinsics.checkNotNullExpressionValue(map2, (String)"getInstance(facet.module\u2026lassMap(myBaseClassQName)");
            Map $this$filter$iv = map2;
            boolean $i$f$filter = false;
            Map map3 = $this$filter$iv;
            Object destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                boolean bl;
                entry = element$iv$iv = iterator2.next();
                boolean bl2 = false;
                name2 = (String)entry.getKey();
                psiClass = (PsiClass)entry.getValue();
                if (((CharSequence)this.packagePrefix).length() == 0 && Intrinsics.areEqual((Object)name2, (Object)psiClass.getQualifiedName())) {
                    String string = psiClass.getQualifiedName();
                    Intrinsics.checkNotNull((Object)string);
                    Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"psiClass");
                    bl = IdeResourcesUtil.isClassPackageNeeded(string, psiClass, apiLevel, this.myBaseClassQName);
                } else {
                    Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"name");
                    bl = StringsKt.startsWith$default((String)name2, (String)this.packagePrefix, (boolean)false, (int)2, null);
                }
                if (!bl) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            $this$filter$iv = destination$iv$iv;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new LinkedHashMap();
            $i$f$filterTo = false;
            iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                entry = element$iv$iv = iterator2.next();
                boolean bl = false;
                name2 = (String)entry.getKey();
                psiClass = (PsiClass)entry.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"name");
                Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"psiClass");
                if (!((Boolean)this.classFilter.invoke((Object)name2, (Object)psiClass)).booleanValue()) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            Map $this$map$iv = destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
                entry = item$iv$iv;
                Object object = destination$iv$iv;
                boolean bl = false;
                name2 = (String)entry.getKey();
                psiClass = (PsiClass)entry.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"name");
                String string = StringsKt.removePrefix((String)name2, (CharSequence)this.packagePrefix);
                Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"psiClass");
                object.add(AndroidXmlReferenceProviderKt.createClassAsTagXmlElement(string, psiClass));
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new Object[0]);
        }

        @NotNull
        public PsiElement bindToElement(@NotNull PsiElement element2) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            String newName2 = ((PsiQualifiedNamedElement)element2).getQualifiedName();
            TextRange range = new TextRange(0, this.myRangeInNameElement.getEndOffset());
            PsiElement psiElement = ElementManipulators.handleContentChange((PsiElement)this.myNameElement.getPsi(), (TextRange)range, (String)newName2);
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"handleContentChange(myNa\u2026ment.psi, range, newName)");
            return psiElement;
        }

        @Nullable
        public PsiElement handleElementRename(@NotNull String newElementName) {
            Intrinsics.checkNotNullParameter((Object)newElementName, (String)"newElementName");
            return ElementManipulators.handleContentChange((PsiElement)this.myNameElement.getPsi(), (TextRange)this.myRangeInNameElement, (String)newElementName);
        }

        @NotNull
        public TextRange getRangeInElement() {
            int parentOffset = this.myNameElement.getStartOffsetInParent();
            return new TextRange(parentOffset + this.myRangeInNameElement.getStartOffset(), parentOffset + this.myRangeInNameElement.getEndOffset());
        }

        public static final /* synthetic */ PsiElement access$resolveInner(MyClassOrPackageReference $this) {
            return $this.resolveInner();
        }
    }
}

