/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiQualifiedNamedElement;
import com.intellij.psi.impl.source.xml.SchemaPrefix;
import com.intellij.psi.impl.source.xml.TagNameReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.DefaultXmlExtension;
import com.intellij.xml.XmlNSDescriptor;
import org.jetbrains.android.dom.AndroidResourceDomFileDescription;
import org.jetbrains.android.dom.drawable.DrawableResourceNSDescriptor;
import org.jetbrains.android.dom.layout.AndroidLayoutNSDescriptor;
import org.jetbrains.android.dom.manifest.ManifestDomFileDescription;
import org.jetbrains.android.dom.xml.XmlResourceNSDescriptor;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.TagFromClassDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidXmlExtension
extends DefaultXmlExtension {
    private static final SchemaPrefix EMPTY_SCHEMA = new SchemaPrefix(null, new TextRange(0, 0), "android");

    @Nullable
    public XmlNSDescriptor getNSDescriptor(XmlTag element2, String namespace, boolean strict) {
        boolean isRoot2;
        XmlFile file2 = (XmlFile)element2.getContainingFile();
        boolean bl = isRoot2 = file2.getRootTag() == element2;
        if (isRoot2 && AndroidResourceDomFileDescription.isFileInResourceFolderType(file2, ResourceFolderType.LAYOUT)) {
            return AndroidLayoutNSDescriptor.INSTANCE;
        }
        if (isRoot2 && AndroidResourceDomFileDescription.isFileInResourceFolderType(file2, ResourceFolderType.XML)) {
            return XmlResourceNSDescriptor.INSTANCE;
        }
        if (isRoot2 && AndroidResourceDomFileDescription.isFileInResourceFolderType(file2, ResourceFolderType.DRAWABLE)) {
            return DrawableResourceNSDescriptor.INSTANCE;
        }
        return super.getNSDescriptor(element2, namespace, strict);
    }

    @Nullable
    public TagNameReference createTagNameReference(ASTNode nameElement, boolean startTagFlag) {
        return new TagNameReference(nameElement, startTagFlag){

            public boolean isSoft() {
                return true;
            }

            public PsiElement bindToElement(@NotNull PsiElement element2) throws IncorrectOperationException {
                if (element2 instanceof PsiQualifiedNamedElement) {
                    return null;
                }
                return super.bindToElement(element2);
            }

            @Nullable
            public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
                XmlTag element2 = this.getTagElement();
                if (element2 != null && element2.getDescriptor() instanceof TagFromClassDescriptor) {
                    return null;
                }
                return super.handleElementRename(newElementName);
            }
        };
    }

    public boolean isAvailable(final PsiFile file2) {
        if (file2 instanceof XmlFile) {
            return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                public Boolean compute() {
                    String tagName;
                    if (AndroidFacet.getInstance((PsiElement)file2) != null) {
                        if (IdeResourcesUtil.isInResourceSubdirectoryInAnyVariant(file2, null)) {
                            return true;
                        }
                        if (file2.getName().equals("AndroidManifest.xml") && ManifestDomFileDescription.isManifestFile((XmlFile)file2)) {
                            return true;
                        }
                    }
                    if ("lint.xml".equals(file2.getName())) {
                        return true;
                    }
                    XmlFile xmlFile = (XmlFile)file2;
                    XmlTag tag = xmlFile.getRootTag();
                    if (tag != null && ("lint".equals(tagName = tag.getName()) || "issues".equals(tagName))) {
                        return true;
                    }
                    return false;
                }
            });
        }
        return false;
    }

    public SchemaPrefix getPrefixDeclaration(XmlTag context2, String namespacePrefix) {
        SchemaPrefix prefix = super.getPrefixDeclaration(context2, namespacePrefix);
        if (prefix != null) {
            return prefix;
        }
        if (namespacePrefix.isEmpty()) {
            return EMPTY_SCHEMA;
        }
        return null;
    }

    public boolean isRequiredAttributeImplicitlyPresent(@NotNull XmlTag tag, @NotNull String attrName) {
        return AndroidXmlExtension.isAaptAttributeDefined(tag, attrName);
    }

    public static boolean isAaptAttributeDefined(@NotNull XmlTag tag, @NotNull String attrName) {
        XmlTag[] subTags;
        for (XmlTag child : subTags = tag.getSubTags()) {
            XmlAttribute attr;
            if (!"attr".equals(child.getLocalName()) || !"http://schemas.android.com/aapt".equals(child.getNamespace()) || (attr = child.getAttribute("name")) == null || !attrName.equals(attr.getValue())) continue;
            return true;
        }
        return false;
    }
}

