/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.augment;

import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.android.tools.idea.res.ResourceRepositoryRClass;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import org.jetbrains.android.augment.AndroidLightField;
import org.jetbrains.android.augment.InnerRClassBase;
import org.jetbrains.android.augment.ResourceLightField;
import org.jetbrains.annotations.NotNull;

public class ResourceRepositoryInnerRClass
extends InnerRClassBase {
    @NotNull
    private final ResourceRepositoryRClass.ResourcesSource mySource;

    public ResourceRepositoryInnerRClass(@NotNull ResourceType resourceType, @NotNull ResourceRepositoryRClass.ResourcesSource source, @NotNull PsiClass parentClass) {
        super(parentClass, resourceType);
        this.mySource = source;
    }

    @NotNull
    static PsiField[] buildLocalResourceFields(@NotNull ResourceType resourceType, @NotNull ResourceRepositoryRClass.ResourcesSource resourcesSource, @NotNull PsiClass context2) {
        AndroidLightField.FieldModifier modifier2 = resourcesSource.getFieldModifier();
        return InnerRClassBase.buildResourceFields(resourcesSource.getResourceRepository(), resourcesSource.getResourceNamespace(), resourcesSource.getResourceRepositoryManager(), modifier2, ACCESSIBLE_RESOURCE_FILTER, resourceType, context2);
    }

    @Override
    @NotNull
    protected PsiField[] doGetFields() {
        return ResourceRepositoryInnerRClass.buildLocalResourceFields(this.myResourceType, this.mySource, this);
    }

    @Override
    public PsiField findFieldByName(String name2, boolean checkBases) {
        if (this.myResourceType == ResourceType.STYLEABLE || this.mySource.getFieldModifier() == AndroidLightField.FieldModifier.FINAL || name2.contains("_")) {
            return super.findFieldByName(name2, checkBases);
        }
        if (!this.mySource.getResourceRepository().hasResources(this.mySource.getResourceNamespace(), this.myResourceType, name2)) {
            return null;
        }
        return new ResourceLightField(name2, this, (PsiType)PsiType.INT, AndroidLightField.FieldModifier.NON_FINAL, null, ResourceVisibility.PUBLIC);
    }

    @Override
    @NotNull
    protected ModificationTracker getFieldsDependencies() {
        return () -> this.mySource.getResourceRepository().getModificationCount();
    }
}

