/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceFolderType;
import com.android.utils.HtmlBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import java.awt.Color;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.jetbrains.android.actions.ElementCreatingValidator;
import org.jetbrains.android.uipreview.DeviceConfiguratorPanel;
import org.jetbrains.android.uipreview.InvalidOptionValueException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CreateResourceDirectoryDialogBase
extends DialogWrapper {
    protected CreateResourceDirectoryDialogBase(@Nullable Project project) {
        super(project);
    }

    @NotNull
    public abstract PsiElement[] getCreatedElements();

    @Nullable
    protected String getHelpId() {
        return "reference.new.resource.directory";
    }

    protected DeviceConfiguratorPanel setupDeviceConfigurationPanel(final JComboBox resourceTypeComboBox, final JTextField directoryNameTextField, final JBLabel errorLabel) {
        return new DeviceConfiguratorPanel(){

            @Override
            public void applyEditors() {
                try {
                    this.doApplyEditors();
                    FolderConfiguration config2 = this.getConfiguration();
                    ResourceFolderType selectedResourceType = (ResourceFolderType)resourceTypeComboBox.getSelectedItem();
                    directoryNameTextField.setText(selectedResourceType != null ? config2.getFolderName(selectedResourceType) : "");
                    errorLabel.setText("");
                }
                catch (InvalidOptionValueException e) {
                    errorLabel.setText(new HtmlBuilder().openHtmlBody().coloredText((Color)JBColor.RED, e.getMessage()).closeHtmlBody().getHtml());
                    directoryNameTextField.setText("");
                }
                CreateResourceDirectoryDialogBase.this.setOKActionEnabled(!directoryNameTextField.getText().isEmpty());
            }
        };
    }

    public static interface ValidatorFactory {
        @NotNull
        public ElementCreatingValidator create(@NotNull PsiDirectory var1);
    }
}

