/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.model.StudioAndroidModuleInfo;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.ScopeType;
import com.android.tools.idea.psi.TagToClassMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.android.facet.AndroidClassesForXmlUtilKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

class TagToClassMapperImpl
implements TagToClassMapper {
    private static final Logger LOG = Logger.getInstance(TagToClassMapper.class);
    private final Map<String, Map<String, SmartPsiElementPointer<PsiClass>>> myInitialClassMaps = new HashMap<String, Map<String, SmartPsiElementPointer<PsiClass>>>();
    private final Map<String, CachedValue<Map<String, PsiClass>>> myClassMaps = Maps.newConcurrentMap();
    private final Module myModule;

    TagToClassMapperImpl(@NotNull Module module2) {
        this.myModule = module2;
        MessageBusConnection connection2 = module2.getProject().getMessageBus().connect((Disposable)module2);
        connection2.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event2) {
                TagToClassMapperImpl.this.clearInitialClassMaps();
            }
        });
    }

    @Override
    @NotNull
    public TagToClassMapper.ClassMapFreshness getClassMapFreshness(String className) {
        CachedValue<Map<String, PsiClass>> value2 = this.myClassMaps.get(className);
        if (value2 == null) {
            return TagToClassMapper.ClassMapFreshness.REBUILD_ENTIRE_CLASS_MAP;
        }
        if (value2.hasUpToDateValue()) {
            return TagToClassMapper.ClassMapFreshness.VALID_CLASS_MAP;
        }
        Map<String, SmartPsiElementPointer<PsiClass>> classMap = this.myInitialClassMaps.get(className);
        if (classMap != null && this.isClassMapUpToDate(classMap)) {
            return TagToClassMapper.ClassMapFreshness.REBUILD_PARTIAL_CLASS_MAP;
        }
        return TagToClassMapper.ClassMapFreshness.REBUILD_ENTIRE_CLASS_MAP;
    }

    @Override
    @TestOnly
    public void resetAllClassMaps() {
        this.clearInitialClassMaps();
        this.myClassMaps.clear();
    }

    @Override
    @NotNull
    public Map<String, PsiClass> getClassMap(String classMapKey) {
        if (DumbService.isDumb((Project)this.myModule.getProject())) {
            return Collections.emptyMap();
        }
        CachedValue value2 = this.myClassMaps.get(classMapKey);
        if (value2 == null) {
            value2 = CachedValuesManager.getManager((Project)this.myModule.getProject()).createCachedValue(() -> {
                Map<String, PsiClass> map2 = this.computeClassMap(classMapKey);
                return CachedValueProvider.Result.create(map2, (Object[])new Object[]{AndroidPsiUtils.getPsiModificationTrackerIgnoringXml((Project)this.myModule.getProject())});
            }, false);
            this.myClassMaps.put(classMapKey, (CachedValue<Map<String, PsiClass>>)value2);
        }
        return Collections.unmodifiableMap((Map)value2.getValue());
    }

    @NotNull
    private Map<String, PsiClass> computeClassMap(@NotNull String classMapKey) {
        PsiClass aClass;
        SmartPsiElementPointer<PsiClass> pointer;
        Map<String, SmartPsiElementPointer<PsiClass>> classMap = this.getInitialClassMap(classMapKey, false);
        HashMap<String, PsiClass> result2 = new HashMap<String, PsiClass>();
        boolean shouldRebuildInitialMap = false;
        int apiLevel = this.getMinApiLevel();
        for (String key : classMap.keySet()) {
            pointer = classMap.get(key);
            aClass = (PsiClass)pointer.getElement();
            if (aClass == null) continue;
            if (!TagToClassMapperImpl.isUpToDate(aClass, key, apiLevel, classMapKey)) {
                shouldRebuildInitialMap = true;
                break;
            }
            result2.put(key, aClass);
        }
        if (shouldRebuildInitialMap) {
            result2.clear();
            classMap = this.getInitialClassMap(classMapKey, true);
            for (String key : classMap.keySet()) {
                pointer = classMap.get(key);
                aClass = (PsiClass)pointer.getElement();
                if (aClass == null) continue;
                result2.put(key, aClass);
            }
        }
        this.fillMap(classMapKey, this.projectClassesScope(), result2);
        return result2;
    }

    private static boolean isUpToDate(@NotNull PsiClass aClass, @NotNull String tagName, int apiLevel, @Nullable String classMapKey) {
        return ArrayUtil.contains((String)tagName, (String[])AndroidClassesForXmlUtilKt.getTagNamesByClass(aClass, apiLevel, classMapKey));
    }

    private boolean isClassMapUpToDate(@NotNull Map<String, SmartPsiElementPointer<PsiClass>> classMap) {
        int apiLevel = this.getMinApiLevel();
        for (String key : classMap.keySet()) {
            SmartPsiElementPointer<PsiClass> pointer = classMap.get(key);
            PsiClass aClass = (PsiClass)pointer.getElement();
            if (aClass == null || TagToClassMapperImpl.isUpToDate(aClass, key, apiLevel, key)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private Map<String, SmartPsiElementPointer<PsiClass>> getInitialClassMap(@NotNull String classMapKey, boolean forceRebuild) {
        Map<String, SmartPsiElementPointer<PsiClass>> viewClassMap = this.myInitialClassMaps.get(classMapKey);
        if (viewClassMap != null && !forceRebuild) {
            return viewClassMap;
        }
        return this.computeInitialClassMap(classMapKey);
    }

    @VisibleForTesting
    @NotNull
    Map<String, SmartPsiElementPointer<PsiClass>> computeInitialClassMap(@NotNull String classMapKey) {
        LOG.info("Building initial class map for " + classMapKey);
        Map<String, SmartPsiElementPointer<PsiClass>> viewClassMap = null;
        HashMap<String, PsiClass> map2 = new HashMap<String, PsiClass>();
        if (this.fillMap(classMapKey, this.dependenciesClassesScope(), map2)) {
            viewClassMap = new HashMap<String, SmartPsiElementPointer<PsiClass>>(map2.size());
            SmartPointerManager manager = SmartPointerManager.getInstance((Project)this.myModule.getProject());
            for (Map.Entry entry : map2.entrySet()) {
                viewClassMap.put((String)entry.getKey(), (SmartPsiElementPointer<PsiClass>)manager.createSmartPsiElementPointer((PsiElement)((PsiClass)entry.getValue())));
            }
            this.myInitialClassMaps.put(classMapKey, viewClassMap);
        }
        return viewClassMap != null ? viewClassMap : Collections.emptyMap();
    }

    @NotNull
    private GlobalSearchScope moduleResolveScope() {
        return ProjectSystemUtil.getModuleSystem(this.myModule).getResolveScope(ScopeType.MAIN);
    }

    @NotNull
    private GlobalSearchScope allLibrariesScope() {
        return ProjectScope.getLibrariesScope((Project)this.myModule.getProject());
    }

    @NotNull
    private GlobalSearchScope projectClassesScope() {
        return this.moduleResolveScope().intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)this.allLibrariesScope()));
    }

    @NotNull
    private GlobalSearchScope dependenciesClassesScope() {
        return this.moduleResolveScope().intersectWith(this.allLibrariesScope());
    }

    private boolean fillMap(@NotNull String className, @NotNull GlobalSearchScope scope2, @NotNull Map<String, PsiClass> map2) {
        String[] baseClassTagNames;
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.myModule.getProject());
        PsiClass baseClass = facade.findClass(className, this.moduleResolveScope());
        if (baseClass == null) {
            return false;
        }
        int api = this.getMinApiLevel();
        for (String tagName : baseClassTagNames = AndroidClassesForXmlUtilKt.getTagNamesByClass(baseClass, api, className)) {
            map2.put(tagName, baseClass);
        }
        try {
            ClassInheritorsSearch.search((PsiClass)baseClass, (SearchScope)scope2, (boolean)true).forEach(c -> {
                String[] tagNames;
                for (String tagName : tagNames = AndroidClassesForXmlUtilKt.getTagNamesByClass(c, api, className)) {
                    map2.put(tagName, (PsiClass)c);
                }
                return true;
            });
        }
        catch (IndexNotReadyException e) {
            Logger.getInstance(this.getClass()).info((Throwable)e);
            return false;
        }
        return !map2.isEmpty();
    }

    private int getMinApiLevel() {
        AndroidModuleInfo androidModuleInfo = StudioAndroidModuleInfo.getInstance(this.myModule);
        return androidModuleInfo == null ? 1 : androidModuleInfo.getModuleMinApi();
    }

    public void clearInitialClassMaps() {
        this.myInitialClassMaps.clear();
    }
}

