/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.resources.ResourceFolderType;
import com.android.tools.dom.attrs.AttributeDefinition;
import com.android.tools.dom.attrs.AttributeDefinitions;
import com.android.tools.idea.databinding.DataBindingAnnotationsService;
import com.android.tools.idea.lang.databinding.DataBindingCompletionUtil;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.XmlAttributeInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.xml.XmlAttributeImpl;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.converters.DelimitedListConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.android.dom.AndroidDomElement;
import org.jetbrains.android.dom.AndroidResourceDomFileDescription;
import org.jetbrains.android.dom.AttributeProcessingUtil;
import org.jetbrains.android.dom.animation.AndroidAnimationUtils;
import org.jetbrains.android.dom.animator.AndroidAnimatorUtil;
import org.jetbrains.android.dom.color.AndroidColorDomUtil;
import org.jetbrains.android.dom.converters.FlagConverter;
import org.jetbrains.android.dom.drawable.AndroidDrawableDomUtil;
import org.jetbrains.android.dom.font.FontFamilyDomFileDescription;
import org.jetbrains.android.dom.layout.Data;
import org.jetbrains.android.dom.layout.DataBindingDomFileDescription;
import org.jetbrains.android.dom.layout.LayoutElement;
import org.jetbrains.android.dom.manifest.ManifestDomFileDescription;
import org.jetbrains.android.dom.raw.RawDomFileDescription;
import org.jetbrains.android.dom.transition.TransitionDomFileDescription;
import org.jetbrains.android.dom.transition.TransitionDomUtil;
import org.jetbrains.android.dom.xml.AndroidXmlResourcesUtil;
import org.jetbrains.android.dom.xml.XmlResourceDomFileDescription;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.annotations.NotNull;

public class AndroidXmlCompletionContributor
extends CompletionContributor {
    private static final String LAYOUT_ATTRIBUTE_PREFIX = "layout_";
    private static final String NAMESPACE_PREFIX = "xmlns";
    private static final String[] AVAILABLE_NAMESPACES = new String[]{"android=\"http://schemas.android.com/apk/res/android\"", "app=\"http://schemas.android.com/apk/res-auto\"", "tools=\"http://schemas.android.com/tools\""};

    public void fillCompletionVariants(@NotNull CompletionParameters parameters2, @NotNull CompletionResultSet resultSet) {
        PsiElement originalParent;
        PsiElement position = parameters2.getPosition();
        PsiElement originalPosition = parameters2.getOriginalPosition();
        AndroidFacet facet2 = AndroidFacet.getInstance((PsiElement)position);
        if (facet2 == null) {
            return;
        }
        PsiElement parent2 = position.getParent();
        PsiElement psiElement = originalParent = originalPosition != null ? originalPosition.getParent() : null;
        if (parent2 instanceof XmlTag) {
            PsiElement element2;
            int refOffset;
            XmlTag tag = (XmlTag)parent2;
            if (tag.getParentTag() != null) {
                return;
            }
            ASTNode startTagName = XmlChildRole.START_TAG_NAME_FINDER.findChild(tag.getNode());
            if (startTagName == null || startTagName.getPsi() != position) {
                return;
            }
            PsiFile file2 = tag.getContainingFile();
            if (!(file2 instanceof XmlFile)) {
                return;
            }
            PsiReference reference = file2.findReferenceAt(parameters2.getOffset());
            if (reference != null && (refOffset = (element2 = reference.getElement()).getTextRange().getStartOffset() + reference.getRangeInElement().getStartOffset()) != position.getTextRange().getStartOffset()) {
                return;
            }
            if (!AndroidXmlCompletionContributor.completeRootTagNames(facet2, (XmlFile)file2, resultSet)) {
                resultSet.stopHere();
            }
        } else if (parent2 instanceof XmlAttribute) {
            ASTNode attrName = XmlChildRole.ATTRIBUTE_NAME_FINDER.findChild(parent2.getNode());
            if (attrName == null || attrName.getPsi() != position) {
                return;
            }
            XmlAttribute attribute2 = (XmlAttribute)parent2;
            String namespace = attribute2.getNamespace();
            XmlTag tag = attribute2.getParent();
            DomElement element3 = DomManager.getDomManager((Project)tag.getProject()).getDomElement(tag);
            if (!(element3 instanceof AndroidDomElement)) {
                return;
            }
            if ("http://schemas.android.com/tools".equals(namespace)) {
                AndroidXmlCompletionContributor.addDesignTimeAttributes(attribute2.getNamespacePrefix(), position, facet2, attribute2, resultSet);
            }
            AndroidXmlCompletionContributor.addDataBindingAttributes(position, facet2, attribute2, resultSet, (AndroidDomElement)element3);
            if (element3 instanceof LayoutElement) {
                AndroidXmlCompletionContributor.addAndCustomizeAttributesForLayoutElement(facet2, parameters2, attribute2, resultSet);
            }
            if (tag.getParentTag() == null) {
                if (attribute2.getNamespacePrefix().equals(NAMESPACE_PREFIX)) {
                    this.addNamespaces(resultSet, tag.getLocalNamespaceDeclarations(), false);
                } else if (namespace.isEmpty()) {
                    this.addNamespaces(resultSet, tag.getLocalNamespaceDeclarations(), true);
                }
            }
        } else if (originalParent instanceof XmlAttributeValue) {
            AndroidXmlCompletionContributor.completeTailsInFlagAttribute(parameters2, resultSet, (XmlAttributeValue)originalParent);
            AndroidXmlCompletionContributor.completeDataBindingTypeAttr(parameters2, resultSet, (XmlAttributeValue)originalParent);
        }
    }

    private void addNamespaces(CompletionResultSet resultSet, @NotNull Map<String, String> namespaces, boolean withPrefix) {
        Collection<String> declaredNamespaces = namespaces.values();
        Stream<String> lookupStrings = Arrays.stream(AVAILABLE_NAMESPACES).filter(availableNamespace -> declaredNamespaces.stream().noneMatch(availableNamespace::contains));
        if (withPrefix) {
            lookupStrings = lookupStrings.map(it -> "xmlns:" + it);
        }
        resultSet.addAllElements((Iterable)lookupStrings.map(LookupElementBuilder::create).collect(Collectors.toList()));
    }

    private static void addAll(Collection<String> collection2, CompletionResultSet set) {
        for (String s : collection2) {
            set.addElement((LookupElement)LookupElementBuilder.create((String)s));
        }
    }

    private static boolean completeRootTagNames(@NotNull AndroidFacet facet2, @NotNull XmlFile xmlFile, @NotNull CompletionResultSet resultSet) {
        if (ManifestDomFileDescription.isManifestFile(xmlFile, facet2)) {
            resultSet.addElement((LookupElement)LookupElementBuilder.create((String)"manifest"));
            return false;
        }
        if (AndroidResourceDomFileDescription.isFileInResourceFolderType(xmlFile, ResourceFolderType.ANIM)) {
            AndroidXmlCompletionContributor.addAll(AndroidAnimationUtils.getPossibleRoots(), resultSet);
            return false;
        }
        if (AndroidResourceDomFileDescription.isFileInResourceFolderType(xmlFile, ResourceFolderType.ANIMATOR)) {
            AndroidXmlCompletionContributor.addAll(AndroidAnimatorUtil.getPossibleRoots(), resultSet);
            return false;
        }
        if (XmlResourceDomFileDescription.isXmlResourceFile(xmlFile)) {
            AndroidXmlCompletionContributor.addAll(AndroidXmlResourcesUtil.ROOT_TAGS, resultSet);
            return false;
        }
        if (TransitionDomFileDescription.isTransitionFile(xmlFile)) {
            AndroidXmlCompletionContributor.addAll(TransitionDomUtil.getPossibleRoots(), resultSet);
            return false;
        }
        if (AndroidColorDomUtil.isColorResourceFile(xmlFile)) {
            AndroidXmlCompletionContributor.addAll(AndroidColorDomUtil.getPossibleRoots(), resultSet);
            return false;
        }
        if (RawDomFileDescription.isRawFile(xmlFile)) {
            resultSet.addElement((LookupElement)LookupElementBuilder.create((String)"resources"));
            return false;
        }
        if (AndroidResourceDomFileDescription.isFileInResourceFolderType(xmlFile, ResourceFolderType.MIPMAP)) {
            AndroidXmlCompletionContributor.addAll(AndroidDrawableDomUtil.getPossibleRoots(facet2, ResourceFolderType.MIPMAP), resultSet);
            return false;
        }
        if (FontFamilyDomFileDescription.isFontFamilyFile(xmlFile)) {
            resultSet.addElement((LookupElement)LookupElementBuilder.create((String)"font-family"));
            return false;
        }
        return true;
    }

    private static void addDesignTimeAttributes(@NotNull String namespacePrefix, @NotNull PsiElement psiElement, @NotNull AndroidFacet facet2, @NotNull XmlAttribute attribute2, @NotNull CompletionResultSet resultSet) {
        XmlTag tag = attribute2.getParent();
        DomElement element2 = DomManager.getDomManager((Project)tag.getProject()).getDomElement(tag);
        HashSet<XmlName> registeredAttributes = new HashSet<XmlName>();
        if (element2 instanceof LayoutElement) {
            AttributeProcessingUtil.processLayoutAttributes(facet2, tag, (LayoutElement)element2, registeredAttributes, (xmlName, attrDef, parentStyleableName) -> {
                if ("http://schemas.android.com/apk/res/android".equals(xmlName.getNamespaceKey())) {
                    String realName = XmlAttributeImpl.getRealName((XmlAttribute)attribute2);
                    String lookupElementString = realName.length() == 0 ? namespacePrefix + ":" + xmlName.getLocalName() : xmlName.getLocalName();
                    LookupElementBuilder lookupElement = LookupElementBuilder.create((Object)psiElement, (String)lookupElementString).withInsertHandler((InsertHandler)XmlAttributeInsertHandler.INSTANCE);
                    resultSet.addElement((LookupElement)lookupElement);
                }
                return null;
            });
        }
    }

    private static void addAndCustomizeAttributesForLayoutElement(AndroidFacet facet2, CompletionParameters parameters2, XmlAttribute attribute2, CompletionResultSet resultSet) {
        boolean localNameCompletion;
        XmlTag tag = attribute2.getParent();
        if (attribute2.getName().contains(":")) {
            String nsPrefix = attribute2.getNamespacePrefix();
            if (nsPrefix.isEmpty()) {
                return;
            }
            if (!"http://schemas.android.com/apk/res/android".equals(tag.getNamespaceByPrefix(nsPrefix))) {
                return;
            }
            localNameCompletion = true;
        } else {
            localNameCompletion = false;
        }
        HashMap prefix2ns = new HashMap();
        resultSet.runRemainingContributors(parameters2, result2 -> {
            LookupElement lookupElement = result2.getLookupElement();
            Object obj = lookupElement.getObject();
            if (obj instanceof String) {
                String s = (String)obj;
                int index2 = s.indexOf(58);
                String attributeName = s.substring(index2 + 1);
                if (index2 > 0) {
                    String prefix = s.substring(0, index2);
                    String ns = (String)prefix2ns.get(prefix);
                    if (ns == null) {
                        ns = tag.getNamespaceByPrefix(prefix);
                        prefix2ns.put(prefix, ns);
                    }
                    if ("http://schemas.android.com/apk/res/android".equals(ns)) {
                        boolean deprecated = AndroidXmlCompletionContributor.isFrameworkAttributeDeprecated(facet2, attribute2, attributeName);
                        result2 = AndroidXmlCompletionContributor.customizeLayoutAttributeLookupElement(lookupElement, result2, attributeName, deprecated);
                    }
                } else if (localNameCompletion) {
                    result2 = AndroidXmlCompletionContributor.customizeLayoutAttributeLookupElement(lookupElement, result2, attributeName, false);
                }
            }
            resultSet.passResult(result2);
        });
    }

    private static boolean isFrameworkAttributeDeprecated(AndroidFacet facet2, XmlAttribute attribute2, String attributeName) {
        ResourceManager manager = ModuleResourceManagers.getInstance(facet2).getResourceManager("android", (PsiElement)attribute2.getParent());
        if (manager == null) {
            return false;
        }
        AttributeDefinitions attributes = manager.getAttributeDefinitions();
        if (attributes == null) {
            return false;
        }
        AttributeDefinition attributeDefinition = attributes.getAttrDefByName(attributeName);
        return attributeDefinition != null && attributeDefinition.isAttributeDeprecated();
    }

    private static CompletionResult customizeLayoutAttributeLookupElement(LookupElement lookupElement, CompletionResult result2, String localName, final boolean markDeprecated) {
        if (!localName.startsWith(LAYOUT_ATTRIBUTE_PREFIX)) {
            if (markDeprecated) {
                return result2.withLookupElement(PrioritizedLookupElement.withPriority((LookupElement)new LookupElementDecorator<LookupElement>(lookupElement){

                    public void renderElement(LookupElementPresentation presentation) {
                        super.renderElement(presentation);
                        presentation.setStrikeout(true);
                    }
                }, (double)-1.0));
            }
            return result2;
        }
        String localSuffix = localName.substring(LAYOUT_ATTRIBUTE_PREFIX.length());
        if (!localSuffix.isEmpty()) {
            final HashSet<String> lookupStrings = new HashSet<String>(lookupElement.getAllLookupStrings());
            lookupStrings.add(localSuffix);
            lookupElement = new LookupElementDecorator<LookupElement>(lookupElement){

                public Set<String> getAllLookupStrings() {
                    return lookupStrings;
                }

                public void renderElement(LookupElementPresentation presentation) {
                    super.renderElement(presentation);
                    presentation.setStrikeout(markDeprecated);
                }
            };
        }
        return result2.withLookupElement(PrioritizedLookupElement.withPriority((LookupElement)lookupElement, (double)100.0));
    }

    private static void addDataBindingAttributes(@NotNull PsiElement position, @NotNull AndroidFacet facet2, @NotNull XmlAttribute attribute2, @NotNull CompletionResultSet resultSet, AndroidDomElement element2) {
        PsiFile containingFile = attribute2.getContainingFile();
        if (!(containingFile instanceof XmlFile) || !DataBindingDomFileDescription.hasDataBindingRootTag((XmlFile)containingFile)) {
            return;
        }
        DataBindingAnnotationsService bindingAnnotationsService = DataBindingAnnotationsService.getInstance(facet2);
        LinkedHashSet alreadyDeclared = new LinkedHashSet();
        AttributeProcessingUtil.processAttributes(element2, facet2, true, (xmlName, attrDef, parentStyleableName) -> {
            alreadyDeclared.add(xmlName.getLocalName());
            return null;
        });
        bindingAnnotationsService.getBindingAdapterAttributes().forEach(dataBindingAttribute -> {
            if (!alreadyDeclared.contains(dataBindingAttribute)) {
                resultSet.addElement((LookupElement)LookupElementBuilder.create((Object)position, (String)dataBindingAttribute).withInsertHandler((InsertHandler)XmlAttributeInsertHandler.INSTANCE));
            }
        });
    }

    private static void completeDataBindingTypeAttr(CompletionParameters parameters2, CompletionResultSet resultSet, XmlAttributeValue originalParent) {
        PsiElement gp = originalParent.getParent();
        if (!(gp instanceof XmlAttribute)) {
            return;
        }
        GenericAttributeValue domElement = DomManager.getDomManager((Project)gp.getProject()).getDomElement((XmlAttribute)gp);
        if (domElement == null) {
            return;
        }
        if (DomUtil.getParentOfType((DomElement)domElement, Data.class, (boolean)true) != null && ((XmlAttribute)gp).getName().equals("type")) {
            DataBindingCompletionUtil.addCompletions(parameters2, resultSet);
        }
    }

    private static void completeTailsInFlagAttribute(CompletionParameters parameters2, CompletionResultSet resultSet, XmlAttributeValue parent2) {
        String prefix;
        Set<String> valueSet;
        Converter converter;
        String currentValue = parent2.getValue();
        if (currentValue.isEmpty() || currentValue.endsWith("|")) {
            return;
        }
        PsiElement grandparent = parent2.getParent();
        if (!(grandparent instanceof XmlAttribute)) {
            return;
        }
        GenericAttributeValue domValue = DomManager.getDomManager((Project)grandparent.getProject()).getDomElement((XmlAttribute)grandparent);
        Converter converter2 = converter = domValue != null ? domValue.getConverter() : null;
        if (!(converter instanceof FlagConverter)) {
            return;
        }
        TextRange valueRange = parent2.getValueTextRange();
        if (valueRange != null && valueRange.getEndOffset() == parameters2.getOffset() && !(valueSet = ((FlagConverter)converter).getValues()).isEmpty() && valueSet.contains(prefix = resultSet.getPrefixMatcher().getPrefix())) {
            ArrayList<String> filteredValues = new ArrayList<String>(valueSet);
            DelimitedListConverter.filterVariants(filteredValues, (GenericDomValue)domValue);
            for (String variant : filteredValues) {
                resultSet.addElement((LookupElement)LookupElementBuilder.create((String)(prefix + "|" + variant)));
            }
        }
    }
}

