/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.resources.ResourceFolderType;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.utils.SdkUtils;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.safeDelete.NonCodeUsageSearchInfo;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessor;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessorDelegateBase;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidResourceFileSafeDeleteProcessor
extends SafeDeleteProcessorDelegateBase {
    @Nullable
    public Collection<? extends PsiElement> getElementsToSearch(@NotNull PsiElement element2, @Nullable Module module2, @NotNull Collection<PsiElement> allElementsToDelete) {
        return Collections.singletonList(element2);
    }

    public boolean handlesElement(PsiElement element2) {
        if (!(element2 instanceof PsiFile)) {
            return false;
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((PsiElement)element2);
        if (facet2 == null) {
            return false;
        }
        VirtualFile vFile = ((PsiFile)element2).getVirtualFile();
        VirtualFile parent2 = vFile != null ? vFile.getParent() : null;
        VirtualFile resDir = parent2 != null ? parent2.getParent() : null;
        return resDir != null && ModuleResourceManagers.getInstance(facet2).getLocalResourceManager().isResourceDir(resDir);
    }

    @Nullable
    public NonCodeUsageSearchInfo findUsages(@NotNull PsiElement element2, @NotNull PsiElement[] allElementsToDelete, @NotNull List<UsageInfo> result2) {
        SafeDeleteProcessor.findGenericElementUsages((PsiElement)element2, result2, (PsiElement[])allElementsToDelete);
        if (element2 instanceof PsiFile) {
            PsiField[] fields;
            for (PsiField field2 : fields = IdeResourcesUtil.findResourceFieldsForFileResource((PsiFile)element2, true)) {
                SafeDeleteProcessor.findGenericElementUsages((PsiElement)field2, result2, (PsiElement[])allElementsToDelete);
            }
        }
        return new NonCodeUsageSearchInfo(SafeDeleteProcessor.getDefaultInsideDeletedCondition((PsiElement[])allElementsToDelete), element2);
    }

    @Nullable
    public Collection<PsiElement> getAdditionalElementsToDelete(@NotNull PsiElement element2, @NotNull Collection<PsiElement> allElementsToDelete, boolean askUser) {
        int r;
        if (allElementsToDelete.size() > 1) {
            return Collections.emptyList();
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((PsiElement)element2);
        assert (facet2 != null);
        PsiFile file2 = (PsiFile)element2;
        VirtualFile vFile = file2.getVirtualFile();
        assert (vFile != null);
        VirtualFile dir = vFile.getParent();
        assert (dir != null);
        ResourceFolderType folderType = ResourceFolderType.getFolderType((String)dir.getName());
        if (folderType == null) {
            return Collections.emptyList();
        }
        String type = folderType.getName();
        String name2 = vFile.getName();
        LocalResourceManager resourceManager = ModuleResourceManagers.getInstance(facet2).getLocalResourceManager();
        Collection<PsiFile> resourceFiles = resourceManager.findResourceFiles(ResourceNamespace.TODO(), folderType, SdkUtils.fileNameToResourceName((String)name2), true, false);
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
        for (PsiFile resourceFile : resourceFiles) {
            if (resourceFile.getManager().areElementsEquivalent((PsiElement)file2, (PsiElement)resourceFile) || !resourceFile.getName().equals(name2)) continue;
            result2.add((PsiElement)resourceFile);
        }
        if (!result2.isEmpty() && askUser && (r = Messages.showDialog((Project)element2.getProject(), (String)"Delete alternative resource files for other configurations?", (String)"Delete", (String[])new String[]{Messages.getYesButton(), Messages.getNoButton()}, (int)1, (Icon)Messages.getQuestionIcon())) != 0) {
            return Collections.emptyList();
        }
        return result2;
    }

    @Nullable
    public Collection<String> findConflicts(@NotNull PsiElement element2, @NotNull PsiElement[] allElementsToDelete) {
        return null;
    }

    @Nullable
    public UsageInfo[] preprocessUsages(Project project, UsageInfo[] usages) {
        return usages;
    }

    public void prepareForDeletion(PsiElement element2) throws IncorrectOperationException {
    }

    public boolean isToSearchInComments(PsiElement element2) {
        return RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_COMMENTS;
    }

    public boolean isToSearchForTextOccurrences(PsiElement element2) {
        return RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_NON_JAVA;
    }

    public void setToSearchInComments(PsiElement element2, boolean enabled2) {
        RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_COMMENTS = enabled2;
    }

    public void setToSearchForTextOccurrences(PsiElement element2, boolean enabled2) {
        RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_NON_JAVA = enabled2;
    }
}

