/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.rendering.GutterIconCache;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.AndroidAnnotatorUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AndroidResourceExternalAnnotatorBase
extends ExternalAnnotator<FileAnnotationInfo, Map<PsiElement, GutterIconRenderer>> {
    private static final Logger LOG = Logger.getInstance(AndroidResourceExternalAnnotatorBase.class);

    @Nullable
    public final FileAnnotationInfo collectInformation(@NotNull PsiFile file2, @NotNull Editor editor, boolean hasErrors) {
        return this.collectInformation(file2, editor);
    }

    @Nullable
    protected abstract FileAnnotationInfo collectInformation(@NotNull PsiFile var1, @NotNull Editor var2);

    @Nullable
    public final FileAnnotationInfo collectInformation(@NotNull PsiFile file2) {
        return null;
    }

    @Nullable
    public Map<PsiElement, GutterIconRenderer> doAnnotate(@NotNull FileAnnotationInfo fileAnnotationsInfo) {
        AndroidFacet facet2 = fileAnnotationsInfo.getFacet();
        Editor editor = fileAnnotationsInfo.getEditor();
        long timestamp = fileAnnotationsInfo.getTimestamp();
        Document document2 = editor.getDocument();
        HashMap<PsiElement, GutterIconRenderer> rendererMap = new HashMap<PsiElement, GutterIconRenderer>();
        Configuration configuration = AndroidAnnotatorUtil.pickConfiguration(fileAnnotationsInfo.getFile(), facet2);
        if (configuration == null) {
            return null;
        }
        ResourceResolver resolver = configuration.getResourceResolver();
        for (FileAnnotationInfo.AnnotatableElement element2 : fileAnnotationsInfo.getElements()) {
            GutterIconRenderer gutterIconRenderer;
            ProgressManager.checkCanceled();
            if (editor.isDisposed() || document2.getModificationStamp() > timestamp) {
                return null;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Rendering icon for %s in %s.", element2.getResource(), fileAnnotationsInfo.getFile()));
            }
            if (element2.getResource() != null) {
                gutterIconRenderer = AndroidResourceExternalAnnotatorBase.getResourceGutterIconRenderer(element2.getResource(), element2.getPsiElement(), resolver, facet2, configuration);
            } else {
                assert (element2.getColor() != null);
                Color color = element2.getColor();
                gutterIconRenderer = new AndroidAnnotatorUtil.ColorRenderer(element2.getPsiElement(), color, resolver, null, true, configuration);
            }
            if (gutterIconRenderer == null) continue;
            rendererMap.put(element2.getPsiElement(), gutterIconRenderer);
        }
        return rendererMap;
    }

    @Nullable
    private static GutterIconRenderer getResourceGutterIconRenderer(@NotNull ResourceReference reference, @NotNull PsiElement element2, @NotNull ResourceResolver resolver, @NotNull AndroidFacet facet2, @NotNull Configuration configuration) {
        ResourceValue renderableValue;
        ResourceValue resolvedResource = null;
        if (reference.getResourceType() == ResourceType.ATTR) {
            ResourceValue resolvedAttribute = resolver.findItemInTheme(reference);
            if (resolvedAttribute == null || resolvedAttribute.getValue() == null) {
                return null;
            }
            ResourceValue resourceValue = resolver.resolveResValue(resolvedAttribute);
            if (resourceValue == null) {
                return null;
            }
            ResourceType resourceValueType = resourceValue.getResourceType();
            if (resourceValueType == ResourceType.DRAWABLE || resourceValueType == ResourceType.MIPMAP || resourceValueType == ResourceType.COLOR || resourceValueType == ResourceType.STYLE_ITEM || resourceValueType == ResourceType.MACRO) {
                resolvedResource = resourceValue;
            } else {
                return null;
            }
        }
        ResourceValue resourceValue = renderableValue = resolvedResource == null ? resolver.getResolvedResource(reference) : resolvedResource;
        if (renderableValue == null) {
            return null;
        }
        ResourceType renderableValueResourceType = renderableValue.getResourceType();
        if (renderableValueResourceType == ResourceType.COLOR || renderableValueResourceType == ResourceType.STYLE_ITEM || renderableValueResourceType == ResourceType.MACRO) {
            return AndroidResourceExternalAnnotatorBase.getColorGutterIconRenderer(resolver, renderableValue, facet2, element2, configuration);
        }
        if (renderableValueResourceType == ResourceType.DRAWABLE || renderableValueResourceType == ResourceType.MIPMAP) {
            return AndroidResourceExternalAnnotatorBase.getDrawableGutterIconRenderer(element2, resolver, renderableValue, facet2, configuration);
        }
        return null;
    }

    @NotNull
    private static GutterIconRenderer getDrawableGutterIconRenderer(@NotNull PsiElement element2, @NotNull ResourceResolver resourceResolver2, @NotNull ResourceValue resourceValue, @NotNull AndroidFacet facet2, @NotNull Configuration configuration) {
        VirtualFile resourceFile = AndroidAnnotatorUtil.resolveDrawableFile(resourceValue, resourceResolver2, facet2);
        if (resourceFile != null) {
            GutterIconCache.getInstance().getIcon(resourceFile, (RenderResources)resourceResolver2, facet2);
        }
        return new com.android.tools.idea.rendering.GutterIconRenderer(element2, resourceResolver2, facet2, resourceFile, configuration);
    }

    @Nullable
    private static GutterIconRenderer getColorGutterIconRenderer(@NotNull ResourceResolver resourceResolver2, @NotNull ResourceValue resourceValue, @NotNull AndroidFacet facet2, @NotNull PsiElement element2, @NotNull Configuration configuration) {
        Color color = IdeResourcesUtil.resolveColor((RenderResources)resourceResolver2, resourceValue, facet2.getModule().getProject());
        if (color == null) {
            return null;
        }
        boolean withCustomColorPalette = AndroidAnnotatorUtil.getFileType(element2) == XmlFileType.INSTANCE;
        return new AndroidAnnotatorUtil.ColorRenderer(element2, color, resourceResolver2, resourceValue, withCustomColorPalette, configuration);
    }

    public void apply(@NotNull PsiFile file2, @NotNull Map<PsiElement, GutterIconRenderer> iconRendererMap, @NotNull AnnotationHolder holder) {
        iconRendererMap.forEach((k, v) -> {
            if (k.isValid()) {
                holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(k).gutterIconRenderer(v).create();
            }
        });
    }

    protected static class FileAnnotationInfo {
        @NotNull
        private final AndroidFacet myFacet;
        @NotNull
        private final PsiFile myFile;
        @NotNull
        private final Editor myEditor;
        private final long myTimestamp;
        @NotNull
        private final List<AnnotatableElement> myElements;

        public FileAnnotationInfo(@NotNull AndroidFacet facet2, @NotNull PsiFile file2, @NotNull Editor editor) {
            this.myFacet = facet2;
            this.myFile = file2;
            this.myEditor = editor;
            this.myTimestamp = this.myEditor.getDocument().getModificationStamp();
            this.myElements = new ArrayList<AnnotatableElement>();
        }

        @NotNull
        public AndroidFacet getFacet() {
            return this.myFacet;
        }

        @NotNull
        public PsiFile getFile() {
            return this.myFile;
        }

        @NotNull
        public List<AnnotatableElement> getElements() {
            return this.myElements;
        }

        @NotNull
        public Editor getEditor() {
            return this.myEditor;
        }

        public long getTimestamp() {
            return this.myTimestamp;
        }

        public static class AnnotatableElement {
            @Nullable
            private final ResourceReference myReference;
            @NotNull
            private final PsiElement myPsiElement;
            @Nullable
            private final Color myColor;

            public AnnotatableElement(@NotNull ResourceReference reference, @NotNull PsiElement element2) {
                this.myReference = reference;
                this.myPsiElement = element2;
                this.myColor = null;
            }

            AnnotatableElement(@NotNull Color color, @NotNull PsiElement element2) {
                this.myReference = null;
                this.myPsiElement = element2;
                this.myColor = color;
            }

            @Nullable
            public ResourceReference getResource() {
                return this.myReference;
            }

            @NotNull
            public PsiElement getPsiElement() {
                return this.myPsiElement;
            }

            @Nullable
            public Color getColor() {
                return this.myColor;
            }
        }
    }
}

