/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.tools.idea.res.IdeResourcesUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.android.facet.AndroidFacet;

public class AndroidProblemFileHighlightingFilter
implements Condition<VirtualFile> {
    private final Project myProject;

    public AndroidProblemFileHighlightingFilter(Project project) {
        this.myProject = project;
    }

    public boolean value(VirtualFile file2) {
        if ("AndroidManifest.xml".equals(file2.getName())) {
            Module module2 = ModuleUtilCore.findModuleForFile((VirtualFile)file2, (Project)this.myProject);
            return module2 != null && AndroidFacet.getInstance((Module)module2) != null;
        }
        VirtualFile parent2 = file2.getParent();
        if (parent2 == null) {
            return false;
        }
        if ((parent2 = parent2.getParent()) == null) {
            return false;
        }
        return IdeResourcesUtil.isLocalResourceDirectory(parent2, this.myProject);
    }
}

