/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.flags.Flag;
import com.android.tools.analytics.AnalyticsSettings;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.modes.EssentialModeMessenger;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.startup.Actions;
import com.android.tools.idea.util.VirtualFileSystemOpener;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.ide.actions.ToggleEssentialHighlightingAction;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.impl.ActionConfigurationCustomizer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public final class AndroidPlugin {
    private static final String GROUP_ANDROID_TOOLS = "AndroidToolsGroup";

    public AndroidPlugin() {
        VirtualFileSystemOpener.INSTANCE.mount();
    }

    private static void initializeForNonStudio(ActionManager actionManager) {
        Actions.moveAction(actionManager, "Android.SyncProject", "FileMenu", GROUP_ANDROID_TOOLS, new Constraints(Anchor.FIRST, null));
        Actions.moveAction(actionManager, "Android.MainToolBarGradleGroup", "MainToolBar", "Android.MainToolBarActionGroup", new Constraints(Anchor.LAST, null));
        AnalyticsSettings.disable();
        UsageTracker.disable();
        UsageTracker.setIdeBrand((AndroidStudioEvent.IdeBrand)AndroidStudioEvent.IdeBrand.INTELLIJ);
    }

    private static void setUpActionsUnderFlag(ActionManager actionManager) {
        AnAction parentGroup;
        if (((Boolean)StudioFlags.RUNDEBUG_ANDROID_BUILD_BUNDLE_ENABLED.get()).booleanValue() && (parentGroup = actionManager.getAction("BuildMenu")) instanceof DefaultActionGroup) {
            String groupId = "Android.BuildApkOrBundle";
            DefaultActionGroup group2 = new DefaultActionGroup("Build Bundle(s) / APK(s)", true){

                public void update(@NotNull AnActionEvent e) {
                    Project project = e.getProject();
                    e.getPresentation().setEnabledAndVisible(project != null && ProjectSystemUtil.requiresAndroidModel(project));
                }
            };
            actionManager.registerAction("Android.BuildApkOrBundle", (AnAction)group2);
            ((DefaultActionGroup)parentGroup).add((AnAction)group2, new Constraints(Anchor.BEFORE, "Android.GenerateSignedApk"), actionManager);
            Actions.moveAction(actionManager, "Android.BuildApk", "BuildMenu", "Android.BuildApkOrBundle", new Constraints(Anchor.FIRST, null));
            Actions.moveAction(actionManager, "Android.BuildBundle", "BuildMenu", "Android.BuildApkOrBundle", new Constraints(Anchor.AFTER, null));
        }
    }

    private static void overrideEssentialHighlightingAction(ActionManager actionManager) {
        StudioToggleEssentialHighlightingAction studioAction = new StudioToggleEssentialHighlightingAction(StudioFlags.ESSENTIAL_HIGHLIGHTING_ACTION_VISIBLE);
        if (actionManager.getAction("ToggleEssentialHighlighting") != null) {
            Actions.replaceAction(actionManager, "ToggleEssentialHighlighting", (AnAction)studioAction);
        } else {
            AnAction group2 = actionManager.getAction("PowerSaveGroup");
            ((DefaultActionGroup)group2).add((AnAction)studioAction, Constraints.LAST, actionManager);
        }
    }

    public static class StudioToggleEssentialHighlightingAction
    extends ToggleAction {
        private final ToggleEssentialHighlightingAction delegate = new ToggleEssentialHighlightingAction();
        private final Flag<Boolean> enabled;
        private final EssentialModeMessenger applicationService = (EssentialModeMessenger)ApplicationManager.getApplication().getService(EssentialModeMessenger.class);

        private StudioToggleEssentialHighlightingAction(Flag<Boolean> enabled2) {
            super("Essential Highlighting");
            this.enabled = enabled2;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            this.applicationService.sendMessage();
            this.delegate.actionPerformed(e);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            return this.delegate.isSelected(e);
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state2) {
            this.delegate.setSelected(e, state2);
        }

        public void update(@NotNull AnActionEvent e) {
            this.delegate.update(e);
            e.getPresentation().setVisible(this.enabled.get().booleanValue());
        }
    }

    static final class ActionCustomizer
    implements ActionConfigurationCustomizer {
        ActionCustomizer() {
        }

        public void customize(@NotNull ActionManager actionManager) {
            if (!IdeInfo.getInstance().isAndroidStudio()) {
                AndroidPlugin.initializeForNonStudio(actionManager);
            } else {
                AndroidPlugin.overrideEssentialHighlightingAction(actionManager);
            }
            AndroidPlugin.setUpActionsUnderFlag(actionManager);
        }
    }
}

