/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceType;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.javadoc.AndroidJavaDocRenderer;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.res.psi.ResourceReferencePsiElement;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.codeInsight.javadoc.JavaDocExternalFilter;
import com.intellij.facet.Facet;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.documentation.ExternalDocumentationProvider;
import com.intellij.lang.java.JavaDocumentationProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidDocumentationProvider
implements DocumentationProvider,
ExternalDocumentationProvider {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.AndroidDocumentationProvider");

    public String generateDoc(PsiElement element2, @Nullable PsiElement originalElement) {
        if (originalElement == null) {
            return null;
        }
        ResourceReferencePsiElement referencePsiElement = ResourceReferencePsiElement.create(element2);
        if (referencePsiElement == null) {
            return null;
        }
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)originalElement);
        if (module2 == null) {
            return null;
        }
        ResourceReference resourceReference = referencePsiElement.getResourceReference();
        AndroidFacet androidFacet = AndroidFacet.getInstance((PsiElement)originalElement);
        if (androidFacet == null) {
            return AndroidJavaDocRenderer.render(module2, null, resourceReference.getResourceUrl());
        }
        Configuration configuration = Configuration.create(ConfigurationManager.getOrCreateInstance(androidFacet.getModule()), null, FolderConfiguration.createDefault());
        return AndroidJavaDocRenderer.render(module2, configuration, resourceReference.getResourceUrl());
    }

    public String fetchExternalDocumentation(final Project project, final PsiElement element2, final List<String> docUrls, boolean onHover) {
        String doc = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                if (AndroidDocumentationProvider.isFrameworkFieldDeclaration(element2)) {
                    Module module2 = AndroidDocumentationProvider.guessAndroidModule(project, element2);
                    PsiField field2 = (PsiField)element2;
                    PsiClass containingClass = field2.getContainingClass();
                    assert (containingClass != null);
                    ResourceType type = ResourceType.fromClassName((String)containingClass.getName());
                    if (module2 != null && type != null && field2.getName() != null) {
                        String name2 = field2.getName();
                        String render2 = AndroidJavaDocRenderer.render(module2, type, name2, true);
                        String external = JavaDocumentationProvider.fetchExternalJavadoc((PsiElement)element2, (List)docUrls, (JavaDocExternalFilter)new MyDocExternalFilter(project));
                        return AndroidJavaDocRenderer.injectExternalDocumentation(render2, external);
                    }
                }
                return null;
            }
        });
        if (doc != null) {
            return null;
        }
        return AndroidDocumentationProvider.isMyContext(element2, project) ? JavaDocumentationProvider.fetchExternalJavadoc((PsiElement)element2, docUrls, (JavaDocExternalFilter)new MyDocExternalFilter(project)) : null;
    }

    @Nullable
    private static Module guessAndroidModule(Project project, PsiElement element2) {
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)element2);
        if (module2 != null) {
            return module2;
        }
        return ProjectSystemUtil.getAndroidFacets(project).stream().map(Facet::getModule).findFirst().orElse(null);
    }

    private static boolean isFrameworkFieldDeclaration(PsiElement element2) {
        PsiField field2;
        PsiClass typeClass;
        if (element2 instanceof PsiField && (typeClass = (field2 = (PsiField)element2).getContainingClass()) != null) {
            PsiClass rClass2 = typeClass.getContainingClass();
            return rClass2 != null && "android.R".equals(AndroidPsiUtils.getQualifiedNameSafely((PsiClass)rClass2));
        }
        return false;
    }

    public boolean hasDocumentationFor(PsiElement element2, PsiElement originalElement) {
        return false;
    }

    public boolean canPromptToConfigureDocumentation(PsiElement element2) {
        return false;
    }

    public void promptToConfigureDocumentation(PsiElement element2) {
    }

    private static boolean isMyContext(@NotNull PsiElement element2, @NotNull Project project) {
        if (element2 instanceof PsiClass) {
            return (Boolean)ApplicationManager.getApplication().runReadAction(() -> {
                PsiFile file2 = element2.getContainingFile();
                if (file2 == null) {
                    return false;
                }
                VirtualFile vFile = file2.getVirtualFile();
                if (vFile == null) {
                    return false;
                }
                String path2 = FileUtil.toSystemIndependentName((String)vFile.getPath());
                if (StringUtil.toLowerCase((String)path2).contains("/android.jar!/") && !ProjectFacetManager.getInstance((Project)project).getFacets(AndroidFacet.ID).isEmpty()) {
                    VirtualFile jarFile = JarFileSystem.getInstance().getVirtualFileForJar(vFile);
                    return jarFile != null && "android.jar".equals(jarFile.getName());
                }
                return false;
            });
        }
        return false;
    }

    @VisibleForTesting
    static class MyDocExternalFilter
    extends JavaDocExternalFilter {
        public MyDocExternalFilter(Project project) {
            super(project);
        }

        protected void doBuildFromStream(String url, Reader input2, StringBuilder data) throws IOException {
            try {
                if (ourAnchorSuffix.matcher(url).find()) {
                    super.doBuildFromStream(url, input2, data);
                    return;
                }
                try (BufferedReader buf = new BufferedReader(input2);){
                    String read2;
                    String startSection = "<!-- ======== START OF CLASS DATA ======== -->";
                    String skipHeader = "<!-- END HEADER -->";
                    data.append("<HTML>");
                    while ((read2 = buf.readLine()) != null && !read2.contains(startSection)) {
                    }
                    if (read2 == null) {
                        data.delete(0, data.length());
                        return;
                    }
                    data.append(read2).append("\n");
                    boolean skip = false;
                    while ((read2 = buf.readLine()) != null && !read2.startsWith("<h2>Class Overview") && !read2.equals("<br><hr>")) {
                        if (read2.contains("<table class=")) {
                            skip = true;
                        } else if (read2.startsWith("<h2 class=\"api-section\"")) {
                            read2 = null;
                            break;
                        }
                        if (!skip && !read2.isEmpty()) {
                            data.append(read2).append("\n");
                        }
                        if (!read2.contains(skipHeader)) continue;
                        skip = true;
                    }
                    if (read2 != null) {
                        data.append("<br><div>\n");
                        while ((read2 = buf.readLine()) != null && !read2.startsWith("<h2>") && !read2.startsWith("<h2 ")) {
                            data.append(read2).append("\n");
                        }
                        data.append("</div>\n");
                    }
                    data.append("</HTML>");
                }
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e, new String[]{"URL: " + url});
            }
        }
    }
}

