/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.RenamePsiPackageProcessor;
import com.intellij.refactoring.rename.RenameXmlAttributeProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.android.dom.converters.PackageClassConverter;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidApplicationPackageRenameProcessor
extends RenamePsiElementProcessor {
    public boolean canProcessElement(@NotNull PsiElement element2) {
        if (element2 instanceof PsiPackage) {
            return ProjectFacetManager.getInstance((Project)element2.getProject()).hasFacets(AndroidFacet.ID);
        }
        return AndroidApplicationPackageRenameProcessor.isPackageAttributeInManifest(element2.getProject(), element2);
    }

    private static boolean isPackageAttributeInManifest(@NotNull Project project, @Nullable PsiElement element2) {
        if (element2 == null) {
            return false;
        }
        PsiFile psiFile = element2.getContainingFile();
        if (!(psiFile instanceof XmlFile)) {
            return false;
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((PsiElement)psiFile);
        if (facet2 == null) {
            return false;
        }
        VirtualFile vFile = psiFile.getVirtualFile();
        if (vFile == null || !vFile.equals(AndroidRootUtil.getPrimaryManifestFile(facet2))) {
            return false;
        }
        if (!(element2 instanceof XmlAttributeValue)) {
            return false;
        }
        PsiElement parent2 = element2.getParent();
        if (!(parent2 instanceof XmlAttribute)) {
            return false;
        }
        GenericAttributeValue attrValue = DomManager.getDomManager((Project)project).getDomElement((XmlAttribute)parent2);
        if (attrValue == null) {
            return false;
        }
        DomElement parentDomElement = attrValue.getParent();
        return parentDomElement instanceof Manifest && attrValue.equals(((Manifest)parentDomElement).getPackage());
    }

    public void renameElement(@NotNull PsiElement element2, @NotNull String newName2, @NotNull UsageInfo[] usages, @Nullable RefactoringElementListener listener2) throws IncorrectOperationException {
        if (element2 instanceof PsiPackage) {
            final HashMap newAttrValues = new HashMap();
            Project project = element2.getProject();
            String oldPackageQName = ((PsiPackage)element2).getQualifiedName();
            String newPackageQName = PsiUtilCore.getQualifiedNameAfterRename((String)oldPackageQName, (String)newName2);
            for (AndroidFacet androidFacet : ProjectSystemUtil.getAndroidFacets(project)) {
                String basePackage;
                XmlElement manifestElement;
                PsiFile manifestPsiFile;
                Manifest manifest = androidFacet != null ? Manifest.getMainManifest(androidFacet) : null;
                if (manifest == null || !((manifestPsiFile = (manifestElement = manifest.getXmlElement()) != null ? manifestElement.getContainingFile() : null) instanceof XmlFile) || (basePackage = (String)manifest.getPackage().getValue()) == null) continue;
                AndroidApplicationPackageRenameProcessor.processAllAttributesToUpdate((XmlFile)manifestPsiFile, basePackage, oldPackageQName, newPackageQName, new Processor<Pair<GenericAttributeValue, String>>(){

                    public boolean process(Pair<GenericAttributeValue, String> pair) {
                        newAttrValues.put((GenericAttributeValue)pair.getFirst(), (String)pair.getSecond());
                        return true;
                    }
                });
            }
            new RenamePsiPackageProcessor().renameElement(element2, newName2, usages, listener2);
            for (Map.Entry entry : newAttrValues.entrySet()) {
                ((GenericAttributeValue)entry.getKey()).setStringValue((String)entry.getValue());
            }
            return;
        }
        PsiFile file2 = element2.getContainingFile();
        if (!(file2 instanceof XmlFile)) {
            return;
        }
        Map<GenericAttributeValue, PsiClass> attr2class = AndroidApplicationPackageRenameProcessor.buildAttr2ClassMap((XmlFile)file2);
        new RenameXmlAttributeProcessor().renameElement(element2, newName2, usages, listener2);
        for (Map.Entry<GenericAttributeValue, PsiClass> e : attr2class.entrySet()) {
            e.getKey().setValue((Object)e.getValue());
        }
    }

    @Nullable
    private static String computeNewQName(@NotNull String name2, @NotNull String oldPackageName, @NotNull String newPackageName) {
        String suffix;
        if (name2.startsWith(oldPackageName) && ((suffix = name2.substring(oldPackageName.length())).isEmpty() || suffix.charAt(0) == '.')) {
            return newPackageName + suffix;
        }
        return null;
    }

    @NotNull
    private static Map<GenericAttributeValue, PsiClass> buildAttr2ClassMap(@NotNull XmlFile file2) {
        final HashMap<GenericAttributeValue, PsiClass> map2 = new HashMap<GenericAttributeValue, PsiClass>();
        AndroidApplicationPackageRenameProcessor.processAllClassAttrValues(file2, new Processor<Pair<GenericAttributeValue, PsiClass>>(){

            public boolean process(Pair<GenericAttributeValue, PsiClass> pair) {
                map2.put((GenericAttributeValue)pair.getFirst(), (PsiClass)pair.getSecond());
                return true;
            }
        });
        return map2;
    }

    public static void processAllAttributesToUpdate(@NotNull XmlFile file2, final @NotNull String basePackage, final @NotNull String oldPackageQName, final @NotNull String newPackageQName, final @NotNull Processor<Pair<GenericAttributeValue, String>> processor) {
        if (!AndroidUtils.isPackagePrefix(oldPackageQName, basePackage) && !AndroidUtils.isPackagePrefix(newPackageQName, basePackage)) {
            return;
        }
        AndroidApplicationPackageRenameProcessor.processAllClassAttrValues(file2, new Processor<Pair<GenericAttributeValue, PsiClass>>(){

            public boolean process(Pair<GenericAttributeValue, PsiClass> pair) {
                String newClassQName;
                String classQName;
                GenericAttributeValue domValue = (GenericAttributeValue)pair.getFirst();
                PsiClass psiClass = (PsiClass)pair.getSecond();
                String classPackageName = PackageClassConverter.getPackageName(psiClass);
                if (classPackageName != null && (classQName = PackageClassConverter.getQualifiedName(psiClass)) != null && (newClassQName = AndroidApplicationPackageRenameProcessor.computeNewQName(classQName, oldPackageQName, newPackageQName)) != null) {
                    String newRefValue = AndroidUtils.isPackagePrefix(basePackage, newClassQName) ? newClassQName.substring(basePackage.length()) : newClassQName;
                    processor.process((Object)Pair.create((Object)domValue, (Object)newRefValue));
                }
                return true;
            }
        });
    }

    private static void processAllClassAttrValues(@NotNull XmlFile file2, final @NotNull Processor<Pair<GenericAttributeValue, PsiClass>> processor) {
        final DomManager domManager = DomManager.getDomManager((Project)file2.getProject());
        file2.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

            public void visitXmlAttribute(@NotNull XmlAttribute attribute2) {
                Object value2;
                GenericAttributeValue domAttrValue = domManager.getDomElement(attribute2);
                if (domAttrValue != null && (value2 = domAttrValue.getValue()) instanceof PsiClass) {
                    processor.process((Object)Pair.create((Object)domAttrValue, (Object)((PsiClass)value2)));
                }
            }
        });
    }
}

