/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.res;

import com.android.annotations.concurrency.Slow;
import com.android.resources.aar.CachingData;
import com.android.resources.aar.FrameworkResourceRepository;
import com.android.tools.concurrency.AndroidIoManager;
import com.android.tools.res.AndroidPluginVersion;
import com.android.tools.res.FrameworkResourceRepositoryManager;
import com.google.common.hash.Hashing;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0002\u0014\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0007J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J&\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0007R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/res/FrameworkResourceRepositoryManager;", "", "()V", "cache", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/android/tools/res/FrameworkResourceRepositoryManager$CacheKey;", "Lcom/android/resources/aar/FrameworkResourceRepository;", "clearCache", "", "createCachingData", "Lcom/android/resources/aar/CachingData;", "resFolderOrJar", "Ljava/nio/file/Path;", "getFrameworkResources", "resourceDirectoryOrFile", "useCompiled9Patches", "", "languages", "", "", "CacheKey", "Companion", "intellij.android.render-resources"})
public final class FrameworkResourceRepositoryManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentHashMap<CacheKey, FrameworkResourceRepository> cache = new ConcurrentHashMap();

    @Slow
    @NotNull
    public final FrameworkResourceRepository getFrameworkResources(@NotNull Path resourceDirectoryOrFile, boolean useCompiled9Patches, @NotNull Set<String> languages2) {
        Intrinsics.checkNotNullParameter((Object)resourceDirectoryOrFile, (String)"resourceDirectoryOrFile");
        Intrinsics.checkNotNullParameter(languages2, (String)"languages");
        Path path2 = resourceDirectoryOrFile;
        CacheKey cacheKey = new CacheKey(path2, useCompiled9Patches);
        CachingData cachingData = this.createCachingData(path2);
        FrameworkResourceRepository frameworkResourceRepository = this.cache.computeIfAbsent(cacheKey, new Function(path2, languages2, cachingData, useCompiled9Patches){
            final /* synthetic */ Path $path;
            final /* synthetic */ Set<String> $languages;
            final /* synthetic */ CachingData $cachingData;
            final /* synthetic */ boolean $useCompiled9Patches;
            {
                this.$path = $path;
                this.$languages = $languages;
                this.$cachingData = $cachingData;
                this.$useCompiled9Patches = $useCompiled9Patches;
            }

            @NotNull
            public final FrameworkResourceRepository apply(@NotNull CacheKey it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return FrameworkResourceRepository.create((Path)this.$path, this.$languages, (CachingData)this.$cachingData, (boolean)this.$useCompiled9Patches);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)frameworkResourceRepository, (String)"useCompiled9Patches: Boo\u2026seCompiled9Patches)\n    }");
        FrameworkResourceRepository cached2 = frameworkResourceRepository;
        if (languages2.isEmpty()) {
            return cached2;
        }
        FrameworkResourceRepository frameworkResourceRepository2 = cached2.loadMissingLanguages(languages2, cachingData);
        Intrinsics.checkNotNullExpressionValue((Object)frameworkResourceRepository2, (String)"cached.loadMissingLangua\u2026s(languages, cachingData)");
        FrameworkResourceRepository repository2 = frameworkResourceRepository2;
        if (repository2 != cached2) {
            ((Map)this.cache).put(cacheKey, repository2);
        }
        return repository2;
    }

    private final CachingData createCachingData(Path resFolderOrJar) {
        String string;
        if (StringsKt.endsWith((String)((Object)resFolderOrJar.getFileName()).toString(), (String)".jar", (boolean)true)) {
            return null;
        }
        String string2 = AndroidPluginVersion.getAndroidPluginVersion();
        if (string2 == null) {
            return null;
        }
        String codeVersion = string2;
        try {
            string = Files.getLastModifiedTime(resFolderOrJar.resolve("../../package.xml"), new LinkOption[0]).toString();
        }
        catch (NoSuchFileException e) {
            string = "";
        }
        String string3 = string;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"try {\n      Files.getLas\u2026ception) {\n      \"\"\n    }");
        String contentVersion = string3;
        String string4 = Hashing.farmHashFingerprint64().hashUnencodedChars((CharSequence)((Object)resFolderOrJar).toString()).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"farmHashFingerprint64().\u2026ar.toString()).toString()");
        String pathHash = string4;
        Object object = resFolderOrJar.getParent();
        if (object == null || (object = object.getParent()) == null || (object = object.getFileName()) == null || (object = object.toString()) == null) {
            object = "framework";
        }
        Object prefix = object;
        String[] stringArray = "%s_%s.dat";
        Object[] objectArray = new Object[]{prefix, pathHash};
        String string5 = String.format((String)stringArray, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(format, *args)");
        String filename = string5;
        stringArray = new String[]{"caches/resources", filename};
        Path cacheFile = Paths.get(PathManager.getSystemPath(), stringArray);
        Executor executor2 = ApplicationManager.getApplication().isUnitTestMode() ? (Executor)createCachingData.executor.1.INSTANCE : (Executor)AndroidIoManager.Companion.getInstance().getBackgroundDiskIoExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)cacheFile, (String)"cacheFile");
        return new CachingData(cacheFile, contentVersion, codeVersion, executor2);
    }

    @TestOnly
    public final void clearCache() {
        this.cache.clear();
    }

    @JvmStatic
    @NotNull
    public static final FrameworkResourceRepositoryManager getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/res/FrameworkResourceRepositoryManager$CacheKey;", "", "path", "Ljava/nio/file/Path;", "useCompiled9Patches", "", "(Ljava/nio/file/Path;Z)V", "getPath", "()Ljava/nio/file/Path;", "getUseCompiled9Patches", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.android.render-resources"})
    private static final class CacheKey {
        @NotNull
        private final Path path;
        private final boolean useCompiled9Patches;

        public CacheKey(@NotNull Path path2, boolean useCompiled9Patches) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            this.path = path2;
            this.useCompiled9Patches = useCompiled9Patches;
        }

        @NotNull
        public final Path getPath() {
            return this.path;
        }

        public final boolean getUseCompiled9Patches() {
            return this.useCompiled9Patches;
        }

        @NotNull
        public final Path component1() {
            return this.path;
        }

        public final boolean component2() {
            return this.useCompiled9Patches;
        }

        @NotNull
        public final CacheKey copy(@NotNull Path path2, boolean useCompiled9Patches) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            return new CacheKey(path2, useCompiled9Patches);
        }

        public static /* synthetic */ CacheKey copy$default(CacheKey cacheKey, Path path2, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                path2 = cacheKey.path;
            }
            if ((n & 2) != 0) {
                bl = cacheKey.useCompiled9Patches;
            }
            return cacheKey.copy(path2, bl);
        }

        @NotNull
        public String toString() {
            return "CacheKey(path=" + this.path + ", useCompiled9Patches=" + this.useCompiled9Patches + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.path).hashCode();
            int n = this.useCompiled9Patches ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result2 = result2 * 31 + n;
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CacheKey)) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)other;
            if (!Intrinsics.areEqual((Object)this.path, (Object)cacheKey.path)) {
                return false;
            }
            return this.useCompiled9Patches == cacheKey.useCompiled9Patches;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/res/FrameworkResourceRepositoryManager$Companion;", "", "()V", "getInstance", "Lcom/android/tools/res/FrameworkResourceRepositoryManager;", "intellij.android.render-resources"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final FrameworkResourceRepositoryManager getInstance() {
            Object object = ApplicationManager.getApplication().getService(FrameworkResourceRepositoryManager.class);
            Intrinsics.checkNotNull((Object)object);
            return (FrameworkResourceRepositoryManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

