/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.property.panel.impl.ui;

import com.android.tools.adtui.common.AdtSecondaryPanel;
import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.adtui.model.stdui.ValueChangedListener;
import com.android.tools.property.panel.impl.model.FlagPropertyEditorModel;
import com.android.tools.property.panel.impl.ui.CustomFocusTraversalPolicy;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0017H\u0002J\u001e\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0002J\b\u0010\u001f\u001a\u00020\u0017H\u0002J\b\u0010 \u001a\u00020\u0017H\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0005H\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020'H\u0002J\b\u0010(\u001a\u00020\u0017H\u0002J\u0006\u0010)\u001a\u00020\u0017R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006*"}, d2={"Lcom/android/tools/property/panel/impl/ui/FlagPropertyPanel;", "Lcom/android/tools/adtui/common/AdtSecondaryPanel;", "editorModel", "Lcom/android/tools/property/panel/impl/model/FlagPropertyEditorModel;", "restoreFocusTo", "Ljavax/swing/JComponent;", "windowHeight", "", "(Lcom/android/tools/property/panel/impl/model/FlagPropertyEditorModel;Ljavax/swing/JComponent;I)V", "balloon", "Lcom/intellij/openapi/ui/popup/Balloon;", "getBalloon", "()Lcom/intellij/openapi/ui/popup/Balloon;", "setBalloon", "(Lcom/intellij/openapi/ui/popup/Balloon;)V", "flagDivider", "Ljavax/swing/JSeparator;", "innerPanel", "searchField", "Lcom/intellij/ui/SearchTextField;", "getSearchField", "()Lcom/intellij/ui/SearchTextField;", "addAllCheckBoxes", "", "addApplyButton", "addCheckBoxes", "panel", "Ljavax/swing/JPanel;", "items", "", "", "addLinks", "addSearchField", "createScrollPane", "Ljavax/swing/JScrollPane;", "component", "getForegroundColor", "Ljava/awt/Color;", "enabled", "", "handleValueChanged", "hideBalloonAndRestoreFocusOnEditor", "intellij.android.layout-ui"})
@SourceDebugExtension(value={"SMAP\nFlagPropertyEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlagPropertyEditor.kt\ncom/android/tools/property/panel/impl/ui/FlagPropertyPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,259:1\n1851#2,2:260\n*S KotlinDebug\n*F\n+ 1 FlagPropertyEditor.kt\ncom/android/tools/property/panel/impl/ui/FlagPropertyPanel\n*L\n193#1:260,2\n*E\n"})
public final class FlagPropertyPanel
extends AdtSecondaryPanel {
    @NotNull
    private final FlagPropertyEditorModel editorModel;
    @NotNull
    private final JComponent restoreFocusTo;
    @Nullable
    private Balloon balloon;
    @NotNull
    private final SearchTextField searchField;
    @NotNull
    private final AdtSecondaryPanel innerPanel;
    @NotNull
    private final JSeparator flagDivider;

    public FlagPropertyPanel(@NotNull FlagPropertyEditorModel editorModel, @NotNull JComponent restoreFocusTo, int windowHeight) {
        Intrinsics.checkNotNullParameter((Object)editorModel, (String)"editorModel");
        Intrinsics.checkNotNullParameter((Object)restoreFocusTo, (String)"restoreFocusTo");
        super((LayoutManager)new VerticalLayout(2));
        this.editorModel = editorModel;
        this.restoreFocusTo = restoreFocusTo;
        this.searchField = new SearchTextField();
        this.innerPanel = new AdtSecondaryPanel((LayoutManager)new VerticalLayout(2));
        this.flagDivider = new JSeparator();
        this.addLinks();
        this.addSearchField();
        this.addAllCheckBoxes();
        Component scrollPane2 = this.add(this.createScrollPane((JComponent)this.innerPanel));
        this.add(new JSeparator());
        this.addApplyButton();
        this.handleValueChanged();
        this.setFocusCycleRoot(true);
        JBTextField jBTextField = this.searchField.getTextEditor();
        Intrinsics.checkNotNullExpressionValue((Object)jBTextField, (String)"searchField.textEditor");
        this.setFocusTraversalPolicy(new CustomFocusTraversalPolicy((JComponent)jBTextField));
        this.editorModel.addListener(new ValueChangedListener(){

            public final void valueChanged() {
                this.handleValueChanged();
            }
        });
        if (this.getPreferredSize().height + 2 * JBUI.scale((int)40) > windowHeight) {
            int otherControlsHeight = this.getPreferredSize().height - this.innerPanel.getPreferredSize().height;
            int preferredHeight = windowHeight - 2 * JBUI.scale((int)40) - otherControlsHeight;
            scrollPane2.setPreferredSize(new Dimension(-1, Math.max(preferredHeight, JBUI.scale((int)200))));
        }
    }

    @Nullable
    public final Balloon getBalloon() {
        return this.balloon;
    }

    public final void setBalloon(@Nullable Balloon balloon) {
        this.balloon = balloon;
    }

    @NotNull
    public final SearchTextField getSearchField() {
        return this.searchField;
    }

    private final void addLinks() {
        Font font = StartupUiUtil.getLabelFont();
        Font smallerFont = font.deriveFont(font.getSize2D() * 0.9f);
        HyperlinkLabel selectAll = new HyperlinkLabel("Select all");
        selectAll.setFont(smallerFont);
        selectAll.addHyperlinkListener(new HyperlinkListener(this){
            final /* synthetic */ FlagPropertyPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public final void hyperlinkUpdate(HyperlinkEvent it) {
                FlagPropertyPanel.access$getEditorModel$p(this.this$0).selectAll();
            }
        });
        HyperlinkLabel clearAll2 = new HyperlinkLabel("Clear");
        clearAll2.setFont(smallerFont);
        clearAll2.addHyperlinkListener(new HyperlinkListener(this){
            final /* synthetic */ FlagPropertyPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public final void hyperlinkUpdate(HyperlinkEvent it) {
                FlagPropertyPanel.access$getEditorModel$p(this.this$0).clearAll();
                this.this$0.getSearchField().setText("");
            }
        });
        AdtSecondaryPanel links = new AdtSecondaryPanel((LayoutManager)new BorderLayout(JBUI.scale((int)5), 0));
        links.setFont(smallerFont);
        links.setBorder(JBUI.Borders.empty((int)5));
        links.add((Component)selectAll, (Object)"West");
        links.add((Component)clearAll2, (Object)"Center");
        this.add((Component)links, "TOP");
    }

    private final void addSearchField() {
        this.add((Component)this.searchField);
        this.searchField.addDocumentListener((DocumentListener)new DocumentAdapter(this){
            final /* synthetic */ FlagPropertyPanel this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            protected void textChanged(@NotNull DocumentEvent event2) {
                void $this$trim$iv;
                Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
                FlagPropertyEditorModel flagPropertyEditorModel = FlagPropertyPanel.access$getEditorModel$p(this.this$0);
                String string = this.this$0.getSearchField().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"searchField.text");
                String string2 = string;
                FlagPropertyEditorModel flagPropertyEditorModel2 = flagPropertyEditorModel;
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                flagPropertyEditorModel2.setFilter(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString());
            }
        });
    }

    private final JScrollPane createScrollPane(JComponent component2) {
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)component2, (int)20, (int)31);
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"createScrollPane(\n      \u2026RIZONTAL_SCROLLBAR_NEVER)");
        JScrollPane scrollPane2 = jScrollPane;
        scrollPane2.setBorder((Border)JBUI.Borders.empty());
        scrollPane2.addComponentListener(new ComponentAdapter(scrollPane2){
            final /* synthetic */ JScrollPane $scrollPane;
            {
                this.$scrollPane = $scrollPane;
            }

            public void componentResized(@Nullable ComponentEvent event2) {
                this.$scrollPane.getVerticalScrollBar().setUnitIncrement(this.$scrollPane.getHeight());
                this.$scrollPane.getVerticalScrollBar().setBlockIncrement(this.$scrollPane.getHeight());
            }
        });
        return scrollPane2;
    }

    private final void addAllCheckBoxes() {
        this.addCheckBoxes((JPanel)this.innerPanel, this.editorModel.getInitialItemsAboveSeparator());
        this.innerPanel.add((Component)this.flagDivider);
        this.addCheckBoxes((JPanel)this.innerPanel, this.editorModel.getInitialItemsBelowSeparator());
    }

    private final void addCheckBoxes(JPanel panel2, List<String> items2) {
        Iterable $this$forEach$iv = items2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            JBCheckBox checkBox2 = new JBCheckBox(it);
            panel2.add((Component)checkBox2);
            checkBox2.setBackground((Color)StudioColorsKt.getSecondaryPanelBackground());
            checkBox2.addActionListener(new ActionListener(this, checkBox2){
                final /* synthetic */ FlagPropertyPanel this$0;
                final /* synthetic */ JBCheckBox $checkBox;
                {
                    this.this$0 = $receiver;
                    this.$checkBox = $checkBox;
                }

                public final void actionPerformed(ActionEvent it) {
                    FlagPropertyEditorModel flagPropertyEditorModel = FlagPropertyPanel.access$getEditorModel$p(this.this$0);
                    String string = this.$checkBox.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"checkBox.text");
                    flagPropertyEditorModel.toggle(string);
                }
            });
        }
    }

    private final void addApplyButton() {
        JButton apply2 = new JButton();
        apply2.setText("Apply");
        apply2.setDefaultCapable(true);
        apply2.setBackground((Color)StudioColorsKt.getSecondaryPanelBackground());
        Dimension minSize = apply2.getMinimumSize();
        apply2.setPreferredSize(new Dimension(minSize.width * 2, minSize.height));
        apply2.addActionListener(new ActionListener(this){
            final /* synthetic */ FlagPropertyPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public final void actionPerformed(ActionEvent it) {
                FlagPropertyPanel.access$getEditorModel$p(this.this$0).applyChanges();
                this.this$0.hideBalloonAndRestoreFocusOnEditor();
            }
        });
        AdtSecondaryPanel applyPanel = new AdtSecondaryPanel(null, 1, null);
        applyPanel.add((Component)apply2);
        applyPanel.setBorder((Border)JBUI.Borders.empty((int)0, (int)5, (int)5, (int)5));
        this.add((Component)applyPanel, "BOTTOM");
    }

    public final void hideBalloonAndRestoreFocusOnEditor() {
        Balloon balloon = this.balloon;
        if (balloon != null) {
            balloon.hide();
        }
        JComponent restoreTo = this.restoreFocusTo;
        if (restoreTo instanceof JTable) {
            ((JTable)restoreTo).editCellAt(((JTable)restoreTo).getSelectedRow(), ((JTable)restoreTo).getSelectedColumn());
            Component component2 = ((JTable)restoreTo).getEditorComponent();
            if (component2 != null) {
                component2.requestFocus();
            }
        } else {
            restoreTo.requestFocus();
        }
    }

    private final void handleValueChanged() {
        int n = this.innerPanel.getComponentCount();
        for (int index2 = 0; index2 < n; ++index2) {
            JBCheckBox component2;
            Component component3 = this.innerPanel.getComponent(index2);
            if ((component3 instanceof JBCheckBox ? (JBCheckBox)component3 : null) == null) continue;
            component2 = component2;
            String string = component2.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"component.text");
            component2.setSelected(this.editorModel.isSelected(string));
            String string2 = component2.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"component.text");
            component2.setForeground(this.getForegroundColor(this.editorModel.isEnabled(string2)));
            String string3 = component2.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"component.text");
            component2.setVisible(this.editorModel.isVisible(string3));
        }
        this.flagDivider.setVisible(this.editorModel.getFlagDividerVisible());
    }

    private final Color getForegroundColor(boolean enabled2) {
        return enabled2 ? UIUtil.getLabelTextForeground() : UIUtil.getLabelDisabledForeground();
    }

    public static final /* synthetic */ FlagPropertyEditorModel access$getEditorModel$p(FlagPropertyPanel $this) {
        return $this.editorModel;
    }
}

