/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profgen;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.UShort;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0019\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u001a\u0014\u0010\u0011\u001a\u00020\u00122\n\u0010\u0013\u001a\u00020\u0014\"\u00020\u0015H\u0000\u001a\f\u0010\u0016\u001a\u00020\u0012*\u00020\u0012H\u0000\u001a\u0014\u0010\u0017\u001a\u00020\u000e*\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0001H\u0000\u001a\u0014\u0010\u0019\u001a\u00020\u0012*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0001H\u0000\u001a\u001c\u0010\u001c\u001a\u00020\u0012*\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u0001H\u0000\u001a\u0014\u0010\u001f\u001a\u00020\u000e*\u00020\u001a2\u0006\u0010 \u001a\u00020\u0001H\u0000\u001a\u0014\u0010!\u001a\u00020\"*\u00020\u001a2\u0006\u0010#\u001a\u00020\u0001H\u0000\u001a\f\u0010$\u001a\u00020\u0001*\u00020\u001aH\u0000\u001a\f\u0010%\u001a\u00020\"*\u00020\u001aH\u0000\u001a\f\u0010&\u001a\u00020\u0001*\u00020\u001aH\u0000\u001a\f\u0010'\u001a\u00020\u0001*\u00020\"H\u0000\u001a\u0014\u0010(\u001a\u00020)*\u00020*2\u0006\u0010+\u001a\u00020\u0012H\u0000\u001a\u0014\u0010,\u001a\u00020)*\u00020*2\u0006\u0010-\u001a\u00020\u000eH\u0000\u001a\u001c\u0010.\u001a\u00020)*\u00020*2\u0006\u0010/\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0001H\u0000\u001a\u0014\u00100\u001a\u00020)*\u00020*2\u0006\u0010/\u001a\u00020\u0001H\u0000\u001a\u0014\u00101\u001a\u00020)*\u00020*2\u0006\u0010/\u001a\u00020\"H\u0000\u001a\u0014\u00102\u001a\u00020)*\u00020*2\u0006\u0010/\u001a\u00020\u0001H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0005\u001a\u00020\u0001*\u00020\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0018\u0010\t\u001a\u00020\u0001*\u00020\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\b\"\u0018\u0010\u000b\u001a\u00020\u0001*\u00020\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\b\"\u0018\u0010\r\u001a\u00020\u0001*\u00020\u000e8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u00063"}, d2={"MASK", "", "UINT_16_SIZE", "UINT_32_SIZE", "UINT_8_SIZE", "leb128", "Ljava/nio/ByteBuffer;", "getLeb128", "(Ljava/nio/ByteBuffer;)I", "ubyte", "getUbyte", "ushort", "getUshort", "utf8Length", "", "getUtf8Length", "(Ljava/lang/String;)I", "byteArrayOf", "", "chars", "", "", "compressed", "mutf8", "encodedSize", "read", "Ljava/io/InputStream;", "length", "readCompressed", "compressedDataSize", "uncompressedDataSize", "readString", "size", "readUInt", "", "numberOfBytes", "readUInt16", "readUInt32", "readUInt8", "toIntSaturated", "writeCompressed", "", "Ljava/io/OutputStream;", "data", "writeString", "s", "writeUInt", "value", "writeUInt16", "writeUInt32", "writeUInt8", "android.sdktools.profgen"})
public final class EncodingKt {
    private static final int MASK = 127;
    public static final int UINT_8_SIZE = 1;
    public static final int UINT_16_SIZE = 2;
    public static final int UINT_32_SIZE = 4;

    public static final int getLeb128(@NotNull ByteBuffer $this$leb128) {
        Intrinsics.checkNotNullParameter((Object)$this$leb128, (String)"<this>");
        int value2 = 0;
        int b = 0;
        int idx = 0;
        do {
            b = EncodingKt.getUbyte($this$leb128);
            value2 |= (b & 0x7F) << idx++ * 7;
        } while ((b & 0xFFFFFF80) != 0);
        return value2;
    }

    @NotNull
    public static final String mutf8(@NotNull ByteBuffer $this$mutf8, int encodedSize) {
        Intrinsics.checkNotNullParameter((Object)$this$mutf8, (String)"<this>");
        char[] out = new char[encodedSize];
        int s = 0;
        while (true) {
            int b;
            char a;
            if ((a = (char)$this$mutf8.get()) == '\u0000') {
                return new String(out, 0, s);
            }
            out[s] = a;
            if (Intrinsics.compare((int)a, (int)128) < 0) {
                ++s;
                continue;
            }
            if ((a & 0xE0) == 192) {
                b = EncodingKt.getUbyte($this$mutf8);
                if ((b & 0xC0) != 128) {
                    throw new UTFDataFormatException("bad second byte");
                }
                out[s++] = (char)((a & 0x1F) << 6 | b & 0x3F);
                continue;
            }
            if ((a & 0xF0) != 224) break;
            b = EncodingKt.getUbyte($this$mutf8);
            int c = EncodingKt.getUbyte($this$mutf8);
            if ((b & 0xC0) != 128 || (c & 0xC0) != 128) {
                throw new UTFDataFormatException("bad second or third byte");
            }
            out[s++] = (char)((a & 0xF) << 12 | (b & 0x3F) << 6 | c & 0x3F);
        }
        throw new UTFDataFormatException("bad byte");
    }

    public static final int toIntSaturated(long $this$toIntSaturated) {
        return $this$toIntSaturated > Integer.MAX_VALUE ? Integer.MAX_VALUE : ($this$toIntSaturated < Integer.MIN_VALUE ? Integer.MIN_VALUE : (int)$this$toIntSaturated);
    }

    public static final int getUshort(@NotNull ByteBuffer $this$ushort) {
        Intrinsics.checkNotNullParameter((Object)$this$ushort, (String)"<this>");
        return UShort.constructor-impl((short)$this$ushort.getShort()) & 0xFFFF;
    }

    public static final int getUbyte(@NotNull ByteBuffer $this$ubyte) {
        Intrinsics.checkNotNullParameter((Object)$this$ubyte, (String)"<this>");
        return UByte.constructor-impl((byte)$this$ubyte.get()) & 0xFF;
    }

    @NotNull
    public static final byte[] byteArrayOf(char ... chars) {
        Intrinsics.checkNotNullParameter((Object)chars, (String)"chars");
        int n = 0;
        int n2 = chars.length;
        byte[] byArray = new byte[n2];
        while (n < n2) {
            int n3 = n++;
            byArray[n3] = (byte)chars[n3];
        }
        return byArray;
    }

    public static final void writeUInt(@NotNull OutputStream $this$writeUInt, long value2, int numberOfBytes) {
        Intrinsics.checkNotNullParameter((Object)$this$writeUInt, (String)"<this>");
        byte[] buffer = new byte[numberOfBytes];
        for (int i = 0; i < numberOfBytes; ++i) {
            buffer[i] = (byte)(value2 >> i * 8 & 0xFFL);
        }
        $this$writeUInt.write(buffer);
    }

    public static final void writeUInt8(@NotNull OutputStream $this$writeUInt8, int value2) {
        Intrinsics.checkNotNullParameter((Object)$this$writeUInt8, (String)"<this>");
        EncodingKt.writeUInt($this$writeUInt8, value2, 1);
    }

    public static final void writeUInt16(@NotNull OutputStream $this$writeUInt16, int value2) {
        Intrinsics.checkNotNullParameter((Object)$this$writeUInt16, (String)"<this>");
        EncodingKt.writeUInt($this$writeUInt16, value2, 2);
    }

    public static final void writeUInt32(@NotNull OutputStream $this$writeUInt32, long value2) {
        Intrinsics.checkNotNullParameter((Object)$this$writeUInt32, (String)"<this>");
        EncodingKt.writeUInt($this$writeUInt32, value2, 4);
    }

    public static final void writeString(@NotNull OutputStream $this$writeString, @NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)$this$writeString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        String string = s;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        $this$writeString.write(byArray);
    }

    public static final void writeCompressed(@NotNull OutputStream $this$writeCompressed, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)$this$writeCompressed, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        byte[] compressed = EncodingKt.compressed(data);
        EncodingKt.writeUInt32($this$writeCompressed, compressed.length);
        $this$writeCompressed.write(compressed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final byte[] compressed(@NotNull byte[] $this$compressed) {
        Intrinsics.checkNotNullParameter((Object)$this$compressed, (String)"<this>");
        Deflater compressor = new Deflater(1);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DeflaterOutputStream deflater = new DeflaterOutputStream((OutputStream)out, compressor);
        Closeable closeable = deflater;
        Throwable throwable = null;
        try {
            DeflaterOutputStream it = (DeflaterOutputStream)closeable;
            boolean bl = false;
            deflater.write($this$compressed);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        byte[] byArray = out.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"out.toByteArray()");
        return byArray;
    }

    @NotNull
    public static final byte[] read(@NotNull InputStream $this$read, int length) {
        int result2;
        Intrinsics.checkNotNullParameter((Object)$this$read, (String)"<this>");
        byte[] buffer = new byte[length];
        for (int offset = 0; offset < length; offset += result2) {
            result2 = $this$read.read(buffer, offset, length - offset);
            if (result2 >= 0) continue;
            throw new IllegalStateException(("Not enough bytes to read: " + length).toString());
        }
        return buffer;
    }

    public static final int readUInt8(@NotNull InputStream $this$readUInt8) {
        Intrinsics.checkNotNullParameter((Object)$this$readUInt8, (String)"<this>");
        return (int)EncodingKt.readUInt($this$readUInt8, 1);
    }

    public static final int readUInt16(@NotNull InputStream $this$readUInt16) {
        Intrinsics.checkNotNullParameter((Object)$this$readUInt16, (String)"<this>");
        return (int)EncodingKt.readUInt($this$readUInt16, 2);
    }

    public static final long readUInt32(@NotNull InputStream $this$readUInt32) {
        Intrinsics.checkNotNullParameter((Object)$this$readUInt32, (String)"<this>");
        return EncodingKt.readUInt($this$readUInt32, 4);
    }

    public static final long readUInt(@NotNull InputStream $this$readUInt, int numberOfBytes) {
        Intrinsics.checkNotNullParameter((Object)$this$readUInt, (String)"<this>");
        byte[] buffer = EncodingKt.read($this$readUInt, numberOfBytes);
        long value2 = 0L;
        for (int k = 0; k < numberOfBytes; ++k) {
            long next = (long)UByte.constructor-impl((byte)buffer[k]) & 0xFFL;
            value2 += next << k * 8;
        }
        return value2;
    }

    @NotNull
    public static final String readString(@NotNull InputStream $this$readString, int size) {
        Intrinsics.checkNotNullParameter((Object)$this$readString, (String)"<this>");
        byte[] byArray = EncodingKt.read($this$readString, size);
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        Charset charset2 = charset;
        return new String(byArray, charset2);
    }

    @NotNull
    public static final byte[] readCompressed(@NotNull InputStream $this$readCompressed, int compressedDataSize, int uncompressedDataSize) {
        int totalBytesRead;
        int bytesRead;
        Intrinsics.checkNotNullParameter((Object)$this$readCompressed, (String)"<this>");
        Inflater inf = new Inflater();
        byte[] result2 = new byte[uncompressedDataSize];
        int totalBytesInflated = 0;
        byte[] input2 = new byte[2048];
        for (totalBytesRead = 0; !inf.finished() && !inf.needsDictionary() && totalBytesRead < compressedDataSize; totalBytesRead += bytesRead) {
            bytesRead = $this$readCompressed.read(input2);
            if (bytesRead < 0) {
                throw new IllegalStateException(("Invalid zip data. Stream ended after " + totalBytesRead + " bytes. Expected " + compressedDataSize + " bytes").toString());
            }
            inf.setInput(input2, 0, bytesRead);
            totalBytesInflated += inf.inflate(result2, totalBytesInflated, uncompressedDataSize - totalBytesInflated);
        }
        if (totalBytesRead != compressedDataSize) {
            throw new IllegalStateException(("Didn't read enough bytes during decompression. expected=" + compressedDataSize + " actual=" + totalBytesRead).toString());
        }
        if (!inf.finished()) {
            throw new IllegalStateException("Inflater did not finish".toString());
        }
        return result2;
    }

    public static final int getUtf8Length(@NotNull String $this$utf8Length) {
        Intrinsics.checkNotNullParameter((Object)$this$utf8Length, (String)"<this>");
        String string = $this$utf8Length;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        return byArray.length;
    }
}

