/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.layoutinspector;

import com.android.io.CancellableFileIo;
import com.android.tools.idea.layoutinspector.proto.SkiaParser;
import com.android.tools.idea.protobuf.ByteString;
import com.android.tools.layoutinspector.BitmapType;
import com.android.tools.layoutinspector.InvalidPictureException;
import com.android.tools.layoutinspector.LayoutInspectorUtilsKt;
import com.android.tools.layoutinspector.SkiaViewNode;
import com.android.tools.layoutinspector.VersionMap;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JF\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u000bJ\u000e\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ0\u0010\u001b\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020\fR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/android/tools/layoutinspector/LayoutInspectorUtils;", "", "()V", "versionMapUnmarshaller", "Ljavax/xml/bind/Unmarshaller;", "kotlin.jvm.PlatformType", "buildTree", "Lcom/android/tools/layoutinspector/SkiaViewNode;", "node", "Lcom/android/tools/idea/layoutinspector/proto/SkiaParser$InspectorView;", "images", "", "", "Lcom/android/tools/idea/protobuf/ByteString;", "isInterrupted", "Lkotlin/Function0;", "", "drawIdToRequest", "", "Lcom/android/tools/idea/layoutinspector/proto/SkiaParser$RequestedNodeInfo;", "getSkpVersion", "data", "", "loadSkiaParserVersionMap", "Lcom/android/tools/layoutinspector/VersionMap;", "path", "Ljava/nio/file/Path;", "makeRequestedNodeInfo", "drawId", "x", "y", "width", "height", "dynamic-layout-inspector.common"})
@SourceDebugExtension(value={"SMAP\nLayoutInspectorUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LayoutInspectorUtils.kt\ncom/android/tools/layoutinspector/LayoutInspectorUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,143:1\n1603#2,9:144\n1851#2:153\n1852#2:155\n1612#2:156\n1#3:154\n*S KotlinDebug\n*F\n+ 1 LayoutInspectorUtils.kt\ncom/android/tools/layoutinspector/LayoutInspectorUtils\n*L\n49#1:144,9\n49#1:153\n49#1:155\n49#1:156\n49#1:154\n*E\n"})
public final class LayoutInspectorUtils {
    @NotNull
    public static final LayoutInspectorUtils INSTANCE = new LayoutInspectorUtils();
    private static final Unmarshaller versionMapUnmarshaller;

    private LayoutInspectorUtils() {
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final SkiaViewNode buildTree(@NotNull SkiaParser.InspectorView node, @NotNull Map<Integer, ? extends ByteString> images, @NotNull Function0<Boolean> isInterrupted, @NotNull Map<Long, SkiaParser.RequestedNodeInfo> drawIdToRequest) {
        SkiaViewNode skiaViewNode;
        ByteString image;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(images, (String)"images");
        Intrinsics.checkNotNullParameter(isInterrupted, (String)"isInterrupted");
        Intrinsics.checkNotNullParameter(drawIdToRequest, (String)"drawIdToRequest");
        if (((Boolean)isInterrupted.invoke()).booleanValue()) {
            throw new InterruptedException();
        }
        ByteString byteString = image = node.getImage().isEmpty() ? images.get(node.getImageId()) : node.getImage();
        boolean bl = byteString != null ? !byteString.isEmpty() : false;
        if (bl) {
            int n;
            int n2;
            if (node.getWidth() > 0) {
                n2 = node.getWidth();
            } else {
                SkiaParser.RequestedNodeInfo requestedNodeInfo = drawIdToRequest.get(node.getId());
                if (requestedNodeInfo != null) {
                    n2 = requestedNodeInfo.getWidth();
                } else {
                    return null;
                }
            }
            int width = n2;
            if (node.getHeight() > 0) {
                n = node.getHeight();
            } else {
                SkiaParser.RequestedNodeInfo requestedNodeInfo = drawIdToRequest.get(node.getId());
                if (requestedNodeInfo != null) {
                    n = requestedNodeInfo.getHeight();
                } else {
                    return null;
                }
            }
            int height = n;
            long l = node.getId();
            ByteBuffer byteBuffer = image.asReadOnlyByteBuffer();
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"image.asReadOnlyByteBuffer()");
            skiaViewNode = new SkiaViewNode(l, BitmapType.ARGB_8888.createImage(byteBuffer, width, height));
        } else {
            List list2;
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            long l = node.getId();
            List list3 = node.getChildrenList();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"node.childrenList");
            Iterable width = list3;
            long l2 = l;
            boolean $i$f$mapNotNull = false;
            void var8_11 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                SkiaViewNode it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl2 = false;
                SkiaParser.InspectorView it = (SkiaParser.InspectorView)element$iv$iv;
                boolean bl3 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                if (INSTANCE.buildTree(it, images, isInterrupted, drawIdToRequest) == null) continue;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list4 = list2 = (List)destination$iv$iv;
            long l3 = l2;
            skiaViewNode = new SkiaViewNode(l3, list4);
        }
        return skiaViewNode;
    }

    @Nullable
    public final SkiaParser.RequestedNodeInfo makeRequestedNodeInfo(long drawId, int x, int y, int width, int height) {
        return SkiaParser.RequestedNodeInfo.newBuilder().setId(drawId).setX(x).setY(y).setWidth(width).setHeight(height).build();
    }

    public final int getSkpVersion(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        List list2 = ArraysKt.slice((byte[])data, (IntRange)new IntRange(0, 7));
        byte[] byArray = "skiapict".getBytes(Charsets.US_ASCII);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        if (!Intrinsics.areEqual((Object)list2, (Object)ArraysKt.asList((byte[])byArray)) || data.length < 12) {
            throw new InvalidPictureException();
        }
        return LayoutInspectorUtilsKt.toInt(ArraysKt.sliceArray((byte[])data, (IntRange)new IntRange(8, 11)));
    }

    @NotNull
    public final VersionMap loadSkiaParserVersionMap(@NotNull Path path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        InputStream mapInputStream = CancellableFileIo.newInputStream((Path)path2, (OpenOption[])new OpenOption[0]);
        Object object = versionMapUnmarshaller.unmarshal(mapInputStream);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.android.tools.layoutinspector.VersionMap");
        return (VersionMap)object;
    }

    static {
        Class[] classArray = new Class[]{VersionMap.class};
        versionMapUnmarshaller = JAXBContext.newInstance((Class[])classArray).createUnmarshaller();
    }
}

