/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.dynamic;

import com.android.tools.adtui.DocumentAccessor;
import com.android.tools.adtui.TextAccessors;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.base.Objects;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorPanel;
import com.intellij.ui.TextAccessor;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class ScopedDataBinder
implements ScopedStateStore.ScopedStoreListener,
FocusListener,
ChangeListener,
ActionListener,
DocumentListener,
ItemListener {
    protected ScopedStateStore myState;
    private final Map<Document, JComponent> myDocumentsToComponent = Maps.newIdentityHashMap();
    private final Map<ScopedStateStore.Key, ValueDeriver> myValueDerivers = Maps.newHashMap();
    private final Table<JComponent, ScopedStateStore.Key<?>, ComponentBinding<?, ?>> myComponentBindings = HashBasedTable.create();
    private final Set<ScopedStateStore.Key> myGuardedKeys = Sets.newHashSet();
    private final Set<ScopedStateStore.Key> myUserEditedKeys = Sets.newHashSet();
    private boolean myAlreadySavingState;
    private JComponent myUpdateTrigger;

    public ScopedDataBinder() {
        this.myState = new ScopedStateStore(ScopedStateStore.Scope.STEP, null, this);
    }

    @Override
    public <T> void invokeUpdate(@Nullable ScopedStateStore.Key<T> changedKey) {
        if (changedKey == null) {
            ImmutableSet allKeys = ImmutableSet.copyOf((Collection)this.myComponentBindings.columnKeySet());
            this.myGuardedKeys.addAll((Collection<ScopedStateStore.Key>)allKeys);
            for (ScopedStateStore.Key key : allKeys) {
                if (!this.myComponentBindings.containsColumn((Object)key)) continue;
                this.internalUpdateKey(key);
            }
            this.deriveValues(null);
        } else {
            this.myGuardedKeys.add(changedKey);
            this.internalUpdateKey(changedKey);
        }
    }

    private <T> void internalUpdateKey(@NotNull ScopedStateStore.Key<T> changedKey) {
        T value2 = this.myState.get(changedKey);
        ImmutableMap keyBindings = ImmutableMap.copyOf((Map)this.myComponentBindings.column(changedKey));
        for (Map.Entry entry : keyBindings.entrySet()) {
            JComponent component2 = (JComponent)entry.getKey();
            if (!this.myComponentBindings.contains((Object)component2, changedKey) || Objects.equal((Object)component2, (Object)this.myUpdateTrigger)) continue;
            ComponentBinding binding = (ComponentBinding)this.myComponentBindings.get((Object)component2, changedKey);
            try {
                binding.setValue(value2, component2);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
        this.deriveValues(changedKey);
        this.myGuardedKeys.remove(changedKey);
    }

    private <T> void deriveValues(@Nullable ScopedStateStore.Key<T> changedKey) {
        for (ScopedStateStore.Key key : this.myValueDerivers.keySet()) {
            if (this.myGuardedKeys.contains(key)) continue;
            ValueDeriver deriver = this.myValueDerivers.get(key);
            if (this.myUserEditedKeys.contains(key) && deriver.respectUserEdits()) continue;
            Set<ScopedStateStore.Key<?>> triggerKeys = deriver.getTriggerKeys();
            if (changedKey != null && triggerKeys != null && !triggerKeys.contains(changedKey)) continue;
            this.deriveValue(key, deriver, changedKey);
        }
    }

    private <T> void deriveValue(@NotNull ScopedStateStore.Key<T> key, @NotNull ValueDeriver<T> deriver, @Nullable ScopedStateStore.Key<?> changedKey) {
        T currentValue = this.myState.get(key);
        T newValue = deriver.deriveValue(this.myState, changedKey, currentValue);
        if (newValue != null && !key.expectedClass.isInstance(newValue)) {
            throw new IllegalArgumentException(String.format("Deriver %1$s returned value for key %2$s of type %3$s, should be %4$s", deriver.toString(), key.name, newValue.getClass().getName(), key.expectedClass.getName()));
        }
        this.myState.put(key, newValue);
    }

    public <T> void saveState(@NotNull JComponent component2) {
        if (this.myAlreadySavingState) {
            return;
        }
        this.myAlreadySavingState = true;
        for (Map.Entry entry : this.myComponentBindings.row((Object)component2).entrySet()) {
            if (this.myGuardedKeys.contains(entry.getKey())) continue;
            ComponentBinding binding = (ComponentBinding)entry.getValue();
            try {
                Object value2 = binding.getValue(component2);
                this.storeValue((ScopedStateStore.Key)entry.getKey(), component2, value2);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
        this.myAlreadySavingState = false;
    }

    private <T> void storeValue(@NotNull ScopedStateStore.Key<T> key, @NotNull JComponent updateTrigger, @Nullable T value2) {
        T oldValue = this.myState.get(key);
        if (oldValue != null && !oldValue.equals(value2) && !this.myGuardedKeys.contains(key)) {
            this.myUserEditedKeys.add(key);
        }
        this.myUpdateTrigger = updateTrigger;
        this.myState.put(key, value2);
        this.myUpdateTrigger = null;
    }

    @Nullable
    private static Object getComponentValue(@NotNull JComponent component2) {
        Object newValue = null;
        if (component2 instanceof JCheckBox) {
            newValue = ((JCheckBox)component2).isSelected();
        } else if (component2 instanceof JComboBox) {
            newValue = ((JComboBox)component2).getSelectedItem();
        } else if (component2 instanceof JSlider) {
            newValue = ((JSlider)component2).getValue();
        } else if (component2 instanceof JSpinner) {
            newValue = ((JSpinner)component2).getValue();
        } else if (component2 instanceof ColorPanel) {
            newValue = ((ColorPanel)component2).getSelectedColor();
        } else {
            TextAccessor accessor = TextAccessors.getTextAccessor((JComponent)component2);
            if (accessor != null) {
                newValue = accessor.getText();
            }
        }
        return newValue;
    }

    private static void setComponentValue(@Nullable Object value2, @NotNull JComponent component2) {
        if (component2 instanceof JCheckBox) {
            ((JCheckBox)component2).setSelected(Boolean.TRUE.equals(value2));
        } else if (component2 instanceof JComboBox) {
            ScopedDataBinder.setSelectedItem((JComboBox)component2, value2);
        } else if (component2 instanceof JSlider) {
            assert (value2 != null);
            ((JSlider)component2).setValue((Integer)value2);
        } else if (component2 instanceof JSpinner) {
            ((JSpinner)component2).setValue(value2);
        } else if (component2 instanceof ColorPanel && value2 != null) {
            ((ColorPanel)component2).setSelectedColor((Color)value2);
        } else {
            String newValue;
            TextAccessor accessor = TextAccessors.getTextAccessor((JComponent)component2);
            if (accessor != null && !(newValue = StringUtil.notNullize((String)((String)value2))).equals(accessor.getText())) {
                accessor.setText(newValue);
            }
        }
    }

    public <T> void registerValueDeriver(@NotNull ScopedStateStore.Key<T> key, @NotNull ValueDeriver<T> deriver) {
        this.myValueDerivers.put(key, deriver);
    }

    public <T, C extends JComponent> void register(@NotNull ScopedStateStore.Key<T> key, @NotNull C component2, @NotNull ComponentBinding<T, ? super C> binding) {
        T value2 = this.bindAndGet(key, component2, binding);
        if (value2 != null) {
            try {
                binding.setValue(value2, component2);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        } else {
            try {
                this.myState.put(key, binding.getValue(component2));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        component2.addFocusListener(this);
        binding.addActionListener(this, component2);
        binding.addChangeListener(this, component2);
        binding.addItemListener(this, component2);
        Document document2 = binding.getDocument(component2);
        if (document2 != null) {
            this.myDocumentsToComponent.put(document2, component2);
            document2.addDocumentListener(this);
        }
    }

    @Nullable
    private <T> T bindAndGet(@NotNull ScopedStateStore.Key<T> key, @NotNull JComponent component2, @Nullable ComponentBinding<T, ?> binding) {
        DefaultBinding b = binding == null ? new DefaultBinding() : binding;
        this.myComponentBindings.put((Object)component2, key, (Object)b);
        return this.myState.get(key);
    }

    public void register(@NotNull ScopedStateStore.Key<Boolean> key, @NotNull JCheckBox checkBox2) {
        Boolean value2 = this.bindAndGet(key, checkBox2, null);
        if (value2 != null) {
            checkBox2.setSelected(value2);
        } else {
            this.myState.put(key, false);
        }
        checkBox2.addFocusListener(this);
        checkBox2.addItemListener(this);
    }

    protected <T> void register(@NotNull ScopedStateStore.Key<T> key, @NotNull JComboBox comboBox2) {
        T value2 = this.bindAndGet(key, comboBox2, null);
        if (value2 != null) {
            ScopedDataBinder.setSelectedItem(comboBox2, value2);
        }
        comboBox2.addFocusListener(this);
        comboBox2.addActionListener(this);
    }

    public static <T> void setSelectedItem(JComboBox comboBox2, @Nullable T value2) {
        int index2 = -1;
        for (int i = 0; i < comboBox2.getItemCount(); ++i) {
            Object item2 = comboBox2.getItemAt(i);
            if (!Objects.equal(item2, value2)) continue;
            index2 = i;
            break;
        }
        comboBox2.setSelectedIndex(index2);
    }

    public void register(@NotNull ScopedStateStore.Key<String> key, @NotNull JTextField textField2) {
        this.myDocumentsToComponent.put(textField2.getDocument(), textField2);
        String value2 = this.bindAndGet(key, textField2, null);
        if (value2 != null) {
            textField2.setText(value2);
        } else {
            this.myState.put(key, textField2.getText());
        }
        textField2.addFocusListener(this);
        textField2.getDocument().addDocumentListener(this);
    }

    public void register(@NotNull ScopedStateStore.Key<String> key, @NotNull JLabel label) {
        String value2 = this.bindAndGet(key, label, null);
        if (value2 != null) {
            label.setText(value2);
        } else {
            this.myState.put(key, label.getText());
        }
    }

    public void register(@NotNull ScopedStateStore.Key<Integer> key, @NotNull JSlider paddingSlider) {
        Integer value2 = this.bindAndGet(key, paddingSlider, null);
        if (value2 != null) {
            paddingSlider.setValue(value2);
        } else {
            this.myState.put(key, paddingSlider.getValue());
        }
        paddingSlider.addFocusListener(this);
        paddingSlider.addChangeListener(this);
    }

    public void register(@NotNull ScopedStateStore.Key<String> key, @NotNull TextFieldWithBrowseButton field2) {
        this.myDocumentsToComponent.put(field2.getTextField().getDocument(), (JComponent)field2);
        String value2 = this.bindAndGet(key, (JComponent)field2, null);
        if (value2 != null) {
            field2.setText(value2);
        } else {
            this.myState.put(key, field2.getText());
        }
        field2.addFocusListener((FocusListener)this);
        field2.getTextField().getDocument().addDocumentListener(this);
        field2.getTextField().addFocusListener(this);
    }

    public void register(@NotNull ScopedStateStore.Key<String> key, @NotNull DocumentAccessor field2) {
        assert (field2 instanceof JComponent);
        JComponent component2 = (JComponent)field2;
        String value2 = this.bindAndGet(key, component2, null);
        if (value2 != null) {
            field2.setText(value2);
        } else {
            this.myState.put(key, field2.getText());
        }
        component2.addFocusListener(this);
        this.myDocumentsToComponent.put(field2.getDocument(), component2);
        field2.getDocument().addDocumentListener(this);
    }

    public void register(@NotNull ScopedStateStore.Key<Color> key, @NotNull ColorPanel colorPanel) {
        Color value2 = this.bindAndGet(key, (JComponent)colorPanel, null);
        if (value2 != null) {
            colorPanel.setSelectedColor(value2);
        } else {
            this.myState.put(key, colorPanel.getSelectedColor());
        }
        colorPanel.addFocusListener((FocusListener)this);
        colorPanel.addActionListener((ActionListener)this);
    }

    protected void deregister(JComponent component2) {
        if (this.myComponentBindings.rowMap().remove(component2) != null) {
            component2.removeFocusListener(this);
            if (component2 instanceof JCheckBox) {
                ((JCheckBox)component2).removeItemListener(this);
            } else if (component2 instanceof JComboBox) {
                ((JComboBox)component2).removeActionListener(this);
            } else if (component2 instanceof JTextField) {
                ((JTextField)component2).getDocument().removeDocumentListener(this);
            } else if (component2 instanceof JRadioButton) {
                ((JRadioButton)component2).removeActionListener(this);
            } else if (component2 instanceof JSlider) {
                ((JSlider)component2).removeChangeListener(this);
            } else if (component2 instanceof JSpinner) {
                ((JSpinner)component2).removeChangeListener(this);
            } else if (component2 instanceof TextFieldWithBrowseButton) {
                ((TextFieldWithBrowseButton)component2).getTextField().getDocument().removeDocumentListener(this);
                ((TextFieldWithBrowseButton)component2).getTextField().removeFocusListener(this);
            } else if (component2 instanceof ColorPanel) {
                ((ColorPanel)component2).removeActionListener((ActionListener)this);
            }
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.saveState((JComponent)e.getSource());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.saveState((JComponent)e.getSource());
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.saveState((JComponent)e.getSource());
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.saveState(this.myDocumentsToComponent.get(e.getDocument()));
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.saveState(this.myDocumentsToComponent.get(e.getDocument()));
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    public static abstract class ComponentBinding<T, C extends JComponent> {
        public void setValue(@Nullable T newValue, @NotNull C component2) {
            throw new UnsupportedOperationException();
        }

        @Nullable
        public T getValue(@NotNull C component2) {
            throw new UnsupportedOperationException();
        }

        public void addActionListener(@NotNull ActionListener listener2, @NotNull C component2) {
        }

        public void addChangeListener(@NotNull ChangeListener listener2, @NotNull C component2) {
        }

        public void addItemListener(@NotNull ItemListener listener2, @NotNull C component2) {
        }

        @Nullable
        public Document getDocument(@NotNull C component2) {
            return null;
        }
    }

    public static abstract class ValueDeriver<T> {
        public boolean respectUserEdits() {
            return true;
        }

        @Nullable
        public Set<ScopedStateStore.Key<?>> getTriggerKeys() {
            return null;
        }

        @Nullable
        protected static Set<ScopedStateStore.Key<?>> makeSetOf(ScopedStateStore.Key<?> ... elements) {
            HashSet keys = new HashSet(elements.length);
            Collections.addAll(keys, elements);
            return keys;
        }

        @Nullable
        public abstract T deriveValue(@NotNull ScopedStateStore var1, @Nullable ScopedStateStore.Key var2, @Nullable T var3);
    }

    private static class DefaultBinding
    extends ComponentBinding<Object, JComponent> {
        private DefaultBinding() {
        }

        @Override
        public void setValue(@Nullable Object newValue, @NotNull JComponent component2) {
            ScopedDataBinder.setComponentValue(newValue, component2);
        }

        @Override
        @Nullable
        public Object getValue(@NotNull JComponent component2) {
            return ScopedDataBinder.getComponentValue(component2);
        }
    }
}

