/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.wizard.deprecated;

import com.android.tools.adtui.validation.Validator;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.ui.validation.validators.PathValidator;
import com.android.tools.idea.welcome.config.FirstRunWizardMode;
import com.android.tools.idea.welcome.install.ComponentTreeNode;
import com.android.tools.idea.welcome.install.InstallableComponent;
import com.android.tools.idea.welcome.wizard.SdkComponentsStep;
import com.android.tools.idea.welcome.wizard.SdkComponentsStepKt;
import com.android.tools.idea.welcome.wizard.WelcomeUiUtils;
import com.android.tools.idea.welcome.wizard.deprecated.FirstRunWizardStep;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextDelegate;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.KeyEvent;
import java.io.File;
import java.nio.file.Paths;
import java.util.Set;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

@Deprecated
public class SdkComponentsStep
extends FirstRunWizardStep
implements Disposable {
    @NotNull
    private final ComponentTreeNode myRootNode;
    @NotNull
    private final FirstRunWizardMode myMode;
    @NotNull
    private final ScopedStateStore.Key<Boolean> myKeyCustomInstall;
    private final ScopedStateStore.Key<String> mySdkDownloadPathKey;
    private final SdkComponentsStep.ComponentsTableModel myTableModel;
    private JPanel myContents;
    private JBTable myComponentsTable;
    private JTextPane myComponentDescription;
    private JLabel myNeededSpace;
    private JLabel myAvailableSpace;
    private JLabel myErrorMessage;
    private TextFieldWithBrowseButton myPath;
    private JPanel myBody;
    private JBLoadingPanel myContentPanel;
    private boolean myUserEditedPath = false;
    private Validator.Result mySdkDirectoryValidationResult;
    private boolean myWasForcedVisible = false;
    private boolean myLoading;

    public SdkComponentsStep(@NotNull ComponentTreeNode rootNode, @NotNull ScopedStateStore.Key<Boolean> keyCustomInstall, @NotNull ScopedStateStore.Key<String> sdkDownloadPathKey, @NotNull FirstRunWizardMode mode, @NotNull Disposable parent2) {
        super("SDK Components Setup");
        this.$$$setupUI$$$();
        Disposer.register((Disposable)parent2, (Disposable)this);
        this.myPath.setEditable(false);
        this.myRootNode = rootNode;
        this.myMode = mode;
        this.myKeyCustomInstall = keyCustomInstall;
        if (!IdeInfo.getInstance().isGameTools()) {
            this.myPath.addBrowseFolderListener("Android SDK", "Select Android SDK install directory", null, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        }
        this.mySdkDownloadPathKey = sdkDownloadPathKey;
        JBFont smallLabelFont = JBUI.Fonts.smallFont();
        this.myNeededSpace.setFont((Font)smallLabelFont);
        this.myAvailableSpace.setFont((Font)smallLabelFont);
        this.myErrorMessage.setText(null);
        this.myTableModel = new SdkComponentsStep.ComponentsTableModel(rootNode);
        this.myComponentsTable.setModel((TableModel)this.myTableModel);
        this.myComponentsTable.setTableHeader(null);
        this.myComponentsTable.getSelectionModel().addListSelectionListener(e -> {
            int row2 = this.myComponentsTable.getSelectedRow();
            this.myComponentDescription.setText(row2 < 0 ? "" : this.myTableModel.getComponentDescription(row2));
        });
        TableColumn column2 = this.myComponentsTable.getColumnModel().getColumn(0);
        column2.setCellRenderer(new SdkComponentRenderer());
        column2.setCellEditor(new SdkComponentRenderer());
        this.setComponent(this.myContents);
    }

    public void dispose() {
    }

    public void startLoading() {
        this.myContentPanel.startLoading();
        this.myLoading = true;
        this.invokeUpdate(null);
    }

    public void stopLoading() {
        this.myContentPanel.stopLoading();
        this.myLoading = false;
        this.invokeUpdate(null);
    }

    public void loadingError() {
        this.myContentPanel.setLoadingText("Error loading components");
        this.myLoading = false;
        this.invokeUpdate(null);
    }

    @Override
    public boolean validate() {
        String message2;
        String path2 = StringUtil.notNullize((String)this.myState.get(this.mySdkDownloadPathKey));
        if (!StringUtil.isEmpty((String)path2)) {
            this.myUserEditedPath = true;
        }
        this.mySdkDirectoryValidationResult = PathValidator.forAndroidSdkLocation().validate(Paths.get(path2, new String[0]));
        Validator.Severity severity = this.mySdkDirectoryValidationResult.getSeverity();
        boolean ok = severity == Validator.Severity.OK;
        String string = message2 = ok ? null : this.mySdkDirectoryValidationResult.getMessage();
        if (ok) {
            File filesystem = SdkComponentsStepKt.getTargetFilesystem(path2);
            if (filesystem != null && filesystem.getFreeSpace() <= this.getComponentsSize()) {
                severity = Validator.Severity.ERROR;
                message2 = "Target drive does not have enough free space.";
            } else if (SdkComponentsStepKt.isNonEmptyNonSdk(path2)) {
                severity = Validator.Severity.WARNING;
                message2 = "Target folder is neither empty nor does it point to an existing SDK installation.";
            } else if (SdkComponentsStepKt.isExistingSdk(path2)) {
                severity = Validator.Severity.WARNING;
                message2 = "An existing Android SDK was detected. The setup wizard will only download missing or outdated SDK components.";
            }
        }
        this.myErrorMessage.setIcon(severity.getIcon());
        this.setErrorHtml(this.myUserEditedPath ? message2 : null);
        if (this.myLoading) {
            return false;
        }
        return this.mySdkDirectoryValidationResult.getSeverity() != Validator.Severity.ERROR;
    }

    @Override
    public void deriveValues(Set<? extends ScopedStateStore.Key> modified) {
        super.deriveValues(modified);
        String path2 = this.myState.get(this.mySdkDownloadPathKey);
        this.myAvailableSpace.setText("Available disk space: " + SdkComponentsStepKt.getDiskSpace(path2));
        long selected = this.getComponentsSize();
        this.myNeededSpace.setText(String.format("Total download size: %s", WelcomeUiUtils.getSizeLabel(selected)));
    }

    private long getComponentsSize() {
        long size = 0L;
        for (InstallableComponent component2 : this.myRootNode.getChildrenToInstall()) {
            size += component2.getDownloadSize();
        }
        return size;
    }

    @Override
    public void init() {
        this.register(this.mySdkDownloadPathKey, this.myPath);
        if (!this.myRootNode.getImmediateChildren().isEmpty()) {
            this.myComponentsTable.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    @Override
    @NotNull
    public JLabel getMessageLabel() {
        return this.myErrorMessage;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myComponentsTable;
    }

    @Override
    public boolean isStepVisible() {
        if (this.myWasForcedVisible) {
            return true;
        }
        if (this.myMode.hasValidSdkLocation()) {
            return false;
        }
        if (this.myState.getNotNull(this.myKeyCustomInstall, true).booleanValue()) {
            return true;
        }
        this.validate();
        this.myWasForcedVisible = this.mySdkDirectoryValidationResult.getSeverity() != Validator.Severity.OK;
        return this.myWasForcedVisible;
    }

    @Override
    public boolean commitStep() {
        if (this.myRootNode.getAllChildren().stream().anyMatch(node -> node instanceof InstallableComponent && !((InstallableComponent)node).getUnavailablePackages().isEmpty())) {
            Messages.showWarningDialog((String)"Some required components are not available.\nYou can continue, but some functionality may not work correctly until they are installed.", (String)"Required Component Missing");
        }
        return true;
    }

    private void createUIComponents() {
        Splitter splitter = new Splitter(false, 0.5f, 0.2f, 0.8f);
        this.myBody = splitter;
        this.myComponentsTable = new JBTable();
        this.myComponentDescription = new JTextPane();
        splitter.setShowDividerIcon(false);
        splitter.setShowDividerControls(false);
        this.myContentPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this);
        this.myContentPanel.add((Component)this.myComponentsTable, (Object)"Center");
        splitter.setFirstComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)this.myContentPanel, (boolean)false));
        splitter.setSecondComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)this.myComponentDescription, (boolean)false));
        this.myComponentDescription.setFont(StartupUiUtil.getLabelFont());
        this.myComponentDescription.setEditable(false);
        this.myComponentDescription.setBorder(BorderFactory.createEmptyBorder(WizardConstants.STUDIO_WIZARD_INSET_SIZE, WizardConstants.STUDIO_WIZARD_INSET_SIZE, WizardConstants.STUDIO_WIZARD_INSET_SIZE, WizardConstants.STUDIO_WIZARD_INSET_SIZE));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JLabel jLabel2;
        JLabel jLabel3;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        this.createUIComponents();
        this.myContents = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Check the components you want to update/install. Click Next to continue.");
        jPanel.add((Component)jLabel4, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 16), null));
        JPanel jPanel2 = this.myBody;
        jPanel.add((Component)jPanel2, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("Android SDK Location:");
        jPanel.add((Component)jLabel5, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPath = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(4, 0, 1, 1, 0, 1, 6, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(3, 1, 2, 1, 0, 3, 0, 3, null, null, null));
        this.myNeededSpace = jLabel3 = new JLabel();
        jLabel3.setText("Total download size: 5.1Gb");
        jPanel3.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myAvailableSpace = jLabel2 = new JLabel();
        jLabel2.setText("Available disk space: 23.0Gb");
        jPanel3.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myErrorMessage = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel.add((Component)jLabel, new GridConstraints(5, 0, 1, 2, 8, 0, 1, 0, null, null, null));
        jLabel5.setLabelFor((Component)textFieldWithBrowseButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContents;
    }

    private final class SdkComponentRenderer
    extends AbstractCellEditor
    implements TableCellRenderer,
    TableCellEditor {
        private final RendererPanel myPanel = new RendererPanel();
        private final RendererCheckBox myCheckBox = new RendererCheckBox();
        private Border myEmptyBorder;

        SdkComponentRenderer() {
            this.myCheckBox.setOpaque(false);
            this.myCheckBox.addActionListener(e -> {
                if (SdkComponentsStep.this.myComponentsTable.isEditing()) {
                    this.stopCellEditing();
                } else {
                    SdkComponentsStep.this.myTableModel.setValueAt(this.myCheckBox.isSelected(), this.myCheckBox.getRow(), 0);
                }
                SdkComponentsStep.this.invokeUpdate(null);
            });
        }

        @Override
        public Component getTableCellRendererComponent(JTable table2, Object value2, boolean isSelected, boolean hasFocus, int row2, int column2) {
            this.setupControl(table2, value2, row2, isSelected, hasFocus);
            return this.myPanel;
        }

        private void setupControl(JTable table2, Object value2, int row2, boolean isSelected, boolean hasFocus) {
            Color foreground;
            Color background;
            this.myCheckBox.setRow(row2);
            this.myPanel.setBorder(this.getCellBorder(table2, isSelected && hasFocus));
            if (isSelected) {
                background = table2.getSelectionBackground();
                foreground = table2.getSelectionForeground();
            } else {
                background = table2.getBackground();
                foreground = table2.getForeground();
            }
            this.myPanel.setBackground(background);
            this.myCheckBox.setForeground(foreground);
            this.myPanel.remove(this.myCheckBox);
            Pair pair = (Pair)value2;
            int indent = 0;
            if (pair != null) {
                ComponentTreeNode node = (ComponentTreeNode)pair.getFirst();
                this.myCheckBox.setEnabled(node.isEnabled());
                this.myCheckBox.setText(node.getLabel());
                this.myCheckBox.setSelected(node.isChecked());
                indent = (Integer)pair.getSecond();
            }
            this.myPanel.add((Component)this.myCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, indent * 2));
        }

        private Border getCellBorder(JTable table2, boolean isSelectedFocus) {
            Border border;
            Border focusedBorder = UIUtil.getTableFocusCellHighlightBorder();
            if (isSelectedFocus) {
                border = focusedBorder;
            } else {
                if (this.myEmptyBorder == null) {
                    this.myEmptyBorder = new EmptyBorder(focusedBorder.getBorderInsets(table2));
                }
                border = this.myEmptyBorder;
            }
            return border;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table2, Object value2, boolean isSelected, int row2, int column2) {
            this.setupControl(table2, value2, row2, true, true);
            return this.myPanel;
        }

        @Override
        public Object getCellEditorValue() {
            return this.myCheckBox.isSelected();
        }

        protected class RendererPanel
        extends JPanel {
            public RendererPanel() {
                super((LayoutManager)new GridLayoutManager(1, 1));
            }

            @Override
            protected void processKeyEvent(KeyEvent e) {
                if (SdkComponentsStep.this.myComponentsTable.isEditing()) {
                    SdkComponentRenderer.this.myCheckBox._processKeyEvent(e);
                } else {
                    super.processKeyEvent(e);
                }
            }

            @Override
            protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
                if (SdkComponentsStep.this.myComponentsTable.isEditing()) {
                    return SdkComponentRenderer.this.myCheckBox._processKeyBinding(ks, e, condition, pressed);
                }
                return super.processKeyBinding(ks, e, condition, pressed);
            }

            @Override
            public AccessibleContext getAccessibleContext() {
                if (this.accessibleContext == null) {
                    this.accessibleContext = new AccessibleRendererPanel();
                }
                return this.accessibleContext;
            }

            protected class AccessibleRendererPanel
            extends AccessibleContextDelegate {
                public AccessibleRendererPanel() {
                    super(SdkComponentRenderer.this.myCheckBox.getAccessibleContext());
                }

                protected Container getDelegateParent() {
                    return RendererPanel.this.getParent();
                }

                public String getAccessibleDescription() {
                    return SdkComponentsStep.this.myTableModel.getComponentDescription(SdkComponentRenderer.this.myCheckBox.getRow());
                }
            }
        }

        protected class RendererCheckBox
        extends JCheckBox {
            private int myRow;

            protected RendererCheckBox() {
            }

            public int getRow() {
                return this.myRow;
            }

            public void setRow(int row2) {
                this.myRow = row2;
            }

            public boolean _processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
                return super.processKeyBinding(ks, e, condition, pressed);
            }

            public void _processKeyEvent(KeyEvent e) {
                super.processKeyEvent(e);
            }

            @Override
            public void requestFocus() {
                if (SdkComponentsStep.this.myComponentsTable.isEditing()) {
                    return;
                }
                super.requestFocus();
            }
        }
    }
}

