/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.wizard;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterClient;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConsoleHighlighter
implements EditorHighlighter,
DocumentListener {
    private List<HighlightRange> myRanges = Lists.newArrayListWithCapacity((int)1024);
    private boolean myIsUpdatePending = false;
    private StringBuilder myPendingStrings = new StringBuilder(4096);
    private String myLastString = null;
    private HighlighterClient myEditor;
    private ModalityState myModalityState = ModalityState.defaultModalityState();

    public synchronized void print(String string, @Nullable TextAttributes attributes) {
        if (Objects.equals(this.myLastString, string)) {
            return;
        }
        this.myLastString = string;
        Application application = ApplicationManager.getApplication();
        this.myPendingStrings.append(string);
        if (!this.myIsUpdatePending && application != null && !application.isUnitTestMode()) {
            this.myIsUpdatePending = true;
            application.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ConsoleHighlighter.this.appendToDocument();
                }
            }, this.myModalityState);
        }
        HighlightRange lastRange = (HighlightRange)Iterables.getLast(this.myRanges, (Object)HighlightRange.EMPTY);
        assert (lastRange != null);
        int start2 = lastRange.end;
        this.myRanges.add(new HighlightRange(start2, start2 + string.length(), attributes));
    }

    public void setModalityState(ModalityState state2) {
        this.myModalityState = state2;
    }

    private synchronized String getPendingString() {
        String string = this.myPendingStrings.toString();
        this.myPendingStrings.delete(0, string.length());
        this.myIsUpdatePending = false;
        return string;
    }

    private void appendToDocument() {
        Document document2 = this.myEditor.getDocument();
        if (document2 != null) {
            String pendingString = StringUtil.convertLineSeparators((String)this.getPendingString());
            document2.insertString(document2.getTextLength(), (CharSequence)pendingString);
            if (this.myEditor instanceof Editor) {
                Editor editor = (Editor)this.myEditor;
                int lineCount = document2.getLineCount();
                editor.getScrollingModel().scrollTo(new LogicalPosition(lineCount - 1, 0), ScrollType.MAKE_VISIBLE);
            }
        }
    }

    @NotNull
    public HighlighterIterator createIterator(int startOffset) {
        return new HighlightedRangesIterator(this.getOffsetRangeIndex(startOffset));
    }

    public void setText(@NotNull CharSequence text2) {
    }

    public void setEditor(@NotNull HighlighterClient editor) {
        this.myEditor = editor;
    }

    public void setColorScheme(@NotNull EditorColorsScheme scheme) {
    }

    private synchronized HighlightRange getRange(int index2) {
        if (index2 < 0 || index2 >= this.myRanges.size()) {
            return HighlightRange.EMPTY;
        }
        return this.myRanges.get(index2);
    }

    @VisibleForTesting
    synchronized int getOffsetRangeIndex(int startOffset) {
        if (this.myRanges.isEmpty() || startOffset < 0 || startOffset >= ((HighlightRange)Iterables.getLast(this.myRanges)).end) {
            return -1;
        }
        int end = this.myRanges.size();
        int i = end / 2;
        while (true) {
            HighlightRange range = this.myRanges.get(i);
            if (range.end > startOffset) {
                if (range.start <= startOffset) {
                    return i;
                }
                end = i;
                i /= 2;
                continue;
            }
            i = (i + end) / 2;
        }
    }

    public void clear() {
        this.clearHighlightedState();
        this.myEditor.getDocument().setText((CharSequence)"");
    }

    private synchronized void clearHighlightedState() {
        this.myRanges.clear();
        this.myPendingStrings.delete(0, this.myPendingStrings.length() - 1);
        this.myIsUpdatePending = false;
    }

    public void attachToProcess(ProcessHandler processHandler2) {
        processHandler2.addProcessListener((ProcessListener)new ProcessOutputProcessor());
    }

    private static final class HighlightRange {
        public static final HighlightRange EMPTY = new HighlightRange(0, 0, null);
        @Nullable
        public final TextAttributes attributes;
        public final int start;
        public final int end;

        public HighlightRange(int start2, int end, @Nullable TextAttributes attributes) {
            this.attributes = attributes;
            this.start = start2;
            this.end = end;
        }
    }

    private class HighlightedRangesIterator
    implements HighlighterIterator {
        private int myIndex;
        @NotNull
        private HighlightRange myRange = HighlightRange.EMPTY;

        public HighlightedRangesIterator(int index2) {
            this.myIndex = index2;
            this.myRange = ConsoleHighlighter.this.getRange(index2);
        }

        @Nullable
        public TextAttributes getTextAttributes() {
            return this.myRange.attributes;
        }

        public int getStart() {
            return this.myRange.start;
        }

        public int getEnd() {
            return this.myRange.end;
        }

        @Nullable
        public IElementType getTokenType() {
            return null;
        }

        public void advance() {
            this.myRange = ConsoleHighlighter.this.getRange(++this.myIndex);
        }

        public void retreat() {
            this.myRange = ConsoleHighlighter.this.getRange(--this.myIndex);
        }

        public boolean atEnd() {
            return this.myRange == HighlightRange.EMPTY;
        }

        public Document getDocument() {
            return ConsoleHighlighter.this.myEditor.getDocument();
        }
    }

    private class ProcessOutputProcessor
    extends ProcessAdapter {
        private AtomicBoolean mySkipped = new AtomicBoolean(false);

        private ProcessOutputProcessor() {
        }

        public void onTextAvailable(@NotNull ProcessEvent event2, @NotNull Key outputType) {
            if (!this.mySkipped.compareAndSet(false, true)) {
                ConsoleHighlighter.this.print(event2.getText(), ConsoleViewContentType.getConsoleViewType((Key)outputType).getAttributes());
            }
        }
    }
}

