/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.wizard;

import com.android.annotations.concurrency.WorkerThread;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.ui.GuiTestingService;
import com.android.tools.idea.welcome.config.AndroidFirstRunPersistentData;
import com.android.tools.idea.welcome.config.FirstRunWizardMode;
import com.android.tools.idea.welcome.config.GlobalInstallerData;
import com.android.tools.idea.welcome.config.InstallerData;
import com.android.tools.idea.welcome.wizard.AndroidStudioWelcomeScreenProvider;
import com.android.tools.idea.welcome.wizard.AndroidStudioWelcomeScreenProviderKt;
import com.android.tools.idea.welcome.wizard.StudioFirstRunWelcomeScreen;
import com.android.tools.idea.welcome.wizard.deprecated.FirstRunWizardHost;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.wm.WelcomeScreen;
import com.intellij.openapi.wm.WelcomeScreenProvider;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.proxy.CommonProxy;
import java.io.IOException;
import java.net.HttpURLConnection;
import javax.swing.Icon;
import javax.swing.JRootPane;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/welcome/wizard/AndroidStudioWelcomeScreenProvider;", "Lcom/intellij/openapi/wm/WelcomeScreenProvider;", "()V", "createWelcomeScreen", "Lcom/intellij/openapi/wm/WelcomeScreen;", "rootPane", "Ljavax/swing/JRootPane;", "isAvailable", "", "Companion", "intellij.android.core"})
public final class AndroidStudioWelcomeScreenProvider
implements WelcomeScreenProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String SYSTEM_PROPERTY_DISABLE_WIZARD = "disable.android.first.run";
    private static boolean ourWasShown;

    @NotNull
    public WelcomeScreen createWelcomeScreen(@NotNull JRootPane rootPane) {
        Intrinsics.checkNotNullParameter((Object)rootPane, (String)"rootPane");
        ApplicationManager.getApplication().executeOnPooledThread((Runnable)createWelcomeScreen.1.INSTANCE);
        FirstRunWizardMode firstRunWizardMode = Companion.getWizardMode();
        Intrinsics.checkNotNull((Object)((Object)firstRunWizardMode));
        FirstRunWizardMode wizardMode = firstRunWizardMode;
        ourWasShown = true;
        Object t = StudioFlags.NPW_FIRST_RUN_WIZARD.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"NPW_FIRST_RUN_WIZARD.get()");
        return (Boolean)t != false ? (WelcomeScreen)new StudioFirstRunWelcomeScreen(wizardMode) : (WelcomeScreen)new FirstRunWizardHost(wizardMode);
    }

    public boolean isAvailable() {
        boolean isWizardDisabled = GuiTestingService.getInstance().isGuiTestingMode() || Boolean.getBoolean(SYSTEM_PROPERTY_DISABLE_WIZARD);
        return !ourWasShown && !isWizardDisabled && Companion.getWizardMode() != null;
    }

    @JvmStatic
    @Nullable
    public static final FirstRunWizardMode getWizardMode() {
        return Companion.getWizardMode();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0003J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u0006H\u0002J\b\u0010\u0011\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b8G\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/welcome/wizard/AndroidStudioWelcomeScreenProvider$Companion;", "", "()V", "SYSTEM_PROPERTY_DISABLE_WIZARD", "", "ourWasShown", "", "wizardMode", "Lcom/android/tools/idea/welcome/config/FirstRunWizardMode;", "getWizardMode", "()Lcom/android/tools/idea/welcome/config/FirstRunWizardMode;", "checkInternetConnection", "", "isHandoff", "persistentData", "Lcom/android/tools/idea/welcome/config/AndroidFirstRunPersistentData;", "promptToRetryFailedConnection", "promptUserForProxy", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final FirstRunWizardMode getWizardMode() {
            block3: {
                block2: {
                    Object t = StudioFlags.NPW_FIRST_RUN_WIZARD.get();
                    Intrinsics.checkNotNullExpressionValue(t, (String)"NPW_FIRST_RUN_WIZARD.get()");
                    if (((Boolean)t).booleanValue()) break block2;
                    Object t2 = StudioFlags.NPW_FIRST_RUN_SHOW.get();
                    Intrinsics.checkNotNullExpressionValue(t2, (String)"NPW_FIRST_RUN_SHOW.get()");
                    if (!((Boolean)t2).booleanValue()) break block3;
                }
                return FirstRunWizardMode.NEW_INSTALL;
            }
            AndroidFirstRunPersistentData persistentData = AndroidFirstRunPersistentData.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)persistentData, (String)"persistentData");
            return this.isHandoff(persistentData) ? FirstRunWizardMode.INSTALL_HANDOFF : (!persistentData.isSdkUpToDate() ? FirstRunWizardMode.NEW_INSTALL : (IdeSdks.getInstance().getEligibleAndroidSdks().isEmpty() ? FirstRunWizardMode.MISSING_SDK : null));
        }

        private final boolean isHandoff(AndroidFirstRunPersistentData persistentData) {
            InstallerData installerData = GlobalInstallerData.get();
            if (installerData == null) {
                return false;
            }
            InstallerData data = installerData;
            return (!persistentData.isSdkUpToDate() || !persistentData.isSameTimestamp(data.getTimestamp())) && data.isCurrentVersion();
        }

        @WorkerThread
        private final void checkInternetConnection() {
            boolean retryConnection;
            ApplicationManager.getApplication().assertIsNonDispatchThread();
            CommonProxy.isInstalledAssertion();
            do {
                retryConnection = false;
                try {
                    HttpURLConnection connection2;
                    Intrinsics.checkNotNullExpressionValue((Object)HttpConfigurable.getInstance().openHttpConnection("http://developer.android.com"), (String)"getInstance().openHttpCo\u2026//developer.android.com\")");
                    connection2.connect();
                    connection2.disconnect();
                    retryConnection = false;
                }
                catch (IOException e) {
                    retryConnection = this.promptToRetryFailedConnection();
                }
                catch (RuntimeException e) {
                    retryConnection = this.promptToRetryFailedConnection();
                }
                catch (Throwable e) {
                    retryConnection = false;
                    Object message2 = "Couldn't check internet connection";
                    if (StringsKt.contains$default((CharSequence)e.toString(), (CharSequence)"crypto", (boolean)false, (int)2, null)) {
                        message2 = (String)message2 + "; check your JDK/JRE installation / consider running on a newer version.";
                    }
                    AndroidStudioWelcomeScreenProviderKt.getLog().warn((String)message2, e);
                }
            } while (retryConnection);
        }

        private final boolean promptToRetryFailedConnection() {
            return (Boolean)ActionsKt.invokeAndWaitIfNeeded$default(null, (Function0)promptToRetryFailedConnection.1.INSTANCE, (int)1, null);
        }

        private final boolean promptUserForProxy() {
            boolean showSetupProxy;
            String[] stringArray = new String[]{"Setup Proxy", "Cancel"};
            int selection = Messages.showIdeaMessageDialog(null, (String)"Unable to access Android SDK add-on list", (String)"Android Studio First Run", (String[])stringArray, (int)1, (Icon)Messages.getErrorIcon(), null);
            boolean bl = showSetupProxy = selection == 0;
            if (showSetupProxy) {
                HttpConfigurable.editConfigurable(null);
            }
            return showSetupProxy;
        }

        public static final /* synthetic */ void access$checkInternetConnection(Companion $this) {
            $this.checkInternetConnection();
        }

        public static final /* synthetic */ boolean access$promptUserForProxy(Companion $this) {
            return $this.promptUserForProxy();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

