/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.repository.Revision;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.repository.impl.meta.TypeDetails;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.AndroidVersionUtils;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.welcome.install.ComponentCategory;
import com.android.tools.idea.welcome.install.ComponentTreeNode;
import com.android.tools.idea.welcome.install.InstallContext;
import com.android.tools.idea.welcome.install.InstallableComponent;
import com.android.tools.idea.welcome.wizard.deprecated.InstallComponentsPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0002J\b\u0010\u0018\u001a\u00020\bH\u0016J\b\u0010\u0019\u001a\u00020\bH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/idea/welcome/install/Platform;", "Lcom/android/tools/idea/welcome/install/InstallableComponent;", "name", "", "description", "myVersion", "Lcom/android/sdklib/AndroidVersion;", "myIsDefaultPlatform", "", "installUpdates", "(Ljava/lang/String;Ljava/lang/String;Lcom/android/sdklib/AndroidVersion;ZZ)V", "optionalSdkPackages", "", "getOptionalSdkPackages", "()Ljava/util/Collection;", "requiredSdkPackages", "getRequiredSdkPackages", "configure", "", "installContext", "Lcom/android/tools/idea/welcome/install/InstallContext;", "sdkHandler", "Lcom/android/sdklib/repository/AndroidSdkHandler;", "findLatestCompatibleBuildTool", "isOptionalForSdkLocation", "isSelectedByDefault", "Companion", "intellij.android.core"})
public final class Platform
extends InstallableComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AndroidVersion myVersion;
    private final boolean myIsDefaultPlatform;

    public Platform(@NotNull String name2, @NotNull String description2, @NotNull AndroidVersion myVersion, boolean myIsDefaultPlatform, boolean installUpdates) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)description2, (String)"description");
        Intrinsics.checkNotNullParameter((Object)myVersion, (String)"myVersion");
        super(name2, description2, installUpdates);
        this.myVersion = myVersion;
        this.myIsDefaultPlatform = myIsDefaultPlatform;
    }

    @Override
    @NotNull
    protected Collection<String> getRequiredSdkPackages() {
        List requests2;
        block0: {
            Object[] objectArray = new String[]{DetailsTypes.getPlatformPath((AndroidVersion)this.myVersion)};
            requests2 = CollectionsKt.mutableListOf((Object[])objectArray);
            String string = this.findLatestCompatibleBuildTool();
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            requests2.add(it);
        }
        return requests2;
    }

    @Override
    @NotNull
    protected Collection<String> getOptionalSdkPackages() {
        return CollectionsKt.listOf((Object)DetailsTypes.getSourcesPath((AndroidVersion)this.myVersion));
    }

    private final String findLatestCompatibleBuildTool() {
        Revision revision = null;
        String path2 = null;
        for (RemotePackage remote : this.getRepositoryPackages().getRemotePackages().values()) {
            Revision testRevision;
            String string = remote.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"remote.path");
            if (!StringsKt.startsWith$default((String)string, (String)"build-tools", (boolean)false, (int)2, null) || (testRevision = remote.getVersion()).getMajor() != this.myVersion.getApiLevel() || revision != null && testRevision.compareTo(revision) <= 0) continue;
            revision = testRevision;
            path2 = remote.getPath();
        }
        return path2;
    }

    @Override
    public void configure(@NotNull InstallContext installContext, @NotNull AndroidSdkHandler sdkHandler) {
        Intrinsics.checkNotNullParameter((Object)installContext, (String)"installContext");
        Intrinsics.checkNotNullParameter((Object)sdkHandler, (String)"sdkHandler");
    }

    @Override
    public boolean isOptionalForSdkLocation() {
        List locals = Platform.Companion.getInstalledPlatformVersions(this.sdkHandler);
        if (locals.isEmpty()) {
            return !this.myIsDefaultPlatform;
        }
        for (AndroidVersion androidVersion : locals) {
            int apiLevel = androidVersion.getApiLevel();
            if (this.myVersion.getFeatureLevel() != apiLevel) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSelectedByDefault() {
        return false;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0016\u0010\u0005\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J*\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0016\u0010\u0005\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/welcome/install/Platform$Companion;", "", "()V", "createSubtree", "Lcom/android/tools/idea/welcome/install/ComponentTreeNode;", "remotePackages", "", "", "Lcom/android/repository/api/RemotePackage;", "installUpdates", "", "getInstalledPlatformVersions", "", "Lcom/android/sdklib/AndroidVersion;", "handler", "Lcom/android/sdklib/repository/AndroidSdkHandler;", "getLatestPlatform", "Lcom/android/tools/idea/welcome/install/Platform;", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        private final Platform getLatestPlatform(Map<String, ? extends RemotePackage> remotePackages, boolean installUpdates) {
            RemotePackage latest = InstallComponentsPath.findLatestPlatform(remotePackages, true);
            if (latest != null) {
                TypeDetails typeDetails = latest.getTypeDetails();
                Intrinsics.checkNotNull((Object)typeDetails, (String)"null cannot be cast to non-null type com.android.sdklib.repository.meta.DetailsTypes.PlatformDetailsType");
                AndroidVersion version2 = ((DetailsTypes.PlatformDetailsType)typeDetails).getAndroidVersion();
                Intrinsics.checkNotNullExpressionValue((Object)version2, (String)"version");
                String versionName2 = AndroidVersionUtils.getFullReleaseName((AndroidVersion)version2, (boolean)true, (boolean)true);
                String description2 = "Android platform libraries for targeting platform: " + versionName2;
                return new Platform(versionName2, description2, version2, !version2.isPreview(), installUpdates);
            }
            return null;
        }

        private final List<AndroidVersion> getInstalledPlatformVersions(AndroidSdkHandler handler2) {
            List result2 = new ArrayList();
            if (handler2 != null) {
                RepositoryPackages packages = handler2.getSdkManager((ProgressIndicator)new StudioLoggerProgressIndicator(Platform.class)).getPackages();
                for (LocalPackage p : packages.getLocalPackages().values()) {
                    if (!(p.getTypeDetails() instanceof DetailsTypes.PlatformDetailsType)) continue;
                    TypeDetails typeDetails = p.getTypeDetails();
                    Intrinsics.checkNotNull((Object)typeDetails, (String)"null cannot be cast to non-null type com.android.sdklib.repository.meta.DetailsTypes.PlatformDetailsType");
                    AndroidVersion androidVersion = ((DetailsTypes.PlatformDetailsType)typeDetails).getAndroidVersion();
                    Intrinsics.checkNotNullExpressionValue((Object)androidVersion, (String)"p.typeDetails as Details\u2026tailsType).androidVersion");
                    result2.add(androidVersion);
                }
            }
            return result2;
        }

        @Nullable
        public final ComponentTreeNode createSubtree(@Nullable Map<String, ? extends RemotePackage> remotePackages, boolean installUpdates) {
            Platform platform = this.getLatestPlatform(remotePackages, installUpdates);
            if (platform == null) {
                return null;
            }
            Platform latestPlatform = platform;
            return new ComponentCategory("Android SDK Platform", "SDK components for creating applications for different Android platforms", CollectionsKt.listOf((Object)latestPlatform));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

