/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.tools.idea.sdk.StudioDownloader;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.util.FormatUtil;
import com.android.tools.idea.welcome.install.ComponentInstaller;
import com.android.tools.idea.welcome.install.InstallContext;
import com.android.tools.idea.welcome.install.InstallOperation;
import com.android.tools.idea.welcome.install.InstallableComponent;
import com.android.tools.idea.welcome.install.SdkManagerProgressIndicatorIntegration;
import com.android.tools.idea.welcome.install.WizardException;
import com.intellij.execution.ui.ConsoleViewContentType;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00142\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u0018\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/welcome/install/InstallComponentsOperation;", "Lcom/android/tools/idea/welcome/install/InstallOperation;", "Ljava/io/File;", "context", "Lcom/android/tools/idea/welcome/install/InstallContext;", "components", "", "Lcom/android/tools/idea/welcome/install/InstallableComponent;", "componentInstaller", "Lcom/android/tools/idea/welcome/install/ComponentInstaller;", "progressRatio", "", "(Lcom/android/tools/idea/welcome/install/InstallContext;Ljava/util/Collection;Lcom/android/tools/idea/welcome/install/ComponentInstaller;D)V", "cleanup", "", "result", "perform", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "argument", "Companion", "intellij.android.core"})
public final class InstallComponentsOperation
extends InstallOperation<File, File> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Collection<InstallableComponent> components;
    @NotNull
    private final ComponentInstaller componentInstaller;

    public InstallComponentsOperation(@NotNull InstallContext context2, @NotNull Collection<? extends InstallableComponent> components, @NotNull ComponentInstaller componentInstaller, double progressRatio) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter(components, (String)"components");
        Intrinsics.checkNotNullParameter((Object)componentInstaller, (String)"componentInstaller");
        super(context2, progressRatio);
        this.components = components;
        this.componentInstaller = componentInstaller;
    }

    @Override
    @NotNull
    protected File perform(@NotNull com.intellij.openapi.progress.ProgressIndicator indicator, @NotNull File argument) throws WizardException {
        List<RemotePackage> list2;
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        indicator.setText("Checking for updated SDK components");
        try {
            list2 = this.componentInstaller.getPackagesToInstall((Iterable<? extends InstallableComponent>)this.components);
        }
        catch (SdkQuickfixUtils.PackageResolutionException e) {
            throw new WizardException("Failed to determine required packages", e);
        }
        List<RemotePackage> packages = list2;
        while (!((Collection)packages).isEmpty()) {
            String message2;
            List<RemotePackage> list3;
            indicator.setFraction(0.0);
            SdkManagerProgressIndicatorIntegration logger2 = new SdkManagerProgressIndicatorIntegration(indicator, this.getContext());
            this.componentInstaller.installPackages(packages, new StudioDownloader(), (ProgressIndicator)logger2);
            try {
                list3 = this.componentInstaller.getPackagesToInstall((Iterable<? extends InstallableComponent>)this.components);
            }
            catch (SdkQuickfixUtils.PackageResolutionException e) {
                throw new WizardException("Failed to determine required packages", e);
            }
            packages = list3;
            if (InstallComponentsOperation.Companion.getRetryMessage(packages) == null) continue;
            boolean bl = false;
            String string = logger2.getErrors();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"logger.errors");
            this.promptToRetry(message2, string, null);
        }
        this.getContext().print("Android SDK is up to date.\n", ConsoleViewContentType.SYSTEM_OUTPUT);
        indicator.setFraction(1.0);
        return argument;
    }

    @Override
    public void cleanup(@NotNull File result2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/welcome/install/InstallComponentsOperation$Companion;", "", "()V", "getRetryMessage", "", "packages", "", "Lcom/android/repository/api/RemotePackage;", "intellij.android.core"})
    @SourceDebugExtension(value={"SMAP\nInstallComponentsOperation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InstallComponentsOperation.kt\ncom/android/tools/idea/welcome/install/InstallComponentsOperation$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n1549#2:83\n1620#2,3:84\n*S KotlinDebug\n*F\n+ 1 InstallComponentsOperation.kt\ncom/android/tools/idea/welcome/install/InstallComponentsOperation$Companion\n*L\n75#1:83\n75#1:84,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final String getRetryMessage(Collection<? extends RemotePackage> packages) {
            void $this$mapTo$iv$iv;
            if (packages.isEmpty()) {
                return null;
            }
            Iterable $this$map$iv = packages;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                RemotePackage remotePackage = (RemotePackage)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(it.getDisplayName());
            }
            return FormatUtil.formatElementListString((List)destination$iv$iv, "The following SDK component was not installed: %s", "The following SDK components were not installed: %1$s and %2$s", "%1$s and %2$s more SDK components were not installed");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

