/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.impl.meta.TypeDetails;
import com.android.resources.Density;
import com.android.resources.ScreenOrientation;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.devices.Abi;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Storage;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.EmulatedProperties;
import com.android.sdklib.internal.avd.GpuMode;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.IdDisplay;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.sdklib.repository.targets.SystemImageManager;
import com.android.tools.analytics.CommonMetricsData;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.avdmanager.AvdOptionsModel;
import com.android.tools.idea.avdmanager.AvdWizardUtils;
import com.android.tools.idea.avdmanager.DeviceManagerConnection;
import com.android.tools.idea.avdmanager.DeviceSkinUpdaterService;
import com.android.tools.idea.avdmanager.SystemImageDescription;
import com.android.tools.idea.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.welcome.install.InstallContext;
import com.android.tools.idea.welcome.install.InstallableComponent;
import com.android.tools.idea.welcome.install.WizardException;
import com.android.tools.idea.welcome.wizard.deprecated.InstallComponentsPath;
import com.android.tools.idea.welcome.wizard.deprecated.ProgressStep;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import com.google.wireless.android.sdk.stats.ProductDetails;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.system.CpuArch;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 '2\u00020\u0001:\u0001'B#\u0012\u0014\u0010\u0002\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\u0010\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u0007H\u0007J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010$\u001a\u00020\u00172\u0006\u0010%\u001a\u00020\u000fH\u0016J\b\u0010&\u001a\u00020\u0007H\u0016R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u00118TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u00118TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013\u00a8\u0006("}, d2={"Lcom/android/tools/idea/welcome/install/AndroidVirtualDevice;", "Lcom/android/tools/idea/welcome/install/InstallableComponent;", "remotePackages", "", "", "Lcom/android/repository/api/RemotePackage;", "installUpdates", "", "(Ljava/util/Map;Z)V", "IS_ARM64_HOST_OS", "MAX_X86_API_LEVEL", "", "myLatestVersion", "Lcom/android/sdklib/AndroidVersion;", "myProgressStep", "Lcom/android/tools/idea/welcome/wizard/deprecated/ProgressStep;", "optionalSdkPackages", "", "getOptionalSdkPackages", "()Ljava/util/Collection;", "requiredSdkPackages", "getRequiredSdkPackages", "configure", "", "installContext", "Lcom/android/tools/idea/welcome/install/InstallContext;", "sdkHandler", "Lcom/android/sdklib/repository/AndroidSdkHandler;", "createAvd", "Lcom/android/sdklib/internal/avd/AvdInfo;", "connection", "Lcom/android/tools/idea/avdmanager/AvdManagerConnection;", "getRequiredSysimgPath", "isArm64HostOs", "getSystemImageDescription", "Lcom/android/tools/idea/avdmanager/SystemImageDescription;", "init", "progressStep", "isSelectedByDefault", "Companion", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nAndroidVirtualDevice.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidVirtualDevice.kt\ncom/android/tools/idea/welcome/install/AndroidVirtualDevice\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,242:1\n1#2:243\n*E\n"})
public final class AndroidVirtualDevice
extends InstallableComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean IS_ARM64_HOST_OS;
    private ProgressStep myProgressStep;
    @Nullable
    private AndroidVersion myLatestVersion;
    private final int MAX_X86_API_LEVEL;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String DEFAULT_DEVICE_ID = "pixel_3a";
    private static final IdDisplay ID_ADDON_GOOGLE_API_IMG;
    private static final IdDisplay ID_VENDOR_GOOGLE;
    @NotNull
    private static final Storage DEFAULT_RAM_SIZE;
    @NotNull
    private static final Storage DEFAULT_HEAP_SIZE;
    @NotNull
    private static final Set<String> ENABLED_HARDWARE;
    @NotNull
    private static final Set<String> DISABLED_HARDWARE;

    public AndroidVirtualDevice(@NotNull Map<String, ? extends RemotePackage> remotePackages, boolean installUpdates) {
        AndroidVersion androidVersion;
        RemotePackage latestInfo;
        Intrinsics.checkNotNullParameter(remotePackages, (String)"remotePackages");
        super("Android Virtual Device", "A preconfigured and optimized Android Virtual Device for app testing on the emulator. (Recommended)", installUpdates);
        this.IS_ARM64_HOST_OS = CpuArch.isArm64() || CommonMetricsData.getOsArchitecture() == ProductDetails.CpuArchitecture.X86_ON_ARM;
        this.MAX_X86_API_LEVEL = 30;
        RemotePackage remotePackage = latestInfo = InstallComponentsPath.findLatestPlatform(remotePackages, true);
        if (remotePackage != null) {
            TypeDetails typeDetails = remotePackage.getTypeDetails();
            Intrinsics.checkNotNull((Object)typeDetails, (String)"null cannot be cast to non-null type com.android.sdklib.repository.meta.DetailsTypes.PlatformDetailsType");
            androidVersion = ((DetailsTypes.PlatformDetailsType)typeDetails).getAndroidVersion();
        } else {
            androidVersion = null;
        }
        this.myLatestVersion = androidVersion;
    }

    private final SystemImageDescription getSystemImageDescription(AndroidSdkHandler sdkHandler) throws WizardException {
        StudioLoggerProgressIndicator progress2 = new StudioLoggerProgressIndicator(this.getClass());
        if (this.myLatestVersion == null) {
            throw new WizardException("Missing system image required for an AVD setup");
        }
        SystemImageManager systemImageManager = sdkHandler.getSystemImageManager((ProgressIndicator)progress2);
        AndroidVersion androidVersion = this.myLatestVersion;
        Intrinsics.checkNotNull((Object)androidVersion);
        Collection systemImages = systemImageManager.lookup(ID_ADDON_GOOGLE_API_IMG, androidVersion, ID_VENDOR_GOOGLE);
        if (systemImages.isEmpty()) {
            throw new WizardException("Missing system image required for an AVD setup");
        }
        return new SystemImageDescription((ISystemImage)systemImages.iterator().next());
    }

    /*
     * Unable to fully structure code
     */
    @VisibleForTesting
    @Nullable
    public final AvdInfo createAvd(@NotNull AvdManagerConnection connection, @NotNull AndroidSdkHandler sdkHandler) throws WizardException {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)sdkHandler, (String)"sdkHandler");
        v0 = sdkHandler.getLocation();
        Intrinsics.checkNotNull((Object)v0);
        d = com.android.tools.idea.welcome.install.AndroidVirtualDevice$Companion.access$getDevice(AndroidVirtualDevice.Companion, v0);
        systemImageDescription = this.getSystemImageDescription(sdkHandler);
        cardSize = EmulatedProperties.DEFAULT_INTERNAL_STORAGE.toIniString();
        var7_6 = d.getDefaultHardware().getSkinFile();
        if (var7_6 == null) ** GOTO lbl-1000
        it = var7_6;
        $i$a$-let-AndroidVirtualDevice$createAvd$hardwareSkinPath$1 = false;
        var8_10 = sdkHandler.toCompatiblePath(it);
        if (var8_10 != null) {
            defaultHardwareSkin = var8_10;
            $i$a$-let-AndroidVirtualDevice$createAvd$hardwareSkinPath$2 = false;
            v1 = (Path)DeviceSkinUpdaterService.getInstance().updateSkins(defaultHardwareSkin, systemImageDescription).get();
        } else lbl-1000:
        // 2 sources

        {
            v1 = null;
        }
        hardwareSkinPath = v1;
        displayName = connection.uniquifyDisplayName(d.getDisplayName() + " " + systemImageDescription.getVersion() + " " + systemImageDescription.getAbiType());
        internalName = AvdWizardUtils.cleanAvdName(connection, displayName, true);
        abi = Abi.getEnum((String)systemImageDescription.getAbiType());
        useRanchu = AvdManagerConnection.doesSystemImageSupportQemu2(systemImageDescription);
        supportsSmp = abi != null && abi.supportsMultipleCpuCores() != false && AvdWizardUtils.getMaxCpuCores() > 1;
        Intrinsics.checkNotNullExpressionValue((Object)internalName, (String)"internalName");
        settings = com.android.tools.idea.welcome.install.AndroidVirtualDevice$Companion.access$getAvdSettings(AndroidVirtualDevice.Companion, internalName, d);
        if (useRanchu) {
            var13_14 = settings;
            var14_15 = "hw.cpu.ncore";
            it = var16_16 = "1";
            $i$a$-takeUnless-AndroidVirtualDevice$createAvd$1 = false;
            v2 = supportsSmp == false ? var16_16 : null;
            if (v2 == null) {
                v2 = String.valueOf(AvdWizardUtils.getMaxCpuCores());
            }
            var15_19 = v2;
            var13_14.put(var14_15, var15_19);
        }
        return connection.createOrUpdateAvd(null, internalName, d, systemImageDescription, ScreenOrientation.PORTRAIT, false, cardSize, hardwareSkinPath, settings, true);
    }

    @VisibleForTesting
    @NotNull
    public final String getRequiredSysimgPath(boolean isArm64HostOs) {
        String string;
        if (isArm64HostOs) {
            string = "arm64-v8a";
        } else {
            AndroidVersion androidVersion = this.myLatestVersion;
            string = (androidVersion != null ? androidVersion.compareTo(this.MAX_X86_API_LEVEL, null) : -1) > 0 ? "x86_64" : "x86";
        }
        String string2 = DetailsTypes.getSysImgPath((IdDisplay)ID_VENDOR_GOOGLE, (AndroidVersion)this.myLatestVersion, (IdDisplay)ID_ADDON_GOOGLE_API_IMG, (String)string);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSysImgPath(ID_VENDOR_\u2026                      } )");
        return string2;
    }

    @Override
    @NotNull
    protected Collection<String> getRequiredSdkPackages() {
        List result2 = new ArrayList();
        if (this.myLatestVersion != null) {
            result2.add(this.getRequiredSysimgPath(this.IS_ARM64_HOST_OS));
        }
        return result2;
    }

    @Override
    @NotNull
    protected Collection<String> getOptionalSdkPackages() {
        List result2 = new ArrayList();
        if (this.myLatestVersion != null) {
            String string = DetailsTypes.getAddonPath((IdDisplay)ID_VENDOR_GOOGLE, (AndroidVersion)this.myLatestVersion, (IdDisplay)ID_ADDON_GOOGLE_API_IMG);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAddonPath(ID_VENDOR_G\u2026 ID_ADDON_GOOGLE_API_IMG)");
            result2.add(string);
        }
        return result2;
    }

    @Override
    public void init(@NotNull ProgressStep progressStep) {
        Intrinsics.checkNotNullParameter((Object)progressStep, (String)"progressStep");
        this.myProgressStep = progressStep;
    }

    @Override
    public void configure(@NotNull InstallContext installContext, @NotNull AndroidSdkHandler sdkHandler) {
        Intrinsics.checkNotNullParameter((Object)installContext, (String)"installContext");
        Intrinsics.checkNotNullParameter((Object)sdkHandler, (String)"sdkHandler");
        ProgressStep progressStep = this.myProgressStep;
        if (progressStep == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myProgressStep");
            progressStep = null;
        }
        progressStep.getProgressIndicator().setIndeterminate(true);
        ProgressStep progressStep2 = this.myProgressStep;
        if (progressStep2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myProgressStep");
            progressStep2 = null;
        }
        progressStep2.getProgressIndicator().setText("Creating Android virtual device");
        installContext.print("Creating Android virtual device\n", ConsoleViewContentType.SYSTEM_OUTPUT);
        try {
            AvdManagerConnection avdManagerConnection = AvdManagerConnection.getAvdManagerConnection(sdkHandler);
            Intrinsics.checkNotNullExpressionValue((Object)avdManagerConnection, (String)"getAvdManagerConnection(sdkHandler)");
            AvdInfo avdInfo = this.createAvd(avdManagerConnection, sdkHandler);
            if (avdInfo == null) {
                throw new WizardException("Unable to create Android virtual device");
            }
            AvdInfo avd = avdInfo;
            String successMessage = "Android virtual device " + avd.getName() + " was successfully created\n";
            installContext.print(successMessage, ConsoleViewContentType.SYSTEM_OUTPUT);
        }
        catch (WizardException e) {
            LOG.error((Throwable)e);
            String failureMessage = "Unable to create a virtual device: " + e.getMessage() + "\n";
            installContext.print(failureMessage, ConsoleViewContentType.ERROR_OUTPUT);
        }
    }

    @Override
    public boolean isSelectedByDefault() {
        SystemImageDescription systemImageDescription;
        if (this.sdkHandler == null) {
            return false;
        }
        try {
            AndroidSdkHandler androidSdkHandler = this.sdkHandler;
            Intrinsics.checkNotNull((Object)androidSdkHandler);
            systemImageDescription = this.getSystemImageDescription(androidSdkHandler);
        }
        catch (WizardException e) {
            return true;
        }
        SystemImageDescription desired = systemImageDescription;
        AndroidSdkHandler androidSdkHandler = this.sdkHandler;
        Intrinsics.checkNotNull((Object)androidSdkHandler);
        AvdManagerConnection avdManagerConnection = AvdManagerConnection.getAvdManagerConnection(androidSdkHandler);
        Intrinsics.checkNotNullExpressionValue((Object)avdManagerConnection, (String)"getAvdManagerConnection(sdkHandler!!)");
        AvdManagerConnection connection2 = avdManagerConnection;
        List<AvdInfo> list2 = connection2.getAvds(false);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"connection.getAvds(false)");
        List<AvdInfo> avds = list2;
        for (AvdInfo avd : avds) {
            if (!Intrinsics.areEqual((Object)avd.getAbiType(), (Object)desired.getAbiType()) || !Intrinsics.areEqual((Object)avd.getAndroidVersion(), (Object)desired.getVersion())) continue;
            return false;
        }
        return true;
    }

    static {
        Logger logger2 = Logger.getInstance(AndroidVirtualDevice.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(AndroidVirtualDevice::class.java)");
        LOG = logger2;
        ID_ADDON_GOOGLE_API_IMG = IdDisplay.create((String)"google_apis", (String)"Google APIs");
        ID_VENDOR_GOOGLE = IdDisplay.create((String)"google", (String)"Google LLC");
        DEFAULT_RAM_SIZE = new Storage(1536L, Storage.Unit.MiB);
        DEFAULT_HEAP_SIZE = new Storage(256L, Storage.Unit.MiB);
        Object[] objectArray = new String[]{"hw.sensors.proximity", "hw.sdCard", "hw.gpu.enabled"};
        ImmutableSet immutableSet = ImmutableSet.of((Object)"hw.accelerometer", (Object)"hw.audioInput", (Object)"hw.battery", (Object)"hw.gps", (Object)"hw.keyboard", (Object)"hw.sensors.orientation", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"of(HardwareProperties.HW\u2026er.AVD_INI_GPU_EMULATION)");
        ENABLED_HARDWARE = (Set)immutableSet;
        Object[] objectArray2 = new String[]{"hw.dPad", "hw.mainKeys", "hw.trackBall", "snapshot.present"};
        DISABLED_HARDWARE = SetsKt.setOf((Object[])objectArray2);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00152\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J4\u0010\u001c\u001a\u00020\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00152\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\"H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006#"}, d2={"Lcom/android/tools/idea/welcome/install/AndroidVirtualDevice$Companion;", "", "()V", "DEFAULT_DEVICE_ID", "", "DEFAULT_HEAP_SIZE", "Lcom/android/sdklib/devices/Storage;", "DEFAULT_RAM_SIZE", "DISABLED_HARDWARE", "", "ENABLED_HARDWARE", "ID_ADDON_GOOGLE_API_IMG", "Lcom/android/sdklib/repository/IdDisplay;", "kotlin.jvm.PlatformType", "ID_VENDOR_GOOGLE", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "getAvdSettings", "", "internalName", "device", "Lcom/android/sdklib/devices/Device;", "getDevice", "sdkPath", "Ljava/nio/file/Path;", "setStorageSizeKey", "", "result", "key", "size", "convertToMb", "", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private final Device getDevice(Path sdkPath) throws WizardException {
            List<Device> list2 = DeviceManagerConnection.getDeviceManagerConnection(sdkPath).getDevices();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getDeviceManagerConnection(sdkPath).devices");
            List<Device> devices2 = list2;
            for (Device device2 : devices2) {
                if (!Objects.equal((Object)device2.getId(), (Object)AndroidVirtualDevice.DEFAULT_DEVICE_ID)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)device2, (String)"device");
                return device2;
            }
            throw new WizardException("No device definition with \"pixel_3a\" ID found");
        }

        private final Map<String, String> getAvdSettings(String internalName, Device device2) {
            Map result2 = new HashMap();
            Object object = result2;
            String string = "hw.gpu.mode";
            String string2 = GpuMode.AUTO.getGpuSetting();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"AUTO.gpuSetting");
            String string3 = string2;
            object.put(string, string3);
            for (String key : ENABLED_HARDWARE) {
                result2.put(key, "yes");
            }
            for (String key : DISABLED_HARDWARE) {
                result2.put(key, "no");
            }
            for (String key : ImmutableSet.of((Object)"hw.camera.back", (Object)"hw.camera.front")) {
                Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                result2.put(key, "emulated");
            }
            object = result2;
            string = "hw.device.name";
            String string4 = device2.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"device.id");
            string3 = string4;
            object.put(string, string3);
            object = result2;
            string = "hw.device.manufacturer";
            String string5 = device2.getManufacturer();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"device.manufacturer");
            string3 = string5;
            object.put(string, string3);
            object = result2;
            string = "runtime.network.latency";
            String string6 = EmulatedProperties.DEFAULT_NETWORK_LATENCY.getAsParameter();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"DEFAULT_NETWORK_LATENCY.asParameter");
            string3 = string6;
            object.put(string, string3);
            object = result2;
            string = "runtime.network.speed";
            String string7 = EmulatedProperties.DEFAULT_NETWORK_SPEED.getAsParameter();
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"DEFAULT_NETWORK_SPEED.asParameter");
            string3 = string7;
            object.put(string, string3);
            result2.put("AvdId", internalName);
            result2.put("avd.ini.displayname", internalName);
            result2.put("hw.lcd.density", String.valueOf(Density.XXHIGH.getDpiValue()));
            this.setStorageSizeKey(result2, "hw.ramSize", DEFAULT_RAM_SIZE, true);
            this.setStorageSizeKey(result2, "vm.heapSize", DEFAULT_HEAP_SIZE, true);
            Storage storage = EmulatedProperties.DEFAULT_INTERNAL_STORAGE;
            Intrinsics.checkNotNullExpressionValue((Object)storage, (String)"DEFAULT_INTERNAL_STORAGE");
            this.setStorageSizeKey(result2, "disk.dataPartition.size", storage, false);
            return result2;
        }

        private final void setStorageSizeKey(Map<String, String> result2, String key, Storage size, boolean convertToMb) {
            Map<String, String> map2 = result2;
            String string = AvdOptionsModel.toIniString(size, convertToMb);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toIniString(size, convertToMb)");
            String string2 = string;
            map2.put(key, string2);
        }

        public static final /* synthetic */ Device access$getDevice(Companion $this, Path sdkPath) {
            return $this.getDevice(sdkPath);
        }

        public static final /* synthetic */ Map access$getAvdSettings(Companion $this, String internalName, Device device2) {
            return $this.getAvdSettings(internalName, device2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

