/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wearpairing;

import com.android.ddmlib.AvdData;
import com.android.ddmlib.EmulatorConsole;
import com.android.ddmlib.IDevice;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.repository.IdDisplay;
import com.android.sdklib.repository.targets.SystemImage;
import com.android.tools.idea.ddms.DevicePropertyUtil;
import com.android.tools.idea.observable.core.OptionalProperty;
import com.android.tools.idea.project.AndroidNotification;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.wearpairing.AndroidWearPairingBundle;
import com.android.tools.idea.wearpairing.ConnectionState;
import com.android.tools.idea.wearpairing.PairingDevice;
import com.android.tools.idea.wearpairing.WearPairingManager;
import com.android.tools.idea.wearpairing.WearPairingUsageTracker;
import com.android.tools.idea.wearpairing.WizardAction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.wireless.android.sdk.stats.WearPairingEvent;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.GlobalScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002\u001a*\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002\u001a\"\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002\u001a\"\u0010\u0015\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002\u001a$\u0010\u0016\u001a\u00020\f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u001bH\u0002\u001a\f\u0010\u001c\u001a\u00020\t*\u00020\u001dH\u0002\u001a\u0014\u0010\u001e\u001a\u00020\t*\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\tH\u0002\u001a\f\u0010 \u001a\u00020!*\u00020\u001dH\u0002\u001a\f\u0010\"\u001a\u00020!*\u00020#H\u0000\u001a\u001c\u0010$\u001a\u00020\f*\u00020%2\u0006\u0010&\u001a\u00020\t2\b\b\u0002\u0010'\u001a\u00020!\u001a\u001c\u0010(\u001a\u00020\f*\u00020%2\u0006\u0010)\u001a\u00020*2\b\b\u0002\u0010'\u001a\u00020!\u001a\u001e\u0010+\u001a\u00020\u0019*\u00020\u001d2\u0006\u0010&\u001a\u00020\t2\b\u0010,\u001a\u0004\u0018\u00010\u0019H\u0002\u001a\u0014\u0010+\u001a\u00020\u0019*\u00020#2\u0006\u0010&\u001a\u00020\tH\u0002\"\u0019\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "WIFI_DEVICE_SERIAL_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "normalizeAvdId", "", "avdId", "showConnectionDroppedBalloon", "", "offlineName", "phoneName", "wearName", "wizardAction", "Lcom/android/tools/idea/wearpairing/WizardAction;", "showMessageBalloon", "title", "text", "showReconnectMessageBalloon", "updateSelectedDevice", "deviceList", "", "Lcom/android/tools/idea/wearpairing/PairingDevice;", "device", "Lcom/android/tools/idea/observable/core/OptionalProperty;", "getDeviceID", "Lcom/android/ddmlib/IDevice;", "getDeviceName", "unknown", "isPhysicalPhone", "", "isWearOrPhone", "Lcom/android/sdklib/internal/avd/AvdInfo;", "removeAllPairedDevicesAsync", "Lcom/android/tools/idea/wearpairing/WearPairingManager;", "deviceID", "restartWearGmsCore", "removePairedDevicesAsync", "phoneWearPair", "Lcom/android/tools/idea/wearpairing/WearPairingManager$PhoneWearPair;", "toPairingDevice", "avdDevice", "intellij.android.wear-pairing"})
@SourceDebugExtension(value={"SMAP\nWearPairingManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WearPairingManager.kt\ncom/android/tools/idea/wearpairing/WearPairingManagerKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,635:1\n10#2:636\n1#3:637\n288#4,2:638\n13543#5,2:640\n*S KotlinDebug\n*F\n+ 1 WearPairingManager.kt\ncom/android/tools/idea/wearpairing/WearPairingManagerKt\n*L\n72#1:636\n581#1:638,2\n609#1:640,2\n*E\n"})
public final class WearPairingManagerKt {
    private static final Pattern WIFI_DEVICE_SERIAL_PATTERN = Pattern.compile("adb-(.*)-.*\\._adb-tls-connect\\._tcp\\.?");

    private static final Logger getLOG() {
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(WearPairingManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(T::class.java)");
        return logger2;
    }

    private static final PairingDevice toPairingDevice(IDevice $this$toPairingDevice, String deviceID, PairingDevice avdDevice) {
        Object object = avdDevice;
        if (object == null || (object = ((PairingDevice)object).getDisplayName()) == null) {
            String string = $this$toPairingDevice.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
            object = WearPairingManagerKt.getDeviceName($this$toPairingDevice, string);
        }
        Object object2 = object;
        PairingDevice pairingDevice = avdDevice;
        int n = pairingDevice != null ? pairingDevice.getApiLevel() : $this$toPairingDevice.getVersion().getFeatureLevel();
        boolean bl = $this$toPairingDevice.isEmulator();
        PairingDevice pairingDevice2 = avdDevice;
        boolean bl2 = pairingDevice2 != null ? pairingDevice2.isWearDevice() : $this$toPairingDevice.supportsFeature(IDevice.HardwareFeature.WATCH);
        ConnectionState connectionState = $this$toPairingDevice.isOnline() ? ConnectionState.ONLINE : ConnectionState.OFFLINE;
        PairingDevice pairingDevice3 = avdDevice;
        boolean bl3 = pairingDevice3 != null ? pairingDevice3.getHasPlayStore() : false;
        Object $this$toPairingDevice_u24lambda_u240 = object2 = new PairingDevice(deviceID, (String)object2, n, bl, bl2, bl3, connectionState);
        boolean bl4 = false;
        ((PairingDevice)$this$toPairingDevice_u24lambda_u240).setLaunch((Function1<? super Project, ? extends ListenableFuture<IDevice>>)((Function1)new Function1<Project, ListenableFuture<IDevice>>($this$toPairingDevice){
            final /* synthetic */ IDevice $this_toPairingDevice;
            {
                this.$this_toPairingDevice = $receiver;
                super(1);
            }

            public final ListenableFuture<IDevice> invoke(@Nullable Project it) {
                ListenableFuture listenableFuture = Futures.immediateFuture((Object)this.$this_toPairingDevice);
                Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"immediateFuture(this@toPairingDevice)");
                return listenableFuture;
            }
        }));
        return object2;
    }

    private static final PairingDevice toPairingDevice(AvdInfo $this$toPairingDevice, String deviceID) {
        Object object = $this$toPairingDevice.getDisplayName();
        int n = $this$toPairingDevice.getAndroidVersion().getFeatureLevel();
        boolean bl = Intrinsics.areEqual((Object)SystemImage.WEAR_TAG, (Object)$this$toPairingDevice.getTag());
        ConnectionState connectionState = ConnectionState.OFFLINE;
        boolean bl2 = $this$toPairingDevice.hasPlayStore();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"displayName");
        Object $this$toPairingDevice_u24lambda_u241 = object = new PairingDevice(deviceID, (String)object, n, true, bl, bl2, connectionState);
        boolean bl3 = false;
        ((PairingDevice)$this$toPairingDevice_u24lambda_u241).setLaunch((Function1<? super Project, ? extends ListenableFuture<IDevice>>)((Function1)new Function1<Project, ListenableFuture<IDevice>>(deviceID, $this$toPairingDevice){
            final /* synthetic */ String $deviceID;
            final /* synthetic */ AvdInfo $this_toPairingDevice;
            {
                this.$deviceID = $deviceID;
                this.$this_toPairingDevice = $receiver;
                super(1);
            }

            @NotNull
            public final ListenableFuture<IDevice> invoke(@Nullable Project project) {
                return WearPairingManager.Companion.getInstance().launchDevice$intellij_android_wear_pairing(project, this.$deviceID, this.$this_toPairingDevice);
            }
        }));
        return object;
    }

    private static final boolean isPhysicalPhone(IDevice $this$isPhysicalPhone) {
        return $this$isPhysicalPhone.isEmulator() ? false : ($this$isPhysicalPhone.supportsFeature(IDevice.HardwareFeature.WATCH) ? false : ($this$isPhysicalPhone.supportsFeature(IDevice.HardwareFeature.TV) ? false : !$this$isPhysicalPhone.supportsFeature(IDevice.HardwareFeature.AUTOMOTIVE)));
    }

    public static final boolean isWearOrPhone(@NotNull AvdInfo $this$isWearOrPhone) {
        Intrinsics.checkNotNullParameter((Object)$this$isWearOrPhone, (String)"<this>");
        IdDisplay idDisplay = $this$isWearOrPhone.getTag();
        return Intrinsics.areEqual((Object)idDisplay, (Object)SystemImage.WEAR_TAG) ? true : (Intrinsics.areEqual((Object)idDisplay, (Object)SystemImage.DESKTOP_TAG) ? false : (Intrinsics.areEqual((Object)idDisplay, (Object)SystemImage.ANDROID_TV_TAG) ? false : (Intrinsics.areEqual((Object)idDisplay, (Object)SystemImage.GOOGLE_TV_TAG) ? false : (Intrinsics.areEqual((Object)idDisplay, (Object)SystemImage.AUTOMOTIVE_TAG) ? false : (Intrinsics.areEqual((Object)idDisplay, (Object)SystemImage.AUTOMOTIVE_PLAY_STORE_TAG) ? false : !Intrinsics.areEqual((Object)idDisplay, (Object)SystemImage.CHROMEOS_TAG))))));
    }

    private static final String getDeviceName(IDevice $this$getDeviceName, String unknown) {
        CharSequence charSequence;
        String string = DevicePropertyUtil.getModel($this$getDeviceName, "");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getModel(this, \"\")");
        String model2 = string;
        String string2 = DevicePropertyUtil.getManufacturer($this$getDeviceName, "");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getManufacturer(this, \"\")");
        String manufacturer = string2;
        String deviceName = StringsKt.startsWith((String)model2, (String)manufacturer, (boolean)true) ? model2 : manufacturer + " " + model2;
        CharSequence charSequence2 = deviceName;
        if (StringsKt.isBlank((CharSequence)charSequence2)) {
            boolean bl = false;
            charSequence = unknown;
        } else {
            charSequence = charSequence2;
        }
        return (String)charSequence;
    }

    private static final String normalizeAvdId(String avdId) {
        String string;
        try {
            Path path2 = Paths.get(((Object)StringsKt.trim((CharSequence)avdId)).toString(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(path)");
            string = ((Object)path2.normalize()).toString();
        }
        catch (Throwable throwable) {
            string = avdId;
        }
        return string;
    }

    private static final String getDeviceID(IDevice $this$getDeviceID) {
        Object object;
        block9: {
            block10: {
                Object object2;
                block12: {
                    block11: {
                        block6: {
                            Object object3;
                            block8: {
                                block7: {
                                    if (!$this$getDeviceID.isEmulator()) break block6;
                                    ListenableFuture listenableFuture = $this$getDeviceID.getAvdData();
                                    boolean bl = listenableFuture != null ? listenableFuture.isDone() : false;
                                    if (!bl) break block6;
                                    object3 = (AvdData)$this$getDeviceID.getAvdData().get();
                                    if (object3 == null || (object3 = object3.getPath()) == null) break block7;
                                    Object it = object3;
                                    boolean bl2 = false;
                                    String string = WearPairingManagerKt.normalizeAvdId((String)it);
                                    object3 = string;
                                    if (string != null) break block8;
                                }
                                object3 = $this$getDeviceID.getName();
                            }
                            object = object3;
                            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"avdData.get()?.path?.let\u2026malizeAvdId(it) } ?: name");
                            break block9;
                        }
                        if (!$this$getDeviceID.isEmulator()) break block10;
                        object2 = EmulatorConsole.getConsole((IDevice)$this$getDeviceID);
                        if (object2 == null || (object2 = object2.getAvdPath()) == null) break block11;
                        Object it = object2;
                        boolean bl = false;
                        String string = WearPairingManagerKt.normalizeAvdId((String)it);
                        object2 = string;
                        if (string != null) break block12;
                    }
                    object2 = $this$getDeviceID.getName();
                }
                object = object2;
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"EmulatorConsole.getConso\u2026malizeAvdId(it) } ?: name");
                break block9;
            }
            Matcher matcher = WIFI_DEVICE_SERIAL_PATTERN.matcher($this$getDeviceID.getSerialNumber());
            String string = matcher.matches() ? matcher.group(1) : $this$getDeviceID.getSerialNumber();
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"{\n      val matcher = WI\u2026e this.serialNumber\n    }");
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private static final void updateSelectedDevice(List<PairingDevice> deviceList2, OptionalProperty<PairingDevice> device2) {
        PairingDevice pairingDevice;
        Object v1;
        OptionalProperty<PairingDevice> optionalProperty;
        PairingDevice currentDevice;
        block3: {
            void $this$firstOrNull$iv;
            PairingDevice pairingDevice2 = device2.getValueOrNull();
            if (pairingDevice2 == null) {
                return;
            }
            currentDevice = pairingDevice2;
            Iterable iterable = deviceList2;
            optionalProperty = device2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PairingDevice it = (PairingDevice)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)currentDevice.getDeviceID(), (Object)it.getDeviceID())) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        if ((pairingDevice = (PairingDevice)v1) == null) {
            pairingDevice = currentDevice.disconnectedCopy();
        }
        optionalProperty.setValue(pairingDevice);
    }

    private static final void showReconnectMessageBalloon(String phoneName, String wearName, WizardAction wizardAction2) {
        Object[] objectArray = new Object[]{wearName, phoneName};
        WearPairingManagerKt.showMessageBalloon(AndroidWearPairingBundle.Companion.message("wear.assistant.device.connection.reconnected.title", new Object[0]), AndroidWearPairingBundle.Companion.message("wear.assistant.device.connection.reconnected.message", objectArray), wizardAction2);
        WearPairingUsageTracker.INSTANCE.log(WearPairingEvent.EventKind.AUTOMATIC_RECONNECT);
    }

    private static final void showConnectionDroppedBalloon(String offlineName, String phoneName, String wearName, WizardAction wizardAction2) {
        Object[] objectArray = new Object[]{offlineName, wearName, phoneName};
        WearPairingManagerKt.showMessageBalloon(AndroidWearPairingBundle.Companion.message("wear.assistant.device.connection.dropped.title", new Object[0]), AndroidWearPairingBundle.Companion.message("wear.assistant.device.connection.dropped.message", objectArray), wizardAction2);
    }

    private static final void showMessageBalloon(String title, String text2, WizardAction wizardAction2) {
        String string = AndroidWearPairingBundle.Companion.message("wear.assistant.device.connection.balloon.link", new Object[0]);
        NotificationHyperlink hyperlink2 = new NotificationHyperlink(wizardAction2, string){
            final /* synthetic */ WizardAction $wizardAction;
            {
                this.$wizardAction = $wizardAction;
                super("launchAssistant", $super_call_param$1);
            }

            protected void execute(@NotNull Project project) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    WizardAction wizardAction2 = this.$wizardAction;
                    if (wizardAction2 == null) break block0;
                    wizardAction2.restart(project);
                }
            }
        };
        WearPairingManagerKt.getLOG().warn(text2);
        Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getInstance().openProjects");
        Object[] $this$forEach$iv = projectArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Project it = (Project)element$iv;
            boolean bl = false;
            NotificationHyperlink[] notificationHyperlinkArray = new NotificationHyperlink[]{hyperlink2};
            AndroidNotification.getInstance(it).showBalloon(title, text2 + "<br/>", NotificationType.INFORMATION, notificationHyperlinkArray);
        }
    }

    public static final void removeAllPairedDevicesAsync(@NotNull WearPairingManager $this$removeAllPairedDevicesAsync, @NotNull String deviceID, boolean restartWearGmsCore) {
        Intrinsics.checkNotNullParameter((Object)$this$removeAllPairedDevicesAsync, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)deviceID, (String)"deviceID");
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>($this$removeAllPairedDevicesAsync, deviceID, restartWearGmsCore, null){
            int label;
            final /* synthetic */ WearPairingManager $this_removeAllPairedDevicesAsync;
            final /* synthetic */ String $deviceID;
            final /* synthetic */ boolean $restartWearGmsCore;
            {
                this.$this_removeAllPairedDevicesAsync = $receiver;
                this.$deviceID = $deviceID;
                this.$restartWearGmsCore = $restartWearGmsCore;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.$this_removeAllPairedDevicesAsync.removeAllPairedDevices(this.$deviceID, this.$restartWearGmsCore, (Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public static /* synthetic */ void removeAllPairedDevicesAsync$default(WearPairingManager wearPairingManager, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        WearPairingManagerKt.removeAllPairedDevicesAsync(wearPairingManager, string, bl);
    }

    public static final void removePairedDevicesAsync(@NotNull WearPairingManager $this$removePairedDevicesAsync, @NotNull WearPairingManager.PhoneWearPair phoneWearPair, boolean restartWearGmsCore) {
        Intrinsics.checkNotNullParameter((Object)$this$removePairedDevicesAsync, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)phoneWearPair, (String)"phoneWearPair");
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>($this$removePairedDevicesAsync, phoneWearPair, restartWearGmsCore, null){
            int label;
            final /* synthetic */ WearPairingManager $this_removePairedDevicesAsync;
            final /* synthetic */ WearPairingManager.PhoneWearPair $phoneWearPair;
            final /* synthetic */ boolean $restartWearGmsCore;
            {
                this.$this_removePairedDevicesAsync = $receiver;
                this.$phoneWearPair = $phoneWearPair;
                this.$restartWearGmsCore = $restartWearGmsCore;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.$this_removePairedDevicesAsync.removePairedDevices(this.$phoneWearPair, this.$restartWearGmsCore, (Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public static /* synthetic */ void removePairedDevicesAsync$default(WearPairingManager wearPairingManager, WearPairingManager.PhoneWearPair phoneWearPair, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        WearPairingManagerKt.removePairedDevicesAsync(wearPairingManager, phoneWearPair, bl);
    }

    public static final /* synthetic */ Logger access$getLOG() {
        return WearPairingManagerKt.getLOG();
    }

    public static final /* synthetic */ void access$updateSelectedDevice(List deviceList2, OptionalProperty device2) {
        WearPairingManagerKt.updateSelectedDevice(deviceList2, device2);
    }

    public static final /* synthetic */ void access$showReconnectMessageBalloon(String phoneName, String wearName, WizardAction wizardAction2) {
        WearPairingManagerKt.showReconnectMessageBalloon(phoneName, wearName, wizardAction2);
    }

    public static final /* synthetic */ void access$showConnectionDroppedBalloon(String offlineName, String phoneName, String wearName, WizardAction wizardAction2) {
        WearPairingManagerKt.showConnectionDroppedBalloon(offlineName, phoneName, wearName, wizardAction2);
    }

    public static final /* synthetic */ PairingDevice access$toPairingDevice(AvdInfo $receiver, String deviceID) {
        return WearPairingManagerKt.toPairingDevice($receiver, deviceID);
    }

    public static final /* synthetic */ boolean access$isPhysicalPhone(IDevice $receiver) {
        return WearPairingManagerKt.isPhysicalPhone($receiver);
    }

    public static final /* synthetic */ PairingDevice access$toPairingDevice(IDevice $receiver, String deviceID, PairingDevice avdDevice) {
        return WearPairingManagerKt.toPairingDevice($receiver, deviceID, avdDevice);
    }

    public static final /* synthetic */ String access$getDeviceID(IDevice $receiver) {
        return WearPairingManagerKt.getDeviceID($receiver);
    }
}

