/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.util;

import com.android.ide.common.util.PathString;
import com.android.tools.idea.util.FileExtensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\fH$J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0013H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH$J\u0018\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\fH$J\u0010\u0010 \u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\tH\u0002J\u0010\u0010!\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\"\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0004J\u0010\u0010#\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020$H\u0016J+\u0010%\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001e2\u0018\u0010&\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000f0'H\u0082\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006Rj\u0010\u0007\u001a^\u0012\u0016\u0012\u0014 \u000b*\t\u0018\u00010\t\u00a2\u0006\u0002\b\n0\t\u00a2\u0006\u0002\b\n\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\f0\f \u000b*-\u0012\u0016\u0012\u0014 \u000b*\t\u0018\u00010\t\u00a2\u0006\u0002\b\n0\t\u00a2\u0006\u0002\b\n\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\f0\f0\r\u00a2\u0006\u0002\b\n0\b\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/android/tools/idea/util/PoliteAndroidVirtualFileListener;", "Lcom/intellij/openapi/vfs/VirtualFileListener;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "relevantPendingFilesToFacet", "", "Lcom/android/ide/common/util/PathString;", "Lorg/jetbrains/annotations/NotNull;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/android/facet/AndroidFacet;", "", "beforeFileDeletion", "", "event", "Lcom/intellij/openapi/vfs/VirtualFileEvent;", "beforeFileMovement", "Lcom/intellij/openapi/vfs/VirtualFileMoveEvent;", "contentsChanged", "fileChanged", "path", "facet", "fileCreated", "fileDeleted", "fileMoved", "isPossiblyRelevant", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isRelevant", "pendingPossiblyIrrelevantFileChangeComplete", "possiblyIrrelevantFileChangePending", "possiblyIrrelevantFileChanged", "propertyChanged", "Lcom/intellij/openapi/vfs/VirtualFilePropertyEvent;", "runIfRelevant", "block", "Lkotlin/Function2;", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nPoliteAndroidVirtualFileListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PoliteAndroidVirtualFileListener.kt\ncom/android/tools/idea/util/PoliteAndroidVirtualFileListener\n*L\n1#1,128:1\n91#1,6:129\n91#1,6:135\n*S KotlinDebug\n*F\n+ 1 PoliteAndroidVirtualFileListener.kt\ncom/android/tools/idea/util/PoliteAndroidVirtualFileListener\n*L\n88#1:129,6\n99#1:135,6\n*E\n"})
public abstract class PoliteAndroidVirtualFileListener
implements VirtualFileListener {
    @NotNull
    private final Project project;
    @NotNull
    private final Map<PathString, AndroidFacet> relevantPendingFilesToFacet;

    public PoliteAndroidVirtualFileListener(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Map map2 = ContainerUtil.createWeakValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"createWeakValueMap<PathString, AndroidFacet>()");
        this.relevantPendingFilesToFacet = map2;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    protected abstract boolean isPossiblyRelevant(@NotNull VirtualFile var1);

    protected abstract boolean isRelevant(@NotNull VirtualFile var1, @NotNull AndroidFacet var2);

    protected abstract void fileChanged(@NotNull PathString var1, @NotNull AndroidFacet var2);

    /*
     * WARNING - void declaration
     */
    protected final void possiblyIrrelevantFileChanged(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        PoliteAndroidVirtualFileListener this_$iv = this;
        boolean $i$f$runIfRelevant = false;
        if (file2.isValid() && this_$iv.isPossiblyRelevant(file2)) {
            AndroidFacet androidFacet = AndroidFacet.getInstance((VirtualFile)file2, (Project)this_$iv.project);
            if (androidFacet != null) {
                Intrinsics.checkNotNullExpressionValue((Object)androidFacet, (String)"AndroidFacet.getInstance(file, project) ?: return");
                AndroidFacet facet$iv = androidFacet;
                if (this_$iv.isRelevant(file2, facet$iv)) {
                    void p1;
                    AndroidFacet androidFacet2 = facet$iv;
                    PathString p0 = FileExtensions.toPathString(file2);
                    boolean bl = false;
                    this.fileChanged(p0, (AndroidFacet)p1);
                }
            }
        }
    }

    private final void runIfRelevant(VirtualFile file2, Function2<? super PathString, ? super AndroidFacet, Unit> block) {
        boolean $i$f$runIfRelevant = false;
        if (!file2.isValid() || !this.isPossiblyRelevant(file2)) {
            return;
        }
        AndroidFacet androidFacet = AndroidFacet.getInstance((VirtualFile)file2, (Project)this.project);
        if (androidFacet == null) {
            return;
        }
        AndroidFacet facet2 = androidFacet;
        if (this.isRelevant(file2, facet2)) {
            block.invoke((Object)FileExtensions.toPathString(file2), (Object)facet2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void possiblyIrrelevantFileChangePending(VirtualFile file2) {
        PoliteAndroidVirtualFileListener this_$iv = this;
        boolean $i$f$runIfRelevant = false;
        if (file2.isValid() && this_$iv.isPossiblyRelevant(file2)) {
            AndroidFacet androidFacet = AndroidFacet.getInstance((VirtualFile)file2, (Project)this_$iv.project);
            if (androidFacet != null) {
                Intrinsics.checkNotNullExpressionValue((Object)androidFacet, (String)"AndroidFacet.getInstance(file, project) ?: return");
                AndroidFacet facet$iv = androidFacet;
                if (this_$iv.isRelevant(file2, facet$iv)) {
                    void facet2;
                    AndroidFacet androidFacet2 = facet$iv;
                    PathString path2 = FileExtensions.toPathString(file2);
                    boolean bl = false;
                    this.relevantPendingFilesToFacet.put(path2, (AndroidFacet)facet2);
                }
            }
        }
    }

    private final void pendingPossiblyIrrelevantFileChangeComplete(PathString path2) {
        block0: {
            AndroidFacet androidFacet = this.relevantPendingFilesToFacet.remove(path2);
            if (androidFacet == null) break block0;
            AndroidFacet facet2 = androidFacet;
            boolean bl = false;
            this.fileChanged(path2, facet2);
        }
    }

    public void beforeFileMovement(@NotNull VirtualFileMoveEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        VirtualFile virtualFile = event2.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"event.file");
        this.possiblyIrrelevantFileChangePending(virtualFile);
    }

    public void fileMoved(@NotNull VirtualFileMoveEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        VirtualFile virtualFile = event2.getOldParent();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"event.oldParent");
        PathString pathString = FileExtensions.toPathString(virtualFile);
        String string = event2.getFileName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event.fileName");
        this.pendingPossiblyIrrelevantFileChangeComplete(pathString.resolve(string));
        VirtualFile virtualFile2 = event2.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"event.file");
        this.possiblyIrrelevantFileChanged(virtualFile2);
    }

    public void beforeFileDeletion(@NotNull VirtualFileEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        VirtualFile virtualFile = event2.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"event.file");
        this.possiblyIrrelevantFileChangePending(virtualFile);
    }

    public void fileDeleted(@NotNull VirtualFileEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        VirtualFile virtualFile = event2.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"event.file");
        this.pendingPossiblyIrrelevantFileChangeComplete(FileExtensions.toPathString(virtualFile));
    }

    public void contentsChanged(@NotNull VirtualFileEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        VirtualFile virtualFile = event2.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"event.file");
        this.possiblyIrrelevantFileChanged(virtualFile);
    }

    public void propertyChanged(@NotNull VirtualFilePropertyEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        VirtualFile virtualFile = event2.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"event.file");
        this.possiblyIrrelevantFileChanged(virtualFile);
    }

    public void fileCreated(@NotNull VirtualFileEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        VirtualFile virtualFile = event2.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"event.file");
        this.possiblyIrrelevantFileChanged(virtualFile);
    }
}

