/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.updater.configure;

import com.android.repository.impl.meta.TypeDetails;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.AndroidVersionUtils;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.updater.configure.DetailsTreeNode;
import com.android.tools.idea.updater.configure.PackageNodeModel;
import com.android.tools.idea.updater.configure.UpdaterTreeNode;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SummaryTreeNode
extends UpdaterTreeNode {
    private AndroidVersion myVersion;
    private Set<UpdaterTreeNode> myAllChildren;
    private Set<UpdaterTreeNode> myIncludedChildren = Sets.newHashSet();
    private UpdaterTreeNode myPrimaryChild;

    public static SummaryTreeNode createNode(@NotNull AndroidVersion version2, @NotNull Set<UpdaterTreeNode> children2) {
        HashSet includedChildren = Sets.newHashSet();
        UpdaterTreeNode primaryChild = null;
        for (UpdaterTreeNode child : children2) {
            if (child.includeInSummary()) {
                includedChildren.add(child);
            }
            if (!child.isPrimary()) continue;
            primaryChild = child;
        }
        if (!includedChildren.isEmpty()) {
            return new SummaryTreeNode(version2, children2, includedChildren, primaryChild);
        }
        return null;
    }

    protected SummaryTreeNode(@NotNull AndroidVersion version2, @NotNull Set<UpdaterTreeNode> children2, @NotNull Set<UpdaterTreeNode> includedChildren, @Nullable UpdaterTreeNode primaryChild) {
        this.myVersion = version2;
        this.myAllChildren = children2;
        this.myIncludedChildren = includedChildren;
        this.myPrimaryChild = primaryChild;
    }

    private PackageNodeModel.SelectedState getState(@NotNull Function<UpdaterTreeNode, PackageNodeModel.SelectedState> childStateGetter) {
        boolean hasNeedsUpdate = false;
        for (UpdaterTreeNode summaryNode : this.myIncludedChildren) {
            if (childStateGetter.apply(summaryNode) == PackageNodeModel.SelectedState.NOT_INSTALLED) {
                return PackageNodeModel.SelectedState.NOT_INSTALLED;
            }
            if (childStateGetter.apply(summaryNode) != PackageNodeModel.SelectedState.MIXED) continue;
            hasNeedsUpdate = true;
        }
        return hasNeedsUpdate ? PackageNodeModel.SelectedState.MIXED : PackageNodeModel.SelectedState.INSTALLED;
    }

    @Override
    @NotNull
    public PackageNodeModel.SelectedState getInitialState() {
        return this.getState(UpdaterTreeNode::getInitialState);
    }

    @Override
    public PackageNodeModel.SelectedState getCurrentState() {
        return this.getState(UpdaterTreeNode::getCurrentState);
    }

    @Override
    public int compareTo(@NotNull UpdaterTreeNode o) {
        if (!(o instanceof SummaryTreeNode)) {
            return super.compareTo(o);
        }
        return this.myVersion.compareTo(((SummaryTreeNode)o).myVersion);
    }

    @Override
    public void customizeRenderer(UpdaterTreeNode.Renderer renderer2, JTree tree2, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
        renderer2.getTextRenderer().append(AndroidVersionUtils.getFullReleaseName((AndroidVersion)this.myVersion, (boolean)false, (boolean)true));
    }

    public AndroidVersion getVersion() {
        return this.myVersion;
    }

    @Override
    protected void setState(PackageNodeModel.SelectedState state2) {
        boolean hasOrigNotInstalled = false;
        for (UpdaterTreeNode summaryTreeNode : this.myIncludedChildren) {
            if (summaryTreeNode.getInitialState() != PackageNodeModel.SelectedState.NOT_INSTALLED) continue;
            hasOrigNotInstalled = true;
        }
        for (UpdaterTreeNode child : this.myAllChildren) {
            child.resetState();
        }
        if (state2 == PackageNodeModel.SelectedState.NOT_INSTALLED && !hasOrigNotInstalled) {
            for (UpdaterTreeNode child : this.myAllChildren) {
                child.setState(PackageNodeModel.SelectedState.NOT_INSTALLED);
            }
        }
        if (state2 == PackageNodeModel.SelectedState.INSTALLED) {
            for (UpdaterTreeNode child : this.myIncludedChildren) {
                child.setState(PackageNodeModel.SelectedState.INSTALLED);
            }
        }
    }

    @Override
    protected boolean canHaveMixedState() {
        for (UpdaterTreeNode child : this.myIncludedChildren) {
            if (!child.canHaveMixedState()) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public String getStatusString() {
        boolean foundSources = false;
        boolean foundPlatform = false;
        boolean foundUpdate = false;
        boolean sourcesAvailable = false;
        for (UpdaterTreeNode child : this.myAllChildren) {
            TypeDetails details = ((DetailsTreeNode)child).getPackage().getTypeDetails();
            if (child.getInitialState() != PackageNodeModel.SelectedState.NOT_INSTALLED) {
                if (details instanceof DetailsTypes.SourceDetailsType) {
                    foundSources = true;
                } else if (details instanceof DetailsTypes.PlatformDetailsType) {
                    foundPlatform = true;
                }
                if (child.getInitialState() == PackageNodeModel.SelectedState.MIXED) {
                    foundUpdate = true;
                }
            }
            if (!(details instanceof DetailsTypes.SourceDetailsType)) continue;
            sourcesAvailable = true;
        }
        if (foundUpdate) {
            return "Update available";
        }
        if (foundPlatform && (foundSources || !sourcesAvailable)) {
            return "Installed";
        }
        if (foundPlatform || foundSources) {
            return "Partially installed";
        }
        return "Not installed";
    }

    @Nullable
    public UpdaterTreeNode getPrimaryChild() {
        return this.myPrimaryChild;
    }
}

