/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.updater.configure;

import com.android.prefs.AndroidLocationsProvider;
import com.android.prefs.AndroidLocationsSingleton;
import com.android.repository.api.Channel;
import com.android.repository.api.DelegatingProgressIndicator;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.PackageOperation;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.api.UpdatablePackage;
import com.android.repository.impl.meta.Archive;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.repository.io.FileUtilKt;
import com.android.repository.util.InstallerUtil;
import com.android.sdklib.devices.Storage;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.StudioDownloader;
import com.android.tools.idea.sdk.StudioSettingsController;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.updater.configure.PackageNodeModel;
import com.android.tools.idea.updater.configure.SdkUpdaterConfigPanel;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.android.utils.HtmlBuilder;
import com.android.utils.Pair;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.AncestorListenerAdapter;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkUpdaterConfigurable
implements SearchableConfigurable {
    private static final int ESTIMATED_ZIP_DECOMPRESSION_RATE = 4;
    private SdkUpdaterConfigPanel myPanel;
    private Channel myCurrentChannel;
    private Runnable myChannelChangedCallback;

    @NotNull
    public String getId() {
        return "AndroidSdkUpdater";
    }

    @Nls
    public String getDisplayName() {
        return "Android SDK Updater";
    }

    @Nullable
    public String getHelpTopic() {
        return "org.jetbrains.android.r/studio-ui/sdk-manager.html";
    }

    @Nullable
    public JComponent createComponent() {
        this.myChannelChangedCallback = () -> {
            Channel channel = StudioSettingsController.getInstance().getChannel();
            if (this.myCurrentChannel == null) {
                this.myCurrentChannel = channel;
            }
            if (!Objects.equal((Object)channel, (Object)this.myCurrentChannel)) {
                this.myCurrentChannel = channel;
                this.myPanel.refresh(true);
            }
        };
        this.myPanel = new SdkUpdaterConfigPanel(this.myChannelChangedCallback, new StudioDownloader(), StudioSettingsController.getInstance(), this);
        JComponent component2 = this.myPanel.getComponent();
        component2.addAncestorListener((AncestorListener)new AncestorListenerAdapter(){

            public void ancestorAdded(AncestorEvent event2) {
                SdkUpdaterConfigurable.this.myChannelChangedCallback.run();
            }
        });
        return this.myPanel.getComponent();
    }

    AndroidSdkHandler getSdkHandler() {
        File location = this.myPanel.getSelectedSdkLocation();
        return AndroidSdkHandler.getInstance((AndroidLocationsProvider)AndroidLocationsSingleton.INSTANCE, (Path)(location == null ? null : location.toPath()));
    }

    RepoManager getRepoManager() {
        return this.getSdkHandler().getSdkManager((ProgressIndicator)new StudioLoggerProgressIndicator(this.getClass()));
    }

    public boolean isModified() {
        Configurable updatesConfigurable;
        if (this.myPanel.isModified()) {
            return true;
        }
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)this.myPanel.getComponent());
        Settings data = (Settings)Settings.KEY.getData(dataContext);
        if (data != null && (updatesConfigurable = data.find("preferences.updates")) != null) {
            return updatesConfigurable.isModified();
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void apply() throws ConfigurationException {
        boolean sourcesModified = this.myPanel.areSourcesModified();
        this.myPanel.saveSources();
        ArrayList<LocalPackage> toDelete = new ArrayList<LocalPackage>();
        HashMap requestedPackages = Maps.newHashMap();
        for (PackageNodeModel model2 : this.myPanel.getStates()) {
            if (model2.getState() == PackageNodeModel.SelectedState.NOT_INSTALLED) {
                if (!model2.getPkg().hasLocal()) continue;
                toDelete.add(model2.getPkg().getLocal());
                continue;
            }
            if (model2.getState() != PackageNodeModel.SelectedState.INSTALLED || !model2.getPkg().isUpdate() && model2.getPkg().hasLocal()) continue;
            UpdatablePackage pkg = model2.getPkg();
            requestedPackages.put(pkg.getRemote(), pkg);
        }
        boolean found = false;
        long spaceToBeFreedUp = 0L;
        long patchesDownloadSize = 0L;
        long fullInstallationsDownloadSize = 0L;
        HtmlBuilder messageToDelete = new HtmlBuilder();
        if (!toDelete.isEmpty()) {
            found = true;
            messageToDelete.add("The following components will be deleted: \n");
            messageToDelete.beginList();
            try {
                spaceToBeFreedUp = (Long)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> SdkUpdaterConfigurable.getLocalInstallationSize(toDelete), "Gathering Package Information", true, null);
            }
            catch (ProcessCanceledException e) {
                throw new ConfigurationException("Installation was canceled.");
            }
            for (LocalPackage item2 : toDelete) {
                messageToDelete.listItem().add(SdkUpdaterConfigurable.getItemMessage((RepoPackage)item2));
            }
            messageToDelete.endList();
        }
        HtmlBuilder messageToInstall = new HtmlBuilder();
        if (!requestedPackages.isEmpty()) {
            found = true;
            messageToInstall.add("The following components will be installed: \n");
            messageToInstall.beginList();
            HashMultimap dependencies2 = HashMultimap.create();
            StudioLoggerProgressIndicator progress3 = new StudioLoggerProgressIndicator(this.getClass());
            final ConcurrentLinkedQueue dependencyIssues = new ConcurrentLinkedQueue();
            DelegatingProgressIndicator dependencyIssueReporter = new DelegatingProgressIndicator((ProgressIndicator)progress3){

                public void logWarning(@NotNull String s) {
                    dependencyIssues.add(s);
                    super.logWarning(s);
                }

                public void logError(@NotNull String s) {
                    dependencyIssues.add(s);
                    super.logError(s);
                }
            };
            RepositoryPackages packages = this.getRepoManager().getPackages();
            for (RemotePackage item3 : requestedPackages.keySet()) {
                List packageDependencies = InstallerUtil.computeRequiredPackages((Collection)ImmutableList.of((Object)item3), (RepositoryPackages)packages, (ProgressIndicator)dependencyIssueReporter);
                if (packageDependencies == null) {
                    Object message2;
                    if (!dependencyIssues.isEmpty()) {
                        StringBuilder sb = new StringBuilder();
                        for (String issue2 : dependencyIssues) {
                            sb.append(issue2);
                            sb.append(", ");
                        }
                        message2 = "Unable to resolve dependencies for " + item3.getDisplayName() + ": " + sb;
                    } else {
                        message2 = "Unable to resolve dependencies for " + item3.getDisplayName();
                    }
                    Messages.showErrorDialog((Project)null, (String)message2, (String)"Dependency Error");
                    throw new ConfigurationException((String)message2);
                }
                for (RemotePackage dependency : packageDependencies) {
                    dependencies2.put((Object)dependency, (Object)item3);
                }
                messageToInstall.listItem().add(SdkUpdaterConfigurable.getItemMessage((RepoPackage)item3));
                Pair<Long, Boolean> itemDownloadSize = SdkUpdaterConfigurable.calculateDownloadSizeForPackage(item3, packages);
                if (((Boolean)itemDownloadSize.getSecond()).booleanValue()) {
                    patchesDownloadSize += ((Long)itemDownloadSize.getFirst()).longValue();
                    continue;
                }
                fullInstallationsDownloadSize += ((Long)itemDownloadSize.getFirst()).longValue();
            }
            for (RemotePackage dependency : dependencies2.keySet()) {
                if (requestedPackages.containsKey(dependency)) continue;
                HashSet requests2 = Sets.newHashSet((Iterable)dependencies2.get((Object)dependency));
                requests2.remove(dependency);
                if (requests2.isEmpty()) continue;
                messageToInstall.listItem().add(dependency.getDisplayName()).add(" (Required by ");
                Iterator requestIterator = requests2.iterator();
                messageToInstall.add(((RemotePackage)requestIterator.next()).getDisplayName());
                while (requestIterator.hasNext()) {
                    messageToInstall.add(", ").add(((RemotePackage)requestIterator.next()).getDisplayName());
                }
                messageToInstall.add(")");
                Pair<Long, Boolean> itemDownloadSize = SdkUpdaterConfigurable.calculateDownloadSizeForPackage(dependency, packages);
                if (((Boolean)itemDownloadSize.getSecond()).booleanValue()) {
                    patchesDownloadSize += ((Long)itemDownloadSize.getFirst()).longValue();
                    continue;
                }
                fullInstallationsDownloadSize += ((Long)itemDownloadSize.getFirst()).longValue();
            }
            messageToInstall.endList();
        }
        if (found) {
            ModelWizardDialog dialog2;
            Path location = this.getSdkHandler().getLocation();
            Pair<HtmlBuilder, HtmlBuilder> diskUsageMessages = SdkUpdaterConfigurable.getDiskUsageMessages(location, fullInstallationsDownloadSize, patchesDownloadSize, spaceToBeFreedUp);
            HtmlBuilder message3 = new HtmlBuilder();
            message3.openHtmlBody();
            if (diskUsageMessages.getSecond() != null) {
                message3.addHtml(((HtmlBuilder)diskUsageMessages.getSecond()).getHtml());
            }
            message3.addHtml(messageToDelete.getHtml());
            message3.addHtml(messageToInstall.getHtml());
            message3.addHtml(((HtmlBuilder)diskUsageMessages.getFirst()).getHtml());
            message3.closeHtmlBody();
            if (!SdkUpdaterConfigurable.confirmChange(message3)) throw new ConfigurationException("Installation was canceled.");
            if (!(requestedPackages.isEmpty() && toDelete.isEmpty() || (dialog2 = SdkQuickfixUtils.createDialogForPackages(this.myPanel.getComponent(), requestedPackages.values(), toDelete, true)) == null)) {
                dialog2.show();
                for (RemotePackage remotePackage : requestedPackages.keySet()) {
                    PackageOperation installer = this.getRepoManager().getInProgressInstallOperation((RepoPackage)remotePackage);
                    if (installer == null) continue;
                    PackageOperation.StatusChangeListener listener2 = (installer1, progress2) -> this.myPanel.getComponent().repaint();
                    installer.registerStateChangeListener(listener2);
                }
            }
            this.myPanel.refresh(sourcesModified);
            return;
        } else {
            this.myChannelChangedCallback.run();
        }
    }

    @VisibleForTesting
    @NotNull
    static String getItemMessage(@NotNull RepoPackage item2) {
        return item2.getDetailedDisplayName();
    }

    private static long getLocalInstallationSize(@NotNull Collection<LocalPackage> localPackages) {
        long size = 0L;
        for (LocalPackage item2 : localPackages) {
            if (item2 == null) continue;
            try {
                size += FileUtilKt.recursiveSize((Path)item2.getLocation());
            }
            catch (IOException iOException) {}
        }
        return size;
    }

    private static Pair<Long, Boolean> calculateDownloadSizeForPackage(@NotNull RemotePackage remotePackage, @NotNull RepositoryPackages packages) {
        Archive.PatchType patch;
        LocalPackage localPackage = (LocalPackage)packages.getLocalPackages().get(remotePackage.getPath());
        Archive archive = remotePackage.getArchive();
        if (archive == null) {
            return Pair.of((Object)0L, (Object)false);
        }
        if (localPackage != null && !StudioSettingsController.getInstance().getDisableSdkPatches() && (patch = archive.getPatch(localPackage.getVersion())) != null) {
            return Pair.of((Object)patch.getSize(), (Object)true);
        }
        return Pair.of((Object)archive.getComplete().getSize(), (Object)false);
    }

    @VisibleForTesting
    static Pair<HtmlBuilder, HtmlBuilder> getDiskUsageMessages(@Nullable Path sdkRoot, long fullInstallationsDownloadSize, long patchesDownloadSize, long spaceToBeFreedUp) {
        long totalDownloadSize;
        HtmlBuilder message2 = new HtmlBuilder();
        message2.add("Disk usage:\n");
        boolean issueDiskSpaceWarning = false;
        message2.beginList();
        if (spaceToBeFreedUp > 0L) {
            message2.listItem().add("Disk space that will be freed: " + new Storage(spaceToBeFreedUp).toUiString());
        }
        if ((totalDownloadSize = patchesDownloadSize + fullInstallationsDownloadSize) > 0L) {
            message2.listItem().add("Estimated download size: " + new Storage(totalDownloadSize).toUiString());
            long sdkRootUsageAfterInstallation = patchesDownloadSize + 4L * fullInstallationsDownloadSize - spaceToBeFreedUp;
            message2.listItem().add("Estimated disk space to be additionally occupied on SDK partition after installation: " + new Storage(sdkRootUsageAfterInstallation).toUiString());
            if (sdkRoot != null) {
                long sdkRootUsableSpace = 0L;
                try {
                    sdkRootUsableSpace = Files.getFileStore(sdkRoot).getUsableSpace();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                message2.listItem().add(String.format("Currently available disk space in SDK root (%1$s): %2$s", sdkRoot.toAbsolutePath(), new Storage(sdkRootUsableSpace).toUiString()));
                long totalSdkUsableSpace = sdkRootUsableSpace + spaceToBeFreedUp;
                issueDiskSpaceWarning = totalSdkUsableSpace < sdkRootUsageAfterInstallation;
            }
        }
        message2.endList();
        if (issueDiskSpaceWarning) {
            HtmlBuilder warningMessage = new HtmlBuilder();
            warningMessage.beginColor((Color)JBColor.RED).addBold("WARNING: There might be insufficient disk space to perform this operation. ").newline().newline().add("Estimated disk usage is presented below. ").add("Consider freeing up more disk space before proceeding. ").endColor().newline().newline();
            return Pair.of((Object)message2, (Object)warningMessage);
        }
        return Pair.of((Object)message2, null);
    }

    static boolean confirmChange(HtmlBuilder message2) {
        String[] options2 = new String[]{Messages.getCancelButton(), Messages.getOkButton()};
        Icon icon2 = AllIcons.General.Warning;
        return Messages.showIdeaMessageDialog(null, (String)message2.getHtml(), (String)"Confirm Change", (String[])options2, (int)1, (Icon)icon2, null) == 1;
    }

    public void reset() {
        this.myPanel.reset();
    }

    public void disposeUIResources() {
        if (this.myPanel != null) {
            Disposer.dispose((Disposable)this.myPanel);
        }
    }
}

