/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.updater.configure;

import com.android.repository.api.RepoPackage;
import com.android.repository.api.UpdatablePackage;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.updater.configure.ApiLevelColumnInfo;
import com.android.tools.idea.updater.configure.DetailsTreeNode;
import com.android.tools.idea.updater.configure.DownloadStatusColumnInfo;
import com.android.tools.idea.updater.configure.PackageNodeModel;
import com.android.tools.idea.updater.configure.ParentTreeNode;
import com.android.tools.idea.updater.configure.RevisionColumnInfo;
import com.android.tools.idea.updater.configure.RootNode;
import com.android.tools.idea.updater.configure.SdkUpdaterConfigPanel;
import com.android.tools.idea.updater.configure.SdkUpdaterConfigurable;
import com.android.tools.idea.updater.configure.StatusColumnInfo;
import com.android.tools.idea.updater.configure.SummaryTreeNode;
import com.android.tools.idea.updater.configure.UpdaterTreeNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultimap;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.dualView.TreeTableView;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModelOnColumns;
import com.intellij.ui.treeStructure.treetable.TreeColumnInfo;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

public class PlatformComponentsPanel {
    private static final String PLATFORM_DETAILS_CHECKBOX_SELECTED = "updater.configure.platform.details.checkbox.selected";
    private TreeTableView myPlatformSummaryTable;
    private TreeTableView myPlatformDetailTable;
    private JPanel myPlatformPanel;
    private JCheckBox myPlatformDetailsCheckbox;
    private JCheckBox myHideObsoletePackagesCheckbox;
    private JPanel myPlatformLoadingPanel;
    private JBLabel myPlatformLoadingLabel;
    private AsyncProcessIcon myPlatformLoadingIcon;
    private JPanel myRootPanel;
    private boolean myModified;
    @VisibleForTesting
    UpdaterTreeNode myPlatformDetailsRootNode;
    @VisibleForTesting
    UpdaterTreeNode myPlatformSummaryRootNode;
    Set<PackageNodeModel> myStates;
    private final Multimap<AndroidVersion, UpdatablePackage> myCurrentPackages;
    private final ChangeListener myModificationListener;
    private SdkUpdaterConfigurable myConfigurable;

    PlatformComponentsPanel() {
        this(PropertiesComponent.getInstance());
    }

    @VisibleForTesting
    PlatformComponentsPanel(@NotNull PropertiesComponent propertiesComponent) {
        this.$$$setupUI$$$();
        this.myStates = Sets.newHashSet();
        this.myCurrentPackages = TreeMultimap.create();
        this.myModificationListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PlatformComponentsPanel.this.refreshModified();
            }
        };
        this.myPlatformSummaryTable.setColumnSelectionAllowed(false);
        this.myPlatformLoadingLabel.setForeground((Color)JBColor.GRAY);
        this.myPlatformDetailsCheckbox.setSelected(propertiesComponent.getBoolean(PLATFORM_DETAILS_CHECKBOX_SELECTED, false));
        this.myPlatformDetailsCheckbox.addActionListener(e -> {
            propertiesComponent.setValue(PLATFORM_DETAILS_CHECKBOX_SELECTED, this.myPlatformDetailsCheckbox.isSelected());
            this.updatePlatformTable();
        });
        this.updatePlatformTable();
        this.myHideObsoletePackagesCheckbox.addActionListener(e -> this.updatePlatformItems());
    }

    private void updatePlatformTable() {
        ((CardLayout)this.myPlatformPanel.getLayout()).show(this.myPlatformPanel, this.myPlatformDetailsCheckbox.isSelected() ? "details" : "summary");
    }

    private void updatePlatformItems() {
        this.myPlatformDetailsRootNode.removeAllChildren();
        this.myPlatformSummaryRootNode.removeAllChildren();
        this.myStates.clear();
        List versions = Lists.newArrayList((Iterable)this.myCurrentPackages.keySet());
        versions = Lists.reverse((List)versions);
        versions.sort(((Comparator)(o1, o2) -> o1.compareTo(o2.getApiLevel(), o2.getCodename()) * -1).thenComparing(AndroidVersion::compareTo));
        for (AndroidVersion version2 : versions) {
            SummaryTreeNode node;
            if (version2.equals(0)) continue;
            HashSet versionNodes = Sets.newHashSet();
            ParentTreeNode marker = new ParentTreeNode(version2);
            for (UpdatablePackage info2 : this.myCurrentPackages.get((Object)version2)) {
                RepoPackage pkg = info2.getRepresentative();
                if (pkg.obsolete() && this.myHideObsoletePackagesCheckbox.isSelected()) continue;
                PackageNodeModel model2 = new PackageNodeModel(info2);
                this.myStates.add(model2);
                DetailsTreeNode node2 = new DetailsTreeNode(model2, this.myModificationListener, this.myConfigurable);
                marker.add(node2);
                versionNodes.add(node2);
            }
            if (marker.getChildCount() > 0) {
                this.myPlatformDetailsRootNode.add(marker);
            }
            if ((node = SummaryTreeNode.createNode(version2, versionNodes)) == null) continue;
            this.myPlatformSummaryRootNode.add(node);
        }
        this.refreshModified();
        SdkUpdaterConfigPanel.resizeColumnsToFit((JTable)this.myPlatformDetailTable);
        SdkUpdaterConfigPanel.resizeColumnsToFit((JTable)this.myPlatformSummaryTable);
        this.myPlatformDetailTable.updateUI();
        this.myPlatformSummaryTable.updateUI();
        TreeUtil.expandAll((JTree)this.myPlatformDetailTable.getTree());
        TreeUtil.expandAll((JTree)this.myPlatformSummaryTable.getTree());
    }

    public void startLoading() {
        this.myCurrentPackages.clear();
        this.myPlatformLoadingPanel.setVisible(true);
    }

    public void finishLoading() {
        this.updatePlatformItems();
        this.myPlatformLoadingPanel.setVisible(false);
    }

    private void createUIComponents() {
        UpdaterTreeNode.Renderer renderer2 = new UpdaterTreeNode.Renderer();
        this.myPlatformLoadingIcon = new AsyncProcessIcon("Loading...");
        this.myPlatformSummaryRootNode = new RootNode();
        this.myPlatformDetailsRootNode = new RootNode();
        ColumnInfo[] platformSummaryColumns = new ColumnInfo[]{new DownloadStatusColumnInfo(), new TreeColumnInfo("Name"), new ApiLevelColumnInfo(), new RevisionColumnInfo(), new StatusColumnInfo()};
        this.myPlatformSummaryTable = new TreeTableView(new ListTreeTableModelOnColumns((TreeNode)this.myPlatformSummaryRootNode, platformSummaryColumns));
        SdkUpdaterConfigPanel.setTreeTableProperties(this.myPlatformSummaryTable, renderer2, this.myModificationListener);
        ColumnInfo[] platformDetailColumns = new ColumnInfo[]{new DownloadStatusColumnInfo(), new TreeColumnInfo("Name"), new ApiLevelColumnInfo(), new RevisionColumnInfo(), new StatusColumnInfo()};
        this.myPlatformDetailTable = new TreeTableView(new ListTreeTableModelOnColumns((TreeNode)this.myPlatformDetailsRootNode, platformDetailColumns));
        SdkUpdaterConfigPanel.setTreeTableProperties(this.myPlatformDetailTable, renderer2, this.myModificationListener);
    }

    public void setPackages(@NotNull Multimap<AndroidVersion, UpdatablePackage> packages) {
        this.myCurrentPackages.clear();
        this.myCurrentPackages.putAll(packages);
        this.updatePlatformItems();
    }

    public boolean isModified() {
        return this.myModified;
    }

    public void refreshModified() {
        Enumeration<TreeNode> items2 = this.myPlatformDetailsRootNode.breadthFirstEnumeration();
        while (items2.hasMoreElements()) {
            UpdaterTreeNode node = (UpdaterTreeNode)items2.nextElement();
            if (node.getInitialState() == node.getCurrentState()) continue;
            this.myModified = true;
            return;
        }
        this.myModified = false;
    }

    public void reset() {
        Enumeration<TreeNode> children2 = this.myPlatformDetailsRootNode.breadthFirstEnumeration();
        while (children2.hasMoreElements()) {
            UpdaterTreeNode node = (UpdaterTreeNode)children2.nextElement();
            node.resetState();
        }
        this.refreshModified();
    }

    public void setEnabled(boolean enabled2) {
        this.myPlatformDetailTable.setEnabled(enabled2);
        this.myPlatformSummaryTable.setEnabled(enabled2);
        this.myPlatformDetailsCheckbox.setEnabled(enabled2);
    }

    public void setConfigurable(@NotNull SdkUpdaterConfigurable configurable) {
        this.myConfigurable = configurable;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JCheckBox jCheckBox;
        JBLabel jBLabel;
        JPanel jPanel2;
        JCheckBox jCheckBox2;
        JPanel jPanel3;
        this.createUIComponents();
        this.myRootPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myPlatformDetailsCheckbox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Show Package Details");
        jPanel4.add((Component)jCheckBox2, new GridConstraints(0, 3, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myPlatformLoadingPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myPlatformLoadingLabel = jBLabel = new JBLabel();
        jBLabel.setText("Looking for updates...");
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        AsyncProcessIcon asyncProcessIcon = this.myPlatformLoadingIcon;
        jPanel2.add((Component)asyncProcessIcon, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, null, null));
        this.myHideObsoletePackagesCheckbox = jCheckBox = new JCheckBox();
        jCheckBox.setSelected(true);
        jCheckBox.setText("Hide Obsolete Packages");
        jPanel4.add((Component)jCheckBox, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("<html>Each Android SDK Platform package includes the Android platform and sources pertaining to an API level by default. Once installed, the IDE will automatically check for updates. Check \"show package details\" to display individual SDK components.</html>");
        jPanel3.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(600, -1), new Dimension(600, -1)));
        this.myPlatformPanel = jPanel = new JPanel();
        jPanel.setLayout(new CardLayout(0, 0));
        jPanel3.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, "summary");
        TreeTableView treeTableView = this.myPlatformSummaryTable;
        jBScrollPane.setViewportView((Component)treeTableView);
        JBScrollPane jBScrollPane2 = new JBScrollPane();
        jPanel.add((Component)jBScrollPane2, "details");
        TreeTableView treeTableView2 = this.myPlatformDetailTable;
        jBScrollPane2.setViewportView((Component)treeTableView2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

