/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.updater.configure;

import com.android.ide.common.gradle.Version;
import com.android.repository.api.RepoPackage;
import com.android.repository.api.UpdatablePackage;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.updater.configure.DetailsTreeNode;
import com.android.tools.idea.updater.configure.PackageNodeModel;
import com.android.tools.idea.updater.configure.UpdaterTreeNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.function.Function;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;

class MultiVersionTreeNode
extends UpdaterTreeNode {
    private final DetailsTreeNode myMaxVersionNode;
    private final Collection<DetailsTreeNode> myVersionNodes;

    public MultiVersionTreeNode(@NotNull Collection<DetailsTreeNode> versionNodes) {
        this.myVersionNodes = versionNodes;
        DetailsTreeNode max = this.myVersionNodes.stream().filter(node -> node.getPackage().getPath().endsWith("latest")).findFirst().orElse(null);
        if (max == null) {
            RepoPackage greatestPackage = AndroidSdkHandler.getLatestPackageFromPrefixCollection((Collection)ContainerUtil.map(this.myVersionNodes, DetailsTreeNode::getPackage), null, (boolean)true, arg_0 -> ((Version.Companion)Version.Companion).parse(arg_0));
            max = this.myVersionNodes.stream().filter(node -> node.getPackage() == greatestPackage).findFirst().orElse(null);
        }
        this.myMaxVersionNode = max;
    }

    @NotNull
    private PackageNodeModel.SelectedState getState(@NotNull Function<UpdaterTreeNode, PackageNodeModel.SelectedState> childStateGetter) {
        if (this.myMaxVersionNode == null) {
            return PackageNodeModel.SelectedState.NOT_INSTALLED;
        }
        if (childStateGetter.apply(this.myMaxVersionNode) == PackageNodeModel.SelectedState.INSTALLED) {
            return PackageNodeModel.SelectedState.INSTALLED;
        }
        for (UpdaterTreeNode updaterTreeNode : this.myVersionNodes) {
            if (childStateGetter.apply(updaterTreeNode) == PackageNodeModel.SelectedState.NOT_INSTALLED) continue;
            return PackageNodeModel.SelectedState.MIXED;
        }
        return PackageNodeModel.SelectedState.NOT_INSTALLED;
    }

    @Override
    @NotNull
    public PackageNodeModel.SelectedState getInitialState() {
        return this.getState(UpdaterTreeNode::getInitialState);
    }

    @Override
    @NotNull
    public PackageNodeModel.SelectedState getCurrentState() {
        return this.getState(UpdaterTreeNode::getCurrentState);
    }

    @Override
    protected boolean canHaveMixedState() {
        return this.getInitialState() == PackageNodeModel.SelectedState.MIXED;
    }

    @Override
    public void customizeRenderer(UpdaterTreeNode.Renderer renderer2, JTree tree2, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
        renderer2.getTextRenderer().append(this.getDisplayName());
    }

    @NotNull
    public String getDisplayName() {
        RepoPackage maxPackage = this.myMaxVersionNode.getPackage();
        String maxName = maxPackage.getDisplayName();
        String maxPath = maxPackage.getPath();
        String suffix = maxPath.substring(maxPath.lastIndexOf(59) + 1);
        maxName = StringUtil.trimEnd((String)maxName, (String)suffix).trim();
        maxName = StringUtil.trimEnd((String)maxName, (String)":");
        return maxName;
    }

    @Override
    @NotNull
    public String getStatusString() {
        String revision;
        if (this.getInitialState() == PackageNodeModel.SelectedState.INSTALLED) {
            return "Installed";
        }
        if (this.getInitialState() == PackageNodeModel.SelectedState.NOT_INSTALLED) {
            return "Not Installed";
        }
        UpdatablePackage p = this.myMaxVersionNode.getItem();
        if (p.hasRemote()) {
            revision = p.getRemote().getVersion().toString();
        } else {
            assert (false);
            revision = p.getLocal().getVersion().toString();
        }
        return "Update Available: " + revision;
    }

    @Override
    protected void setState(PackageNodeModel.SelectedState state2) {
        if (state2 == PackageNodeModel.SelectedState.NOT_INSTALLED) {
            for (UpdaterTreeNode updaterTreeNode : this.myVersionNodes) {
                updaterTreeNode.setState(PackageNodeModel.SelectedState.NOT_INSTALLED);
            }
        } else {
            for (UpdaterTreeNode updaterTreeNode : this.myVersionNodes) {
                updaterTreeNode.resetState();
            }
            if (state2 == PackageNodeModel.SelectedState.INSTALLED) {
                this.myMaxVersionNode.setState(PackageNodeModel.SelectedState.INSTALLED);
            }
        }
    }
}

