/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.updater.configure;

import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RepositorySource;
import com.android.repository.api.RepositorySourceProvider;
import com.android.tools.idea.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.AndroidAuthenticator;
import com.android.tools.idea.updater.configure.EditSourceDialog;
import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.OneTimeString;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u001c\u001a\u00020\u001dH\u0014J\n\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0014J\u0012\u0010 \u001a\u0004\u0018\u00010\u00132\u0006\u0010!\u001a\u00020\u0013H\u0002R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R\u000e\u0010\u0018\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/android/tools/idea/updater/configure/EditSourceDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "provider", "Lcom/android/repository/api/RepositorySourceProvider;", "existingSource", "Lcom/android/repository/api/RepositorySource;", "(Lcom/android/repository/api/RepositorySourceProvider;Lcom/android/repository/api/RepositorySource;)V", "credentials", "Lcom/intellij/credentialStore/Credentials;", "getCredentials", "()Lcom/intellij/credentialStore/Credentials;", "existingAuth", "Ljava/net/PasswordAuthentication;", "loginField", "Ljavax/swing/JTextField;", "nameField", "passwordField", "Ljavax/swing/JPasswordField;", "uiName", "", "getUiName", "()Ljava/lang/String;", "url", "getUrl", "urlField", "useAuthentication", "Lcom/intellij/ui/dsl/builder/Cell;", "Lcom/intellij/ui/components/JBCheckBox;", "createCenterPanel", "Ljavax/swing/JComponent;", "doValidate", "Lcom/intellij/openapi/ui/ValidationInfo;", "getErrorMessage", "urlString", "intellij.android.sdkUpdates"})
@SourceDebugExtension(value={"SMAP\nEditSourceDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditSourceDialog.kt\ncom/android/tools/idea/updater/configure/EditSourceDialog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,116:1\n1#2:117\n*E\n"})
public final class EditSourceDialog
extends DialogWrapper {
    @NotNull
    private final RepositorySourceProvider provider;
    @Nullable
    private final RepositorySource existingSource;
    @Nullable
    private final PasswordAuthentication existingAuth;
    @NotNull
    private final JTextField urlField;
    @NotNull
    private final JTextField nameField;
    private Cell<? extends JBCheckBox> useAuthentication;
    @NotNull
    private final JTextField loginField;
    @NotNull
    private final JPasswordField passwordField;

    public EditSourceDialog(@NotNull RepositorySourceProvider provider2, @Nullable RepositorySource existingSource) {
        String string;
        PasswordAuthentication passwordAuthentication;
        EditSourceDialog editSourceDialog;
        Intrinsics.checkNotNullParameter((Object)provider2, (String)"provider");
        super(null);
        this.provider = provider2;
        this.existingSource = existingSource;
        EditSourceDialog editSourceDialog2 = this;
        RepositorySource repositorySource = this.existingSource;
        if (repositorySource != null) {
            RepositorySource repositorySource2 = repositorySource;
            editSourceDialog = editSourceDialog2;
            boolean bl = false;
            passwordAuthentication = AndroidAuthenticator.getAuthentication(this.existingSource.getUrl());
            editSourceDialog2 = editSourceDialog;
        } else {
            passwordAuthentication = null;
        }
        editSourceDialog2.existingAuth = passwordAuthentication;
        RepositorySource repositorySource3 = this.existingSource;
        String string2 = repositorySource3 != null ? repositorySource3.getUrl() : null;
        if (string2 == null) {
            string2 = "http://";
        }
        this.urlField = new JTextField(string2);
        RepositorySource repositorySource4 = this.existingSource;
        String string3 = repositorySource4 != null ? repositorySource4.getDisplayName() : null;
        if (string3 == null) {
            string3 = "Custom Update Site";
        }
        this.nameField = new JTextField(string3);
        PasswordAuthentication passwordAuthentication2 = this.existingAuth;
        this.loginField = new JTextField(passwordAuthentication2 != null ? passwordAuthentication2.getUserName() : null);
        EditSourceDialog editSourceDialog3 = this;
        PasswordAuthentication passwordAuthentication3 = this.existingAuth;
        if (passwordAuthentication3 != null) {
            PasswordAuthentication it = passwordAuthentication3;
            editSourceDialog = editSourceDialog3;
            boolean bl = false;
            char[] cArray = this.existingAuth.getPassword();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"existingAuth.password");
            string = new OneTimeString(cArray, 0, 0, true, 6, null).toString();
            editSourceDialog3 = editSourceDialog;
        } else {
            string = null;
        }
        String string4 = string;
        editSourceDialog3.passwordField = new JPasswordField(string4);
        this.setModal(true);
        this.urlField.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent it) {
                this.initValidation();
            }
        });
        this.urlField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(@NotNull FocusEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.initValidation();
            }
        });
        this.init();
    }

    @NotNull
    public final String getUiName() {
        String string = this.nameField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nameField.text");
        return string;
    }

    @NotNull
    public final String getUrl() {
        String string = this.urlField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"urlField.text");
        return string;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        ValidationInfo validationInfo;
        String string = this.urlField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"urlField.text");
        String string2 = this.getErrorMessage(string);
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            validationInfo = new ValidationInfo(it);
        } else {
            validationInfo = null;
        }
        return validationInfo;
    }

    private final String getErrorMessage(String urlString) {
        try {
            new URL(urlString);
        }
        catch (MalformedURLException e) {
            return "URL is invalid";
        }
        if (this.existingSource == null) {
            for (RepositorySource s : this.provider.getSources(null, (ProgressIndicator)new StudioLoggerProgressIndicator(((Object)((Object)this)).getClass()), false)) {
                if (!StringsKt.equals((String)urlString, (String)s.getUrl(), (boolean)true)) continue;
                return "An update site with this URL already exists";
            }
        }
        return null;
    }

    @Nullable
    public final Credentials getCredentials() {
        Cell<? extends JBCheckBox> cell = this.useAuthentication;
        if (cell == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"useAuthentication");
            cell = null;
        }
        if (((JBCheckBox)cell.getComponent()).isSelected()) {
            return new Credentials(this.loginField.getText(), this.passwordField.getPassword());
        }
        return null;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        return (JComponent)BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this){
            final /* synthetic */ EditSourceDialog this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                Panel.row$default((Panel)$this$panel, null, (Function1)createCenterPanel.1.INSTANCE, (int)1, null);
                $this$panel.row("Name:", (Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ EditSourceDialog this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        $this$row.cell((JComponent)EditSourceDialog.access$getNameField$p(this.this$0)).align((Align)AlignX.FILL.INSTANCE);
                    }
                });
                $this$panel.row("URL:", (Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ EditSourceDialog this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        $this$row.cell((JComponent)EditSourceDialog.access$getUrlField$p(this.this$0)).align((Align)AlignX.FILL.INSTANCE);
                    }
                });
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ EditSourceDialog this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull Row $this$row) {
                        void it;
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        Cell cell = $this$row.checkBox("Use Authentication");
                        EditSourceDialog editSourceDialog = this.this$0;
                        Cell cell2 = cell;
                        EditSourceDialog editSourceDialog2 = this.this$0;
                        boolean bl = false;
                        ((JBCheckBox)it.getComponent()).setSelected(EditSourceDialog.access$getExistingAuth$p(editSourceDialog) != null);
                        EditSourceDialog.access$setUseAuthentication$p(editSourceDialog2, cell);
                    }
                }), (int)1, null);
                Row row2 = $this$panel.row("Login:", (Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ EditSourceDialog this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        $this$row.cell((JComponent)EditSourceDialog.access$getLoginField$p(this.this$0)).align((Align)AlignX.FILL.INSTANCE);
                    }
                });
                Cell cell = EditSourceDialog.access$getUseAuthentication$p(this.this$0);
                if (cell == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"useAuthentication");
                    cell = null;
                }
                row2.enabledIf(ButtonKt.getSelected((Cell)cell));
                Row row3 = $this$panel.row("Password:", (Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ EditSourceDialog this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        $this$row.cell((JComponent)EditSourceDialog.access$getPasswordField$p(this.this$0)).align((Align)AlignX.FILL.INSTANCE);
                    }
                });
                Cell cell2 = EditSourceDialog.access$getUseAuthentication$p(this.this$0);
                if (cell2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"useAuthentication");
                    cell2 = null;
                }
                row3.enabledIf(ButtonKt.getSelected((Cell)cell2));
            }
        }));
    }

    public static final /* synthetic */ JTextField access$getNameField$p(EditSourceDialog $this) {
        return $this.nameField;
    }

    public static final /* synthetic */ JTextField access$getUrlField$p(EditSourceDialog $this) {
        return $this.urlField;
    }

    public static final /* synthetic */ void access$setUseAuthentication$p(EditSourceDialog $this, Cell cell) {
        $this.useAuthentication = cell;
    }

    public static final /* synthetic */ PasswordAuthentication access$getExistingAuth$p(EditSourceDialog $this) {
        return $this.existingAuth;
    }

    public static final /* synthetic */ JTextField access$getLoginField$p(EditSourceDialog $this) {
        return $this.loginField;
    }

    public static final /* synthetic */ Cell access$getUseAuthentication$p(EditSourceDialog $this) {
        return $this.useAuthentication;
    }

    public static final /* synthetic */ JPasswordField access$getPasswordField$p(EditSourceDialog $this) {
        return $this.passwordField;
    }
}

