/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.screenshot;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.ui.AndroidAdbUiBundle;
import com.android.tools.idea.ui.screenshot.FramingOption;
import com.android.tools.idea.ui.screenshot.ScreenshotImage;
import com.android.tools.idea.ui.screenshot.ScreenshotPostprocessor;
import com.android.tools.idea.ui.screenshot.ScreenshotSupplier;
import com.android.tools.idea.ui.screenshot.ScreenshotTask;
import com.android.tools.pixelprobe.color.Colors;
import com.android.utils.HashCodes;
import com.google.common.base.Preconditions;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.Deflater;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.intellij.images.editor.ImageFileEditor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.w3c.dom.Node;

public class ScreenshotViewer
extends DialogWrapper
implements DataProvider {
    @NonNls
    private static final String SCREENSHOT_VIEWER_DIMENSIONS_KEY = "ScreenshotViewer.Dimensions";
    @NonNls
    private static final String SCREENSHOT_SAVE_PATH_KEY = "ScreenshotViewer.SavePath";
    private static final String HELP_PREFIX = "org.jetbrains.android.";
    public static final int MINIMUM_WEAR_PLAY_COMPATIBLE_SCREENSHOT_SIZE_PIXELS = 384;
    @NotNull
    private final SimpleDateFormat myTimestampFormat;
    @NotNull
    private final Project myProject;
    @Nullable
    private final ScreenshotSupplier myScreenshotSupplier;
    @Nullable
    private final ScreenshotPostprocessor myScreenshotPostprocessor;
    @NotNull
    private final VirtualFile myBackingFile;
    @NotNull
    private final ImageFileEditor myImageFileEditor;
    @NotNull
    private final FileEditorProvider myEditorProvider;
    @NotNull
    private final PersistentState myPersistentStorage;
    @NotNull
    private JPanel myPanel;
    @NotNull
    private JButton myRefreshButton;
    @NotNull
    private JButton myRotateRightButton;
    @NotNull
    private JButton myRotateLeftButton;
    @NotNull
    private JPanel myContentPane;
    @NotNull
    private JComboBox<DecorationOption> myDecorationComboBox;
    @NotNull
    private JButton myCopyButton;
    private int myRotationQuadrants;
    private final AtomicReference<ScreenshotImage> mySourceImageRef;
    private final AtomicReference<BufferedImage> myDisplayedImageRef;
    @Nullable
    private Path myScreenshotFile;

    public ScreenshotViewer(@NotNull Project project, @NotNull ScreenshotImage screenshotImage, @NotNull Path backingFile, @Nullable ScreenshotSupplier screenshotSupplier, @Nullable ScreenshotPostprocessor screenshotPostprocessor, @NotNull List<? extends FramingOption> framingOptions, int defaultFramingOption, @NotNull Set<Option> screenshotViewerOptions) {
        super(project, true);
        this.$$$setupUI$$$();
        this.myTimestampFormat = new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.ROOT);
        this.mySourceImageRef = new AtomicReference();
        this.myDisplayedImageRef = new AtomicReference();
        Preconditions.checkArgument((framingOptions.isEmpty() || screenshotPostprocessor != null ? 1 : 0) != 0);
        Preconditions.checkArgument((framingOptions.isEmpty() || defaultFramingOption >= 0 && defaultFramingOption < framingOptions.size() ? 1 : 0) != 0);
        this.setModal(false);
        this.setTitle(AndroidAdbUiBundle.message("screenshot.action.title", new Object[0]));
        this.myProject = project;
        this.myScreenshotSupplier = screenshotSupplier;
        this.myScreenshotPostprocessor = screenshotPostprocessor;
        this.mySourceImageRef.set(screenshotImage);
        this.myRotationQuadrants = screenshotImage.getScreenshotRotationQuadrants();
        this.myDisplayedImageRef.set(screenshotImage.getImage());
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(backingFile);
        assert (virtualFile != null);
        this.myBackingFile = virtualFile;
        if (screenshotSupplier == null) {
            this.hideComponent(this.myRefreshButton);
        } else {
            this.myRefreshButton.setIcon(AllIcons.Actions.Refresh);
        }
        this.myEditorProvider = this.getImageFileEditorProvider();
        this.myImageFileEditor = (ImageFileEditor)this.myEditorProvider.createEditor(this.myProject, this.myBackingFile);
        this.myContentPane.setLayout(new BorderLayout());
        this.myContentPane.add((Component)this.myImageFileEditor.getComponent(), "Center");
        this.myPersistentStorage = PersistentState.getInstance(this.myProject);
        if (screenshotPostprocessor == null) {
            this.hideComponent(this.myDecorationComboBox);
        } else {
            boolean isPlayCompatibleWearScreenshot;
            boolean canClipDeviceMask;
            DefaultComboBoxModel<DecorationOption> decorationOptions = new DefaultComboBoxModel<DecorationOption>();
            decorationOptions.addElement(DecorationOption.RECTANGULAR);
            boolean bl = canClipDeviceMask = screenshotPostprocessor.getCanClipToDisplayShape() || screenshotImage.isRoundDisplay();
            if (canClipDeviceMask) {
                decorationOptions.addElement(DecorationOption.DISPLAY_SHAPE_CLIP);
            }
            boolean bl2 = isPlayCompatibleWearScreenshot = (Boolean)StudioFlags.PLAY_COMPATIBLE_WEAR_SCREENSHOTS_ENABLED.get() != false && screenshotImage.isWear();
            if (isPlayCompatibleWearScreenshot) {
                decorationOptions.addElement(DecorationOption.PLAY_COMPATIBLE);
            }
            int frameOptionStartIndex = decorationOptions.getSize();
            for (FramingOption framingOption : framingOptions) {
                decorationOptions.addElement(new DecorationOption(framingOption));
            }
            this.myDecorationComboBox.setModel(decorationOptions);
            if (this.myPersistentStorage.frameScreenshot) {
                this.myDecorationComboBox.setSelectedIndex(defaultFramingOption + frameOptionStartIndex);
            } else if (canClipDeviceMask) {
                this.myDecorationComboBox.setSelectedItem(DecorationOption.DISPLAY_SHAPE_CLIP);
            } else if (isPlayCompatibleWearScreenshot) {
                this.myDecorationComboBox.setSelectedItem(DecorationOption.PLAY_COMPATIBLE);
            } else {
                this.myDecorationComboBox.setSelectedItem(DecorationOption.RECTANGULAR);
            }
            ActionListener decorationListener = event2 -> {
                this.myPersistentStorage.frameScreenshot = ((DecorationOption)decorationOptions.getSelectedItem()).getFramingOption() != null;
                this.updateImageFrame();
            };
            this.myDecorationComboBox.addActionListener(decorationListener);
        }
        this.myRefreshButton.addActionListener(event2 -> this.doRefreshScreenshot());
        if (screenshotViewerOptions.contains((Object)Option.ALLOW_IMAGE_ROTATION)) {
            this.myRotateLeftButton.addActionListener(event2 -> this.updateImageRotation(1));
            this.myRotateRightButton.addActionListener(event2 -> this.updateImageRotation(3));
        } else {
            this.hideComponent(this.myRotateLeftButton);
            this.hideComponent(this.myRotateRightButton);
        }
        this.myCopyButton.addActionListener(event2 -> {
            BufferedImage currentImage = this.myImageFileEditor.getImageEditor().getDocument().getValue();
            CopyPasteManager.getInstance().setContents((Transferable)new BufferedImageTransferable(currentImage));
            NotificationGroup group2 = NotificationGroup.findRegisteredGroup((String)"Screen Capture");
            assert (group2 != null);
            Notifications.Bus.notify((Notification)group2.createNotification(AndroidAdbUiBundle.message("screenshot.notification.copied.to.clipboard", new Object[0]), NotificationType.INFORMATION), (Project)project);
        });
        this.updateEditorImage();
        this.init();
        this.updateImageFrame();
    }

    private void hideComponent(@NotNull Component component2) {
        component2.getParent().remove(component2);
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        return this.myImageFileEditor.getComponent();
    }

    protected void dispose() {
        this.myEditorProvider.disposeEditor((FileEditor)this.myImageFileEditor);
        try {
            ApplicationManager.getApplication().runWriteAction(() -> {
                try {
                    this.myBackingFile.delete((Object)this);
                }
                catch (IOException e) {
                    ScreenshotViewer.logger().error((Throwable)e);
                }
            });
        }
        finally {
            super.dispose();
        }
    }

    private void doRefreshScreenshot() {
        assert (this.myScreenshotSupplier != null);
        new ScreenshotTask(this.myProject, this.myScreenshotSupplier){

            public void onSuccess() {
                String msg = this.getError();
                if (msg != null) {
                    Messages.showErrorDialog((Project)this.myProject, (String)msg, (String)AndroidAdbUiBundle.message("screenshot.action.title", new Object[0]));
                    return;
                }
                ScreenshotImage screenshotImage = this.getScreenshot();
                ScreenshotViewer.this.mySourceImageRef.set(screenshotImage);
                ScreenshotViewer.this.processScreenshot(ScreenshotViewer.this.myRotationQuadrants);
            }
        }.queue();
    }

    private void updateImageRotation(int numQuadrants) {
        this.myRotationQuadrants = this.myRotationQuadrants + numQuadrants & 3;
        this.processScreenshot(numQuadrants);
    }

    private void updateImageFrame() {
        this.processScreenshot(0);
    }

    private void processScreenshot(int rotationQuadrants) {
        ScreenshotImage rotatedImage = this.mySourceImageRef.get().rotated(rotationQuadrants);
        BufferedImage processedImage = this.processImage(rotatedImage);
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            Path file2 = VfsUtilCore.virtualToIoFile((VirtualFile)this.myBackingFile).toPath();
            try {
                ScreenshotViewer.writePng(processedImage, file2);
                this.myBackingFile.refresh(false, false);
            }
            catch (IOException e) {
                ScreenshotViewer.logger().error("Unexpected error while writing to " + file2, (Throwable)e);
            }
        });
        this.mySourceImageRef.set(rotatedImage);
        this.myDisplayedImageRef.set(processedImage);
        this.updateEditorImage();
    }

    private BufferedImage processImage(ScreenshotImage sourceImage) {
        boolean isPlayCompatible;
        int height;
        int width;
        if (this.myScreenshotPostprocessor == null) {
            return sourceImage.getImage();
        }
        DecorationOption selectedDecoration = (DecorationOption)Objects.requireNonNull(this.myDecorationComboBox.getSelectedItem());
        FramingOption framingOption = selectedDecoration.getFramingOption();
        Color backgroundColor = null;
        if (selectedDecoration.equals(DecorationOption.RECTANGULAR) || selectedDecoration.equals(DecorationOption.PLAY_COMPATIBLE)) {
            backgroundColor = Color.BLACK;
        }
        boolean isOneToOneRatio = (width = sourceImage.getImage().getWidth()) == (height = sourceImage.getImage().getHeight());
        boolean bl = isPlayCompatible = isOneToOneRatio && width >= 384;
        if (selectedDecoration.equals(DecorationOption.PLAY_COMPATIBLE) && !isPlayCompatible) {
            int outputSize = Math.max(Math.max(width, height), 384);
            return this.myScreenshotPostprocessor.addFrame(sourceImage, framingOption, backgroundColor, new Dimension(outputSize, outputSize));
        }
        return this.myScreenshotPostprocessor.addFrame(sourceImage, framingOption, backgroundColor);
    }

    @VisibleForTesting
    void updateEditorImage() {
        BufferedImage image = this.myDisplayedImageRef.get();
        this.myImageFileEditor.getImageEditor().getDocument().setValue(image);
        this.pack();
        IdeFocusManager.getInstance((Project)this.myProject).requestFocusInProject((Component)this.getPreferredFocusedComponent(), this.myProject);
    }

    @NotNull
    private FileEditorProvider getImageFileEditorProvider() {
        List providers = FileEditorProviderManager.getInstance().getProviderList(this.myProject, this.myBackingFile);
        assert (!providers.isEmpty());
        for (FileEditorProvider p : providers) {
            if (!p.getEditorTypeId().equals("images")) continue;
            return p;
        }
        return (FileEditorProvider)providers.get(0);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @NonNls
    @NotNull
    protected String getDimensionServiceKey() {
        return SCREENSHOT_VIEWER_DIMENSIONS_KEY;
    }

    @Nullable
    public Object getData(@NonNls @NotNull String dataId) {
        return PlatformCoreDataKeys.FILE_EDITOR.is(dataId) ? this.myImageFileEditor : null;
    }

    @NotNull
    protected String getHelpId() {
        return "org.jetbrains.android.r/studio-ui/am-screenshot.html";
    }

    protected void createDefaultActions() {
        super.createDefaultActions();
        this.getOKAction().putValue("Name", AndroidAdbUiBundle.message("screenshot.dialog.ok.button.text", new Object[0]));
    }

    protected void doOKAction() {
        VirtualFile baseDir2;
        FileSaverDescriptor descriptor2 = new FileSaverDescriptor(AndroidAdbUiBundle.message("screenshot.dialog.title", new Object[0]), "", new String[]{"png"});
        FileSaverDialog saveFileDialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor2, this.myProject);
        VirtualFileWrapper fileWrapper2 = saveFileDialog.save(baseDir2 = this.loadScreenshotPath(), this.adjustedFileName(this.getDefaultFileName()));
        if (fileWrapper2 == null) {
            return;
        }
        this.myScreenshotFile = fileWrapper2.getFile().toPath();
        try {
            ScreenshotViewer.writePng(this.myDisplayedImageRef.get(), this.myScreenshotFile);
        }
        catch (IOException e) {
            Messages.showErrorDialog((Project)this.myProject, (String)AndroidAdbUiBundle.message("screenshot.dialog.error", e), (String)AndroidAdbUiBundle.message("screenshot.action.title", new Object[0]));
            return;
        }
        VirtualFile virtualFile = fileWrapper2.getVirtualFile();
        if (virtualFile != null) {
            PropertiesComponent properties2 = PropertiesComponent.getInstance((Project)this.myProject);
            properties2.setValue(SCREENSHOT_SAVE_PATH_KEY, virtualFile.getParent().getPath());
        }
        super.doOKAction();
    }

    @NotNull
    private String adjustedFileName(@NotNull String fileName) {
        return SystemInfo.isMac ? fileName + ".png" : fileName;
    }

    private static void writePng(@NotNull BufferedImage image, @NotNull Path outFile) throws IOException {
        ImageWriter pngWriter = null;
        ImageTypeSpecifier imageType = ImageTypeSpecifier.createFromRenderedImage(image);
        Iterator<ImageWriter> iterator2 = ImageIO.getImageWriters(imageType, "png");
        if (iterator2.hasNext()) {
            pngWriter = iterator2.next();
        }
        if (pngWriter == null) {
            throw new IOException("Failed to find PNG writer");
        }
        try (ImageOutputStream stream = ImageIO.createImageOutputStream(Files.newOutputStream(outFile, new OpenOption[0]));){
            pngWriter.setOutput(stream);
            ColorSpace colorSpace = image.getColorModel().getColorSpace();
            if (colorSpace instanceof ICC_ColorSpace) {
                ICC_ColorSpace colorSpace2 = (ICC_ColorSpace)colorSpace;
                ImageTypeSpecifier type = ImageTypeSpecifier.createFromRenderedImage(image);
                ImageWriteParam writeParams = pngWriter.getDefaultWriteParam();
                IIOMetadata metadata = pngWriter.getDefaultImageMetadata(type, writeParams);
                Node node = metadata.getAsTree("javax_imageio_png_1.0");
                IIOMetadataNode metadataNode = new IIOMetadataNode("iCCP");
                metadataNode.setUserObject(ScreenshotViewer.deflate(colorSpace2.getProfile().getData()));
                metadataNode.setAttribute("profileName", Colors.getIccProfileDescription((ICC_Profile)colorSpace2.getProfile()));
                metadataNode.setAttribute("compressionMethod", "deflate");
                node.appendChild(metadataNode);
                metadata.setFromTree("javax_imageio_png_1.0", node);
                pngWriter.write(new IIOImage(image, null, metadata));
            } else {
                pngWriter.write(image);
            }
            pngWriter.dispose();
        }
        catch (IOException e) {
            Files.deleteIfExists(outFile);
        }
    }

    private static byte[] deflate(byte[] data) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(data.length);
        Deflater deflater = new Deflater();
        deflater.setInput(data);
        deflater.finish();
        byte[] buffer = new byte[4096];
        while (!deflater.finished()) {
            int count2 = deflater.deflate(buffer);
            out.write(buffer, 0, count2);
        }
        data = out.toByteArray();
        return data;
    }

    @NotNull
    private String getDefaultFileName() {
        Date timestamp = new Date();
        String timestampSuffix = this.myTimestampFormat.format(timestamp);
        return String.format("Screenshot_%s", timestampSuffix);
    }

    @Nullable
    public Path getScreenshot() {
        return this.myScreenshotFile;
    }

    @Nullable
    private VirtualFile loadScreenshotPath() {
        PropertiesComponent properties2 = PropertiesComponent.getInstance((Project)this.myProject);
        String lastPath = properties2.getValue(SCREENSHOT_SAVE_PATH_KEY);
        if (lastPath != null) {
            return LocalFileSystem.getInstance().findFileByPath(lastPath);
        }
        return ProjectUtil.guessProjectDir((Project)this.myProject);
    }

    @NotNull
    private static Logger logger() {
        return Logger.getInstance(ScreenshotViewer.class);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JButton jButton4;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 6, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 2, 0, 1, 6, 0, null, null, null));
        this.myRefreshButton = jButton4 = new JButton();
        jButton4.setText("Recapture");
        jPanel3.add((Component)jButton4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 3, null, new Dimension(66, 26), null));
        this.myRotateRightButton = jButton3 = new JButton();
        ((Component)jButton3).setEnabled(true);
        jButton3.setText("Rotate Right");
        jPanel3.add((Component)jButton3, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 4, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myRotateLeftButton = jButton2 = new JButton();
        jButton2.setText("Rotate Left");
        jPanel3.add((Component)jButton2, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 3, null, null, null));
        this.myCopyButton = jButton = new JButton();
        jButton.setText("Copy to Clipboard");
        jPanel3.add((Component)jButton, new GridConstraints(0, 3, 1, 1, 8, 0, 0, 3, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myDecorationComboBox = jComboBox;
        jPanel3.add(jComboBox, new GridConstraints(0, 5, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myContentPane = jPanel = new JPanel();
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 2, 0, 3, 7, 7, new Dimension(400, 600), null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    @State(name="ScreenshotViewer", storages={@Storage(value="other.xml")})
    public static class PersistentState
    implements PersistentStateComponent<PersistentState> {
        public boolean frameScreenshot;

        @Nullable
        public PersistentState getState() {
            return this;
        }

        public void loadState(@NotNull PersistentState state2) {
            XmlSerializerUtil.copyBean((Object)state2, (Object)this);
        }

        public static PersistentState getInstance(@NotNull Project project) {
            return (PersistentState)project.getService(PersistentState.class);
        }
    }

    private static final class DecorationOption {
        private static final DecorationOption RECTANGULAR = new DecorationOption(AndroidAdbUiBundle.message("screenshot.dialog.decoration.rectangular", new Object[0]));
        private static final DecorationOption DISPLAY_SHAPE_CLIP = new DecorationOption(AndroidAdbUiBundle.message("screenshot.dialog.decoration.display.shape", new Object[0]));
        private static final DecorationOption PLAY_COMPATIBLE = new DecorationOption(AndroidAdbUiBundle.message("screenshot.dialog.decoration.display.play-compatible", new Object[0]));
        @Nullable
        private final String myClipAction;
        @Nullable
        private final FramingOption myFramingOption;

        public DecorationOption(@NotNull FramingOption framingOption) {
            this.myClipAction = null;
            this.myFramingOption = framingOption;
        }

        private DecorationOption(@NotNull String clipAction) {
            this.myClipAction = clipAction;
            this.myFramingOption = null;
        }

        @Nullable
        public FramingOption getFramingOption() {
            return this.myFramingOption;
        }

        @NotNull
        public String toString() {
            return this.myFramingOption != null ? this.myFramingOption.getDisplayName() : this.myClipAction;
        }

        public int hashCode() {
            return HashCodes.mix((int)Objects.hashCode(this.myClipAction), (int)Objects.hashCode(this.myFramingOption));
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            DecorationOption other = (DecorationOption)obj;
            return Objects.equals(this.myClipAction, other.myClipAction) && Objects.equals(this.myFramingOption, other.myFramingOption);
        }
    }

    public static enum Option {
        ALLOW_IMAGE_ROTATION;

    }

    private static class BufferedImageTransferable
    implements Transferable {
        @NotNull
        private final BufferedImage myImage;

        public BufferedImageTransferable(@NotNull BufferedImage image) {
            this.myImage = image;
        }

        @Override
        @NotNull
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.imageFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(@NotNull DataFlavor dataFlavor) {
            return DataFlavor.imageFlavor.equals(dataFlavor);
        }

        @Override
        @NotNull
        public BufferedImage getTransferData(@NotNull DataFlavor dataFlavor) throws UnsupportedFlavorException {
            if (!DataFlavor.imageFlavor.equals(dataFlavor)) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            return this.myImage;
        }
    }
}

