/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.screenshot;

import com.android.io.Images;
import com.android.tools.idea.ui.AndroidAdbUiBundle;
import com.android.tools.idea.ui.screenshot.AdbScreenCapScreenshotSupplier;
import com.android.tools.idea.ui.screenshot.DeviceType;
import com.android.tools.idea.ui.screenshot.FramingOption;
import com.android.tools.idea.ui.screenshot.ScreenshotAction;
import com.android.tools.idea.ui.screenshot.ScreenshotImage;
import com.android.tools.idea.ui.screenshot.ScreenshotPostprocessor;
import com.android.tools.idea.ui.screenshot.ScreenshotTask;
import com.android.tools.idea.ui.screenshot.ScreenshotViewer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import icons.StudioIcons;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \b2\u00020\u0001:\u0002\b\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/ui/screenshot/ScreenshotAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "Companion", "ScreenshotOptions", "intellij.android.adb.ui"})
public final class ScreenshotAction
extends DumbAwareAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final DataKey<ScreenshotOptions> SCREENSHOT_OPTIONS_KEY;

    public ScreenshotAction() {
        super(AndroidAdbUiBundle.message("screenshot.action.title", new Object[0]), AndroidAdbUiBundle.message("screenshot.action.description", new Object[0]), StudioIcons.Common.SCREENSHOT);
    }

    public void update(@NotNull AnActionEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        event2.getPresentation().setEnabled(event2.getData(SCREENSHOT_OPTIONS_KEY) != null);
    }

    public void actionPerformed(@NotNull AnActionEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        Project project = event2.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        ScreenshotOptions screenshotOptions = (ScreenshotOptions)event2.getData(SCREENSHOT_OPTIONS_KEY);
        if (screenshotOptions == null) {
            return;
        }
        ScreenshotOptions screenshotOptions2 = screenshotOptions;
        String serialNumber = screenshotOptions2.getSerialNumber();
        AdbScreenCapScreenshotSupplier screenshotSupplier = new AdbScreenCapScreenshotSupplier(project2, serialNumber, screenshotOptions2);
        Ref.ObjectRef disposable2 = new Ref.ObjectRef();
        disposable2.element = screenshotSupplier;
        new ScreenshotTask(project2, screenshotSupplier, screenshotOptions2, (Ref.ObjectRef<Disposable>)disposable2){
            final /* synthetic */ Project $project;
            final /* synthetic */ AdbScreenCapScreenshotSupplier $screenshotSupplier;
            final /* synthetic */ ScreenshotOptions $screenshotOptions;
            final /* synthetic */ Ref.ObjectRef<Disposable> $disposable;
            {
                this.$project = $project;
                this.$screenshotSupplier = $screenshotSupplier;
                this.$screenshotOptions = $screenshotOptions;
                this.$disposable = $disposable;
                super($project, $screenshotSupplier);
            }

            public void onSuccess() {
                String string = this.getError();
                if (string != null) {
                    String string2 = string;
                    Project project = this.$project;
                    String msg = string2;
                    boolean bl = false;
                    Messages.showErrorDialog((Project)project, (String)msg, (String)AndroidAdbUiBundle.message("screenshot.action.title", new Object[0]));
                    return;
                }
                try {
                    Path backingFile = FileUtil.createTempFile((String)"screenshot", (String)".png").toPath();
                    ScreenshotImage screenshotImage = this.getScreenshot();
                    Intrinsics.checkNotNull((Object)screenshotImage);
                    ScreenshotImage screenshotImage2 = screenshotImage;
                    RenderedImage renderedImage = screenshotImage2.getImage();
                    Intrinsics.checkNotNullExpressionValue((Object)backingFile, (String)"backingFile");
                    Images.writeImage((RenderedImage)renderedImage, (String)"png", (Path)backingFile);
                    ScreenshotPostprocessor screenshotPostprocessor = this.$screenshotOptions.getScreenshotPostprocessor();
                    List<FramingOption> framingOptions = this.$screenshotOptions.getFramingOptions(screenshotImage2);
                    int defaultFrame = !((Collection)framingOptions).isEmpty() ? this.$screenshotOptions.getDefaultFramingOption(framingOptions, screenshotImage2) : 0;
                    Set<ScreenshotViewer.Option> set = this.$screenshotOptions.getScreenshotViewerOptions();
                    ScreenshotViewer viewer2 = new ScreenshotViewer(this.$project, screenshotImage2, backingFile, this.$screenshotSupplier, screenshotPostprocessor, framingOptions, defaultFrame, set){
                        final /* synthetic */ Project $project;
                        {
                            this.$project = $project;
                            super($project, $screenshotImage, $backingFile, $screenshotSupplier, $screenshotPostprocessor, $framingOptions, $defaultFrame, $super_call_param$1);
                        }

                        protected void doOKAction() {
                            block1: {
                                super.doOKAction();
                                Path path2 = this.getScreenshot();
                                if (path2 == null) break block1;
                                Path path3 = path2;
                                Project project = this.$project;
                                Path it = path3;
                                boolean bl = false;
                                VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(it);
                                if (virtualFile != null) {
                                    VirtualFile virtualFile2 = virtualFile;
                                    boolean bl2 = false;
                                    virtualFile2.refresh(false, false);
                                    FileEditorManager.getInstance((Project)project).openFile(virtualFile2, true);
                                }
                            }
                        }
                    };
                    viewer2.show();
                    Disposer.register((Disposable)viewer2.getDisposable(), (Disposable)this.$screenshotSupplier);
                    this.$disposable.element = null;
                }
                catch (Exception e) {
                    actionPerformed.1 $this$thisLogger$iv = this;
                    boolean $i$f$thisLogger = false;
                    Logger logger2 = Logger.getInstance(actionPerformed.1.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(T::class.java)");
                    logger2.warn("Error while displaying screenshot viewer: ", (Throwable)e);
                    Object[] objectArray = new Object[]{e};
                    Messages.showErrorDialog((Project)this.$project, (String)AndroidAdbUiBundle.message("screenshot.error.generic", objectArray), (String)AndroidAdbUiBundle.message("screenshot.action.title", new Object[0]));
                }
            }

            public void onFinished() {
                block0: {
                    Disposable disposable2 = (Disposable)this.$disposable.element;
                    if (disposable2 == null) break block0;
                    Disposable it = disposable2;
                    boolean bl = false;
                    Disposer.dispose((Disposable)it);
                }
            }
        }.queue();
    }

    static {
        DataKey dataKey = DataKey.create((String)"ScreenshotOptions");
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"create<ScreenshotOptions>(\"ScreenshotOptions\")");
        SCREENSHOT_OPTIONS_KEY = dataKey;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R$\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/ui/screenshot/ScreenshotAction$Companion;", "", "()V", "SCREENSHOT_OPTIONS_KEY", "Lcom/intellij/openapi/actionSystem/DataKey;", "Lcom/android/tools/idea/ui/screenshot/ScreenshotAction$ScreenshotOptions;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getSCREENSHOT_OPTIONS_KEY", "()Lcom/intellij/openapi/actionSystem/DataKey;", "intellij.android.adb.ui"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataKey<ScreenshotOptions> getSCREENSHOT_OPTIONS_KEY() {
            return SCREENSHOT_OPTIONS_KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H&J\u001e\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u0010H&J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u0010H&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001d\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/idea/ui/screenshot/ScreenshotAction$ScreenshotOptions;", "", "screenshotPostprocessor", "Lcom/android/tools/idea/ui/screenshot/ScreenshotPostprocessor;", "getScreenshotPostprocessor", "()Lcom/android/tools/idea/ui/screenshot/ScreenshotPostprocessor;", "screenshotViewerOptions", "", "Lcom/android/tools/idea/ui/screenshot/ScreenshotViewer$Option;", "getScreenshotViewerOptions", "()Ljava/util/Set;", "serialNumber", "", "getSerialNumber", "()Ljava/lang/String;", "createScreenshotImage", "Lcom/android/tools/idea/ui/screenshot/ScreenshotImage;", "image", "Ljava/awt/image/BufferedImage;", "displayInfo", "deviceType", "Lcom/android/tools/idea/ui/screenshot/DeviceType;", "getDefaultFramingOption", "", "framingOptions", "", "Lcom/android/tools/idea/ui/screenshot/FramingOption;", "screenshotImage", "getFramingOptions", "intellij.android.adb.ui"})
    public static interface ScreenshotOptions {
        @NotNull
        public String getSerialNumber();

        @NotNull
        public Set<ScreenshotViewer.Option> getScreenshotViewerOptions();

        @NotNull
        public ScreenshotPostprocessor getScreenshotPostprocessor();

        @NotNull
        public ScreenshotImage createScreenshotImage(@NotNull BufferedImage var1, @NotNull String var2, @NotNull DeviceType var3);

        @NotNull
        public List<FramingOption> getFramingOptions(@NotNull ScreenshotImage var1);

        public int getDefaultFramingOption(@NotNull List<? extends FramingOption> var1, @NotNull ScreenshotImage var2);
    }
}

