/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.screenshot;

import com.android.annotations.concurrency.Slow;
import com.android.tools.adtui.ImageUtils;
import com.android.tools.adtui.device.DeviceArtDescriptor;
import com.android.tools.adtui.device.DeviceArtPainter;
import com.android.tools.idea.ui.screenshot.DeviceArtFramingOption;
import com.android.tools.idea.ui.screenshot.FramingOption;
import com.android.tools.idea.ui.screenshot.ScreenshotImage;
import com.android.tools.idea.ui.screenshot.ScreenshotPostprocessor;
import com.intellij.util.ui.ImageUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0017J\u001a\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/ui/screenshot/DeviceArtScreenshotPostprocessor;", "Lcom/android/tools/idea/ui/screenshot/ScreenshotPostprocessor;", "()V", "canClipToDisplayShape", "", "getCanClipToDisplayShape", "()Z", "addFrame", "Ljava/awt/image/BufferedImage;", "screenshotImage", "Lcom/android/tools/idea/ui/screenshot/ScreenshotImage;", "framingOption", "Lcom/android/tools/idea/ui/screenshot/FramingOption;", "backgroundColor", "Ljava/awt/Color;", "circularClip", "image", "intellij.android.adb.ui"})
public final class DeviceArtScreenshotPostprocessor
implements ScreenshotPostprocessor {
    @Override
    @Slow
    @NotNull
    public BufferedImage addFrame(@NotNull ScreenshotImage screenshotImage, @Nullable FramingOption framingOption, @Nullable Color backgroundColor) {
        Intrinsics.checkNotNullParameter((Object)screenshotImage, (String)"screenshotImage");
        if (framingOption == null) {
            return screenshotImage.isRoundDisplay() ? this.circularClip(screenshotImage.getImage(), backgroundColor) : screenshotImage.getImage();
        }
        DeviceArtDescriptor frameDescriptor = ((DeviceArtFramingOption)framingOption).getDeviceArtDescriptor();
        BufferedImage bufferedImage = DeviceArtPainter.createFrame((BufferedImage)screenshotImage.getImage(), (DeviceArtDescriptor)frameDescriptor);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"createFrame(screenshotIm\u2026e.image, frameDescriptor)");
        BufferedImage framedImage = bufferedImage;
        BufferedImage bufferedImage2 = ImageUtils.cropBlank((BufferedImage)framedImage, null);
        if (bufferedImage2 == null) {
            throw new IllegalArgumentException("The screenshot is completely transparent");
        }
        return bufferedImage2;
    }

    @Override
    public boolean getCanClipToDisplayShape() {
        return false;
    }

    private final BufferedImage circularClip(BufferedImage image, Color backgroundColor) {
        Graphics2D graphics2D;
        Graphics2D graphics2D2;
        BufferedImage mask = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        Graphics2D $this$circularClip_u24lambda_u240 = graphics2D2 = mask.createGraphics();
        boolean bl = false;
        ImageUtil.applyQualityRenderingHints((Graphics2D)$this$circularClip_u24lambda_u240);
        double diameter = Math.max(image.getWidth(), image.getHeight());
        $this$circularClip_u24lambda_u240.fill(new Area(new Ellipse2D.Double(0.0, 0.0, diameter, diameter)));
        $this$circularClip_u24lambda_u240.dispose();
        BufferedImage shapedImage = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        Graphics2D $this$circularClip_u24lambda_u241 = graphics2D = shapedImage.createGraphics();
        boolean bl2 = false;
        ImageUtil.applyQualityRenderingHints((Graphics2D)$this$circularClip_u24lambda_u241);
        $this$circularClip_u24lambda_u241.drawImage((Image)image, 0, 0, null);
        $this$circularClip_u24lambda_u241.setComposite(AlphaComposite.getInstance(6));
        $this$circularClip_u24lambda_u241.drawImage((Image)mask, 0, 0, null);
        if (backgroundColor != null) {
            $this$circularClip_u24lambda_u241.setColor(backgroundColor);
            $this$circularClip_u24lambda_u241.setComposite(AlphaComposite.getInstance(4));
            $this$circularClip_u24lambda_u241.fillRect(0, 0, image.getWidth(), image.getHeight());
        }
        $this$circularClip_u24lambda_u241.dispose();
        return shapedImage;
    }
}

