/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.screenshot;

import com.android.resources.ScreenOrientation;
import com.android.tools.adtui.device.DeviceArtDescriptor;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.ui.screenshot.DeviceArtFramingOption;
import com.android.tools.idea.ui.screenshot.DeviceArtScreenshotPostprocessor;
import com.android.tools.idea.ui.screenshot.DeviceType;
import com.android.tools.idea.ui.screenshot.FramingOption;
import com.android.tools.idea.ui.screenshot.ScreenshotAction;
import com.android.tools.idea.ui.screenshot.ScreenshotImage;
import com.android.tools.idea.ui.screenshot.ScreenshotPostprocessor;
import com.android.tools.idea.ui.screenshot.ScreenshotViewer;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u001e\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u0004\u001a\u00020\u0003H\u0002J\u001e\u0010\u001e\u001a\u00020\u001a2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010 \u001a\u00020\u0013H\u0016J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010 \u001a\u00020\u0013H\u0016J\u0014\u0010\"\u001a\u00020#*\u00020$2\u0006\u0010 \u001a\u00020\u0013H\u0002R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007\u00a8\u0006%"}, d2={"Lcom/android/tools/idea/ui/screenshot/DeviceArtScreenshotOptions;", "Lcom/android/tools/idea/ui/screenshot/ScreenshotAction$ScreenshotOptions;", "serialNumber", "", "deviceModel", "(Ljava/lang/String;Ljava/lang/String;)V", "getDeviceModel", "()Ljava/lang/String;", "screenshotPostprocessor", "Lcom/android/tools/idea/ui/screenshot/ScreenshotPostprocessor;", "getScreenshotPostprocessor", "()Lcom/android/tools/idea/ui/screenshot/ScreenshotPostprocessor;", "screenshotViewerOptions", "Ljava/util/EnumSet;", "Lcom/android/tools/idea/ui/screenshot/ScreenshotViewer$Option;", "getScreenshotViewerOptions", "()Ljava/util/EnumSet;", "getSerialNumber", "createScreenshotImage", "Lcom/android/tools/idea/ui/screenshot/ScreenshotImage;", "image", "Ljava/awt/image/BufferedImage;", "displayInfo", "deviceType", "Lcom/android/tools/idea/ui/screenshot/DeviceType;", "findFrameIndexForDeviceModel", "", "frames", "", "Lcom/android/tools/idea/ui/screenshot/FramingOption;", "getDefaultFramingOption", "framingOptions", "screenshotImage", "getFramingOptions", "isCompatible", "", "Lcom/android/tools/adtui/device/DeviceArtDescriptor;", "intellij.android.adb.ui"})
@SourceDebugExtension(value={"SMAP\nDeviceArtScreenshotOptions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeviceArtScreenshotOptions.kt\ncom/android/tools/idea/ui/screenshot/DeviceArtScreenshotOptions\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,84:1\n766#2:85\n857#2,2:86\n766#2:88\n857#2,2:89\n1549#2:91\n1620#2,3:92\n350#2,7:95\n*S KotlinDebug\n*F\n+ 1 DeviceArtScreenshotOptions.kt\ncom/android/tools/idea/ui/screenshot/DeviceArtScreenshotOptions\n*L\n48#1:85\n48#1:86,2\n49#1:88\n49#1:89,2\n50#1:91\n50#1:92,3\n68#1:95,7\n*E\n"})
public final class DeviceArtScreenshotOptions
implements ScreenshotAction.ScreenshotOptions {
    @NotNull
    private final String serialNumber;
    @Nullable
    private final String deviceModel;
    @NotNull
    private final EnumSet<ScreenshotViewer.Option> screenshotViewerOptions;
    @NotNull
    private final ScreenshotPostprocessor screenshotPostprocessor;

    public DeviceArtScreenshotOptions(@NotNull String serialNumber, @Nullable String deviceModel) {
        Intrinsics.checkNotNullParameter((Object)serialNumber, (String)"serialNumber");
        this.serialNumber = serialNumber;
        this.deviceModel = deviceModel;
        EnumSet<Enum> enumSet = EnumSet.of((Enum)ScreenshotViewer.Option.ALLOW_IMAGE_ROTATION);
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"of(ALLOW_IMAGE_ROTATION)");
        this.screenshotViewerOptions = enumSet;
        this.screenshotPostprocessor = new DeviceArtScreenshotPostprocessor();
    }

    @Override
    @NotNull
    public String getSerialNumber() {
        return this.serialNumber;
    }

    @Nullable
    public final String getDeviceModel() {
        return this.deviceModel;
    }

    @NotNull
    public EnumSet<ScreenshotViewer.Option> getScreenshotViewerOptions() {
        return this.screenshotViewerOptions;
    }

    @Override
    @NotNull
    public ScreenshotPostprocessor getScreenshotPostprocessor() {
        return this.screenshotPostprocessor;
    }

    @Override
    @NotNull
    public ScreenshotImage createScreenshotImage(@NotNull BufferedImage image, @NotNull String displayInfo, @NotNull DeviceType deviceType) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)displayInfo, (String)"displayInfo");
        Intrinsics.checkNotNullParameter((Object)((Object)deviceType), (String)"deviceType");
        return new ScreenshotImage(image, 0, deviceType, displayInfo);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<FramingOption> getFramingOptions(@NotNull ScreenshotImage screenshotImage) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        DeviceArtDescriptor it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)screenshotImage, (String)"screenshotImage");
        double imgAspectRatio = (double)screenshotImage.getWidth() / (double)screenshotImage.getHeight();
        ScreenOrientation orientation = imgAspectRatio >= 0.99999 ? ScreenOrientation.LANDSCAPE : ScreenOrientation.PORTRAIT;
        List allDescriptors = DeviceArtDescriptor.getDescriptors(null);
        Intrinsics.checkNotNullExpressionValue((Object)allDescriptors, (String)"allDescriptors");
        Iterable iterable = allDescriptors;
        boolean $i$f$filter = false;
        void var8_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (DeviceArtDescriptor)element$iv$iv;
            boolean bl = false;
            if (!it.canFrameImage(screenshotImage.getImage(), orientation)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (DeviceArtDescriptor)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            if (!this.isCompatible(it, screenshotImage)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (DeviceArtDescriptor)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            collection2.add(new DeviceArtFramingOption(it));
        }
        return (List)destination$iv$iv;
    }

    @Override
    public int getDefaultFramingOption(@NotNull List<? extends FramingOption> framingOptions, @NotNull ScreenshotImage screenshotImage) {
        int index2;
        Intrinsics.checkNotNullParameter(framingOptions, (String)"framingOptions");
        Intrinsics.checkNotNullParameter((Object)screenshotImage, (String)"screenshotImage");
        if (this.deviceModel != null && (index2 = this.findFrameIndexForDeviceModel(framingOptions, this.deviceModel)) >= 0) {
            return index2;
        }
        String defaultDevice = Math.min(screenshotImage.getWidth(), screenshotImage.getHeight()) > 1280 ? "Generic Tablet" : "Generic Phone";
        return RangesKt.coerceAtLeast((int)this.findFrameIndexForDeviceModel(framingOptions, defaultDevice), (int)0);
    }

    private final int findFrameIndexForDeviceModel(List<? extends FramingOption> frames, String deviceModel) {
        int n;
        block2: {
            List<? extends FramingOption> $this$indexOfFirst$iv = frames;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<? extends FramingOption> iterator2 = $this$indexOfFirst$iv.iterator();
            while (iterator2.hasNext()) {
                FramingOption item$iv;
                FramingOption it = item$iv = iterator2.next();
                boolean bl = false;
                if (StringsKt.equals((String)it.getDisplayName(), (String)deviceModel, (boolean)true)) {
                    n = index$iv;
                    break block2;
                }
                ++index$iv;
            }
            n = -1;
        }
        return n;
    }

    private final boolean isCompatible(DeviceArtDescriptor $this$isCompatible, ScreenshotImage screenshotImage) {
        if (!((Boolean)StudioFlags.PLAY_COMPATIBLE_WEAR_SCREENSHOTS_ENABLED.get()).booleanValue()) {
            return true;
        }
        if (!screenshotImage.isWear()) {
            return true;
        }
        String compatibleDeviceArtId = screenshotImage.isRoundDisplay() ? "watch_round" : "watch_square";
        return Intrinsics.areEqual((Object)$this$isCompatible.getId(), (Object)compatibleDeviceArtId);
    }
}

