/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.screenrecording;

import com.android.tools.idea.ui.screenrecording.ScreenRecorderOptions;
import com.android.tools.idea.ui.screenrecording.ScreenRecorderPersistentOptionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.awt.Dimension;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ScreenRecorderOptions", storages={@Storage(value="screenRecorderOptions.xml")})
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 \u001e2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0015\u001a\u00020\u0000H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0000H\u0016J\u0018\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u0004R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000f\"\u0004\b\u0014\u0010\u0011\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/idea/ui/screenrecording/ScreenRecorderPersistentOptions;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "()V", "bitRateMbps", "", "getBitRateMbps", "()I", "setBitRateMbps", "(I)V", "resolutionPercent", "getResolutionPercent", "setResolutionPercent", "showTaps", "", "getShowTaps", "()Z", "setShowTaps", "(Z)V", "useEmulatorRecording", "getUseEmulatorRecording", "setUseEmulatorRecording", "getState", "loadState", "", "state", "toScreenRecorderOptions", "Lcom/android/tools/idea/ui/screenrecording/ScreenRecorderOptions;", "size", "Ljava/awt/Dimension;", "timeLimitSec", "Companion", "intellij.android.adb.ui"})
public final class ScreenRecorderPersistentOptions
implements PersistentStateComponent<ScreenRecorderPersistentOptions> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int bitRateMbps = 4;
    private int resolutionPercent = 100;
    private boolean showTaps;
    private boolean useEmulatorRecording = true;

    public final int getBitRateMbps() {
        return this.bitRateMbps;
    }

    public final void setBitRateMbps(int n) {
        this.bitRateMbps = n;
    }

    public final int getResolutionPercent() {
        return this.resolutionPercent;
    }

    public final void setResolutionPercent(int n) {
        this.resolutionPercent = n;
    }

    public final boolean getShowTaps() {
        return this.showTaps;
    }

    public final void setShowTaps(boolean bl) {
        this.showTaps = bl;
    }

    public final boolean getUseEmulatorRecording() {
        return this.useEmulatorRecording;
    }

    public final void setUseEmulatorRecording(boolean bl) {
        this.useEmulatorRecording = bl;
    }

    @NotNull
    public ScreenRecorderPersistentOptions getState() {
        return this;
    }

    public void loadState(@NotNull ScreenRecorderPersistentOptions state2) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        XmlSerializerUtil.copyBean((Object)state2, (Object)this);
    }

    @NotNull
    public final ScreenRecorderOptions toScreenRecorderOptions(@Nullable Dimension size, int timeLimitSec) {
        int width = 0;
        int height = 0;
        if (size != null && this.resolutionPercent != 100) {
            double ratio = (double)this.resolutionPercent / (double)100;
            width = ScreenRecorderPersistentOptionsKt.access$roundToMultipleOf16((double)size.width * ratio);
            height = ScreenRecorderPersistentOptionsKt.access$roundToMultipleOf16((double)size.height * ratio);
        } else {
            width = 0;
            height = 0;
        }
        return new ScreenRecorderOptions(width, height, this.bitRateMbps, this.showTaps, timeLimitSec);
    }

    @JvmStatic
    @NotNull
    public static final ScreenRecorderPersistentOptions getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/idea/ui/screenrecording/ScreenRecorderPersistentOptions$Companion;", "", "()V", "getInstance", "Lcom/android/tools/idea/ui/screenrecording/ScreenRecorderPersistentOptions;", "intellij.android.adb.ui"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ScreenRecorderPersistentOptions getInstance() {
            Object object = ApplicationManager.getApplication().getService(ScreenRecorderPersistentOptions.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getApplication().getServ\u2026stentOptions::class.java)");
            return (ScreenRecorderPersistentOptions)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

