/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.screenrecording;

import com.android.tools.idea.ui.AndroidAdbUiBundle;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.DialogWrapperDialog;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.ui.PopupBorder;
import com.intellij.ui.TitlePanel;
import com.intellij.ui.WindowMoveListener;
import com.intellij.ui.WindowRoundedCornersManager;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Alarm;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Arrays;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u001c\u001a\u00020\u001dH\u0014J\n\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0014J\b\u0010 \u001a\u00020\u000eH\u0002J\n\u0010!\u001a\u0004\u0018\u00010\u001dH\u0014J\b\u0010\"\u001a\u00020#H\u0014J\b\u0010$\u001a\u00020\u0016H\u0002J\u0010\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u0016H\u0002J\b\u0010'\u001a\u00020#H\u0016J\b\u0010(\u001a\u00020#H\u0002J\b\u0010)\u001a\u00020#H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0016@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/android/tools/idea/ui/screenrecording/ScreenRecorderDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "dialogTitle", "", "project", "Lcom/intellij/openapi/project/Project;", "maxRecordingDurationMillis", "", "onStop", "Ljava/lang/Runnable;", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;ILjava/lang/Runnable;)V", "alarm", "Lcom/intellij/util/Alarm;", "panel", "Lcom/intellij/openapi/ui/DialogPanel;", "recordingLabel", "Ljavax/swing/JLabel;", "value", "recordingLabelText", "setRecordingLabelText", "(Ljava/lang/String;)V", "recordingStartTime", "", "recordingTimeMillis", "setRecordingTimeMillis", "(J)V", "stopButton", "Ljavax/swing/JButton;", "createCenterPanel", "Ljavax/swing/JComponent;", "createContentPaneBorder", "Ljavax/swing/border/Border;", "createPanel", "createSouthPanel", "init", "", "millisUntilNextSecondTick", "recordingTimeText", "timeMillis", "show", "stopRecordingTimer", "updateRecordingTime", "intellij.android.adb.ui"})
public final class ScreenRecorderDialog
extends DialogWrapper {
    @NotNull
    private final String dialogTitle;
    private final int maxRecordingDurationMillis;
    @NotNull
    private final Runnable onStop;
    @NotNull
    private final Alarm alarm;
    private long recordingStartTime;
    @NotNull
    private final DialogPanel panel;
    private long recordingTimeMillis;
    @NotNull
    private String recordingLabelText;
    private JLabel recordingLabel;
    private JButton stopButton;

    public ScreenRecorderDialog(@NotNull String dialogTitle, @NotNull Project project, int maxRecordingDurationMillis, @NotNull Runnable onStop) {
        Intrinsics.checkNotNullParameter((Object)dialogTitle, (String)"dialogTitle");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)onStop, (String)"onStop");
        super(project, false, DialogWrapper.IdeModalityType.MODELESS);
        this.dialogTitle = dialogTitle;
        this.maxRecordingDurationMillis = maxRecordingDurationMillis;
        this.onStop = onStop;
        this.alarm = new Alarm(this.getDisposable());
        this.panel = this.createPanel();
        this.recordingLabelText = this.recordingTimeText(this.recordingTimeMillis);
        this.init();
    }

    private final void setRecordingTimeMillis(long value2) {
        this.recordingTimeMillis = value2;
        this.setRecordingLabelText(this.recordingTimeText(value2));
    }

    private final void setRecordingLabelText(String value2) {
        this.recordingLabelText = value2;
        JLabel jLabel = this.recordingLabel;
        if (jLabel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"recordingLabel");
            jLabel = null;
        }
        jLabel.setText(value2);
    }

    protected void init() {
        super.init();
        this.setUndecorated(true);
        this.getRootPane().setWindowDecorationStyle(0);
        this.getRootPane().setBorder((Border)JBUI.Borders.empty());
        this.panel.setBorder((Border)PopupBorder.Factory.create((boolean)true, (boolean)true));
        if (WindowRoundedCornersManager.isAvailable()) {
            if (SystemInfoRt.isMac && UIUtil.isUnderDarcula()) {
                WindowRoundedCornersManager.setRoundedCorners((Window)this.getWindow(), (Object)JBUI.CurrentTheme.Popup.borderColor((boolean)true));
                this.getRootPane().setBorder((Border)PopupBorder.Factory.createEmpty());
            } else {
                WindowRoundedCornersManager.setRoundedCorners((Window)this.getWindow());
            }
        }
    }

    public void show() {
        super.show();
        this.recordingStartTime = System.currentTimeMillis();
        this.alarm.addRequest(new Runnable(this){
            final /* synthetic */ ScreenRecorderDialog $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final void run() {
                ScreenRecorderDialog.access$stopRecordingTimer(this.$tmp0);
            }
        }, this.maxRecordingDurationMillis, ModalityState.any());
        this.alarm.addRequest(new Runnable(this){
            final /* synthetic */ ScreenRecorderDialog $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final void run() {
                ScreenRecorderDialog.access$updateRecordingTime(this.$tmp0);
            }
        }, 1000, ModalityState.any());
    }

    @NotNull
    protected JComponent createCenterPanel() {
        return (JComponent)this.panel;
    }

    @Nullable
    protected JComponent createSouthPanel() {
        return null;
    }

    @Nullable
    protected Border createContentPaneBorder() {
        return null;
    }

    private final void stopRecordingTimer() {
        this.alarm.cancelAllRequests();
        this.setRecordingLabelText(AndroidAdbUiBundle.message("screenrecord.action.stopping", new Object[0]));
        JButton jButton = this.stopButton;
        if (jButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"stopButton");
            jButton = null;
        }
        jButton.setEnabled(false);
    }

    private final String recordingTimeText(long timeMillis) {
        int seconds = (int)(timeMillis / (long)1000);
        Object[] objectArray = new Object[1];
        String string = "%02d:%02d";
        Object[] objectArray2 = new Object[]{seconds / 60, seconds % 60};
        Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray2, objectArray2.length)), (String)"format(format, *args)");
        return AndroidAdbUiBundle.message("screenrecord.dialog.progress", objectArray);
    }

    private final void updateRecordingTime() {
        this.setRecordingTimeMillis(System.currentTimeMillis() - this.recordingStartTime);
        this.alarm.addRequest(new Runnable(this){
            final /* synthetic */ ScreenRecorderDialog $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final void run() {
                ScreenRecorderDialog.access$updateRecordingTime(this.$tmp0);
            }
        }, this.millisUntilNextSecondTick(), ModalityState.any());
    }

    private final long millisUntilNextSecondTick() {
        return (long)1000 - this.recordingTimeMillis % (long)1000;
    }

    private final DialogPanel createPanel() {
        DialogPanel dialogPanel = ComponentsKt.DialogPanel$default((String)this.dialogTitle, null, (int)2, null);
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setText(this.dialogTitle);
        titlePanel.setActive(true);
        WindowMoveListener moveListener2 = new WindowMoveListener(titlePanel){

            @NotNull
            protected Component getView(@NotNull Component component2) {
                Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
                Container container = SwingUtilities.getAncestorOfClass(DialogWrapperDialog.class, component2);
                Intrinsics.checkNotNullExpressionValue((Object)container, (String)"getAncestorOfClass(Dialo\u2026g::class.java, component)");
                return container;
            }
        };
        titlePanel.addMouseListener((MouseListener)moveListener2);
        titlePanel.addMouseMotionListener((MouseMotionListener)moveListener2);
        dialogPanel.add((Component)titlePanel, (Object)"North");
        BorderLayoutPanel centerPanel2 = new BorderLayoutPanel();
        centerPanel2.setBorder((Border)JBUI.Borders.empty((int)15, (int)10));
        this.recordingLabel = ComponentsKt.Label$default((String)this.recordingTimeText(this.recordingTimeMillis), null, null, (boolean)false, (int)14, null);
        JLabel jLabel = this.recordingLabel;
        if (jLabel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"recordingLabel");
            jLabel = null;
        }
        centerPanel2.addToLeft((Component)jLabel);
        centerPanel2.addToCenter(Box.createRigidArea(new Dimension(JBUIScale.scale((int)20), 0)));
        this.stopButton = new JButton(AndroidAdbUiBundle.message("screenrecord.dialog.stop.recording", new Object[0]));
        JButton jButton = this.stopButton;
        if (jButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"stopButton");
            jButton = null;
        }
        jButton.addActionListener(new ActionListener(this){
            final /* synthetic */ ScreenRecorderDialog this$0;
            {
                this.this$0 = $receiver;
            }

            public final void actionPerformed(ActionEvent it) {
                ScreenRecorderDialog.access$stopRecordingTimer(this.this$0);
                ScreenRecorderDialog.access$getOnStop$p(this.this$0).run();
            }
        });
        JButton jButton2 = this.stopButton;
        if (jButton2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"stopButton");
            jButton2 = null;
        }
        centerPanel2.addToRight((Component)jButton2);
        dialogPanel.add((Component)centerPanel2, (Object)"Center");
        return dialogPanel;
    }

    public static final /* synthetic */ void access$stopRecordingTimer(ScreenRecorderDialog $this) {
        $this.stopRecordingTimer();
    }

    public static final /* synthetic */ void access$updateRecordingTime(ScreenRecorderDialog $this) {
        $this.updateRecordingTime();
    }

    public static final /* synthetic */ Runnable access$getOnStop$p(ScreenRecorderDialog $this) {
        return $this.onStop;
    }
}

