/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.screenrecording;

import com.android.adblib.AdbDeviceServices;
import com.android.adblib.AdbDeviceServicesKt;
import com.android.adblib.AdbSession;
import com.android.adblib.DeviceSelector;
import com.android.adblib.ShellCommandOutput;
import com.android.annotations.concurrency.UiThread;
import com.android.prefs.AndroidLocationsException;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.adblib.AdbLibService;
import com.android.tools.idea.concurrency.AndroidDispatchers;
import com.android.tools.idea.concurrency.CoroutinesUtilsKt;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.IdeAvdManagers;
import com.android.tools.idea.ui.AndroidAdbUiBundle;
import com.android.tools.idea.ui.screenrecording.EmulatorConsoleRecordingProvider;
import com.android.tools.idea.ui.screenrecording.ScreenRecorder;
import com.android.tools.idea.ui.screenrecording.ScreenRecorderAction;
import com.android.tools.idea.ui.screenrecording.ScreenRecorderOptions;
import com.android.tools.idea.ui.screenrecording.ScreenRecorderOptionsDialog;
import com.android.tools.idea.ui.screenrecording.ScreenRecorderPersistentOptions;
import com.android.tools.idea.ui.screenrecording.ScreenRecordingSupportedCache;
import com.android.tools.idea.ui.screenrecording.ShellCommandRecordingProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import icons.StudioIcons;
import java.awt.Dimension;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroupCollection;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineExceptionHandler;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 +2\u00020\u0001:\u0002+,B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J)\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\bH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\u001aH\u0016J#\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\bH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001dJ\n\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J!\u0010$\u001a\u00020!2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\bH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001dJ)\u0010%\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010&\u001a\u00020!H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010'J \u0010(\u001a\u00020\n2\u0006\u0010\"\u001a\u00020#2\u0006\u0010)\u001a\u00020!2\u0006\u0010\u000f\u001a\u00020\u0010H\u0003J\u0010\u0010*\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006-"}, d2={"Lcom/android/tools/idea/ui/screenrecording/ScreenRecorderAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "recordingInProgress", "", "", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "coroutineExceptionHandler", "Lkotlinx/coroutines/CoroutineExceptionHandler;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "execute", "adbSession", "Lcom/android/adblib/AdbSession;", "serialNumber", "command", "(Lcom/android/adblib/AdbSession;Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getDeviceScreenSize", "Ljava/awt/Dimension;", "(Lcom/android/adblib/AdbSession;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getVirtualDeviceManager", "Lcom/android/sdklib/internal/avd/AvdManager;", "isRecordingSupported", "", "params", "Lcom/android/tools/idea/ui/screenrecording/ScreenRecorderAction$Parameters;", "isShowTouchEnabled", "setShowTouch", "isEnabled", "(Lcom/android/adblib/AdbSession;Ljava/lang/String;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "startRecordingAsync", "useEmulatorRecording", "update", "Companion", "Parameters", "intellij.android.adb.ui"})
@SourceDebugExtension(value={"SMAP\nScreenRecorderAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScreenRecorderAction.kt\ncom/android/tools/idea/ui/screenrecording/ScreenRecorderAction\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 CoroutineExceptionHandler.kt\nkotlinx/coroutines/CoroutineExceptionHandlerKt\n*L\n1#1,236:1\n8#2:237\n49#3,4:238\n*S KotlinDebug\n*F\n+ 1 ScreenRecorderAction.kt\ncom/android/tools/idea/ui/screenrecording/ScreenRecorderAction\n*L\n62#1:237\n198#1:238,4\n*E\n"})
public final class ScreenRecorderAction
extends DumbAwareAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    @NotNull
    private final Set<String> recordingInProgress;
    @NotNull
    private static final DataKey<Parameters> SCREEN_RECORDER_PARAMETERS_KEY;
    public static final int MAX_RECORDING_DURATION_MINUTES = 30;
    public static final int MAX_RECORDING_DURATION_MINUTES_LEGACY = 3;
    @NotNull
    private static final String REMOTE_PATH = "/sdcard/screen-recording-%d.mp4";
    @NotNull
    private static final Regex WM_SIZE_OUTPUT_REGEX;
    @NotNull
    private static final String EMU_TMP_FILENAME = "tmp.webm";
    private static final Duration COMMAND_TIMEOUT;

    public ScreenRecorderAction() {
        super(AndroidAdbUiBundle.message("screenrecord.action.title", new Object[0]), AndroidAdbUiBundle.message("screenrecord.action.description", new Object[0]), StudioIcons.Common.VIDEO_CAPTURE);
        ScreenRecorderAction $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger2 = Logger.getInstance(ScreenRecorderAction.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(T::class.java)");
        this.logger = logger2;
        this.recordingInProgress = new LinkedHashSet();
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        Parameters params2 = (Parameters)event2.getData(SCREEN_RECORDER_PARAMETERS_KEY);
        Project project = event2.getProject();
        event2.getPresentation().setEnabled(params2 != null && project != null && this.isRecordingSupported(params2, project) && !this.recordingInProgress.contains(params2.getSerialNumber()));
    }

    public void actionPerformed(@NotNull AnActionEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        Parameters parameters2 = (Parameters)event2.getData(SCREEN_RECORDER_PARAMETERS_KEY);
        if (parameters2 == null) {
            return;
        }
        Parameters params2 = parameters2;
        Project project = event2.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        String serialNumber = params2.getSerialNumber();
        ScreenRecorderOptionsDialog dialog2 = new ScreenRecorderOptionsDialog(project2, ScreenRecorderAction.Companion.isEmulator(serialNumber), params2.getFeatureLevel());
        if (dialog2.showAndGet()) {
            this.startRecordingAsync(params2, dialog2.getUseEmulatorRecording(), project2);
        }
    }

    private final boolean isRecordingSupported(Parameters params2, Project project) {
        return params2.getFeatureLevel() >= 19 && ScreenRecordingSupportedCache.Companion.getInstance(project).isScreenRecordingSupported(params2.getSerialNumber(), params2.getFeatureLevel());
    }

    @UiThread
    private final void startRecordingAsync(Parameters params2, boolean useEmulatorRecording, Project project) {
        AdbSession adbSession = AdbLibService.Companion.getSession(project);
        AvdManager manager = this.getVirtualDeviceManager();
        String serialNumber = params2.getSerialNumber();
        String avdName = params2.getAvdId();
        Path emulatorRecordingFile = manager != null && useEmulatorRecording && avdName != null ? ScreenRecorderAction.Companion.getTemporaryVideoPathForVirtualDevice(avdName, manager) : null;
        this.recordingInProgress.add(serialNumber);
        Disposable disposableParent = params2.getRecordingLifetimeDisposable();
        CoroutineScope coroutineScope = CoroutinesUtilsKt.AndroidCoroutineScope((Disposable)disposableParent, (CoroutineContext)((CoroutineContext)EmptyCoroutineContext.INSTANCE));
        CoroutineExceptionHandler exceptionHandler = this.coroutineExceptionHandler(project, coroutineScope);
        BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)((CoroutineContext)exceptionHandler), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, adbSession, serialNumber, emulatorRecordingFile, params2, disposableParent, project, null){
            boolean Z$0;
            int I$0;
            Object L$0;
            int label;
            final /* synthetic */ ScreenRecorderAction this$0;
            final /* synthetic */ AdbSession $adbSession;
            final /* synthetic */ String $serialNumber;
            final /* synthetic */ Path $emulatorRecordingFile;
            final /* synthetic */ Parameters $params;
            final /* synthetic */ Disposable $disposableParent;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$adbSession = $adbSession;
                this.$serialNumber = $serialNumber;
                this.$emulatorRecordingFile = $emulatorRecordingFile;
                this.$params = $params;
                this.$disposableParent = $disposableParent;
                this.$project = $project;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = ScreenRecorderAction.access$isShowTouchEnabled(this.this$0, this.$adbSession, this.$serialNumber, (Continuation)this);
                        if (v0 == var10_2) {
                            return var10_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        this.Z$0 = showTouchEnabled = ((Boolean)v0).booleanValue();
                        this.label = 2;
                        v1 = ScreenRecorderAction.access$getDeviceScreenSize(this.this$0, this.$adbSession, this.$serialNumber, (Continuation)this);
                        if (v1 == var10_2) {
                            return var10_2;
                        }
                        ** GOTO lbl23
                    }
                    case 2: {
                        showTouchEnabled = this.Z$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl23:
                        // 2 sources

                        size = (Dimension)v1;
                        timeLimitSec = this.$emulatorRecordingFile != null || this.$params.getFeatureLevel() >= 34 ? 1800 : 0;
                        options = ScreenRecorderPersistentOptions.Companion.getInstance().toScreenRecorderOptions(size, timeLimitSec);
                        if (options.getShowTouches() != showTouchEnabled) {
                            this.L$0 = options;
                            this.Z$0 = showTouchEnabled;
                            this.I$0 = timeLimitSec;
                            this.label = 3;
                            v2 = ScreenRecorderAction.access$setShowTouch(this.this$0, this.$adbSession, this.$serialNumber, options.getShowTouches(), (Continuation)this);
                            if (v2 == var10_2) {
                                return var10_2;
                            }
                        }
                        ** GOTO lbl42
                    }
                    case 3: {
                        timeLimitSec = this.I$0;
                        showTouchEnabled = this.Z$0;
                        options = (ScreenRecorderOptions)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl42:
                        // 3 sources

                        if (this.$emulatorRecordingFile == null) {
                            var8_7 = "/sdcard/screen-recording-%d.mp4";
                            var9_8 = new Object[]{Boxing.boxLong((long)System.currentTimeMillis())};
                            v3 = String.format(var8_7, Arrays.copyOf(var9_8, var9_8.length));
                            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"format(this, *args)");
                            v4 = new ShellCommandRecordingProvider(this.$disposableParent, this.$serialNumber, v3, options, this.$adbSession);
                        } else {
                            v4 = new EmulatorConsoleRecordingProvider(this.$disposableParent, this.$serialNumber, this.$emulatorRecordingFile, options, this.$adbSession);
                        }
                        recodingProvider = v4;
                        timeLimit = timeLimitSec > 0 ? timeLimitSec : 180;
                        this.L$0 = options;
                        this.Z$0 = showTouchEnabled;
                        this.label = 4;
                        v5 = new ScreenRecorder(this.$project, recodingProvider, this.$params.getDeviceName()).recordScreen(timeLimit, (Continuation<? super Unit>)((Continuation)this));
                        ** if (v5 != var10_2) goto lbl59
lbl58:
                        // 1 sources

                        return var10_2;
lbl59:
                        // 1 sources

                        ** GOTO lbl67
                    }
                    case 4: {
                        showTouchEnabled = this.Z$0;
                        options = (ScreenRecorderOptions)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v5 = $result;
lbl67:
                        // 2 sources

                        if (options.getShowTouches() == showTouchEnabled) ** GOTO lbl77
                        this.L$0 = null;
                        this.label = 5;
                        v6 = ScreenRecorderAction.access$setShowTouch(this.this$0, this.$adbSession, this.$serialNumber, showTouchEnabled != false, (Continuation)this);
                        ** if (v6 != var10_2) goto lbl73
lbl72:
                        // 1 sources

                        return var10_2;
lbl73:
                        // 1 sources

                        ** GOTO lbl77
                    }
                    case 5: {
                        ResultKt.throwOnFailure((Object)$result);
                        v6 = $result;
lbl77:
                        // 3 sources

                        this.L$0 = null;
                        this.label = 6;
                        v7 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)AndroidDispatchers.INSTANCE.getUiThread()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(this.this$0, this.$serialNumber, null){
                            int label;
                            final /* synthetic */ ScreenRecorderAction this$0;
                            final /* synthetic */ String $serialNumber;
                            {
                                this.this$0 = $receiver;
                                this.$serialNumber = $serialNumber;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        return Boxing.boxBoolean((boolean)ScreenRecorderAction.access$getRecordingInProgress$p(this.this$0).remove(this.$serialNumber));
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Boolean> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (v7 == var10_2) {
                            return var10_2;
                        }
                        break;
                    }
                    case 6: {
                        ResultKt.throwOnFailure((Object)$result);
                        v7 = $result;
                        break;
                    }
                }
                catch (Throwable var6_10) {
                    if (options.getShowTouches() != showTouchEnabled) {
                        this.L$0 = var6_10;
                        this.label = 7;
                        v8 = ScreenRecorderAction.access$setShowTouch(this.this$0, this.$adbSession, this.$serialNumber, showTouchEnabled != false, (Continuation)this);
                        if (v8 == var10_2) {
                            return var10_2;
                        }
                    }
                    ** GOTO lbl99
                }
                {
                    case 7: {
                        var6_11 = (Throwable)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v8 = $result;
lbl99:
                        // 2 sources

                        this.L$0 = var6_11;
                        this.label = 8;
                        v9 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)AndroidDispatchers.INSTANCE.getUiThread()), (Function2)((Function2)new /* invalid duplicate definition of identical inner class */), (Continuation)((Continuation)this));
                        if (v9 == var10_2) {
                            return var10_2;
                        }
                        ** GOTO lbl109
                    }
                    case 8: {
                        var6_11 = (Throwable)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v9 = $result;
lbl109:
                        // 2 sources

                        throw var6_11;
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final AvdManager getVirtualDeviceManager() {
        AvdManager avdManager2;
        try {
            AndroidSdkHandler androidSdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
            Intrinsics.checkNotNullExpressionValue((Object)androidSdkHandler, (String)"getInstance().tryToChooseSdkHandler()");
            avdManager2 = IdeAvdManagers.INSTANCE.getAvdManager(androidSdkHandler);
        }
        catch (AndroidLocationsException exception) {
            this.logger.warn((Throwable)exception);
            avdManager2 = null;
        }
        return avdManager2;
    }

    /*
     * Unable to fully structure code
     */
    private final Object getDeviceScreenSize(AdbSession var1_1, String var2_2, Continuation<? super Dimension> var3_3) {
        if (!(var3_3 instanceof getDeviceScreenSize.1)) ** GOTO lbl-1000
        var9_4 = var3_3;
        if ((var9_4.label & -2147483648) != 0) {
            var9_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ ScreenRecorderAction this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ScreenRecorderAction.access$getDeviceScreenSize(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = this.execute((AdbSession)adbSession, (String)serialNumber, "wm size", (Continuation<? super String>)$continuation);
                ** if (v0 != var10_6) goto lbl19
lbl18:
                // 1 sources

                return var10_6;
lbl19:
                // 1 sources

                ** GOTO lbl26
            }
            case 1: {
                this = (ScreenRecorderAction)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl26:
                    // 2 sources

                    if ((matchResult = Regex.find$default((Regex)ScreenRecorderAction.WM_SIZE_OUTPUT_REGEX, (CharSequence)(out = (String)v0), (int)0, (int)2, null)) == null) {
                        this.logger.warn("Unexpected output from 'wm size': " + out);
                        return null;
                    }
                    width = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult.getGroups(), (String)"width");
                    height = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult.getGroups(), (String)"height");
                    if (width == null || height == null) {
                        this.logger.warn("Unexpected output from 'wm size': " + out);
                        return null;
                    }
                    return new Dimension(Integer.parseInt(width.getValue()), Integer.parseInt(height.getValue()));
                }
                catch (Exception e) {
                    this.logger.warn("Failed to get device screen size.", (Throwable)e);
                    return null;
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object execute(AdbSession var1_1, String var2_2, String var3_3, Continuation<? super String> var4_4) {
        if (!(var4_4 instanceof execute.1)) ** GOTO lbl-1000
        var7_5 = var4_4;
        if ((var7_5.label & -2147483648) != 0) {
            var7_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var4_4){
                /* synthetic */ Object result;
                final /* synthetic */ ScreenRecorderAction this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ScreenRecorderAction.access$execute(this.this$0, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var8_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = adbSession.getDeviceServices();
                v1 = DeviceSelector.Companion.fromSerialNumber((String)serialNumber);
                var5_8 = ScreenRecorderAction.COMMAND_TIMEOUT;
                Intrinsics.checkNotNullExpressionValue((Object)var5_8, (String)"COMMAND_TIMEOUT");
                $continuation.label = 1;
                v2 = AdbDeviceServicesKt.shellAsText$default((AdbDeviceServices)v0, (DeviceSelector)v1, (String)command, null, (Duration)var5_8, (int)0, (Continuation)$continuation, (int)20, null);
                if (v2 == var8_7) {
                    return var8_7;
                }
                ** GOTO lbl24
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl24:
                // 2 sources

                return ((ShellCommandOutput)v2).getStdout();
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object setShowTouch(AdbSession var1_1, String var2_2, boolean var3_3, Continuation<? super Unit> var4_4) {
        if (!(var4_4 instanceof setShowTouch.1)) ** GOTO lbl-1000
        var8_5 = var4_4;
        if ((var8_5.label & -2147483648) != 0) {
            var8_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var4_4){
                Object L$0;
                boolean Z$0;
                /* synthetic */ Object result;
                final /* synthetic */ ScreenRecorderAction this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ScreenRecorderAction.access$setShowTouch(this.this$0, null, null, false, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                value = isEnabled != false ? 1 : 0;
                $continuation.L$0 = this;
                $continuation.Z$0 = isEnabled;
                $continuation.label = 1;
                v0 = this.execute((AdbSession)adbSession, (String)serialNumber, "settings put system show_touches " + value, (Continuation<? super String>)$continuation);
                ** if (v0 != var9_7) goto lbl21
lbl20:
                // 1 sources

                return var9_7;
lbl21:
                // 1 sources

                ** GOTO lbl32
            }
            case 1: {
                isEnabled = $continuation.Z$0;
                this = (ScreenRecorderAction)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
                }
                catch (Exception e) {
                    this.logger.warn("Failed to set show taps to " + (isEnabled != false), (Throwable)e);
                }
lbl32:
                // 3 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object isShowTouchEnabled(AdbSession var1_1, String var2_2, Continuation<? super Boolean> var3_3) {
        if (!(var3_3 instanceof isShowTouchEnabled.1)) ** GOTO lbl-1000
        var6_4 = var3_3;
        if ((var6_4.label & -2147483648) != 0) {
            var6_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                /* synthetic */ Object result;
                final /* synthetic */ ScreenRecorderAction this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ScreenRecorderAction.access$isShowTouchEnabled(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var7_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = this.execute((AdbSession)adbSession, (String)serialNumber, "settings get system show_touches", (Continuation<? super String>)$continuation);
                if (v0 == var7_6) {
                    return var7_6;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                out = (String)v0;
                return Boxing.boxBoolean((boolean)Intrinsics.areEqual((Object)StringsKt.trim((CharSequence)out).toString(), (Object)"1"));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final CoroutineExceptionHandler coroutineExceptionHandler(Project project, CoroutineScope coroutineScope) {
        boolean $i$f$CoroutineExceptionHandler = false;
        CoroutineExceptionHandler.Key key = CoroutineExceptionHandler.Key;
        return new CoroutineExceptionHandler(key, this, coroutineScope, project){
            final /* synthetic */ ScreenRecorderAction this$0;
            final /* synthetic */ CoroutineScope $coroutineScope$inlined;
            final /* synthetic */ Project $project$inlined;
            {
                this.this$0 = screenRecorderAction;
                this.$coroutineScope$inlined = coroutineScope;
                this.$project$inlined = project;
                super((CoroutineContext.Key)$super_call_param$1);
            }

            public void handleException(@NotNull CoroutineContext context2, @NotNull Throwable exception) {
                Throwable throwable = exception;
                boolean bl = false;
                ScreenRecorderAction.access$getLogger$p(this.this$0).warn("Failed to record screen", throwable);
                BuildersKt.launch$default((CoroutineScope)this.$coroutineScope$inlined, (CoroutineContext)((CoroutineContext)AndroidDispatchers.INSTANCE.getUiThread()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$project$inlined, throwable, null){
                    int label;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ Throwable $throwable;
                    {
                        this.$project = $project;
                        this.$throwable = $throwable;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                Object[] objectArray = new Object[]{this.$throwable.toString()};
                                Messages.showErrorDialog((Project)this.$project, (String)AndroidAdbUiBundle.message("screenrecord.error.exception", objectArray), (String)AndroidAdbUiBundle.message("screenrecord.action.title", new Object[0]));
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
            }
        };
    }

    @NotNull
    public static final DataKey<Parameters> getSCREEN_RECORDER_PARAMETERS_KEY() {
        return Companion.getSCREEN_RECORDER_PARAMETERS_KEY();
    }

    public static final /* synthetic */ Object access$isShowTouchEnabled(ScreenRecorderAction $this, AdbSession adbSession, String serialNumber, Continuation $completion) {
        return $this.isShowTouchEnabled(adbSession, serialNumber, (Continuation<? super Boolean>)$completion);
    }

    public static final /* synthetic */ Object access$getDeviceScreenSize(ScreenRecorderAction $this, AdbSession adbSession, String serialNumber, Continuation $completion) {
        return $this.getDeviceScreenSize(adbSession, serialNumber, (Continuation<? super Dimension>)$completion);
    }

    public static final /* synthetic */ Object access$setShowTouch(ScreenRecorderAction $this, AdbSession adbSession, String serialNumber, boolean isEnabled2, Continuation $completion) {
        return $this.setShowTouch(adbSession, serialNumber, isEnabled2, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Set access$getRecordingInProgress$p(ScreenRecorderAction $this) {
        return $this.recordingInProgress;
    }

    public static final /* synthetic */ Object access$execute(ScreenRecorderAction $this, AdbSession adbSession, String serialNumber, String command, Continuation $completion) {
        return $this.execute(adbSession, serialNumber, command, (Continuation<? super String>)$completion);
    }

    public static final /* synthetic */ Logger access$getLogger$p(ScreenRecorderAction $this) {
        return $this.logger;
    }

    static {
        DataKey dataKey = DataKey.create((String)"ScreenRecorderParameters");
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"create<Parameters>(\"ScreenRecorderParameters\")");
        SCREEN_RECORDER_PARAMETERS_KEY = dataKey;
        WM_SIZE_OUTPUT_REGEX = new Regex("(?<width>\\d+)x(?<height>\\d+)");
        COMMAND_TIMEOUT = Duration.ofSeconds(2L);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\f\u0010\u001a\u001a\u00020\u001b*\u00020\u0007H\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R/\u0010\f\u001a\u0015\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\u000e0\u000e0\r\u00a2\u0006\u0002\b\u000f8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0010\u0010\u0002\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/idea/ui/screenrecording/ScreenRecorderAction$Companion;", "", "()V", "COMMAND_TIMEOUT", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "EMU_TMP_FILENAME", "", "MAX_RECORDING_DURATION_MINUTES", "", "MAX_RECORDING_DURATION_MINUTES_LEGACY", "REMOTE_PATH", "SCREEN_RECORDER_PARAMETERS_KEY", "Lcom/intellij/openapi/actionSystem/DataKey;", "Lcom/android/tools/idea/ui/screenrecording/ScreenRecorderAction$Parameters;", "Lorg/jetbrains/annotations/NotNull;", "getSCREEN_RECORDER_PARAMETERS_KEY$annotations", "getSCREEN_RECORDER_PARAMETERS_KEY", "()Lcom/intellij/openapi/actionSystem/DataKey;", "WM_SIZE_OUTPUT_REGEX", "Lkotlin/text/Regex;", "getTemporaryVideoPathForVirtualDevice", "Ljava/nio/file/Path;", "avdName", "manager", "Lcom/android/sdklib/internal/avd/AvdManager;", "isEmulator", "", "intellij.android.adb.ui"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataKey<Parameters> getSCREEN_RECORDER_PARAMETERS_KEY() {
            return SCREEN_RECORDER_PARAMETERS_KEY;
        }

        @JvmStatic
        public static /* synthetic */ void getSCREEN_RECORDER_PARAMETERS_KEY$annotations() {
        }

        private final Path getTemporaryVideoPathForVirtualDevice(String avdName, AvdManager manager) {
            AvdInfo avdInfo = manager.getAvd(avdName, true);
            if (avdInfo == null) {
                return null;
            }
            AvdInfo virtualDevice = avdInfo;
            return virtualDevice.getDataFolderPath().resolve(ScreenRecorderAction.EMU_TMP_FILENAME);
        }

        private final boolean isEmulator(String $this$isEmulator) {
            return StringsKt.startsWith$default((String)$this$isEmulator, (String)"emulator-", (boolean)false, (int)2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\tH\u00c6\u0003J=\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\f\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/idea/ui/screenrecording/ScreenRecorderAction$Parameters;", "", "deviceName", "", "serialNumber", "featureLevel", "", "avdId", "recordingLifetimeDisposable", "Lcom/intellij/openapi/Disposable;", "(Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;Lcom/intellij/openapi/Disposable;)V", "getAvdId", "()Ljava/lang/String;", "getDeviceName", "getFeatureLevel", "()I", "getRecordingLifetimeDisposable", "()Lcom/intellij/openapi/Disposable;", "getSerialNumber", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "intellij.android.adb.ui"})
    public static final class Parameters {
        @NotNull
        private final String deviceName;
        @NotNull
        private final String serialNumber;
        private final int featureLevel;
        @Nullable
        private final String avdId;
        @NotNull
        private final Disposable recordingLifetimeDisposable;

        public Parameters(@NotNull String deviceName, @NotNull String serialNumber, int featureLevel, @Nullable String avdId, @NotNull Disposable recordingLifetimeDisposable) {
            Intrinsics.checkNotNullParameter((Object)deviceName, (String)"deviceName");
            Intrinsics.checkNotNullParameter((Object)serialNumber, (String)"serialNumber");
            Intrinsics.checkNotNullParameter((Object)recordingLifetimeDisposable, (String)"recordingLifetimeDisposable");
            this.deviceName = deviceName;
            this.serialNumber = serialNumber;
            this.featureLevel = featureLevel;
            this.avdId = avdId;
            this.recordingLifetimeDisposable = recordingLifetimeDisposable;
        }

        @NotNull
        public final String getDeviceName() {
            return this.deviceName;
        }

        @NotNull
        public final String getSerialNumber() {
            return this.serialNumber;
        }

        public final int getFeatureLevel() {
            return this.featureLevel;
        }

        @Nullable
        public final String getAvdId() {
            return this.avdId;
        }

        @NotNull
        public final Disposable getRecordingLifetimeDisposable() {
            return this.recordingLifetimeDisposable;
        }

        @NotNull
        public final String component1() {
            return this.deviceName;
        }

        @NotNull
        public final String component2() {
            return this.serialNumber;
        }

        public final int component3() {
            return this.featureLevel;
        }

        @Nullable
        public final String component4() {
            return this.avdId;
        }

        @NotNull
        public final Disposable component5() {
            return this.recordingLifetimeDisposable;
        }

        @NotNull
        public final Parameters copy(@NotNull String deviceName, @NotNull String serialNumber, int featureLevel, @Nullable String avdId, @NotNull Disposable recordingLifetimeDisposable) {
            Intrinsics.checkNotNullParameter((Object)deviceName, (String)"deviceName");
            Intrinsics.checkNotNullParameter((Object)serialNumber, (String)"serialNumber");
            Intrinsics.checkNotNullParameter((Object)recordingLifetimeDisposable, (String)"recordingLifetimeDisposable");
            return new Parameters(deviceName, serialNumber, featureLevel, avdId, recordingLifetimeDisposable);
        }

        public static /* synthetic */ Parameters copy$default(Parameters parameters2, String string, String string2, int n, String string3, Disposable disposable2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = parameters2.deviceName;
            }
            if ((n2 & 2) != 0) {
                string2 = parameters2.serialNumber;
            }
            if ((n2 & 4) != 0) {
                n = parameters2.featureLevel;
            }
            if ((n2 & 8) != 0) {
                string3 = parameters2.avdId;
            }
            if ((n2 & 0x10) != 0) {
                disposable2 = parameters2.recordingLifetimeDisposable;
            }
            return parameters2.copy(string, string2, n, string3, disposable2);
        }

        @NotNull
        public String toString() {
            return "Parameters(deviceName=" + this.deviceName + ", serialNumber=" + this.serialNumber + ", featureLevel=" + this.featureLevel + ", avdId=" + this.avdId + ", recordingLifetimeDisposable=" + this.recordingLifetimeDisposable + ")";
        }

        public int hashCode() {
            int result2 = this.deviceName.hashCode();
            result2 = result2 * 31 + this.serialNumber.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.featureLevel);
            result2 = result2 * 31 + (this.avdId == null ? 0 : this.avdId.hashCode());
            result2 = result2 * 31 + this.recordingLifetimeDisposable.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Parameters)) {
                return false;
            }
            Parameters parameters2 = (Parameters)other;
            if (!Intrinsics.areEqual((Object)this.deviceName, (Object)parameters2.deviceName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.serialNumber, (Object)parameters2.serialNumber)) {
                return false;
            }
            if (this.featureLevel != parameters2.featureLevel) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.avdId, (Object)parameters2.avdId)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.recordingLifetimeDisposable, (Object)parameters2.recordingLifetimeDisposable);
        }
    }
}

