/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.screenrecording;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.concurrency.AndroidDispatchers;
import com.android.tools.idea.ui.AndroidAdbUiBundle;
import com.android.tools.idea.ui.screenrecording.RecordingProvider;
import com.android.tools.idea.ui.screenrecording.ScreenRecorder;
import com.android.tools.idea.ui.screenrecording.ScreenRecorderDialog;
import com.intellij.CommonBundle;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.fileTypes.NativeFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.util.ui.UIUtil;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.CancellationException;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007H\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0011\u001a\u00020\u0007H\u0002J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0013H\u0003J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0013H\u0002J\u0011\u0010\u0017\u001a\u00020\rH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0018J\u0019\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001bH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u0007H\u0002R\u0018\u0010\t\u001a\f0\u0007\u00a2\u0006\u0002\b\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/idea/ui/screenrecording/ScreenRecorder;", "", "project", "Lcom/intellij/openapi/project/Project;", "recordingProvider", "Lcom/android/tools/idea/ui/screenrecording/RecordingProvider;", "deviceName", "", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/ui/screenrecording/RecordingProvider;Ljava/lang/String;)V", "dialogTitle", "Lorg/jetbrains/annotations/Nls;", "Lorg/jetbrains/annotations/NotNull;", "closeDialog", "", "dialog", "Lcom/intellij/openapi/ui/DialogWrapper;", "getDefaultFileName", "extension", "getTargetFile", "Lcom/intellij/openapi/vfs/VirtualFileWrapper;", "handleSavedRecording", "fileWrapper", "openSavedFile", "pullRecording", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "recordScreen", "timeLimitSec", "", "(ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "showErrorDialog", "errorMessage", "intellij.android.adb.ui"})
@SourceDebugExtension(value={"SMAP\nScreenRecorder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScreenRecorder.kt\ncom/android/tools/idea/ui/screenrecording/ScreenRecorder\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,210:1\n8#2:211\n8#2:212\n8#2:213\n*S KotlinDebug\n*F\n+ 1 ScreenRecorder.kt\ncom/android/tools/idea/ui/screenrecording/ScreenRecorder\n*L\n88#1:211\n94#1:212\n125#1:213\n*E\n"})
public final class ScreenRecorder {
    @NotNull
    private final Project project;
    @NotNull
    private final RecordingProvider recordingProvider;
    @NotNull
    private final String dialogTitle;

    public ScreenRecorder(@NotNull Project project, @NotNull RecordingProvider recordingProvider, @NotNull String deviceName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)recordingProvider, (String)"recordingProvider");
        Intrinsics.checkNotNullParameter((Object)deviceName, (String)"deviceName");
        this.project = project;
        this.recordingProvider = recordingProvider;
        Object[] objectArray = new Object[]{deviceName};
        this.dialogTitle = AndroidAdbUiBundle.message("screenrecord.dialog.title", objectArray);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object recordScreen(int var1_1, @NotNull Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof recordScreen.1)) ** GOTO lbl-1000
        var10_3 = var2_2;
        if ((var10_3.label & -2147483648) != 0) {
            var10_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                Object L$2;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ ScreenRecorder this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.recordScreen(0, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var11_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!(timeLimitSec > 0)) {
                    var4_6 = "Failed requirement.";
                    throw new IllegalArgumentException(var4_6.toString());
                }
                $continuation.L$0 = this;
                $continuation.I$0 = timeLimitSec;
                $continuation.label = 1;
                v0 = this.recordingProvider.startRecording((Continuation<? super Deferred<Unit>>)$continuation);
                if (v0 == var11_5) {
                    return var11_5;
                }
                ** GOTO lbl27
            }
            case 1: {
                timeLimitSec = $continuation.I$0;
                this = (ScreenRecorder)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl27:
                // 2 sources

                recordingHandle = (Deferred)v0;
                dialog = new Ref.ObjectRef();
                $continuation.L$0 = this;
                $continuation.L$1 = recordingHandle;
                $continuation.L$2 = dialog;
                $continuation.label = 2;
                v1 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)AndroidDispatchers.INSTANCE.getUiThread()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Ref.ObjectRef<ScreenRecorderDialog>)dialog, this, timeLimitSec, (Deferred<Unit>)recordingHandle, null){
                    int label;
                    final /* synthetic */ Ref.ObjectRef<ScreenRecorderDialog> $dialog;
                    final /* synthetic */ ScreenRecorder this$0;
                    final /* synthetic */ int $timeLimitSec;
                    final /* synthetic */ Deferred<Unit> $recordingHandle;
                    {
                        this.$dialog = $dialog;
                        this.this$0 = $receiver;
                        this.$timeLimitSec = $timeLimitSec;
                        this.$recordingHandle = $recordingHandle;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                RecordingProvider recordingProvider = ScreenRecorder.access$getRecordingProvider$p(this.this$0);
                                this.$dialog.element = new ScreenRecorderDialog(ScreenRecorder.access$getDialogTitle$p(this.this$0), ScreenRecorder.access$getProject$p(this.this$0), this.$timeLimitSec * 1000 - 100, new Runnable(recordingProvider){
                                    final /* synthetic */ RecordingProvider $tmp0;
                                    {
                                        this.$tmp0 = $tmp0;
                                    }

                                    public final void run() {
                                        this.$tmp0.stopRecording();
                                    }
                                });
                                Disposer.register((Disposable)((ScreenRecorderDialog)((Object)this.$dialog.element)).getDisposable(), (Disposable)new Disposable(this.$dialog, this.$recordingHandle){
                                    final /* synthetic */ Ref.ObjectRef<ScreenRecorderDialog> $dialog;
                                    final /* synthetic */ Deferred<Unit> $recordingHandle;
                                    {
                                        this.$dialog = $dialog;
                                        this.$recordingHandle = $recordingHandle;
                                    }

                                    public final void dispose() {
                                        if (((ScreenRecorderDialog)((Object)this.$dialog.element)).getExitCode() == 1) {
                                            Job.DefaultImpls.cancel$default((Job)((Job)this.$recordingHandle), null, (int)1, null);
                                        }
                                    }
                                });
                                ((ScreenRecorderDialog)((Object)this.$dialog.element)).show();
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v1 == var11_5) {
                    return var11_5;
                }
                ** GOTO lbl44
            }
            case 2: {
                dialog = (Ref.ObjectRef)$continuation.L$2;
                recordingHandle = (Deferred)$continuation.L$1;
                this = (ScreenRecorder)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl44:
                // 3 sources

                $continuation.L$0 = this;
                $continuation.L$1 = dialog;
                $continuation.L$2 = null;
                $continuation.label = 3;
                v2 = recordingHandle.await((Continuation)$continuation);
                ** if (v2 != var11_5) goto lbl52
lbl51:
                // 1 sources

                return var11_5;
lbl52:
                // 1 sources

                ** GOTO lbl60
            }
            case 3: {
                dialog = (Ref.ObjectRef)$continuation.L$1;
                this = (ScreenRecorder)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl60:
                    // 2 sources

                    this.closeDialog((DialogWrapper)dialog.element);
                }
                catch (CancellationException e) {
                    this.closeDialog((DialogWrapper)dialog.element);
                    try {
                        this.recordingProvider.cancelRecording();
                    }
                    catch (Throwable e) {
                        $i$f$thisLogger = false;
                        v3 = Logger.getInstance(ScreenRecorder.class);
                        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getInstance(T::class.java)");
                        v3.warn(AndroidAdbUiBundle.message("screenrecord.error.cancelling", new Object[0]), e);
                    }
                    throw e;
                }
                catch (Throwable e) {
                    this.closeDialog((DialogWrapper)dialog.element);
                    $i$f$thisLogger = false;
                    v4 = Logger.getInstance(ScreenRecorder.class);
                    Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getInstance(T::class.java)");
                    v4.warn("Screen recording failed", e);
                    cause = e.getMessage();
                    if (cause == null) {
                        v5 = AndroidAdbUiBundle.message("screenrecord.error", new Object[0]);
                    } else {
                        var8_14 = new Object[]{cause};
                        v5 = AndroidAdbUiBundle.message("screenrecord.error.with.cause", var8_14);
                    }
                    message = v5;
                    this.showErrorDialog(message);
                    return Unit.INSTANCE;
                }
                $continuation.L$0 = null;
                $continuation.L$1 = null;
                $continuation.label = 4;
                v6 = this.pullRecording((Continuation<? super Unit>)$continuation);
                if (v6 == var11_5) {
                    return var11_5;
                }
                ** GOTO lbl100
            }
            case 4: {
                ResultKt.throwOnFailure((Object)$result);
                v6 = $result;
lbl100:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object pullRecording(Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof pullRecording.1)) ** GOTO lbl-1000
        var8_2 = var1_1;
        if ((var8_2.label & -2147483648) != 0) {
            var8_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ ScreenRecorder this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ScreenRecorder.access$pullRecording(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = this.recordingProvider.doesRecordingExist((Continuation<? super Boolean>)$continuation);
                if (v0 == var9_4) {
                    return var9_4;
                }
                ** GOTO lbl22
            }
            case 1: {
                this = (ScreenRecorder)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                if (!((Boolean)v0).booleanValue()) {
                    this.showErrorDialog(AndroidAdbUiBundle.message("screenrecord.error", new Object[0]));
                    return Unit.INSTANCE;
                }
                $continuation.L$0 = this;
                $continuation.label = 2;
                v1 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)AndroidDispatchers.INSTANCE.getUiThread()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super VirtualFileWrapper>, Object>(this, null){
                    int label;
                    final /* synthetic */ ScreenRecorder this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                return ScreenRecorder.access$getTargetFile(this.this$0, ScreenRecorder.access$getRecordingProvider$p(this.this$0).getFileExtension());
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super VirtualFileWrapper> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v1 == var9_4) {
                    return var9_4;
                }
                ** GOTO lbl35
            }
            case 2: {
                this = (ScreenRecorder)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl35:
                // 2 sources

                v2 = (VirtualFileWrapper)v1;
                if (v2 == null) {
                    return Unit.INSTANCE;
                }
                fileWrapper = v2;
                v3 = fileWrapper.getFile().toPath();
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"fileWrapper.file.toPath()");
                $continuation.L$0 = this;
                $continuation.L$1 = fileWrapper;
                $continuation.label = 3;
                v4 = this.recordingProvider.pullRecording(v3, (Continuation<? super Unit>)$continuation);
                ** if (v4 != var9_4) goto lbl49
lbl48:
                // 1 sources

                return var9_4;
lbl49:
                // 1 sources

                ** GOTO lbl72
            }
            case 3: {
                fileWrapper = (VirtualFileWrapper)$continuation.L$1;
                this = (ScreenRecorder)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v4 = $result;
                }
                catch (CancellationException e) {
                    throw e;
                }
                catch (Throwable e) {
                    var5_8 = new Object[1];
                    var6_9 = fileWrapper.getFile();
                    Intrinsics.checkNotNullExpressionValue((Object)var6_9, (String)"fileWrapper.file");
                    var5_8[0] = var6_9;
                    message = AndroidAdbUiBundle.message("screenrecord.error.save", var5_8);
                    $i$f$thisLogger = false;
                    v5 = Logger.getInstance(ScreenRecorder.class);
                    Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getInstance(T::class.java)");
                    v5.warn(message, e);
                    this.showErrorDialog(message);
                    return Unit.INSTANCE;
                }
lbl72:
                // 2 sources

                $continuation.L$0 = null;
                $continuation.L$1 = null;
                $continuation.label = 4;
                v6 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)AndroidDispatchers.INSTANCE.getUiThread()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, fileWrapper, null){
                    int label;
                    final /* synthetic */ ScreenRecorder this$0;
                    final /* synthetic */ VirtualFileWrapper $fileWrapper;
                    {
                        this.this$0 = $receiver;
                        this.$fileWrapper = $fileWrapper;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                ScreenRecorder.access$handleSavedRecording(this.this$0, this.$fileWrapper);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v6 == var9_4) {
                    return var9_4;
                }
                ** GOTO lbl82
            }
            case 4: {
                ResultKt.throwOnFailure((Object)$result);
                v6 = $result;
lbl82:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void closeDialog(DialogWrapper dialog2) {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(dialog2){
            final /* synthetic */ DialogWrapper $dialog;
            {
                this.$dialog = $dialog;
            }

            public final void run() {
                if (!this.$dialog.isDisposed()) {
                    this.$dialog.close(1);
                }
            }
        });
    }

    private final void showErrorDialog(String errorMessage) {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(errorMessage){
            final /* synthetic */ String $errorMessage;
            {
                this.$errorMessage = $errorMessage;
            }

            public final void run() {
                Messages.showErrorDialog((String)this.$errorMessage, (String)AndroidAdbUiBundle.message("screenrecord.error.popup.title", new Object[0]));
            }
        });
    }

    private final VirtualFileWrapper getTargetFile(String extension) {
        PropertiesComponent properties2 = PropertiesComponent.getInstance((Project)this.project);
        String[] stringArray = new String[]{extension};
        FileSaverDescriptor descriptor2 = new FileSaverDescriptor(AndroidAdbUiBundle.message("screenrecord.action.save.as", new Object[0]), "", stringArray);
        FileSaverDialog fileSaverDialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor2, this.project);
        Intrinsics.checkNotNullExpressionValue((Object)fileSaverDialog, (String)"getInstance().createSave\u2026alog(descriptor, project)");
        FileSaverDialog saveFileDialog = fileSaverDialog;
        String lastPath = properties2.getValue("ScreenRecorder.SavePath");
        VirtualFile baseDir2 = lastPath != null ? LocalFileSystem.getInstance().findFileByPath(lastPath) : VfsUtil.getUserHomeDir();
        VirtualFileWrapper saveFileWrapper = saveFileDialog.save(baseDir2, this.getDefaultFileName(extension));
        if (saveFileWrapper != null) {
            properties2.setValue("ScreenRecorder.SavePath", ((Object)saveFileWrapper.getFile().toPath().getParent()).toString());
        }
        return saveFileWrapper;
    }

    private final String getDefaultFileName(String extension) {
        SimpleDateFormat timestampFormat = new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.ROOT);
        String timestampSuffix = timestampFormat.format(new Date());
        String filename = "Screen_recording_" + timestampSuffix;
        return SystemInfo.isMac ? filename + "." + extension : filename;
    }

    @UiThread
    private final void handleSavedRecording(VirtualFileWrapper fileWrapper2) {
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)fileWrapper2.getFile(), (String)"fileWrapper.file");
        String message2 = AndroidAdbUiBundle.message("screenrecord.action.view.recording", objectArray);
        String cancel = CommonBundle.getOkButtonText();
        Icon icon2 = Messages.getInformationIcon();
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"getInformationIcon()");
        Icon icon3 = icon2;
        if (RevealFileAction.isSupported()) {
            Object[] objectArray2 = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)RevealFileAction.getFileManagerName(), (String)"getFileManagerName()");
            String no = AndroidAdbUiBundle.message("screenrecord.action.show.in", objectArray2);
            int exitCode2 = Messages.showYesNoCancelDialog((Project)this.project, (String)message2, (String)this.dialogTitle, (String)AndroidAdbUiBundle.message("screenrecord.action.open", new Object[0]), (String)no, (String)cancel, (Icon)icon3);
            switch (exitCode2) {
                case 0: {
                    this.openSavedFile(fileWrapper2);
                    break;
                }
                case 1: {
                    RevealFileAction.openFile((Path)fileWrapper2.getFile().toPath());
                }
            }
        } else if (Messages.showOkCancelDialog((Project)this.project, (String)message2, (String)this.dialogTitle, (String)AndroidAdbUiBundle.message("screenrecord.action.open.file", new Object[0]), (String)cancel, (Icon)icon3) == 0) {
            this.openSavedFile(fileWrapper2);
        }
    }

    private final void openSavedFile(VirtualFileWrapper fileWrapper2) {
        VirtualFile file2 = fileWrapper2.getVirtualFile();
        if (file2 != null) {
            NativeFileType.openAssociatedApplication((VirtualFile)file2);
        }
    }

    public static final /* synthetic */ String access$getDialogTitle$p(ScreenRecorder $this) {
        return $this.dialogTitle;
    }

    public static final /* synthetic */ Project access$getProject$p(ScreenRecorder $this) {
        return $this.project;
    }

    public static final /* synthetic */ RecordingProvider access$getRecordingProvider$p(ScreenRecorder $this) {
        return $this.recordingProvider;
    }

    public static final /* synthetic */ Object access$pullRecording(ScreenRecorder $this, Continuation $completion) {
        return $this.pullRecording((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ VirtualFileWrapper access$getTargetFile(ScreenRecorder $this, String extension) {
        return $this.getTargetFile(extension);
    }

    public static final /* synthetic */ void access$handleSavedRecording(ScreenRecorder $this, VirtualFileWrapper fileWrapper2) {
        $this.handleSavedRecording(fileWrapper2);
    }
}

